/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.SectionBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.cover.SessionManager;

public class SavePartAttachmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SavePartAttachmentListener.class);
    private boolean isForAuthorSettings;

    public SavePartAttachmentListener() {
    }

    public SavePartAttachmentListener(boolean isForAuthorSettings) {
        this.isForAuthorSettings = isForAuthorSettings;
    }

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        SectionBean sectionBean = (SectionBean)ContextUtil.lookupBean((String)"sectionBean");
        Object assessmentService = null;
        Object assessment = null;
        assessmentService = this.isForAuthorSettings ? new AssessmentService() : new PublishedAssessmentService();
        List attachmentList = this.prepareSectionAttachment(sectionBean, assessmentService);
        sectionBean.setAttachmentList(attachmentList);
        if (attachmentList != null && attachmentList.size() > 0) {
            sectionBean.setHasAttachment(true);
        } else {
            sectionBean.setHasAttachment(false);
        }
    }

    private HashMap getResourceIdHash(Set attachmentSet) {
        HashMap<String, SectionAttachmentIfc> map = new HashMap<String, SectionAttachmentIfc>();
        if (attachmentSet != null) {
            for (SectionAttachmentIfc attach : attachmentSet) {
                map.put(attach.getResourceId(), attach);
            }
        }
        return map;
    }

    private List prepareSectionAttachment(SectionBean sectionBean, AssessmentService assessmentService) {
        ToolSession session;
        SectionDataIfc section = null;
        if (sectionBean.getSection() != null) {
            section = sectionBean.getSection().getData();
        }
        if ((session = SessionManager.getCurrentToolSession()).getAttribute("sakaiproject.filepicker.attachments") != null) {
            Set attachmentSet = new HashSet();
            if (section != null) {
                attachmentSet = section.getSectionAttachmentSet();
            }
            HashMap map = this.getResourceIdHash(attachmentSet);
            ArrayList<SectionAttachmentIfc> newAttachmentList = new ArrayList<SectionAttachmentIfc>();
            String protocol = ContextUtil.getProtocol();
            List refs = (List)session.getAttribute("sakaiproject.filepicker.attachments");
            if (refs != null && refs.size() > 0) {
                for (int i = 0; i < refs.size(); ++i) {
                    Reference ref = (Reference)refs.get(i);
                    String resourceId = ref.getId();
                    if (map.get(resourceId) == null) {
                        log.debug((Object)("**** ref.Id=" + ref.getId()));
                        log.debug((Object)("**** ref.name=" + ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName())));
                        SectionAttachmentIfc newAttach = assessmentService.createSectionAttachment(section, ref.getId(), ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName()), protocol);
                        newAttachmentList.add(newAttach);
                        continue;
                    }
                    newAttachmentList.add((SectionAttachmentIfc)map.get(resourceId));
                    map.remove(resourceId);
                }
            }
            session.removeAttribute("sakaiproject.filepicker.attachments");
            session.removeAttribute("sakaiproject.filepicker.cancel");
            return newAttachmentList;
        }
        return new ArrayList();
    }
}

