/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.api.SamigoApiFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedEvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSecuredIPAddress;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.CalendarServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.sakaiproject.tool.assessment.ui.bean.author.AssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishRepublishNotificationBean;
import org.sakaiproject.tool.assessment.ui.bean.author.PublishedAssessmentSettingsBean;
import org.sakaiproject.tool.assessment.ui.listener.author.AuthorActionListener;
import org.sakaiproject.tool.assessment.ui.listener.author.PublishAssessmentListener;
import org.sakaiproject.tool.assessment.ui.listener.author.SaveAssessmentSettings;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;
import org.sakaiproject.util.ResourceLoader;

public class SavePublishedSettingsListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SavePublishedSettingsListener.class);
    private static final GradebookServiceHelper gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
    private static final boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
    private CalendarServiceHelper calendarService = IntegrationContextFactory.getInstance().getCalendarServiceHelper();
    private ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages");

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        PublishedAssessmentSettingsBean assessmentSettings = (PublishedAssessmentSettingsBean)ContextUtil.lookupBean((String)"publishedSettings");
        Long assessmentId = assessmentSettings.getAssessmentId();
        log.debug((Object)("**** save assessment assessmentId =" + assessmentId.toString()));
        PublishedAssessmentService assessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade assessment = assessmentService.getPublishedAssessment(assessmentId.toString());
        boolean retractNow = false;
        String id = ae.getComponent().getId();
        if ("retract".equals(id)) {
            retractNow = true;
        }
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubsetting.edit", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", publishedAssessmentId=" + assessmentId), (boolean)true));
        boolean error = this.checkPublishedSettings(assessmentService, assessmentSettings, context);
        if (error) {
            assessmentSettings.setOutcome("editPublishedAssessmentSettings");
            return;
        }
        boolean isTitleChanged = this.isTitleChanged(assessmentSettings, assessment);
        boolean isScoringTypeChanged = this.isScoringTypeChanged(assessmentSettings, assessment);
        SaveAssessmentSettings saveAssessmentSettings = new SaveAssessmentSettings();
        this.setPublishedSettings(assessmentSettings, assessment, retractNow, saveAssessmentSettings);
        boolean gbError = this.checkScore(assessmentSettings, assessment, context);
        if (gbError) {
            assessmentSettings.setOutcome("editPublishedAssessmentSettings");
            return;
        }
        boolean gbUpdated = this.updateGB(assessmentSettings, assessment, isTitleChanged, isScoringTypeChanged, context);
        if (!gbUpdated) {
            assessmentSettings.setOutcome("editPublishedAssessmentSettings");
            return;
        }
        assessment.setLastModifiedBy(AgentFacade.getAgentString());
        assessment.setLastModifiedDate(new Date());
        assessmentService.saveAssessment(assessment);
        assessmentService.saveAssessment(assessment);
        assessmentService.deleteAllSecuredIP((PublishedAssessmentIfc)assessment);
        HashSet<PublishedSecuredIPAddress> ipSet = new HashSet<PublishedSecuredIPAddress>();
        String ipAddresses = assessmentSettings.getIpAddresses();
        if (ipAddresses == null) {
            ipAddresses = "";
        }
        String[] ip = ipAddresses.split("\\n");
        for (int j = 0; j < ip.length; ++j) {
            if (ip[j] == null || ip[j].equals("\r")) continue;
            ipSet.add(new PublishedSecuredIPAddress((AssessmentBaseIfc)assessment.getData(), null, ip[j]));
        }
        assessment.setSecuredIPAddressSet(ipSet);
        SecureDeliveryServiceAPI secureDeliveryService = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI();
        assessment.updateAssessmentMetaData("SECURE_DELIVERY_MODULE_KEY", assessmentSettings.getSecureDeliveryModule());
        String encryptedPassword = secureDeliveryService.encryptPassword(assessmentSettings.getSecureDeliveryModule(), assessmentSettings.getSecureDeliveryModuleExitPassword());
        assessment.updateAssessmentMetaData("SECURE_DELIVERY_EXITPWD_KEY", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)encryptedPassword));
        String titleDecoration = assessment.getAssessmentMetaDataByLabel("SECURE_DELIVERY_TITLE_DECORATION");
        String newTitle = titleDecoration != null ? assessment.getTitle().replace(titleDecoration, "") : assessment.getTitle();
        titleDecoration = secureDeliveryService.getTitleDecoration(assessmentSettings.getSecureDeliveryModule(), new ResourceLoader().getLocale());
        newTitle = newTitle + " " + titleDecoration;
        assessment.setTitle(newTitle);
        assessment.updateAssessmentMetaData("SECURE_DELIVERY_TITLE_DECORATION", titleDecoration);
        assessmentService.saveAssessment(assessment);
        saveAssessmentSettings.updateAttachment(assessment.getAssessmentAttachmentList(), assessmentSettings.getAttachmentList(), (AssessmentIfc)assessment.getData(), false);
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.pubSetting.edit", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", pubAssessmentId=" + assessmentSettings.getAssessmentId()), (boolean)true));
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        if ("editAssessment".equals(author.getFromPage())) {
            AssessmentBean assessmentBean = (AssessmentBean)ContextUtil.lookupBean((String)"assessmentBean");
            assessmentBean.setTitle(assessmentSettings.getTitle());
        } else {
            this.resetPublishedAssessmentsList(author, assessmentService);
        }
        assessmentSettings.setOutcome(author.getFromPage());
        boolean addDueDateToCalendar = assessment.getAssessmentMetaDataByLabel("CALENDAR_DUE_DATE_EVENT_ID") != null;
        PublishAssessmentListener publishAssessmentListener = new PublishAssessmentListener();
        PublishRepublishNotificationBean publishRepublishNotification = (PublishRepublishNotificationBean)ContextUtil.lookupBean((String)"publishRepublishNotification");
        String notificationMessage = publishAssessmentListener.getNotificationMessage(publishRepublishNotification, assessmentSettings.getTitle(), assessmentSettings.getReleaseTo(), assessmentSettings.getStartDateString(), assessmentSettings.getPublishedUrl(), assessmentSettings.getReleaseToGroupsAsString(), assessmentSettings.getDueDateString(), assessmentSettings.getTimedHours(), assessmentSettings.getTimedMinutes(), assessmentSettings.getUnlimitedSubmissions(), assessmentSettings.getSubmissionsAllowed(), assessmentSettings.getScoringType(), assessmentSettings.getFeedbackDelivery(), assessmentSettings.getFeedbackDateString());
        this.calendarService.updateAllCalendarEvents(assessment, assessmentSettings.getReleaseTo(), assessmentSettings.getGroupsAuthorized(), this.rb.getString("calendarDueDatePrefix") + " ", addDueDateToCalendar, notificationMessage);
    }

    public boolean checkPublishedSettings(PublishedAssessmentService assessmentService, PublishedAssessmentSettingsBean assessmentSettings, FacesContext context) {
        String exitPassword;
        String moduleId;
        SecureDeliveryServiceAPI secureDeliveryService;
        String scoringType;
        String unlimitedSubmissions;
        boolean error = false;
        String assessmentName = assessmentSettings.getTitle();
        if (assessmentName == null || assessmentName.trim().equals("")) {
            String nameEmpty_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_empty");
            context.addMessage(null, new FacesMessage(nameEmpty_err));
            error = true;
        } else {
            assessmentName = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentName.trim());
            if (!assessmentService.publishedAssessmentTitleIsUnique(assessmentSettings.getAssessmentId().toString(), assessmentName)) {
                String nameUnique_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"assessmentName_error");
                context.addMessage(null, new FacesMessage(nameUnique_err));
                error = true;
            }
        }
        if (!assessmentSettings.getIsValidStartDate()) {
            String startDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_start_date");
            context.addMessage(null, new FacesMessage(startDateErr));
            error = true;
        }
        if (!assessmentSettings.getIsValidDueDate()) {
            String dueDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_due_date");
            context.addMessage(null, new FacesMessage(dueDateErr));
            error = true;
        }
        if (!assessmentSettings.getIsValidRetractDate()) {
            String retractDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_retrack_date");
            context.addMessage(null, new FacesMessage(retractDateErr));
            error = true;
        }
        Date startDate = assessmentSettings.getStartDate();
        Date dueDate = assessmentSettings.getDueDate();
        Date retractDate = assessmentSettings.getRetractDate();
        boolean isRetractEarlierThanAvaliable = false;
        if (dueDate != null && startDate != null && dueDate.before(startDate) || dueDate != null && startDate == null && dueDate.before(new Date())) {
            String dateError1 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"due_earlier_than_avaliable");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, dateError1, null));
            error = true;
            assessmentSettings.setStartDate(new Date());
        }
        if (retractDate != null && startDate != null && retractDate.before(startDate) || retractDate != null && startDate == null && retractDate.before(new Date())) {
            String dateError2 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"retract_earlier_than_avaliable");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, dateError2, null));
            error = true;
            isRetractEarlierThanAvaliable = true;
            assessmentSettings.setStartDate(new Date());
        }
        if (!isRetractEarlierThanAvaliable && retractDate != null && dueDate != null && retractDate.before(dueDate)) {
            String dateError3 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"retract_earlier_than_due");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, dateError3, null));
            error = true;
        }
        if (assessmentSettings.getLateHandling() != null && AssessmentAccessControlIfc.NOT_ACCEPT_LATE_SUBMISSION.equals(assessmentSettings.getLateHandling()) && retractDate == null && dueDate != null && assessmentSettings.getAutoSubmit()) {
            assessmentSettings.setRetractDate(dueDate);
        }
        if (assessmentSettings.getAutoSubmit() && retractDate == null) {
            String dateError4 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"retract_required_with_auto_submit");
            context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, dateError4, null));
            error = true;
        }
        Object time = assessmentSettings.getValueMap().get("hasTimeAssessment");
        boolean isTime = false;
        try {
            if (time != null) {
                isTime = (Boolean)time;
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Expecting Boolean hasTimeAssessment, got: " + time + ", exception: " + ex));
        }
        if (isTime && assessmentSettings.getTimeLimit() == 0) {
            String time_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"timeSelect_error");
            context.addMessage(null, new FacesMessage(time_err));
            error = true;
        }
        if ((unlimitedSubmissions = assessmentSettings.getUnlimitedSubmissions()) != null && unlimitedSubmissions.equals(AssessmentAccessControlIfc.LIMITED_SUBMISSIONS.toString())) {
            try {
                String submissionsAllowed = assessmentSettings.getSubmissionsAllowed().trim();
                int submissionAllowed = Integer.parseInt(submissionsAllowed);
                if (submissionAllowed < 1) {
                    throw new RuntimeException();
                }
            }
            catch (RuntimeException e) {
                error = true;
                String submission_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"submissions_allowed_error");
                context.addMessage(null, new FacesMessage(submission_err));
            }
        }
        if ((scoringType = assessmentSettings.getScoringType()).equals(EvaluationModelIfc.AVERAGE_SCORE.toString()) && "0".equals(assessmentSettings.getUnlimitedSubmissions())) {
            try {
                String submissionsAllowed = assessmentSettings.getSubmissionsAllowed().trim();
                int submissionAllowed = Integer.parseInt(submissionsAllowed);
                if (submissionAllowed < 2) {
                    throw new RuntimeException();
                }
            }
            catch (RuntimeException e) {
                error = true;
                String submission_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"averag_grading_single_submission");
                context.addMessage(null, new FacesMessage(submission_err));
            }
        }
        if (assessmentSettings.getFeedbackDelivery().equals("2")) {
            if (assessmentSettings.getFeedbackDateString() == null || assessmentSettings.getFeedbackDateString().equals("")) {
                error = true;
                String date_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"date_error");
                context.addMessage(null, new FacesMessage(date_err));
            } else if (!assessmentSettings.getIsValidFeedbackDate()) {
                String feedbackDateErr = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.GeneralMessages", (String)"invalid_feedback_date");
                context.addMessage(null, new FacesMessage(feedbackDateErr));
                error = true;
            }
        }
        if ((secureDeliveryService = SamigoApiFactory.getInstance().getSecureDeliveryServiceAPI()).isSecureDeliveryAvaliable() && !"SECURE_DELIVERY_NONE_ID".equals(moduleId = assessmentSettings.getSecureDeliveryModule()) && (exitPassword = assessmentSettings.getSecureDeliveryModuleExitPassword()) != null && exitPassword.length() > 0) {
            for (int i = 0; i < exitPassword.length(); ++i) {
                char c = exitPassword.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                error = true;
                String submission_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"exit_password_error");
                context.addMessage(null, new FacesMessage(submission_err));
                break;
            }
        }
        return error;
    }

    private boolean isTitleChanged(PublishedAssessmentSettingsBean assessmentSettings, PublishedAssessmentFacade assessment) {
        if (assessment.getTitle() != null && assessmentSettings.getTitle() != null) {
            String assessmentTitle = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getTitle().trim());
            if (!assessment.getTitle().trim().equals(assessmentTitle)) {
                assessment.setTitle(assessmentTitle);
                return true;
            }
        }
        return false;
    }

    private boolean isScoringTypeChanged(PublishedAssessmentSettingsBean assessmentSettings, PublishedAssessmentFacade assessment) {
        if (assessment.getEvaluationModel() != null && assessment.getEvaluationModel().getScoringType() != null && assessmentSettings.getScoringType() != null) {
            Integer oldScoringType = assessment.getEvaluationModel().getScoringType();
            String newScoringType = assessmentSettings.getScoringType().trim();
            if (newScoringType.equals(oldScoringType.toString())) {
                return false;
            }
        }
        return true;
    }

    private void setPublishedSettings(PublishedAssessmentSettingsBean assessmentSettings, PublishedAssessmentFacade assessment, boolean retractNow, SaveAssessmentSettings saveAssessmentSettings) {
        assessment.setDescription(assessmentSettings.getDescription());
        assessment.updateAssessmentMetaData("ASSESSMENT_AUTHORS", assessmentSettings.getAuthors());
        PublishedAccessControl control = (PublishedAccessControl)assessment.getAssessmentAccessControl();
        if (control == null) {
            control = new PublishedAccessControl();
            control.setAssessmentBase((AssessmentBaseIfc)assessment.getData());
        }
        control.setStartDate(assessmentSettings.getStartDate());
        control.setDueDate(assessmentSettings.getDueDate());
        if (retractNow) {
            control.setRetractDate(new Date());
        } else {
            control.setRetractDate(assessmentSettings.getRetractDate());
        }
        if (assessmentSettings.getItemNavigation() != null) {
            String nav = assessmentSettings.getItemNavigation();
            if ("1".equals(nav)) {
                assessmentSettings.setAssessmentFormat("1");
            }
            control.setItemNavigation(Integer.valueOf(nav));
        }
        if (assessmentSettings.getAssessmentFormat() != null) {
            control.setAssessmentFormat(new Integer(assessmentSettings.getAssessmentFormat()));
        }
        if (assessmentSettings.getItemNumbering() != null) {
            control.setItemNumbering(new Integer(assessmentSettings.getItemNumbering()));
        }
        control.setTimeLimit(assessmentSettings.getTimeLimit());
        if (assessmentSettings.getTimedAssessment()) {
            control.setTimedAssessment(AssessmentAccessControl.TIMED_ASSESSMENT);
        } else {
            control.setTimedAssessment(AssessmentAccessControl.DO_NOT_TIMED_ASSESSMENT);
        }
        if (assessmentSettings.getIsMarkForReview()) {
            control.setMarkForReview(AssessmentAccessControl.MARK_FOR_REVIEW);
        } else {
            control.setMarkForReview(AssessmentAccessControl.NOT_MARK_FOR_REVIEW);
        }
        if (assessmentSettings.getUnlimitedSubmissions() != null) {
            if (!assessmentSettings.getUnlimitedSubmissions().equals(AssessmentAccessControlIfc.UNLIMITED_SUBMISSIONS.toString())) {
                control.setUnlimitedSubmissions(Boolean.FALSE);
                if (assessmentSettings.getSubmissionsAllowed() != null) {
                    control.setSubmissionsAllowed(new Integer(assessmentSettings.getSubmissionsAllowed()));
                } else {
                    control.setSubmissionsAllowed(Integer.valueOf("1"));
                }
            } else {
                control.setUnlimitedSubmissions(Boolean.TRUE);
                control.setSubmissionsAllowed(null);
            }
        }
        if (assessmentSettings.getLateHandling() != null) {
            control.setLateHandling(new Integer(assessmentSettings.getLateHandling()));
        }
        if (assessmentSettings.getSubmissionsSaved() != null) {
            control.setSubmissionsSaved(new Integer(assessmentSettings.getSubmissionsSaved()));
        }
        if (assessmentSettings.getAutoSubmit()) {
            control.setAutoSubmit(AssessmentAccessControl.AUTO_SUBMIT);
        } else {
            control.setAutoSubmit(AssessmentAccessControl.DO_NOT_AUTO_SUBMIT);
        }
        assessment.setAssessmentAccessControl((AssessmentAccessControlIfc)control);
        control.setSubmissionMessage(assessmentSettings.getSubmissionMessage());
        control.setUsername(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getUsername()));
        control.setPassword(TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getPassword()));
        String finalPageUrl = "";
        if (assessmentSettings.getFinalPageUrl() != null && (finalPageUrl = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getFinalPageUrl().trim())).length() != 0 && !finalPageUrl.toLowerCase().startsWith("http")) {
            finalPageUrl = "http://" + finalPageUrl;
        }
        control.setFinalPageUrl(finalPageUrl);
        AssessmentFeedbackIfc feedback = assessment.getAssessmentFeedback();
        if (feedback == null) {
            feedback = new AssessmentFeedback();
            feedback.setAssessmentBase((AssessmentBaseIfc)assessment.getData());
        }
        if (assessmentSettings.getFeedbackAuthoring() != null) {
            feedback.setFeedbackAuthoring(new Integer(assessmentSettings.getFeedbackAuthoring()));
        }
        if (assessmentSettings.getFeedbackDelivery() != null) {
            feedback.setFeedbackDelivery(new Integer(assessmentSettings.getFeedbackDelivery()));
        }
        if (assessmentSettings.getFeedbackComponentOption() != null) {
            feedback.setFeedbackComponentOption(new Integer(assessmentSettings.getFeedbackComponentOption()));
        }
        control.setFeedbackDate(assessmentSettings.getFeedbackDate());
        feedback.setShowStudentResponse(Boolean.valueOf(assessmentSettings.getShowStudentResponse()));
        feedback.setShowCorrectResponse(Boolean.valueOf(assessmentSettings.getShowCorrectResponse()));
        feedback.setShowStudentScore(Boolean.valueOf(assessmentSettings.getShowStudentScore()));
        feedback.setShowStudentQuestionScore(Boolean.valueOf(assessmentSettings.getShowStudentQuestionScore()));
        feedback.setShowQuestionLevelFeedback(Boolean.valueOf(assessmentSettings.getShowQuestionLevelFeedback()));
        feedback.setShowSelectionLevelFeedback(Boolean.valueOf(assessmentSettings.getShowSelectionLevelFeedback()));
        feedback.setShowGraderComments(Boolean.valueOf(assessmentSettings.getShowGraderComments()));
        feedback.setShowStatistics(Boolean.valueOf(assessmentSettings.getShowStatistics()));
        assessment.setAssessmentFeedback(feedback);
        EvaluationModelIfc evaluation = assessment.getEvaluationModel();
        if (evaluation == null) {
            evaluation = new EvaluationModel();
            evaluation.setAssessmentBase((AssessmentBaseIfc)assessment.getData());
        }
        if (assessmentSettings.getAnonymousGrading() != null) {
            evaluation.setAnonymousGrading(new Integer(assessmentSettings.getAnonymousGrading()));
        }
        if (assessmentSettings.getToDefaultGradebook() != null) {
            evaluation.setToGradeBook(assessmentSettings.getToDefaultGradebook());
        }
        if (assessmentSettings.getScoringType() != null) {
            evaluation.setScoringType(new Integer(assessmentSettings.getScoringType()));
        }
        assessment.setEvaluationModel(evaluation);
        HashMap h = assessmentSettings.getValueMap();
        saveAssessmentSettings.updateMetaWithValueMap((AssessmentIfc)assessment, h);
        assessment.updateAssessmentMetaData("ASSESSMENT_BGCOLOR", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getBgColor()));
        assessment.updateAssessmentMetaData("ASSESSMENT_BGIMAGE", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getBgImage()));
        assessment.updateAssessmentMetaData("ASSESSMENT_KEYWORDS", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getKeywords()));
        assessment.updateAssessmentMetaData("ASSESSMENT_OBJECTIVES", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getObjectives()));
        assessment.updateAssessmentMetaData("ASSESSMENT_RUBRICS", TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getRubrics()));
    }

    public boolean checkScore(PublishedAssessmentSettingsBean assessmentSettings, PublishedAssessmentFacade assessment, FacesContext context) {
        boolean gbError = false;
        if (assessmentSettings.getToDefaultGradebook() != null && assessmentSettings.getToDefaultGradebook().equals("1") && assessment.getTotalScore().floatValue() <= 0.0f) {
            String gb_err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_min_points");
            context.addMessage(null, new FacesMessage(gb_err));
            gbError = true;
        }
        return gbError;
    }

    public boolean updateGB(PublishedAssessmentSettingsBean assessmentSettings, PublishedAssessmentFacade assessment, boolean isTitleChanged, boolean isScoringTypeChanged, FacesContext context) {
        GradebookService g = null;
        if (integrated) {
            g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
        }
        if (gbsHelper.gradebookExists(GradebookFacade.getGradebookUId(), g)) {
            PublishedEvaluationModel evaluation = (PublishedEvaluationModel)assessment.getEvaluationModel();
            if (evaluation == null) {
                evaluation = new PublishedEvaluationModel();
                evaluation.setAssessmentBase((AssessmentBaseIfc)assessment.getData());
            }
            String assessmentName = "";
            boolean gbItemExists = false;
            try {
                assessmentName = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)assessmentSettings.getTitle().trim());
                gbItemExists = gbsHelper.isAssignmentDefined(assessmentName, g);
                if (assessmentSettings.getToDefaultGradebook() != null && assessmentSettings.getToDefaultGradebook().equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString()) && gbItemExists && isTitleChanged) {
                    String gbConflict_error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AssessmentSettingsMessages", (String)"gbConflict_error");
                    context.addMessage(null, new FacesMessage(gbConflict_error));
                    return false;
                }
            }
            catch (Exception e) {
                log.warn((Object)("external assessment in GB has the same title:" + e.getMessage()));
            }
            if (assessmentSettings.getToDefaultGradebook() != null) {
                evaluation.setToGradeBook(assessmentSettings.getToDefaultGradebook());
            }
            if (AssessmentBaseIfc.RETRACT_FOR_EDIT_STATUS.equals(assessment.getStatus())) {
                return true;
            }
            Integer scoringType = evaluation.getScoringType();
            if (evaluation.getToGradeBook() != null && evaluation.getToGradeBook().equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString())) {
                if (isTitleChanged || isScoringTypeChanged) {
                    try {
                        log.debug((Object)"before gbsHelper.removeGradebook()");
                        gbsHelper.removeExternalAssessment(GradebookFacade.getGradebookUId(), assessment.getPublishedAssessmentId().toString(), g);
                    }
                    catch (Exception e1) {
                        log.info((Object)("Exception thrown in updateGB():" + e1.getMessage()));
                    }
                }
                if (gbItemExists && !isTitleChanged && !isScoringTypeChanged) {
                    try {
                        gbsHelper.updateGradebook((PublishedAssessmentIfc)assessment, g);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Exception thrown in updateGB():" + e.getMessage()));
                    }
                } else {
                    try {
                        log.debug((Object)"before gbsHelper.addToGradebook()");
                        gbsHelper.addToGradebook((PublishedAssessmentData)assessment.getData(), g);
                        GradingService gradingService = new GradingService();
                        List list = null;
                        list = scoringType.equals(EvaluationModelIfc.HIGHEST_SCORE) ? gradingService.getHighestSubmittedOrGradedAssessmentGradingList(assessment.getPublishedAssessmentId()) : gradingService.getLastSubmittedOrGradedAssessmentGradingList(assessment.getPublishedAssessmentId());
                        log.debug((Object)("list size =" + list.size()));
                        for (int i = 0; i < list.size(); ++i) {
                            try {
                                AssessmentGradingData ag = (AssessmentGradingData)list.get(i);
                                log.debug((Object)("ag.scores " + ag.getTotalAutoScore()));
                                if (scoringType.equals(EvaluationModelIfc.AVERAGE_SCORE)) {
                                    if (ag.getStatus() == 5) {
                                        ag.setFinalScore(ag.getFinalScore());
                                    } else {
                                        Float averageScore = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAverageSubmittedAssessmentGrading(Long.valueOf(assessment.getPublishedAssessmentId()), ag.getAgentId());
                                        ag.setFinalScore(averageScore);
                                    }
                                }
                                gbsHelper.updateExternalAssessmentScore((AssessmentGradingIfc)ag, g);
                                continue;
                            }
                            catch (Exception e) {
                                log.warn((Object)("Exception occues in " + i + "th record. Message:" + e.getMessage()));
                            }
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("oh well, must have been added already:" + e.getMessage()));
                    }
                }
            } else {
                try {
                    gbsHelper.removeExternalAssessment(GradebookFacade.getGradebookUId(), assessment.getPublishedAssessmentId().toString(), g);
                }
                catch (Exception e) {
                    log.warn((Object)("*** oh well, looks like there is nothing to remove:" + e.getMessage()));
                }
            }
        }
        return true;
    }

    public void resetPublishedAssessmentsList(AuthorBean author, PublishedAssessmentService assessmentService) {
        AuthorActionListener authorActionListener = new AuthorActionListener();
        GradingService gradingService = new GradingService();
        ArrayList publishedAssessmentList = assessmentService.getBasicInfoOfAllPublishedAssessments2("title", true, AgentFacade.getCurrentSiteId());
        authorActionListener.prepareAllPublishedAssessmentsList(author, gradingService, publishedAssessmentList);
    }
}

