/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.listener.author.AuthorActionListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class SortInactivePublishedAssessmentListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SortInactivePublishedAssessmentListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        this.processSortInfo(author);
        AuthorActionListener authorActionListener = new AuthorActionListener();
        GradingService gradingService = new GradingService();
        ArrayList publishedAssessmentList = publishedAssessmentService.getBasicInfoOfAllPublishedAssessments2(this.getInactivePublishedOrderBy(author), author.isInactivePublishedAscending(), AgentFacade.getCurrentSiteId());
        authorActionListener.prepareAllPublishedAssessmentsList(author, gradingService, publishedAssessmentList);
        author.setJustPublishedAnAssessment(true);
    }

    private String getInactivePublishedOrderBy(AuthorBean author) {
        String sort = author.getInactivePublishedAssessmentOrderBy();
        String returnType = "title";
        if (sort == null) {
            return returnType;
        }
        if ("releaseTo".equals(sort)) {
            returnType = "releaseTo";
        } else if ("startDate".equals(sort)) {
            returnType = "startDate";
        } else if ("dueDate".equals(sort)) {
            returnType = "dueDate";
        }
        return returnType;
    }

    private void processSortInfo(AuthorBean bean) {
        String inactiveOrder = ContextUtil.lookupParam((String)"inactiveSortType");
        String inactivePublishedAscending = ContextUtil.lookupParam((String)"inactivePublishedAscending");
        if (inactiveOrder != null && !inactiveOrder.trim().equals("")) {
            bean.setInactivePublishedAssessmentOrderBy(inactiveOrder);
        }
        if (inactivePublishedAscending != null && !inactivePublishedAscending.trim().equals("")) {
            try {
                bean.setInactivePublishedAscending(Boolean.valueOf(inactivePublishedAscending).booleanValue());
            }
            catch (Exception ex) {
                log.warn((Object)ex.getMessage());
            }
        } else {
            bean.setInactivePublishedAscending(true);
        }
    }
}

