/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.util.ArrayList;
import java.util.Collections;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.IndexBean;
import org.sakaiproject.tool.assessment.ui.bean.author.TemplateBean;
import org.sakaiproject.tool.assessment.ui.listener.author.TemplateBaseListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.BeanSort;

public class TemplateListener
extends TemplateBaseListener
implements ActionListener {
    private static Log log = LogFactory.getLog(TemplateListener.class);
    private static BeanSort bs;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        AssessmentService assessmentService = new AssessmentService();
        IndexBean templateIndex = (IndexBean)ContextUtil.lookupBean((String)"templateIndex");
        this.processSortInfo(templateIndex);
        String autoSubmitEnabled = ServerConfigurationService.getString((String)"samigo.autoSubmit.enabled");
        if (autoSubmitEnabled == null || autoSubmitEnabled.equals("") || !autoSubmitEnabled.equals("true")) {
            templateIndex.setAutomaticSubmissionEnabled(false);
        } else {
            templateIndex.setAutomaticSubmissionEnabled(true);
        }
        ArrayList templates = new ArrayList();
        try {
            FacesContext.getCurrentInstance().getExternalContext().getSessionMap().put("template", new TemplateBean());
            ArrayList list = assessmentService.getBasicInfoOfAllActiveAssessmentTemplates("title");
            for (AssessmentTemplateFacade facade : list) {
                TemplateBean bean = new TemplateBean();
                bean.setTemplateName(facade.getTitle());
                bean.setIdString(facade.getAssessmentBaseId().toString());
                bean.setLastModified(facade.getLastModifiedDate().toString());
                bean.setTypeId(facade.getTypeId().toString());
                templates.add(bean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sortProperty = templateIndex.getTemplateOrderBy();
        boolean sortAscending = templateIndex.isTemplateAscending();
        bs = new BeanSort(templates, sortProperty);
        if (templates != null) {
            if ("lastModified".equals(sortProperty)) {
                bs.toDateSort();
            } else {
                bs.toStringSort();
            }
        }
        templates = (ArrayList)bs.sort();
        if (!sortAscending) {
            Collections.reverse(templates);
        }
        templateIndex.setSortTemplateList(templates);
    }

    private void processSortInfo(IndexBean bean) {
        bean.setTemplateOrderBy("templateName");
        bean.setTemplateAscending(true);
        String templateOrder = ContextUtil.lookupParam((String)"templateSortType");
        String tempAscending = ContextUtil.lookupParam((String)"templateAscending");
        if (templateOrder != null && !templateOrder.trim().equals("")) {
            bean.setTemplateOrderBy(templateOrder);
        }
        if (tempAscending != null && !tempAscending.trim().equals("")) {
            try {
                bean.setTemplateAscending(Boolean.valueOf(tempAscending).booleanValue());
            }
            catch (Exception ex) {
                log.warn((Object)("tempAscending is not a boolena value:" + ex.getMessage()));
            }
        }
    }
}

