/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.author;

import java.text.SimpleDateFormat;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.TemplateBean;
import org.sakaiproject.tool.assessment.ui.listener.author.TemplateBaseListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.util.FormattedText;

public class TemplateLoadListener
extends TemplateBaseListener
implements ActionListener {
    private static Log log = LogFactory.getLog(TemplateLoadListener.class);
    private static ContextUtil cu;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        TemplateBean templateBean = this.lookupTemplateBean(context);
        String templateId = ContextUtil.lookupParam((String)"templateId");
        this.loadAssessment(templateBean, templateId);
    }

    public boolean loadAssessment(TemplateBean templateBean, String templateId) {
        try {
            AssessmentFeedback feedback;
            EvaluationModel model;
            AssessmentService delegate = new AssessmentService();
            AssessmentTemplateFacade template = delegate.getAssessmentTemplate(templateId);
            templateBean.setIdString(templateId);
            templateBean.setTemplateName(FormattedText.convertFormattedTextToPlaintext((String)template.getTitle()));
            templateBean.setTemplateAuthor(FormattedText.convertFormattedTextToPlaintext((String)((String)template.getAssessmentMetaDataMap(template.getAssessmentMetaDataSet()).get("author"))));
            templateBean.setTemplateDescription(template.getDescription());
            AssessmentAccessControl aac = (AssessmentAccessControl)template.getAssessmentAccessControl();
            if (aac != null) {
                if (aac.getItemNavigation() != null) {
                    templateBean.setItemAccessType(aac.getItemNavigation().toString());
                }
                if (aac.getAssessmentFormat() != null) {
                    templateBean.setDisplayChunking(aac.getAssessmentFormat().toString());
                }
                if (aac.getItemNumbering() != null) {
                    templateBean.setQuestionNumbering(aac.getItemNumbering().toString());
                }
                if (aac.getMarkForReview() != null) {
                    if (aac.getMarkForReview().equals(1)) {
                        templateBean.setMarkForReview(Boolean.TRUE);
                    } else {
                        templateBean.setMarkForReview(Boolean.FALSE);
                    }
                } else {
                    templateBean.setMarkForReview(Boolean.FALSE);
                }
                if (aac.getSubmissionsSaved() != null) {
                    templateBean.setSubmissionModel(aac.getSubmissionsSaved().toString());
                }
                if (aac.getUnlimitedSubmissions().equals(Boolean.TRUE)) {
                    templateBean.setSubmissionModel(AssessmentAccessControlIfc.UNLIMITED_SUBMISSIONS.toString());
                    templateBean.setSubmissionNumber(null);
                } else {
                    templateBean.setSubmissionModel(AssessmentAccessControlIfc.LIMITED_SUBMISSIONS.toString());
                    if (aac.getSubmissionsAllowed() != null) {
                        templateBean.setSubmissionNumber(aac.getSubmissionsAllowed().toString());
                    } else {
                        templateBean.setSubmissionNumber("0");
                    }
                }
                if (aac.getLateHandling() != null) {
                    templateBean.setLateHandling(aac.getLateHandling().toString());
                }
                if (aac.getAutoSubmit() != null && aac.getAutoSubmit() == 1) {
                    templateBean.setAutomaticSubmission(Boolean.TRUE);
                }
            } else {
                templateBean.setAutomaticSubmission(Boolean.FALSE);
            }
            if ((model = (EvaluationModel)template.getEvaluationModel()) != null) {
                if (model.getAnonymousGrading() != null) {
                    templateBean.setAnonymousGrading(model.getAnonymousGrading().toString());
                }
                templateBean.setToGradebook(model.getToGradeBook());
                if (model.getScoringType() != null) {
                    templateBean.setRecordedScore(model.getScoringType().toString());
                }
            }
            if ((feedback = (AssessmentFeedback)template.getAssessmentFeedback()) != null) {
                if (feedback.getFeedbackDelivery() != null) {
                    templateBean.setFeedbackType(feedback.getFeedbackDelivery().toString());
                }
                if (feedback.getFeedbackAuthoring() != null) {
                    templateBean.setFeedbackAuthoring(feedback.getFeedbackAuthoring().toString());
                }
                templateBean.setFeedbackComponent_QuestionText(feedback.getShowQuestionText());
                templateBean.setFeedbackComponent_StudentResp(feedback.getShowStudentResponse());
                templateBean.setFeedbackComponent_CorrectResp(feedback.getShowCorrectResponse());
                templateBean.setFeedbackComponent_StudentScore(feedback.getShowStudentScore());
                templateBean.setFeedbackComponent_StudentQuestionScore(feedback.getShowStudentQuestionScore());
                templateBean.setFeedbackComponent_QuestionLevel(feedback.getShowQuestionLevelFeedback());
                templateBean.setFeedbackComponent_SelectionLevel(feedback.getShowSelectionLevelFeedback());
                templateBean.setFeedbackComponent_GraderComments(feedback.getShowGraderComments());
                templateBean.setFeedbackComponent_Statistics(feedback.getShowStatistics());
            }
            SimpleDateFormat format = new SimpleDateFormat();
            templateBean.setCreatedDate(format.format(template.getCreatedDate()));
            templateBean.setCreatedBy(template.getCreatedBy());
            templateBean.setLastModified(template.getLastModifiedDate().toString());
            templateBean.setLastModifiedBy(template.getLastModifiedBy());
            templateBean.setTypeId(template.getTypeId().toString());
            templateBean.setValueMap(template.getAssessmentMetaDataMap(template.getAssessmentMetaDataSet()));
        }
        catch (RuntimeException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }
}

