/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.delivery;

import java.util.ArrayList;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class SaCharCountListener
implements ActionListener {
    private static Log log = LogFactory.getLog(SaCharCountListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        String itemId = ContextUtil.lookupParam((String)"itemId");
        if (itemId == null) {
            return;
        }
        StringBuffer redrawAnchorName = new StringBuffer("p");
        for (SectionContentsBean part : delivery.getPageContents().getPartsContents()) {
            String partSeq = part.getNumber();
            redrawAnchorName.append(partSeq);
            for (ItemContentsBean item : part.getItemContents()) {
                ItemDataIfc itemData = item.getItemData();
                ArrayList itemGradingDataArray = item.getItemGradingDataArray();
                if (itemGradingDataArray != null && itemGradingDataArray.size() != 0) {
                    for (ItemGradingData itemGrading : itemGradingDataArray) {
                        if (itemData == null || !itemId.equals(itemData.getItemIdString()) || itemGrading.getAnswerText() == null) continue;
                        if (itemGrading.getAnswerText() != null) {
                            String processedAnswerText = itemGrading.getAnswerText().replaceAll("\r", "").replaceAll("\n", "");
                            int saCharCount = processedAnswerText.length();
                            String formattedCount = String.format("%,d\n", saCharCount);
                            item.setSaCharCount(formattedCount);
                            if (saCharCount > 60000) {
                                item.setIsInvalidSALengthInput(true);
                            } else {
                                item.setIsInvalidSALengthInput(false);
                            }
                        } else {
                            item.setSaCharCount("0");
                            item.setIsInvalidSALengthInput(false);
                        }
                        redrawAnchorName.append("q");
                        String itemSeq = itemData.getSequence().toString();
                        redrawAnchorName.append(itemSeq);
                        delivery.setRedrawAnchorName(redrawAnchorName.toString());
                    }
                    continue;
                }
                if (!itemId.equals(itemData.getItemIdString())) continue;
                item.setSaCharCount("0");
                redrawAnchorName.append("q");
                String itemSeq = itemData.getSequence().toString();
                redrawAnchorName.append(itemSeq);
                delivery.setRedrawAnchorName(redrawAnchorName.toString());
            }
        }
        delivery.syncTimeElapsedWithServer();
    }
}

