/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.ItemContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.SectionContentsBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.StudentScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.delivery.DeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.evaluation.util.EvaluationListenerUtil;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.BeanSort;
import org.sakaiproject.util.FormattedText;

public class StudentScoreListener
implements ActionListener {
    private static Log log = LogFactory.getLog(StudentScoreListener.class);
    private static EvaluationListenerUtil util;
    private static BeanSort bs;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"StudentScore LISTENER.");
        StudentScoresBean bean = (StudentScoresBean)ContextUtil.lookupBean((String)"studentScores");
        String publishedId = ContextUtil.lookupParam((String)"publishedIdd");
        log.debug((Object)"Calling studentScores.");
        if (!this.studentScores(publishedId, bean, false)) {
            throw new RuntimeException("failed to call studentScores.");
        }
    }

    public boolean studentScores(String publishedId, StudentScoresBean bean, boolean isValueChange) {
        log.debug((Object)"studentScores()");
        try {
            bean.setPublishedId(publishedId);
            String studentId = ContextUtil.lookupParam((String)"studentid");
            bean.setStudentId(studentId);
            AgentFacade agent = new AgentFacade(studentId);
            bean.setStudentName(agent.getFirstName() + " " + agent.getLastName());
            bean.setLastName(agent.getLastName());
            bean.setFirstName(agent.getFirstName());
            bean.setAssessmentGradingId(ContextUtil.lookupParam((String)"gradingData"));
            bean.setItemId(ContextUtil.lookupParam((String)"itemId"));
            bean.setEmail(agent.getEmail());
            DeliveryBean dbean = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
            dbean.setActionString("gradeAssessment");
            GradingService service = new GradingService();
            AssessmentGradingData adata = service.load(bean.getAssessmentGradingId());
            DeliveryActionListener listener = new DeliveryActionListener();
            listener.processAction(null);
            DeliveryBean updatedDeliveryBean = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
            ArrayList parts = updatedDeliveryBean.getPageContents().getPartsContents();
            Iterator iter = parts.iterator();
            while (iter.hasNext()) {
                ArrayList items = ((SectionContentsBean)iter.next()).getItemContents();
                for (ItemContentsBean question : items) {
                    if (question.getGradingComment() == null || question.getGradingComment().equals("")) continue;
                    question.setGradingComment(FormattedText.convertFormattedTextToPlaintext((String)question.getGradingComment()));
                }
            }
            bean.setComments(FormattedText.convertFormattedTextToPlaintext((String)adata.getComments()));
            this.buildItemContentsMap(dbean);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void buildItemContentsMap(DeliveryBean dbean) {
        HashMap<Long, ItemContentsBean> itemContentsMap = new HashMap<Long, ItemContentsBean>();
        ArrayList partsContents = dbean.getPageContents().getPartsContents();
        if (partsContents != null) {
            for (SectionContentsBean sectionContentsBean : partsContents) {
                if (sectionContentsBean == null) continue;
                ArrayList itemContents = sectionContentsBean.getItemContents();
                for (ItemContentsBean itemContentsBean : itemContents) {
                    if (itemContentsBean == null) continue;
                    ArrayList itemGradingDataArray = itemContentsBean.getItemGradingDataArray();
                    for (ItemGradingData itemGradingData : itemGradingDataArray) {
                        itemContentsMap.put(itemGradingData.getItemGradingId(), itemContentsBean);
                    }
                }
            }
        }
        dbean.setItemContentsMap(itemContentsMap);
    }
}

