/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.evaluation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.StudentGradingSummaryData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.AgentHelper;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.AgentResults;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.QuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.RetakeAssessmentBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.SubmissionStatusBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.evaluation.TotalScoreListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.BeanSort;

public class SubmissionStatusListener
implements ActionListener,
ValueChangeListener {
    private static Log log = LogFactory.getLog(SubmissionStatusListener.class);
    private static BeanSort bs;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        SubmissionStatusBean bean = (SubmissionStatusBean)ContextUtil.lookupBean((String)"submissionStatus");
        TotalScoresBean totalScoresBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        String defaultSearchString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"search_default_student_search_string");
        bean.setSearchString(defaultSearchString);
        if (!this.submissionStatus(publishedId, bean, totalScoresBean, false)) {
            throw new RuntimeException("failed to call submissionStatus.");
        }
    }

    public void processValueChange(ValueChangeEvent event) {
        log.debug((Object)"QuestionScore CHANGE LISTENER.");
        SubmissionStatusBean bean = (SubmissionStatusBean)ContextUtil.lookupBean((String)"submissionStatus");
        TotalScoresBean totalScoresBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        QuestionScoresBean questionbean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        String selectedvalue = (String)event.getNewValue();
        if (selectedvalue != null && !selectedvalue.equals("") && event.getComponent().getId().indexOf("sectionpicker") > -1) {
            bean.setSelectedSectionFilterValue(selectedvalue);
            totalScoresBean.setSelectedSectionFilterValue(selectedvalue);
            questionbean.setSelectedSectionFilterValue(selectedvalue);
        }
        if (!this.submissionStatus(publishedId, bean, totalScoresBean, false)) {
            throw new RuntimeException("failed to call questionScores.");
        }
    }

    public boolean submissionStatus(String publishedId, SubmissionStatusBean bean, TotalScoresBean totalScoresBean, boolean isValueChange) {
        log.debug((Object)"submissionStatus()");
        try {
            TotalScoreListener totalScorelistener = new TotalScoreListener();
            GradingService delegate = new GradingService();
            if (ContextUtil.lookupParam((String)"sortBy") != null && !ContextUtil.lookupParam((String)"sortBy").trim().equals("")) {
                bean.setSortType(ContextUtil.lookupParam((String)"sortBy"));
            }
            boolean sortAscending = true;
            if (ContextUtil.lookupParam((String)"sortAscending") != null && !ContextUtil.lookupParam((String)"sortAscending").trim().equals("")) {
                sortAscending = Boolean.valueOf(ContextUtil.lookupParam((String)"sortAscending"));
                bean.setSortAscending(sortAscending);
                log.debug((Object)("submissionStatus() :: sortAscending = " + sortAscending));
            }
            totalScoresBean.setSelectedSectionFilterValue(bean.getSelectedSectionFilterValue());
            bean.setPublishedId(publishedId);
            List scores = delegate.getLastSubmittedAssessmentGradingList(new Long(publishedId));
            ArrayList agents = new ArrayList();
            Iterator iter = scores.iterator();
            if (!iter.hasNext()) {
                bean.setAgents(agents);
                bean.setAllAgents(agents);
                bean.setTotalPeople(Integer.toString(bean.getAgents().size()));
                return true;
            }
            Object next = iter.next();
            Map useridMap = totalScoresBean.getUserIdMap(1);
            ArrayList agentUserIds = totalScorelistener.getAgentIds(useridMap);
            AgentHelper helper = IntegrationContextFactory.getInstance().getAgentHelper();
            Map userRoles = helper.getUserRolesFromContextRealm((Collection)agentUserIds);
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            AssessmentGradingData data = (AssessmentGradingData)next;
            PublishedAssessmentFacade pub = pubService.getPublishedAssessment(data.getPublishedAssessmentId().toString());
            if (pub != null) {
                bean.setAssessmentName(pub.getTitle());
            }
            if (ContextUtil.lookupParam((String)"roleSelection") != null) {
                bean.setRoleSelection(ContextUtil.lookupParam((String)"roleSelection"));
            }
            if (bean.getSortType() == null) {
                bean.setSortType("agentEid");
            }
            ArrayList<String> students_submitted = new ArrayList<String>();
            iter = scores.iterator();
            HashMap studentGradingSummaryDataMap = new HashMap();
            RetakeAssessmentBean retakeAssessment = (RetakeAssessmentBean)ContextUtil.lookupBean((String)"retakeAssessment");
            while (iter.hasNext()) {
                AgentResults results = new AgentResults();
                AssessmentGradingData gdata = (AssessmentGradingData)iter.next();
                gdata.setItemGradingSet(new HashSet());
                BeanUtils.copyProperties((Object)results, (Object)gdata);
                results.setAssessmentGradingId(gdata.getAssessmentGradingId());
                String agentid = gdata.getAgentId();
                AgentFacade agent = new AgentFacade(agentid);
                results.setLastName(agent.getLastName());
                results.setFirstName(agent.getFirstName());
                results.setEmail(agent.getEmail());
                if (results.getLastName() != null && results.getLastName().length() > 0) {
                    results.setLastInitial(results.getLastName().substring(0, 1));
                } else if (results.getFirstName() != null && results.getFirstName().length() > 0) {
                    results.setLastInitial(results.getFirstName().substring(0, 1));
                } else {
                    results.setLastInitial("A");
                }
                results.setIdString(agent.getIdString());
                results.setAgentEid(agent.getEidString());
                results.setRole((String)userRoles.get(agentid));
                results.setRetakeAllowed(this.getRetakeAllowed(agent.getIdString(), studentGradingSummaryDataMap, retakeAssessment));
                if (!useridMap.containsKey(agentid)) continue;
                agents.add(results);
                students_submitted.add(agentid);
            }
            retakeAssessment.setStudentGradingSummaryDataMap(studentGradingSummaryDataMap);
            ArrayList<String> students_not_submitted = new ArrayList<String>();
            for (String userid : useridMap.keySet()) {
                if (students_submitted.contains(userid)) continue;
                students_not_submitted.add(userid);
            }
            this.prepareNotSubmittedAgentResult(students_not_submitted.iterator(), agents, userRoles, retakeAssessment, studentGradingSummaryDataMap);
            bs = new BeanSort(agents, bean.getSortType());
            if (bean.getSortType().equals("assessmentGradingId")) {
                bs.toNumericSort();
            } else {
                bs.toStringSort();
            }
            if (sortAscending) {
                log.debug((Object)"TotalScoreListener: setRoleAndSortSection() :: sortAscending");
                agents = (ArrayList)bs.sort();
            } else {
                log.debug((Object)"TotalScoreListener: setRoleAndSortSection() :: !sortAscending");
                agents = (ArrayList)bs.sortDesc();
            }
            bean.setAgents((Collection)agents);
            bean.setAllAgents(agents);
            bean.setTotalPeople(Integer.toString(bean.getAgents().size()));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void prepareNotSubmittedAgentResult(Iterator notsubmitted_iter, ArrayList agents, Map userRoles, RetakeAssessmentBean retakeAssessment, HashMap studentGradingSummaryDataMap) {
        while (notsubmitted_iter.hasNext()) {
            String studentid = (String)notsubmitted_iter.next();
            AgentResults results = new AgentResults();
            AgentFacade agent = new AgentFacade(studentid);
            results.setLastName(agent.getLastName());
            results.setFirstName(agent.getFirstName());
            results.setEmail(agent.getEmail());
            if (results.getLastName() != null && results.getLastName().length() > 0) {
                results.setLastInitial(results.getLastName().substring(0, 1));
            } else if (results.getFirstName() != null && results.getFirstName().length() > 0) {
                results.setLastInitial(results.getFirstName().substring(0, 1));
            } else {
                results.setLastInitial("Anonymous");
            }
            results.setIdString(agent.getIdString());
            results.setAgentEid(agent.getEidString());
            results.setRole((String)userRoles.get(studentid));
            results.setRetakeAllowed(this.getRetakeAllowed(agent.getIdString(), studentGradingSummaryDataMap, retakeAssessment));
            retakeAssessment.setStudentGradingSummaryDataMap(studentGradingSummaryDataMap);
            agents.add(results);
        }
    }

    public boolean getRetakeAllowed(String agentId, HashMap studentGradingSummaryDataMap, RetakeAssessmentBean retakeAssessment) {
        TotalScoresBean totalScoresBean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        PublishedAssessmentData publishedAssessmentData = totalScoresBean.getPublishedAssessment();
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        int totalSubmitted = pubService.getTotalSubmission(agentId, publishedAssessmentData.getPublishedAssessmentId().toString());
        AssessmentAccessControlIfc assessmentAccessControl = publishedAssessmentData.getAssessmentAccessControl();
        Date currentDate = new Date();
        Date startDate = assessmentAccessControl.getStartDate();
        Date dueDate = assessmentAccessControl.getDueDate();
        GradingService gradingService = new GradingService();
        List studentGradingSummaryDataList = gradingService.getStudentGradingSummaryData(publishedAssessmentData.getPublishedAssessmentId(), agentId);
        StudentGradingSummaryData studentGradingSummaryData = null;
        int numberRetake = 0;
        if (studentGradingSummaryDataList.size() != 0) {
            studentGradingSummaryData = (StudentGradingSummaryData)studentGradingSummaryDataList.get(0);
            studentGradingSummaryDataMap.put(agentId, studentGradingSummaryData);
            retakeAssessment.setStudentGradingSummaryData(studentGradingSummaryData);
            numberRetake = studentGradingSummaryData.getNumberRetake();
        } else {
            retakeAssessment.setStudentGradingSummaryData(null);
        }
        boolean acceptLateSubmission = AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION.equals(assessmentAccessControl.getLateHandling());
        if (startDate == null || startDate.before(currentDate)) {
            if (dueDate != null && dueDate.before(currentDate)) {
                if (acceptLateSubmission && totalSubmitted == 0) {
                    return false;
                }
                int actualNumberRetake = gradingService.getActualNumberRetake(publishedAssessmentData.getPublishedAssessmentId(), agentId);
                if (actualNumberRetake == numberRetake) {
                    return true;
                }
            } else {
                int maxSubmissionsAllowed = 9999;
                if (Boolean.FALSE.equals(assessmentAccessControl.getUnlimitedSubmissions())) {
                    maxSubmissionsAllowed = assessmentAccessControl.getSubmissionsAllowed();
                }
                if (totalSubmitted >= maxSubmissionsAllowed + numberRetake) {
                    return true;
                }
            }
        }
        return false;
    }
}

