/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.business.entity.RecordingData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.AgentHelper;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.author.AuthorBean;
import org.sakaiproject.tool.assessment.ui.bean.authz.AuthorizationBean;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.AgentResults;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.HistogramScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.QuestionScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.SubmissionStatusBean;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.bean.util.EmailBean;
import org.sakaiproject.tool.assessment.ui.listener.evaluation.ResetTotalScoreListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.BeanSort;
import org.sakaiproject.util.FormattedText;

public class TotalScoreListener
implements ActionListener,
ValueChangeListener {
    private static Log log = LogFactory.getLog(TotalScoreListener.class);
    private static BeanSort bs;

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"TotalScore Action Listener.");
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBean((String)"delivery");
        TotalScoresBean bean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        QuestionScoresBean questionbean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
        HistogramScoresBean histobean = (HistogramScoresBean)ContextUtil.lookupBean((String)"histogramScores");
        SubmissionStatusBean submissionbean = (SubmissionStatusBean)ContextUtil.lookupBean((String)"submissionStatus");
        EmailBean emailBean = (EmailBean)ContextUtil.lookupBean((String)"email");
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        PublishedAssessmentService pubAssessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade pubAssessment = pubAssessmentService.getPublishedAssessment(publishedId);
        if (ae == null || ae != null && ae.getComponent().getId().startsWith("authorIndexToScore")) {
            log.debug((Object)"coming from authorIndex");
            if (pubAssessment != null && pubAssessment.getEvaluationModel() != null && pubAssessment.getEvaluationModel().getScoringType() != null) {
                String allSubmissions = pubAssessment.getEvaluationModel().getScoringType().toString();
                bean.setAllSubmissions(allSubmissions);
                questionbean.setAllSubmissions(allSubmissions);
                histobean.setAllSubmissions(allSubmissions);
            } else {
                bean.setAllSubmissions("2");
                questionbean.setAllSubmissions("2");
                histobean.setAllSubmissions("2");
            }
            boolean isReleasedToGroups = false;
            if (pubAssessment != null && pubAssessment.getAssessmentAccessControl() != null) {
                isReleasedToGroups = "Selected Groups".equals(pubAssessment.getAssessmentAccessControl().getReleaseTo());
            }
            if (isReleasedToGroups) {
                bean.setSelectedSectionFilterValue("-2");
            } else {
                bean.setSelectedSectionFilterValue("-1");
            }
        }
        AgentFacade agent = new AgentFacade();
        StringBuilder sb = new StringBuilder(agent.getFirstName());
        sb.append(" ");
        sb.append(agent.getLastName());
        bean.setGraderName(sb.toString());
        emailBean.setFromName(agent.getEmail());
        bean.setGraderEmailInfo(agent.getEmail());
        emailBean.setFromEmailAddress(agent.getEmail());
        FacesContext context = FacesContext.getCurrentInstance();
        AuthorBean author = (AuthorBean)ContextUtil.lookupBean((String)"author");
        author.setOutcome("totalScores");
        if (pubAssessment != null && !this.passAuthz(context, pubAssessment.getCreatedBy())) {
            author.setOutcome("author");
            return;
        }
        delivery.setActionString("gradeAssessment");
        String defaultSearchString = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"search_default_student_search_string");
        bean.setSearchString(defaultSearchString);
        questionbean.setSections(new ArrayList());
        questionbean.setTypeId("0");
        questionbean.setMaxScore("");
        questionbean.setDeliveryItem(new ArrayList());
        questionbean.setSelectedSARationaleView("1");
        if (ae == null) {
            submissionbean.setMaxDisplayedRows(0);
            bean.setMaxDisplayedRows(0);
            questionbean.setHasAudioMaxDisplayedScoreRowsChanged(false);
            questionbean.setMaxDisplayedRows(0);
            questionbean.setOtherMaxDisplayedScoreRows(0);
            questionbean.setAudioMaxDisplayedScoreRows(5);
        }
        if (!this.totalScores(pubAssessment, bean, false)) {
            throw new RuntimeException("failed to call totalScores.");
        }
    }

    public void processValueChange(ValueChangeEvent event) {
        ResetTotalScoreListener reset = new ResetTotalScoreListener();
        reset.processAction(null);
        TotalScoresBean bean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        QuestionScoresBean questionbean = (QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores");
        HistogramScoresBean histobean = (HistogramScoresBean)ContextUtil.lookupBean((String)"histogramScores");
        SubmissionStatusBean submissionbean = (SubmissionStatusBean)ContextUtil.lookupBean((String)"submissionStatus");
        String publishedId = ContextUtil.lookupParam((String)"publishedId");
        PublishedAssessmentService pubAssessmentService = new PublishedAssessmentService();
        PublishedAssessmentFacade pubAssessment = pubAssessmentService.getPublishedAssessment(publishedId);
        String selectedvalue = (String)event.getNewValue();
        if (selectedvalue != null && !selectedvalue.equals("")) {
            if (event.getComponent().getId().indexOf("sectionpicker") > -1) {
                log.debug((Object)"changed section picker");
                bean.setSelectedSectionFilterValue(selectedvalue);
                questionbean.setSelectedSectionFilterValue(selectedvalue);
                submissionbean.setSelectedSectionFilterValue(selectedvalue);
            } else {
                log.debug((Object)"changed submission pulldown ");
                bean.setAllSubmissions(selectedvalue);
                histobean.setAllSubmissions(selectedvalue);
                questionbean.setAllSubmissions(selectedvalue);
            }
        }
        if (!this.totalScores(pubAssessment, bean, true)) {
            throw new RuntimeException("failed to call totalScores.");
        }
    }

    public boolean totalScores(PublishedAssessmentFacade pubAssessment, TotalScoresBean bean, boolean isValueChange) {
        log.debug((Object)"TotalScoreListener: totalScores() starts");
        if (ContextUtil.lookupParam((String)"sortBy") != null && !ContextUtil.lookupParam((String)"sortBy").trim().equals("")) {
            bean.setSortType(ContextUtil.lookupParam((String)"sortBy"));
            log.debug((Object)("TotalScoreListener: totalScores() :: sortBy = " + ContextUtil.lookupParam((String)"sortBy")));
        }
        boolean sortAscending = true;
        if (ContextUtil.lookupParam((String)"sortAscending") != null && !ContextUtil.lookupParam((String)"sortAscending").trim().equals("")) {
            sortAscending = Boolean.valueOf(ContextUtil.lookupParam((String)"sortAscending"));
            bean.setSortAscending(sortAscending);
            log.debug((Object)("TotalScoreListener: totalScores() :: sortAscending = " + sortAscending));
        }
        log.debug((Object)"totalScores()");
        try {
            PublishedAccessControl ac;
            boolean firstTime = true;
            PublishedAssessmentData p = (PublishedAssessmentData)pubAssessment.getData();
            if (bean.getPublishedId() != null && bean.getPublishedId().equals(p.getPublishedAssessmentId().toString())) {
                firstTime = false;
            }
            if (!isValueChange) {
                bean.setPublishedAssessment(p);
            }
            if ((ac = (PublishedAccessControl)p.getAssessmentAccessControl()).getTimeLimit() != null && ac.getTimeLimit().equals(0)) {
                bean.setIsTimedAssessment(false);
            } else {
                bean.setIsTimedAssessment(true);
            }
            if (ac.getLateHandling() != null && ac.getLateHandling().equals(AssessmentAccessControlIfc.ACCEPT_LATE_SUBMISSION)) {
                bean.setAcceptLateSubmission(true);
            } else {
                bean.setAcceptLateSubmission(false);
            }
            ArrayList scores = new ArrayList();
            ArrayList students_not_submitted = new ArrayList();
            Map useridMap = bean.getUserIdMap(3);
            ArrayList agents = new ArrayList();
            this.prepareAgentResultList(bean, p, scores, students_not_submitted, useridMap);
            if (scores.size() == 0 && students_not_submitted.size() == 0) {
                bean.setAgents(agents);
                bean.setAllAgents(agents);
                return true;
            }
            if (firstTime) {
                HashSet sectionSet = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getSectionSetForAssessment((PublishedAssessmentIfc)p);
                p.setSectionSet((Set)sectionSet);
                Iterator sectionIter = sectionSet.iterator();
                boolean isAutoScored = true;
                block2: while (sectionIter.hasNext() && isAutoScored) {
                    PublishedSectionData section = (PublishedSectionData)sectionIter.next();
                    Set itemSet = section.getItemSet();
                    for (PublishedItemData item : itemSet) {
                        Long typeId = item.getTypeId();
                        if (!typeId.equals(TypeIfc.FILE_UPLOAD) && !typeId.equals(TypeIfc.ESSAY_QUESTION) && !typeId.equals(TypeIfc.AUDIO_RECORDING)) continue;
                        bean.setIsAutoScored(false);
                        isAutoScored = false;
                        continue block2;
                    }
                }
                if (isAutoScored) {
                    bean.setIsAutoScored(true);
                }
                bean.setFirstItem(this.getFirstItem(p));
                log.debug((Object)("totallistener: firstItem = " + bean.getFirstItem()));
                bean.setHasRandomDrawPart(this.hasRandomPart(p));
            }
            if (firstTime || isValueChange) {
                bean.setAnsweredItems(this.getAnsweredItems(scores, p));
            }
            log.debug((Object)("**firstTime=" + firstTime));
            log.debug((Object)("**isValueChange=" + isValueChange));
            ArrayList agentUserIds = this.getAgentIds(useridMap);
            AgentHelper helper = IntegrationContextFactory.getInstance().getAgentHelper();
            Map userRoles = helper.getUserRolesFromContextRealm((Collection)agentUserIds);
            this.prepareAgentResult(p, scores.iterator(), agents, userRoles);
            this.prepareNotSubmittedAgentResult(students_not_submitted.iterator(), agents, userRoles);
            bean.setAgents(agents);
            bean.setAllAgents(agents);
            bean.setTotalPeople(Integer.toString(bean.getAgents().size()));
            this.setRoleAndSortSelection(bean, agents, sortAscending);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean passAuthz(FacesContext context, String ownerId) {
        boolean hasPrivilege;
        AuthorizationBean authzBean = (AuthorizationBean)ContextUtil.lookupBean((String)"authorization");
        boolean hasPrivilege_any = authzBean.getGradeAnyAssessment();
        boolean hasPrivilege_own0 = authzBean.getGradeOwnAssessment();
        boolean hasPrivilege_own = hasPrivilege_own0 && this.isOwner(ownerId);
        boolean bl = hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        if (!hasPrivilege) {
            String err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"denied_grade_assessment_error");
            context.addMessage("authorIndexForm:grade_assessment_denied", new FacesMessage(err));
        }
        return hasPrivilege;
    }

    public boolean isOwner(String ownerId) {
        boolean isOwner = false;
        String agentId = AgentFacade.getAgentString();
        isOwner = agentId.equals(ownerId);
        log.debug((Object)("***isOwner=" + isOwner));
        return isOwner;
    }

    public Integer getScoringType(PublishedAssessmentData pub) {
        Integer scoringType = EvaluationModelIfc.HIGHEST_SCORE;
        EvaluationModelIfc e = pub.getEvaluationModel();
        if (e != null) {
            scoringType = e.getScoringType();
        }
        return scoringType;
    }

    public HashMap getAnsweredItems(ArrayList scores, PublishedAssessmentData pub) {
        log.debug((Object)("*** in getAnsweredItems.  scores.size = " + scores.size()));
        HashMap<Long, String> answeredItems = new HashMap<Long, String>();
        HashMap<Long, String> h = new HashMap<Long, String>();
        for (int m = 0; m < scores.size(); ++m) {
            AssessmentGradingData a = (AssessmentGradingData)scores.get(m);
            h.put(a.getAssessmentGradingId(), "");
        }
        log.debug((Object)("****h.size " + h.size()));
        List list = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getPublishedItemIds(pub.getPublishedAssessmentId());
        log.debug((Object)("***list .size " + list.size()));
        HashMap itemIdHash = this.getPublishedItemIdHash(pub);
        log.debug((Object)("***temIdHash.size " + itemIdHash.size()));
        block1: for (int i = 0; i < list.size(); ++i) {
            Long itemId = (Long)list.get(i);
            log.debug((Object)("****publishedItemId" + itemId));
            ArrayList l = new ArrayList();
            Object o = itemIdHash.get(itemId);
            if (o != null) {
                l = (ArrayList)o;
            }
            for (int j = 0; j < l.size(); ++j) {
                Long assessmentGradingId = (Long)l.get(j);
                log.debug((Object)("****assessmentGradingId" + assessmentGradingId));
                if (h.get(assessmentGradingId) == null) continue;
                log.debug((Object)("****putting itemid into answeredItems: " + itemId));
                answeredItems.put(itemId, "true");
                continue block1;
            }
        }
        log.debug((Object)("***answeritems.size " + answeredItems.size()));
        return answeredItems;
    }

    public boolean hasRandomPart(PublishedAssessmentData pub) {
        return PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().hasRandomPart(pub.getPublishedAssessmentId());
    }

    public String getFirstItem(PublishedAssessmentData pub) {
        PublishedItemData item = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getFirstPublishedItem(pub.getPublishedAssessmentId());
        if (item != null) {
            return item.getItemId().toString();
        }
        return "";
    }

    public void getFilteredList(TotalScoresBean bean, ArrayList allscores, ArrayList scores, ArrayList students_not_submitted, Map useridMap) {
        if (bean.getReleaseToAnonymous()) {
            scores.addAll(allscores);
        } else {
            ArrayList<String> students_submitted = new ArrayList<String>();
            for (AssessmentGradingData data : allscores) {
                String agentid = data.getAgentId();
                if (!useridMap.containsKey(agentid)) continue;
                scores.add(data);
                students_submitted.add(agentid);
            }
            for (String userid : useridMap.keySet()) {
                if (students_submitted.contains(userid)) continue;
                students_not_submitted.add(userid);
            }
        }
    }

    public void prepareAgentResultList(TotalScoresBean bean, PublishedAssessmentData p, ArrayList scores, ArrayList students_not_submitted, Map useridMap) {
        GradingService delegate = new GradingService();
        ArrayList allscores = bean.getAssessmentGradingList();
        if (allscores == null || allscores.size() == 0) {
            PublishedAccessControl ac = (PublishedAccessControl)p.getAssessmentAccessControl();
            if (ac.getUnlimitedSubmissions() != null && !ac.getUnlimitedSubmissions().booleanValue() && ac.getSubmissionsAllowed() == 1) {
                bean.setAllSubmissions("2");
                ((QuestionScoresBean)ContextUtil.lookupBean((String)"questionScores")).setAllSubmissions("2");
                ((HistogramScoresBean)ContextUtil.lookupBean((String)"histogramScores")).setAllSubmissions("2");
            }
            EvaluationModelIfc model = p.getEvaluationModel();
            boolean getSubmittedOnly = model.getAnonymousGrading().equals(EvaluationModelIfc.ANONYMOUS_GRADING);
            allscores = delegate.getTotalScores(p.getPublishedAssessmentId().toString(), bean.getAllSubmissions(), getSubmittedOnly);
            bean.setAssessmentGradingList(allscores);
        }
        this.getFilteredList(bean, allscores, scores, students_not_submitted, useridMap);
        bean.setTotalPeople(scores.size() + "");
    }

    public void prepareAgentResult(PublishedAssessmentData p, Iterator iter, ArrayList agents, Map userRoles) {
        GradingService gradingService = new GradingService();
        TotalScoresBean bean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        while (iter.hasNext()) {
            AgentResults results = new AgentResults();
            AssessmentGradingData gdata = (AssessmentGradingData)iter.next();
            gdata.setItemGradingSet(new HashSet());
            try {
                BeanUtils.copyProperties((Object)results, (Object)gdata);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
            results.setAssessmentGradingId(gdata.getAssessmentGradingId());
            if (gdata.getTotalAutoScore() != null) {
                if (gdata.getForGrade().booleanValue()) {
                    results.setTotalAutoScore(gdata.getTotalAutoScore().toString());
                } else {
                    results.setTotalAutoScore("-");
                }
            } else {
                results.setTotalAutoScore("0.0");
            }
            if (gdata.getTotalOverrideScore() != null) {
                results.setTotalOverrideScore(gdata.getTotalOverrideScore().toString());
            } else {
                results.setTotalOverrideScore("0.0");
            }
            if (gdata.getFinalScore() != null) {
                results.setFinalScore(gdata.getFinalScore().toString());
                results.setScoreSummation(gdata.getFinalScore());
                results.setSubmissionCount(1);
            } else {
                results.setFinalScore("0.0");
            }
            if (gdata.getTimeElapsed() != null) {
                results.setTimeElapsed(gdata.getTimeElapsed());
            } else {
                results.setTimeElapsed(new Integer(0));
            }
            results.setComments(FormattedText.convertFormattedTextToPlaintext((String)gdata.getComments()));
            Date dueDate = null;
            PublishedAccessControl ac = (PublishedAccessControl)p.getAssessmentAccessControl();
            if (ac != null) {
                dueDate = ac.getDueDate();
            }
            if (dueDate == null || gdata.getSubmittedDate() == null || gdata.getSubmittedDate().before(dueDate)) {
                results.setIsLate(Boolean.FALSE);
            } else {
                results.setIsLate(Boolean.TRUE);
            }
            if (gdata.getIsAutoSubmitted() != null && gdata.getIsAutoSubmitted().equals(Boolean.TRUE)) {
                results.setIsAutoSubmitted(true);
            } else {
                results.setIsAutoSubmitted(false);
            }
            if (dueDate != null && gdata.getAttemptDate() != null && gdata.getAttemptDate().after(dueDate)) {
                results.setIsAttemptDateAfterDueDate(true);
            } else {
                results.setIsAttemptDateAfterDueDate(false);
            }
            AgentFacade agent = new AgentFacade(gdata.getAgentId());
            results.setLastName(agent.getLastName());
            results.setFirstName(agent.getFirstName());
            results.setEmail(agent.getEmail());
            if (results.getLastName() != null && results.getLastName().length() > 0) {
                results.setLastInitial(results.getLastName().substring(0, 1));
            } else if (results.getFirstName() != null && results.getFirstName().length() > 0) {
                results.setLastInitial(results.getFirstName().substring(0, 1));
            } else {
                results.setLastInitial("Anonymous");
            }
            results.setIdString(agent.getIdString());
            results.setAgentEid(agent.getEidString());
            log.debug((Object)("testing agent getEid agent.getFirstname= " + agent.getFirstName()));
            log.debug((Object)("testing agent getEid agent.getid= " + agent.getIdString()));
            log.debug((Object)("testing agent getEid agent.geteid = " + agent.getEidString()));
            results.setRole((String)userRoles.get(gdata.getAgentId()));
            if (bean.getAllSubmissions().equals("4") && bean.getScoringOption().equals("4") && agents.size() > 0) {
                ListIterator it = agents.listIterator();
                boolean updated = false;
                while (it.hasNext()) {
                    AgentResults ar = (AgentResults)it.next();
                    if (!ar.getAgentId().equals(results.getAgentId())) continue;
                    agents.remove(it.previousIndex());
                    ar.setSubmissionCount(ar.getSubmissionCount() + 1);
                    ar.setScoreSummation(Float.valueOf(ar.getScoreSummation().floatValue() + gdata.getFinalScore().floatValue()));
                    ar.setAssessmentGradingId(results.getAssessmentGradingId());
                    agents.add(ar);
                    updated = true;
                }
                if (updated) continue;
                agents.add(results);
                continue;
            }
            agents.add(results);
        }
        if (bean.getAllSubmissions().equals("4") && bean.getScoringOption().equals("4") && agents.size() > 0) {
            for (AgentResults ar : agents) {
                Float averageScore = Float.valueOf(ar.getScoreSummation().floatValue() / (float)ar.getSubmissionCount());
                ar.setFinalScore(averageScore.toString());
                ar.setComments(null);
                ar.setSubmittedDate(new Date());
                ar.setStatus(null);
                ar.setItemGradingSet(null);
            }
        }
    }

    public ArrayList getAgentIds(Map useridMap) {
        ArrayList<String> agentUserIds = new ArrayList<String>();
        for (String userid : useridMap.keySet()) {
            agentUserIds.add(userid);
        }
        return agentUserIds;
    }

    public void setRoleAndSortSelection(TotalScoresBean bean, ArrayList agents, boolean sortAscending) {
        log.debug((Object)"TotalScoreListener: setRoleAndSortSection() starts");
        if (ContextUtil.lookupParam((String)"roleSelection") != null) {
            bean.setRoleSelection(ContextUtil.lookupParam((String)"roleSelection"));
        }
        if (bean.getSortType() == null) {
            if (bean.getAnonymous() != null && bean.getAnonymous().equals("true")) {
                bean.setSortType("totalAutoScore");
            } else {
                bean.setSortType("lastName");
            }
        }
        String sortProperty = bean.getSortType();
        log.debug((Object)("TotalScoreListener: setRoleAndSortSection() :: sortProperty = " + sortProperty));
        bs = new BeanSort((Collection)agents, sortProperty);
        if (sortProperty.equals("lastName")) {
            bs.toStringSort();
        }
        if (sortProperty.equals("idString")) {
            bs.toStringSort();
        }
        if (sortProperty.equals("agentEid")) {
            bs.toStringSort();
        }
        if (sortProperty.equals("role")) {
            bs.toStringSort();
        }
        if (sortProperty.equals("comments")) {
            bs.toStringSort();
        }
        if (sortProperty.equals("submittedDate")) {
            bs.toDateSort();
        }
        if (sortProperty.equals("assessmentGradingId")) {
            bs.toNumericSort();
        }
        if (sortProperty.equals("status")) {
            bs.toNumericSort();
        }
        if (sortProperty.equals("totalAutoScore")) {
            bs.toNumericSort();
        }
        if (sortProperty.equals("totalOverrideScore")) {
            bs.toNumericSort();
        }
        if (sortProperty.equals("finalScore")) {
            bs.toNumericSort();
        }
        if (sortProperty.equals("timeElapsed")) {
            bs.toNumericSort();
        }
        if (sortAscending) {
            log.debug((Object)"TotalScoreListener: setRoleAndSortSection() :: sortAscending");
            agents = (ArrayList)bs.sort();
        } else {
            log.debug((Object)"TotalScoreListener: setRoleAndSortSection() :: !sortAscending");
            agents = (ArrayList)bs.sortDesc();
        }
    }

    public void setRecordingData(TotalScoresBean bean) {
        String courseContext = bean.getAssessmentName() + " total ";
        String userId = "";
        String userName = "";
        RecordingData recordingData = new RecordingData(userId, userName, courseContext, "0", "30");
        bean.setRecordingData(recordingData);
    }

    public void prepareNotSubmittedAgentResult(Iterator notsubmitted_iter, ArrayList agents, Map userRoles) {
        log.debug((Object)"TotalScoreListener: prepareNotSubmittedAgentResult starts");
        while (notsubmitted_iter.hasNext()) {
            String studentid = (String)notsubmitted_iter.next();
            AgentResults results = new AgentResults();
            AgentFacade agent = new AgentFacade(studentid);
            results.setLastName(agent.getLastName());
            results.setFirstName(agent.getFirstName());
            results.setEmail(agent.getEmail());
            if (results.getLastName() != null && results.getLastName().length() > 0) {
                results.setLastInitial(results.getLastName().substring(0, 1));
            } else if (results.getFirstName() != null && results.getFirstName().length() > 0) {
                results.setLastInitial(results.getFirstName().substring(0, 1));
            } else {
                results.setLastInitial("Anonymous");
            }
            results.setIdString(agent.getIdString());
            results.setAgentEid(agent.getEidString());
            results.setRole((String)userRoles.get(studentid));
            results.setAssessmentGradingId(Long.valueOf(-1L));
            results.setTotalAutoScore("-");
            results.setTotalOverrideScore("-");
            results.setSubmittedDate(null);
            results.setFinalScore("-");
            results.setComments("");
            results.setStatus(AssessmentGradingIfc.NO_SUBMISSION);
            agents.add(results);
        }
    }

    public HashMap getPublishedItemIdHash(PublishedAssessmentData pub) {
        Integer scoringType = this.getScoringType(pub);
        HashMap publishedItemIdHash = scoringType.equals(EvaluationModelIfc.HIGHEST_SCORE) ? PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestAssessmentGradingByPublishedItem(pub.getPublishedAssessmentId()) : (scoringType.equals(EvaluationModelIfc.AVERAGE_SCORE) ? PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAverageAssessmentGradingByPublishedItem(pub.getPublishedAssessmentId()) : PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastAssessmentGradingByPublishedItem(pub.getPublishedAssessmentId()));
        return publishedItemIdHash;
    }
}

