/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.evaluation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.util.MathUtils;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.GradebookServiceException;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.AgentResults;
import org.sakaiproject.tool.assessment.ui.bean.evaluation.TotalScoresBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class TotalScoreUpdateListener
implements ActionListener {
    private static Log log = LogFactory.getLog(TotalScoreUpdateListener.class);

    public void processAction(ActionEvent ae) throws AbortProcessingException {
        log.debug((Object)"Total Score Update LISTENER.");
        TotalScoresBean bean = (TotalScoresBean)ContextUtil.lookupBean((String)"totalScores");
        log.debug((Object)"Calling saveTotalScores.");
        if (!this.saveTotalScores(bean)) {
            throw new RuntimeException("failed to call saveTotalScores.");
        }
    }

    private HashMap prepareAssessmentGradingHash(ArrayList assessmentGradingList) {
        HashMap<Long, AssessmentGradingIfc> map = new HashMap<Long, AssessmentGradingIfc>();
        for (int i = 0; i < assessmentGradingList.size(); ++i) {
            AssessmentGradingIfc a = (AssessmentGradingIfc)assessmentGradingList.get(i);
            map.put(a.getAssessmentGradingId(), a);
        }
        return map;
    }

    public boolean saveTotalScores(TotalScoresBean bean) {
        ArrayList assessmentGradingList = bean.getAssessmentGradingList();
        HashMap map = this.prepareAssessmentGradingHash(assessmentGradingList);
        Collection agents = bean.getAgents();
        Iterator iter = agents.iterator();
        ArrayList<AssessmentGradingData> grading = new ArrayList<AssessmentGradingData>();
        boolean hasNumberFormatException = false;
        StringBuffer idList = new StringBuffer(" ");
        String err = "";
        boolean isAnonymousGrading = false;
        String applyToUngraded = bean.getApplyToUngraded().trim();
        if (applyToUngraded != null && !"".equals(applyToUngraded)) {
            try {
                Float.valueOf(applyToUngraded).floatValue();
                ArrayList allAgents = bean.getAllAgentsDirect();
                for (AgentResults agentResults : allAgents) {
                    if (!agentResults.getAssessmentGradingId().equals(-1L) && agentResults.getSubmittedDate() != null) continue;
                    agentResults.setTotalOverrideScore(applyToUngraded + "");
                }
                iter = allAgents.iterator();
                bean.setApplyToUngraded("");
            }
            catch (Exception e) {
                FacesContext context = FacesContext.getCurrentInstance();
                String err2 = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"number_format_error_user_id_apply");
                context.addMessage(null, new FacesMessage(err2));
                return true;
            }
            bean.setApplyToUngraded("");
        }
        if (bean.getPublishedAssessment() != null && bean.getPublishedAssessment().getEvaluationModel() != null && bean.getPublishedAssessment().getEvaluationModel().getAnonymousGrading() != null && bean.getPublishedAssessment().getEvaluationModel().getAnonymousGrading().equals(EvaluationModelIfc.ANONYMOUS_GRADING)) {
            isAnonymousGrading = true;
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"number_format_error_submission_id");
        } else {
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"number_format_error_user_id");
        }
        ArrayList<Object> badAdjList = new ArrayList<Object>();
        while (iter.hasNext()) {
            AgentResults agentResults;
            agentResults = (AgentResults)iter.next();
            StringBuilder newScoreString = new StringBuilder();
            boolean update = false;
            try {
                update = this.needUpdate(agentResults, map, newScoreString);
            }
            catch (NumberFormatException e) {
                hasNumberFormatException = true;
                update = false;
                if (isAnonymousGrading) {
                    badAdjList.add(agentResults.getAssessmentGradingId());
                }
                badAdjList.add(agentResults.getAgentEid());
            }
            if (!update) continue;
            log.debug((Object)"update is true");
            Float newScore = new Float(0.0f);
            AssessmentGradingData data = new AssessmentGradingData();
            try {
                if (!agentResults.getAssessmentGradingId().equals(-1L)) {
                    newScore = Float.valueOf(newScoreString.toString());
                    agentResults.setFinalScore(newScore + "");
                    BeanUtils.copyProperties((Object)data, (Object)agentResults);
                    data.setPublishedAssessmentId(bean.getPublishedAssessment().getPublishedAssessmentId());
                    if ("-".equals(agentResults.getTotalAutoScore())) {
                        data.setTotalAutoScore(Float.valueOf(0.0f));
                    } else {
                        data.setTotalAutoScore(Float.valueOf(agentResults.getTotalAutoScore()));
                    }
                    data.setTotalOverrideScore(Float.valueOf(agentResults.getTotalOverrideScore()));
                    data.setFinalScore(Float.valueOf(agentResults.getFinalScore()));
                    data.setIsLate(agentResults.getIsLate());
                    data.setComments(agentResults.getComments());
                    data.setGradedBy(AgentFacade.getAgentString());
                    data.setGradedDate(new Date());
                    grading.add(data);
                    continue;
                }
                newScore = Float.valueOf(newScoreString.toString());
                agentResults.setFinalScore(newScore + "");
                BeanUtils.copyProperties((Object)data, (Object)agentResults);
                data.setAgentId(agentResults.getIdString());
                data.setForGrade(Boolean.FALSE);
                data.setIsLate(Boolean.FALSE);
                data.setItemGradingSet(new HashSet());
                data.setPublishedAssessmentId(bean.getPublishedAssessment().getPublishedAssessmentId());
                data.setAssessmentGradingId(Long.valueOf(0L));
                data.setSubmittedDate(null);
                data.setTotalAutoScore(Float.valueOf(0.0f));
                data.setTotalOverrideScore(Float.valueOf(agentResults.getTotalOverrideScore()));
                data.setFinalScore(Float.valueOf(agentResults.getFinalScore()));
                data.setComments(agentResults.getComments());
                data.setGradedBy(AgentFacade.getAgentString());
                data.setGradedDate(new Date());
                grading.add(data);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("IllegalAccessException: " + e));
                return false;
            }
            catch (InvocationTargetException e) {
                log.error((Object)("InvocationTargetException: " + e));
                return false;
            }
        }
        if (hasNumberFormatException) {
            err = bean.getPublishedAssessment() != null && bean.getPublishedAssessment().getEvaluationModel() != null && bean.getPublishedAssessment().getEvaluationModel().getAnonymousGrading() != null && bean.getPublishedAssessment().getEvaluationModel().getAnonymousGrading().equals(EvaluationModelIfc.ANONYMOUS_GRADING) ? ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"number_format_error_submission_id") : ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.EvaluationMessages", (String)"number_format_error_user_id");
            for (int i = 0; i < badAdjList.size(); ++i) {
                idList.append(badAdjList.get(i));
                if (i == badAdjList.size() - 1) continue;
                idList.append(", ");
            }
            idList.append(".");
            FacesContext context = FacesContext.getCurrentInstance();
            context.addMessage(null, new FacesMessage(err + idList.toString()));
        }
        GradingService delegate = new GradingService();
        try {
            delegate.saveTotalScores(grading, (PublishedAssessmentIfc)bean.getPublishedAssessment());
            log.debug((Object)"Saved total scores.");
        }
        catch (GradebookServiceException ge) {
            FacesContext context = FacesContext.getCurrentInstance();
            String error = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"gradebook_exception_error");
            context.addMessage(null, new FacesMessage(error));
            return true;
        }
        return true;
    }

    private boolean needUpdate(AgentResults agentResults, HashMap map, StringBuilder newScoreString) throws NumberFormatException {
        boolean update = true;
        String newComments = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)agentResults.getComments());
        agentResults.setComments(newComments);
        log.debug((Object)("newComments = " + newComments));
        float totalAutoScore = 0.0f;
        if (agentResults.getTotalAutoScore() != null && !"".equals(agentResults.getTotalAutoScore())) {
            try {
                totalAutoScore = Float.valueOf(agentResults.getTotalAutoScore()).floatValue();
            }
            catch (NumberFormatException e) {
                totalAutoScore = 0.0f;
            }
        }
        float totalOverrideScore = 0.0f;
        Boolean newIsLate = agentResults.getIsLate();
        AssessmentGradingIfc old = (AssessmentGradingIfc)map.get(agentResults.getAssessmentGradingId());
        if (old != null) {
            if (agentResults.getTotalOverrideScore() != null && !"".equals(agentResults.getTotalOverrideScore())) {
                try {
                    totalOverrideScore = Float.valueOf(agentResults.getTotalOverrideScore()).floatValue();
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Adj has wrong input type" + e));
                    throw e;
                }
            }
            float newScore = totalAutoScore + totalOverrideScore;
            newScoreString.append(Float.valueOf(newScore));
            float oldScore = 0.0f;
            if (old.getFinalScore() != null) {
                oldScore = old.getFinalScore().floatValue();
            }
            Boolean oldIsLate = old.getIsLate();
            String oldComments = old.getComments();
            log.debug((Object)("***oldScore = " + oldScore));
            log.debug((Object)("***newScore = " + newScore));
            log.debug((Object)("***oldIsLate = " + oldIsLate));
            log.debug((Object)("***newIsLate = " + newIsLate));
            log.debug((Object)("***oldComments = " + oldComments));
            log.debug((Object)("***newComments = " + newComments));
            if (MathUtils.equalsIncludingNaN((double)oldScore, (double)newScore, (double)1.0E-4) && newIsLate.equals(oldIsLate) && (newComments != null && newComments.equals(oldComments) || newComments == null && oldComments == null || newComments != null && newComments.equals("") && oldComments == null)) {
                update = false;
            }
        } else {
            boolean noOverrideScore = false;
            boolean noComment = false;
            String score = agentResults.getTotalOverrideScore();
            if (score != null) {
                if (!"".equals(score.trim()) && !"-".equals(score.trim())) {
                    try {
                        totalOverrideScore = Float.valueOf(agentResults.getTotalOverrideScore()).floatValue();
                        noOverrideScore = false;
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Adj has wrong input type" + e));
                        throw e;
                    }
                } else {
                    noOverrideScore = true;
                    totalAutoScore = 0.0f;
                }
            } else {
                noOverrideScore = true;
                totalAutoScore = 0.0f;
            }
            float newScore = totalAutoScore + totalOverrideScore;
            newScoreString.append(Float.valueOf(newScore));
            if ("".equals(agentResults.getComments().trim())) {
                noComment = true;
            }
            if (noOverrideScore && noComment) {
                update = false;
            }
        }
        return update;
    }
}

