/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.listener.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.time.cover.TimeService;

public class TimeUtil {
    private static Log log = LogFactory.getLog(TimeUtil.class);
    private TimeZone m_client_timezone = TimeService.getLocalTimeZone();
    private TimeZone m_server_timezone = TimeZone.getDefault();

    public Date convertFromTimeZone1StringToServerDate(SimpleDateFormat ndf, String tz1string, TimeZone tz1) {
        Date serverDate = null;
        try {
            ndf.setTimeZone(tz1);
            serverDate = ndf.parse(tz1string);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverDate;
    }

    public String convertFromServerDateToTimeZone2String(SimpleDateFormat ndf, Date tz2Date, TimeZone tz1) {
        GregorianCalendar cal1 = new GregorianCalendar(tz1);
        ndf.setCalendar(cal1);
        String clientStr = ndf.format(tz2Date);
        return clientStr;
    }

    public Date getServerDateTime(SimpleDateFormat ndf, String clientString) {
        Date serverDate;
        block2: {
            serverDate = null;
            try {
                serverDate = this.m_client_timezone != null && this.m_server_timezone != null && !this.m_client_timezone.hasSameRules(this.m_server_timezone) ? this.convertFromTimeZone1StringToServerDate(ndf, clientString, this.m_client_timezone) : ndf.parse(clientString);
            }
            catch (ParseException e) {
                log.warn((Object)("can not parse the string, " + clientString + ", into a Date using format: " + ndf.toPattern()));
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
        return serverDate;
    }

    public String getDisplayDateTime(SimpleDateFormat ndf, Date serverDate) {
        String displayDate = "";
        try {
            displayDate = this.m_client_timezone != null && this.m_server_timezone != null && !this.m_client_timezone.hasSameRules(this.m_server_timezone) ? this.convertFromServerDateToTimeZone2String(ndf, serverDate, this.m_client_timezone) : ndf.format(serverDate);
        }
        catch (RuntimeException e) {
            log.warn((Object)"can not format the Date to a string");
        }
        return displayDate;
    }
}

