/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.model.delivery;

import java.util.Date;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;

public class TimedAssessmentGradingModel {
    private Long assessmentGradingId;
    private int timeLimit;
    private int timeLeft;
    private Date beginDate;
    private Date expirationDate;
    private Date bufferedExpirationDate;
    private Date localBeginDate;
    private Date localExpirationDate;
    private boolean submittedForGrade = false;
    private String timerId;
    private PublishedAssessmentFacade publishedAssessment;
    private int latencyBuffer = 30;
    private int transactionBuffer = 30;

    public TimedAssessmentGradingModel() {
    }

    public TimedAssessmentGradingModel(Long assessmentGradingId, int timeLimit, int timeLeft, Date beginDate, Date localBeginDate, boolean submittedForGrade, String timerId, PublishedAssessmentFacade publishedAssessment) {
        this.assessmentGradingId = assessmentGradingId;
        this.timeLimit = timeLimit;
        this.timeLeft = timeLeft;
        this.beginDate = beginDate;
        this.expirationDate = new Date(beginDate.getTime() + (long)timeLeft * 1000L);
        this.bufferedExpirationDate = new Date(beginDate.getTime() + (long)timeLeft * 1000L + (long)(this.latencyBuffer * 1000));
        this.submittedForGrade = submittedForGrade;
        this.localBeginDate = localBeginDate;
        this.localExpirationDate = new Date(localBeginDate.getTime() + (long)timeLeft * 1000L);
        this.timerId = timerId;
        this.publishedAssessment = publishedAssessment;
    }

    public TimedAssessmentGradingModel(Long assessmentGradingId, int timeLimit, int timeLeft, int latencyBuffer, int transactionBuffer, Date beginDate, Date localBeginDate, boolean submittedForGrade, String timerId, PublishedAssessmentFacade publishedAssessment) {
        this.assessmentGradingId = assessmentGradingId;
        this.timeLimit = timeLimit;
        this.timeLeft = timeLeft;
        this.latencyBuffer = latencyBuffer;
        this.transactionBuffer = transactionBuffer;
        this.beginDate = beginDate;
        this.expirationDate = new Date(beginDate.getTime() + (long)timeLeft * 1000L);
        this.bufferedExpirationDate = new Date(beginDate.getTime() + (long)timeLeft * 1000L + (long)(latencyBuffer * 1000));
        this.submittedForGrade = submittedForGrade;
        this.localBeginDate = localBeginDate;
        this.localExpirationDate = new Date(localBeginDate.getTime() + (long)timeLeft * 1000L);
        this.timerId = timerId;
        this.publishedAssessment = publishedAssessment;
    }

    public Long getAssessmentGradingId() {
        return this.assessmentGradingId;
    }

    public void setAssessmentGradingId(Long assessmentGradingId) {
        this.assessmentGradingId = assessmentGradingId;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }

    public int getLatencyBuffer() {
        return this.latencyBuffer;
    }

    public void setLatencyBuffer(int latencyBuffer) {
        this.latencyBuffer = latencyBuffer;
    }

    public int getTransactionBuffer() {
        return this.transactionBuffer;
    }

    public void setTransactionBuffer(int transactionBuffer) {
        this.transactionBuffer = transactionBuffer;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getBufferedExpirationDate() {
        return this.bufferedExpirationDate;
    }

    public void setBufferedExpirationDate(Date bufferedExpirationDate) {
        this.bufferedExpirationDate = bufferedExpirationDate;
    }

    public Date getLocalBeginDate() {
        return this.localBeginDate;
    }

    public void setLocalBeginDate(Date localBeginDate) {
        this.localBeginDate = localBeginDate;
    }

    public Date getLocalExpirationDate() {
        return this.localExpirationDate;
    }

    public void setLocalExpirationDate(Date localExpirationDate) {
        this.localExpirationDate = localExpirationDate;
    }

    public boolean getSubmittedForGrade() {
        return this.submittedForGrade;
    }

    public void setSubmittedForGrade(boolean submittedForGrade) {
        this.submittedForGrade = submittedForGrade;
    }

    public String getTimerId() {
        return this.timerId;
    }

    public void setTimerId(String timerId) {
        this.timerId = timerId;
    }

    public PublishedAssessmentFacade getPublishedAssessment() {
        return this.publishedAssessment;
    }

    public void setPublishedAssessment(PublishedAssessmentFacade publishedAssessment) {
        this.publishedAssessment = publishedAssessment;
    }
}

