/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.queue.delivery;

import java.util.Collection;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.ui.model.delivery.TimedAssessmentGradingModel;
import org.sakaiproject.tool.assessment.ui.queue.delivery.SubmitTimedAssessmentThread;

public class TimedAssessmentQueue {
    private static TimedAssessmentQueue instance;
    private ConcurrentHashMap queue = new ConcurrentHashMap();
    private Timer timer;
    private static Log log;

    private TimedAssessmentQueue() {
    }

    public static synchronized TimedAssessmentQueue getInstance() {
        if (instance == null) {
            instance = new TimedAssessmentQueue();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimedAssessmentGradingModel timedAG) {
        ConcurrentHashMap concurrentHashMap = this.queue;
        synchronized (concurrentHashMap) {
            this.queue.put(timedAG.getAssessmentGradingId(), timedAG);
            log.debug((Object)("***1. TimedAssessmentQueue.add, before schedule timer=" + this.timer));
            this.scheduleTask();
            log.debug((Object)("***2. TimedAssessmentQueue.add, after schedule timer=" + this.timer));
        }
    }

    private void scheduleTask() {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)new SubmitTimedAssessmentThread(), 0L, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TimedAssessmentGradingModel timedAG) {
        ConcurrentHashMap concurrentHashMap = this.queue;
        synchronized (concurrentHashMap) {
            this.queue.remove(timedAG.getAssessmentGradingId());
            if (this.isEmpty()) {
                log.debug((Object)("*** before destroy, timer=" + this.timer));
                this.timer.cancel();
                this.timer = null;
                log.debug((Object)("*** after destroy, timer=" + this.timer));
            }
        }
    }

    public TimedAssessmentGradingModel get(Long assessmentGradingId) {
        return (TimedAssessmentGradingModel)this.queue.get(assessmentGradingId);
    }

    public void emptyQueue() {
        this.queue.clear();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public Iterator iterator() {
        Collection c = this.queue.values();
        return c.iterator();
    }

    static {
        log = LogFactory.getLog(TimedAssessmentQueue.class);
    }
}

