/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.servlet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.util.MimeTypesLocator;

public class InitMimeTypes
extends HttpServlet {
    private static final long serialVersionUID = 6032485774950035961L;
    private static Log log = LogFactory.getLog(InitMimeTypes.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String path = config.getServletContext().getRealPath("WEB-INF/mime.types");
        log.debug((Object)("**** mimetypes path=" + path));
        MimetypesFileTypeMap mimeTypeMap = null;
        FileInputStream input = null;
        try {
            input = new FileInputStream(path);
            log.debug((Object)("**** input=" + input));
            mimeTypeMap = new MimetypesFileTypeMap((InputStream)input);
            log.debug((Object)("**** mimeTypeMap=" + mimeTypeMap));
            MimeTypesLocator.setMimetypesFileTypeMap((MimetypesFileTypeMap)mimeTypeMap);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex1) {
                log.warn((Object)ex1.getMessage());
            }
        }
    }
}

