/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.servlet.cp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.tool.assessment.contentpackaging.ManifestGenerator;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.qti.XMLController;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class DownloadCPServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(DownloadCPServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String err;
        AssessmentService assessmentService = new AssessmentService();
        String assessmentId = req.getParameter("assessmentId");
        int success = assessmentService.updateAllRandomPoolQuestions(assessmentService.getAssessment(assessmentId));
        if (success == 0) {
            String agentIdString = this.getAgentString(req, res);
            String currentSiteId = assessmentService.getAssessmentSiteId(assessmentId);
            String assessmentCreatedBy = assessmentService.getAssessmentCreatedBy(assessmentId);
            boolean accessDenied = true;
            if (this.canExport(req, res, agentIdString, currentSiteId, assessmentCreatedBy)) {
                accessDenied = false;
            }
            if (accessDenied) {
                String path = "/jsf/qti/exportDenied.faces";
                RequestDispatcher dispatcher = req.getRequestDispatcher(path);
                dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                return;
            }
            res.setContentType("application/x-zip-compressed");
            String zipFilename = "exportAssessment.zip";
            res.setHeader("Content-Disposition", "attachment;filename=\"" + zipFilename + "\";");
            ServletOutputStream outputStream = null;
            ZipOutputStream zos = null;
            ZipEntry ze = null;
            try {
                byte[] b = null;
                outputStream = res.getOutputStream();
                zos = new ZipOutputStream((OutputStream)outputStream);
                ze = new ZipEntry("exportAssessment.xml");
                zos.putNextEntry(ze);
                XMLController xmlController = (XMLController)ContextUtil.lookupBeanFromExternalServlet((String)"xmlController", (HttpServletRequest)req, (HttpServletResponse)res);
                xmlController.setId(assessmentId);
                xmlController.setQtiVersion(1);
                xmlController.displayAssessmentXml();
                String qtiString = xmlController.getXmlBean().getXml();
                log.debug((Object)("qtiString = " + qtiString));
                b = qtiString.getBytes();
                zos.write(b, 0, b.length);
                zos.closeEntry();
                ze = new ZipEntry("imsmanifest.xml");
                zos.putNextEntry(ze);
                ManifestGenerator manifestGenerator = new ManifestGenerator(assessmentId);
                String manString = manifestGenerator.getManifest();
                log.debug((Object)("manString = " + manString));
                b = manString.getBytes();
                zos.write(b, 0, b.length);
                zos.closeEntry();
                HashMap contentMap = manifestGenerator.getContentMap();
                String filename = null;
                for (Map.Entry entry : contentMap.entrySet()) {
                    filename = (String)entry.getKey();
                    ze = new ZipEntry(filename.substring(1));
                    zos.putNextEntry(ze);
                    b = (byte[])entry.getValue();
                    zos.write(b, 0, b.length);
                    zos.closeEntry();
                }
                return;
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
                throw e;
            }
            finally {
                if (zos != null) {
                    try {
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                    try {
                        zos.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                }
            }
        }
        if (success == 1) {
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"update_pool_error_size_too_large");
            req.setAttribute("error", (Object)err);
        } else {
            err = ContextUtil.getLocalizedString((String)"org.sakaiproject.tool.assessment.bundle.AuthorMessages", (String)"update_pool_error_unknown");
            req.setAttribute("error", (Object)err);
        }
        String path = "/jsf/qti/poolUpdateError.faces";
        RequestDispatcher dispatcher = req.getRequestDispatcher(path);
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private boolean isOwner(String agentId, String ownerId) {
        boolean isOwner = false;
        isOwner = agentId.equals(ownerId);
        return isOwner;
    }

    private String getAgentString(HttpServletRequest req, HttpServletResponse res) {
        String agentIdString = AgentFacade.getAgentString();
        if (agentIdString == null || agentIdString.equals("")) {
            PersonBean person = (PersonBean)ContextUtil.lookupBeanFromExternalServlet((String)"person", (HttpServletRequest)req, (HttpServletResponse)res);
            agentIdString = person.getAnonymousId();
        }
        return agentIdString;
    }

    public boolean canExport(HttpServletRequest req, HttpServletResponse res, String agentId, String currentSiteId, String createdBy) {
        log.debug((Object)("agentId=" + agentId));
        log.debug((Object)("currentSiteId=" + currentSiteId));
        boolean hasPrivilege_any = this.hasPrivilege(req, "edit_any_assessment", currentSiteId);
        boolean hasPrivilege_own = this.hasPrivilege(req, "edit_own_assessment", currentSiteId);
        log.debug((Object)("hasPrivilege_any=" + hasPrivilege_any));
        log.debug((Object)("hasPrivilege_own=" + hasPrivilege_own));
        boolean hasPrivilege = hasPrivilege_any || hasPrivilege_own && this.isOwner(agentId, createdBy);
        return hasPrivilege;
    }

    public boolean hasPrivilege(HttpServletRequest req, String functionKey, String context) {
        String functionName = ContextUtil.getLocalizedString((HttpServletRequest)req, (String)"org.sakaiproject.tool.assessment.bundle.AuthzPermissions", (String)functionKey);
        boolean privilege = SecurityService.unlock((String)functionName, (String)("/site/" + context));
        return privilege;
    }
}

