/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.servlet.delivery;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.delivery.BeginDeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.delivery.DeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.delivery.LinearAccessDeliveryActionListener;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;
import org.sakaiproject.user.cover.UserDirectoryService;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = -5495078878170443939L;
    private static Log log = LogFactory.getLog(LoginServlet.class);
    private SiteService siteService;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String alias = req.getParameter("id");
        if (alias == null || "".equals(alias)) {
            log.warn((Object)"The published URL you have entered is incorrect. id is missing. Please check in Published Settings.");
            return;
        }
        HttpSession httpSession = req.getSession(true);
        httpSession.setMaxInactiveInterval(3600);
        PersonBean person = (PersonBean)ContextUtil.lookupBeanFromExternalServlet((String)"person", (HttpServletRequest)req, (HttpServletResponse)res);
        DeliveryBean delivery = (DeliveryBean)ContextUtil.lookupBeanFromExternalServlet((String)"delivery", (HttpServletRequest)req, (HttpServletResponse)res);
        delivery.setAssessmentGrading(null);
        delivery.setActionString("takeAssessmentViaUrl");
        delivery.setTimeElapse("0");
        delivery.setLastTimer(0L);
        delivery.setTimeLimit("0");
        delivery.setBeginAssessment(true);
        delivery.setContextPath(req.getContextPath());
        PublishedAssessmentService service = new PublishedAssessmentService();
        PublishedAssessmentFacade pub = service.getPublishedAssessmentIdByAlias(alias);
        if (pub == null) {
            log.warn((Object)"The published URL you have entered is incorrect. Please check in Published Settings.");
            return;
        }
        delivery.setAssessmentId(pub.getPublishedAssessmentId().toString());
        delivery.setAssessmentTitle(pub.getTitle());
        delivery.setPublishedAssessment(pub);
        RequestDispatcher dispatcher = null;
        String path = "/jsf/delivery/invalidAssessment.faces";
        boolean relativePath = true;
        String agentIdString = "";
        boolean isAuthorized = false;
        boolean isAuthenticated = false;
        String releaseTo = pub.getAssessmentAccessControl().getReleaseTo();
        if (releaseTo != null && releaseTo.indexOf("Anonymous Users") > -1) {
            agentIdString = AgentFacade.createAnonymous();
            isAuthenticated = true;
            isAuthorized = true;
            delivery.setAnonymousLogin(true);
            person.setAnonymousId(agentIdString);
        } else {
            agentIdString = req.getRemoteUser();
            boolean bl = isAuthenticated = agentIdString != null && !"".equals(agentIdString);
            if (isAuthenticated) {
                isAuthorized = releaseTo.indexOf("Selected Groups") > -1 ? this.checkMembershipForGroupRelease(pub, req, res) : this.checkMembership(pub, req, res);
                agentIdString = AgentFacade.getAgentString();
            }
        }
        log.debug((Object)("*** agentIdString: " + agentIdString));
        String nextAction = delivery.checkFromViaUrlLogin();
        log.debug((Object)("nextAction=" + nextAction));
        if (isAuthorized) {
            if ("isRemoved".equals(nextAction)) {
                path = "/jsf/delivery/isRemoved.faces";
            } else if ("safeToProceed".equals(nextAction)) {
                BeginDeliveryActionListener listener = new BeginDeliveryActionListener();
                listener.processAction(null);
                path = "/jsf/delivery/beginTakingAssessment_viaurl.faces";
            } else {
                path = "assessmentNotAvailable".equals(nextAction) ? "/jsf/delivery/assessmentNotAvailable.faces" : ("isRetracted".equals(nextAction) ? "/jsf/delivery/isRetracted.faces" : ("isRetractedForEdit".equals(nextAction) ? "/jsf/delivery/isRetractedForEdit.faces" : ("discrepancyInData".equals(nextAction) ? "/jsf/delivery/discrepancyInData.faces" : ("assessmentHasBeenSubmitted".equals(nextAction) ? "/jsf/delivery/assessmentHasBeenSubmitted.faces" : ("noSubmissionLeft".equals(nextAction) ? "/jsf/delivery/noSubmissionLeft.faces" : ("noLateSubmission".equals(nextAction) ? "/jsf/delivery/noLateSubmission.faces" : ("timeExpired".equals(nextAction) ? "/jsf/delivery/timeExpired.faces" : "/jsf/delivery/assessmentNotAvailable.faces")))))));
            }
        } else if (!isAuthenticated) {
            if (AgentFacade.isStandaloneEnvironment()) {
                delivery.setActionString(null);
                path = "/jsf/delivery/login.faces";
            } else {
                relativePath = false;
                delivery.setActionString(null);
                path = "/authn/login?url=" + URLEncoder.encode(req.getRequestURL().toString() + "?id=" + alias, "UTF-8");
            }
        } else {
            path = "/jsf/delivery/accessDenied.faces";
        }
        if ("true".equals(req.getParameter("fromDirect"))) {
            if (delivery.getNavigation().trim() != null && "1".equals(delivery.getNavigation().trim())) {
                LinearAccessDeliveryActionListener linearDeliveryListener = new LinearAccessDeliveryActionListener();
                linearDeliveryListener.processAction(null);
            } else {
                DeliveryActionListener deliveryListener = new DeliveryActionListener();
                deliveryListener.processAction(null);
            }
            if ("takeAssessment".equals(delivery.validate())) {
                path = "/jsf/delivery/deliverAssessment.faces";
            }
        }
        log.debug((Object)("***path" + path));
        if (relativePath) {
            dispatcher = req.getRequestDispatcher(path);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else {
            log.info((Object)("** servlet path=" + req.getRequestURL().toString()));
            String url = req.getRequestURL().toString();
            String context = req.getContextPath();
            String finalUrl = url.substring(0, url.lastIndexOf(context)) + path;
            log.info((Object)("**** finalUrl = " + finalUrl));
            res.sendRedirect(finalUrl);
        }
    }

    private boolean checkMembership(PublishedAssessmentFacade pub, HttpServletRequest req, HttpServletResponse res) {
        boolean isMember = false;
        List l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("VIEW_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size(); ++i) {
            String siteId = ((AuthorizationData)l.get(i)).getAgentIdString();
            isMember = PersistenceService.getInstance().getAuthzQueriesFacade().checkMembership(siteId);
            if (isMember) break;
        }
        return isMember;
    }

    private boolean checkMembershipForGroupRelease(PublishedAssessmentFacade pub, HttpServletRequest req, HttpServletResponse res) {
        String groupId;
        boolean isMember = false;
        List l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("OWN_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        if (l == null || l.isEmpty()) {
            return false;
        }
        String siteId = ((AuthorizationData)l.get(0)).getAgentIdString();
        Collection siteGroupsContainingUser = null;
        String currentUserId = UserDirectoryService.getCurrentUser().getId();
        try {
            siteGroupsContainingUser = SiteService.getSite((String)siteId).getGroupsWithMember(currentUserId);
        }
        catch (IdUnusedException ex) {
            // empty catch block
        }
        l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("TAKE_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size() && !(isMember = this.isUserInAuthorizedGroup(groupId = ((AuthorizationData)l.get(i)).getAgentIdString(), siteGroupsContainingUser)); ++i) {
        }
        return isMember;
    }

    private boolean isUserInAuthorizedGroup(String authorizedGroupId, Collection userGroups) {
        if (userGroups == null || userGroups.isEmpty() || authorizedGroupId == null || authorizedGroupId.equals("")) {
            return false;
        }
        for (Group group : userGroups) {
            if (!group.getId().equals(authorizedGroupId)) continue;
            return true;
        }
        return false;
    }
}

