/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.servlet.delivery;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class ShowAttachmentMediaServlet
extends HttpServlet {
    private static final long serialVersionUID = 2203681863823855810L;
    private static Log log = LogFactory.getLog(ShowAttachmentMediaServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        byte[] media;
        block49: {
            String resourceId = req.getParameter("resourceId");
            String mimeType = req.getParameter("mimeType");
            String filename = req.getParameter("filename");
            String cleanedFilename = TextFormat.convertPlaintextToFormattedTextNoHighUnicode((Log)log, (String)filename);
            res.setHeader("Content-Disposition", "inline;filename=\"" + cleanedFilename + "\";");
            log.debug((Object)("resourceId = " + resourceId));
            log.debug((Object)("mimeType = " + mimeType));
            log.debug((Object)("cleanedFilename = " + cleanedFilename));
            res.setContentType(mimeType);
            ContentResource cr = null;
            media = null;
            try {
                cr = AssessmentService.getContentHostingService().getResource(resourceId);
                if (cr == null) {
                    return;
                }
                media = cr.getContent();
                if (media == null) {
                    return;
                }
                res.setContentLength((int)cr.getContentLength());
                log.debug((Object)("**** media.length = " + media.length));
            }
            catch (PermissionException e) {
                log.warn((Object)("PermissionException from doPost(): " + e.getMessage()));
            }
            catch (IdUnusedException e) {
                log.warn((Object)("IdUnusedException from doPost(): " + e.getMessage()));
            }
            catch (TypeException e) {
                log.warn((Object)("TypeException from doPost(): " + e.getMessage()));
            }
            catch (ServerOverloadException e) {
                log.warn((Object)("ServerOverloadException from doPost(): " + e.getMessage()));
            }
            finally {
                if (media != null) break block49;
                return;
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(media);
        BufferedInputStream buf_inputStream = new BufferedInputStream(byteArrayInputStream);
        ServletOutputStream outputStream = res.getOutputStream();
        BufferedOutputStream buf_outputStream = null;
        int count = 0;
        try {
            buf_outputStream = new BufferedOutputStream((OutputStream)outputStream);
            int i = 0;
            while ((i = buf_inputStream.read()) != -1) {
                buf_outputStream.write(i);
                ++count;
            }
            res.flushBuffer();
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        finally {
            if (buf_outputStream != null) {
                try {
                    buf_outputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            if (buf_inputStream != null) {
                try {
                    buf_inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
    }
}

