/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.servlet.delivery;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.shared.PersonBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class ShowMediaServlet
extends HttpServlet {
    private static final long serialVersionUID = 2203681863823855810L;
    private static Log log = LogFactory.getLog(ShowMediaServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean hasPrivilege;
        String agentIdString = this.getAgentString(req, res);
        if (agentIdString == null) {
            String path = "/jsf/delivery/mediaAccessDenied.faces";
            RequestDispatcher dispatcher = req.getRequestDispatcher(path);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        String mediaId = req.getParameter("mediaId");
        if (mediaId == null || mediaId.trim().equals("")) {
            return;
        }
        GradingService gradingService = new GradingService();
        MediaData mediaData = gradingService.getMedia(mediaId);
        String mediaLocation = mediaData.getLocation();
        int fileSize = mediaData.getFileSize().intValue();
        log.info((Object)("****1. media file size=" + fileSize));
        String setMimeType = req.getParameter("setMimeType");
        log.info((Object)("****2. setMimeType=" + setMimeType));
        boolean accessDenied = true;
        String currentSiteId = "";
        boolean isAudio = false;
        Long assessmentGradingId = mediaData.getItemGradingData().getAssessmentGradingId();
        PublishedAssessmentIfc pub = gradingService.getPublishedAssessmentByAssessmentGradingId(assessmentGradingId.toString());
        if (pub != null) {
            PublishedAssessmentService service = new PublishedAssessmentService();
            currentSiteId = service.getPublishedAssessmentOwner(pub.getPublishedAssessmentId());
        }
        boolean bl = hasPrivilege = agentIdString != null && (agentIdString.equals(mediaData.getCreatedBy()) || this.canGrade(req, res, agentIdString, currentSiteId));
        if (hasPrivilege) {
            accessDenied = false;
        }
        if (accessDenied) {
            String path = "/jsf/delivery/mediaAccessDenied.faces";
            RequestDispatcher dispatcher = req.getRequestDispatcher(path);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else {
            String displayType = "inline";
            if (!(mediaData.getMimeType() == null || mediaData.getMimeType().equals("application/octet-stream") || setMimeType != null && "false".equals(setMimeType))) {
                res.setContentType(mediaData.getMimeType());
            } else {
                displayType = "attachment";
                res.setContentType("application/octet-stream");
            }
            log.debug((Object)("****" + displayType + ";filename=\"" + mediaData.getFilename() + "\";"));
            res.setHeader("Content-Disposition", displayType + ";filename=\"" + mediaData.getFilename() + "\";");
            res.setContentLength(fileSize);
            FileInputStream inputStream = null;
            BufferedInputStream buf_inputStream = null;
            ServletOutputStream outputStream = res.getOutputStream();
            BufferedOutputStream buf_outputStream = null;
            ByteArrayInputStream byteArrayInputStream = null;
            if (mediaLocation == null || mediaLocation.trim().equals("")) {
                try {
                    byte[] media = mediaData.getMedia();
                    byteArrayInputStream = new ByteArrayInputStream(media);
                    buf_inputStream = new BufferedInputStream(byteArrayInputStream);
                    log.debug((Object)("**** media.length=" + media.length));
                }
                catch (Exception e) {
                    log.error((Object)("****empty media save to DB=" + e.getMessage()));
                }
            } else {
                try {
                    inputStream = this.getFileStream(mediaLocation);
                    buf_inputStream = new BufferedInputStream(inputStream);
                }
                catch (Exception e) {
                    log.error((Object)("****empty media save to file =" + e.getMessage()));
                }
            }
            try {
                buf_outputStream = new BufferedOutputStream((OutputStream)outputStream);
                int i = 0;
                if (buf_inputStream != null) {
                    while ((i = buf_inputStream.read()) != -1) {
                        buf_outputStream.write(i);
                    }
                }
                log.debug((Object)("**** mediaLocation=" + mediaLocation));
                res.flushBuffer();
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
            finally {
                if (buf_outputStream != null) {
                    try {
                        buf_outputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                if (buf_inputStream != null) {
                    try {
                        buf_inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                }
            }
        }
    }

    private FileInputStream getFileStream(String mediaLocation) {
        FileInputStream inputStream = null;
        try {
            File media = new File(mediaLocation);
            inputStream = new FileInputStream(media);
        }
        catch (FileNotFoundException ex) {
            log.warn((Object)("file not found=" + ex.getMessage()));
        }
        return inputStream;
    }

    public String getAgentString(HttpServletRequest req, HttpServletResponse res) {
        String agentIdString = AgentFacade.getAgentString();
        if (agentIdString == null || agentIdString.equals("")) {
            PersonBean person = (PersonBean)ContextUtil.lookupBeanFromExternalServlet((String)"person", (HttpServletRequest)req, (HttpServletResponse)res);
            agentIdString = person.getAnonymousId();
        }
        return agentIdString;
    }

    public boolean canGrade(HttpServletRequest req, HttpServletResponse res, String agentId, String currentSiteId) {
        boolean hasPrivilege_any = this.hasPrivilege(req, "grade_any_assessment", currentSiteId);
        boolean hasPrivilege_own = this.hasPrivilege(req, "grade_own_assessment", currentSiteId);
        log.debug((Object)("hasPrivilege_any=" + hasPrivilege_any));
        log.debug((Object)("hasPrivilege_own=" + hasPrivilege_own));
        boolean hasPrivilege = hasPrivilege_any || hasPrivilege_own;
        return hasPrivilege;
    }

    public boolean isOwner(String agentId, String ownerId) {
        boolean isOwner = false;
        isOwner = agentId.equals(ownerId);
        return isOwner;
    }

    public boolean hasPrivilege(HttpServletRequest req, String functionKey, String context) {
        String functionName = ContextUtil.getLocalizedString((HttpServletRequest)req, (String)"org.sakaiproject.tool.assessment.bundle.AuthzPermissions", (String)functionKey);
        boolean privilege = SecurityService.unlock((String)functionName, (String)("/site/" + context));
        return privilege;
    }
}

