/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.ui.web.session;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.ui.bean.delivery.DeliveryBean;
import org.sakaiproject.tool.cover.SessionManager;

public class SessionUtil {
    public static final String EXTERNAL_APP_INTERVAL = "app_interval_val";
    public static final int HOURS_TO_SECONDS_MULTIPLIER = 3600;
    public static final int MINUTES_TO_SECONDS_MULTIPLIER = 60;
    public static final int DEFAULT_APP_INTERVAL_VAL = 18000;
    private static final int INTERVAL_BUFFER = 900;
    private static Log log = LogFactory.getLog(SessionUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSessionTimeout(FacesContext context, DeliveryBean delivery, boolean beginAssessment) {
        boolean standalone;
        boolean bl = standalone = !IntegrationContextFactory.getInstance().isIntegrated();
        if (standalone) {
            return;
        }
        ExternalContext exContext = context.getExternalContext();
        HttpSession session = (HttpSession)exContext.getSession(false);
        if (session == null) {
            return;
        }
        if (session instanceof ToolSession) {
            session = (HttpSession)SessionManager.getCurrentSession();
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            if (beginAssessment) {
                int interval = 18000;
                if (session.getAttribute(EXTERNAL_APP_INTERVAL) == null) {
                    if (delivery != null && delivery.getHasTimeLimit()) {
                        interval = delivery.getTimeLimit_hour() * 3600;
                        interval += delivery.getTimeLimit_minute() * 60;
                    } else {
                        interval = 18000;
                    }
                }
                if (interval > session.getMaxInactiveInterval()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("begin_assessment: Setting session " + session.getId() + " inactive interval= " + interval + " seconds"));
                    }
                    session.setAttribute(EXTERNAL_APP_INTERVAL, (Object)session.getMaxInactiveInterval());
                    session.setMaxInactiveInterval(interval + 900);
                }
            } else {
                Integer returnVal = (Integer)session.getAttribute(EXTERNAL_APP_INTERVAL);
                if (returnVal == null) {
                    return;
                }
                session.removeAttribute(EXTERNAL_APP_INTERVAL);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("end_assessment: Setting session " + session.getId() + " inactive interval= " + returnVal + " seconds"));
                }
                session.setMaxInactiveInterval(returnVal.intValue());
            }
        }
    }
}

