/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.dao.assessment.AttachmentData;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.ui.bean.util.EmailBean;
import org.sakaiproject.tool.assessment.ui.listener.util.ContextUtil;

public class SamigoEmailService {
    private static Log log = LogFactory.getLog(SamigoEmailService.class);
    private String fromName;
    private String fromEmailAddress;
    private String toName;
    private String toEmailAddress;
    private ArrayList toEmailAddressList;
    private String ccMe;
    private String subject;
    private String message;
    private String smtpServer;
    private String smtpPort;
    private String prefixedPath;

    public SamigoEmailService(String fromName, String fromEmailAddress, String toName, String toEmailAddress, ArrayList toEmailAddressList, String ccMe, String subject, String message) {
        this.fromName = fromName;
        this.fromEmailAddress = fromEmailAddress;
        this.toName = toName;
        this.toEmailAddress = toEmailAddress;
        this.toEmailAddressList = toEmailAddressList;
        this.ccMe = ccMe;
        this.subject = subject;
        this.message = message;
        this.smtpServer = ServerConfigurationService.getString((String)"samigo.smtp.server");
        this.smtpPort = ServerConfigurationService.getString((String)"samigo.smtp.port");
        this.prefixedPath = ServerConfigurationService.getString((String)"samigo.email.prefixedPath");
    }

    public SamigoEmailService(String fromName, String fromEmailAddress, String toName, String toEmailAddress, String ccMe, String subject, String message) {
        this(fromName, fromEmailAddress, toName, toEmailAddress, null, ccMe, subject, message);
    }

    public SamigoEmailService(String fromEmailAddress, ArrayList toEmailAddressList, String ccMe, String subject, String message) {
        this(null, fromEmailAddress, null, null, toEmailAddressList, ccMe, subject, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send() {
        String string;
        List attachmentList = null;
        AttachmentData a2 = null;
        try {
            Properties props = new Properties();
            if (this.smtpServer == null || this.smtpServer.equals("")) {
                log.info((Object)"samigo.email.smtpServer is not set");
                this.smtpServer = ServerConfigurationService.getString((String)"smtp@org.sakaiproject.email.api.EmailService");
                if (this.smtpServer == null || this.smtpServer.equals("")) {
                    log.info((Object)"smtp@org.sakaiproject.email.api.EmailService is not set");
                    log.error((Object)"Please set the value of samigo.email.smtpServer or smtp@org.sakaiproject.email.api.EmailService");
                    String string2 = "error";
                    return string2;
                }
            }
            props.setProperty("mail.smtp.host", this.smtpServer);
            if (this.smtpPort == null || this.smtpPort.equals("")) {
                log.warn((Object)"samigo.email.smtpPort is not set. The default port 25 will be used.");
            } else {
                props.setProperty("mail.smtp.port", this.smtpPort);
            }
            Session session = Session.getInstance((Properties)props);
            session.setDebug(true);
            MimeMessage msg = new MimeMessage(session);
            InternetAddress fromIA = new InternetAddress(this.fromEmailAddress, this.fromName);
            msg.setFrom((Address)fromIA);
            InternetAddress[] toIA = new InternetAddress[]{new InternetAddress(this.toEmailAddress, this.toName)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])toIA);
            if ("yes".equals(this.ccMe)) {
                InternetAddress[] ccIA = new InternetAddress[]{new InternetAddress(this.fromEmailAddress, this.fromName)};
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccIA);
            }
            msg.setSubject(this.subject);
            EmailBean emailBean = (EmailBean)ContextUtil.lookupBean((String)"email");
            attachmentList = emailBean.getAttachmentList();
            StringBuilder content = new StringBuilder(this.message);
            ArrayList<File> fileList = new ArrayList<File>();
            ArrayList<String> fileNameList = new ArrayList<String>();
            if (attachmentList != null) {
                if (this.prefixedPath == null || this.prefixedPath.equals("")) {
                    log.error((Object)"samigo.email.prefixedPath is not set");
                    String string3 = "error";
                    return string3;
                }
                for (AttachmentData a2 : attachmentList) {
                    if (a2.getIsLink().booleanValue()) {
                        log.debug((Object)"send(): url");
                        content.append("<br/>\n\r");
                        content.append("<br/>");
                        content.append(a2.getFilename());
                        continue;
                    }
                    log.debug((Object)"send(): file");
                    File attachedFile = this.getAttachedFile(a2.getResourceId());
                    fileList.add(attachedFile);
                    fileNameList.add(a2.getFilename());
                }
            }
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)content.toString(), "text/html");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
            for (int i = 0; i < fileList.size(); ++i) {
                messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource((File)fileList.get(i));
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName((String)fileNameList.get(i));
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Exception throws from send()" + e.getMessage()));
            string = "error";
            return string;
        }
        catch (MessagingException e) {
            log.error((Object)("Exception throws from send()" + e.getMessage()));
            string = "error";
            return string;
        }
        catch (ServerOverloadException e) {
            log.error((Object)("Exception throws from send()" + e.getMessage()));
            string = "error";
            return string;
        }
        catch (PermissionException e) {
            log.error((Object)("Exception throws from send()" + e.getMessage()));
            string = "error";
            return string;
        }
        catch (IdUnusedException e) {
            log.error((Object)("Exception throws from send()" + e.getMessage()));
            string = "error";
            return string;
        }
        catch (TypeException e) {
            log.error((Object)("Exception throws from send()" + e.getMessage()));
            string = "error";
            return string;
        }
        catch (IOException e) {
            log.error((Object)("Exception throws from send()" + e.getMessage()));
            string = "error";
            return string;
        }
        finally {
            if (attachmentList != null && this.prefixedPath != null && !this.prefixedPath.equals("")) {
                Iterator iter = attachmentList.iterator();
                while (iter.hasNext()) {
                    StringBuilder sbPrefixedPath = new StringBuilder(this.prefixedPath);
                    sbPrefixedPath.append("/email_tmp/");
                    a2 = (AttachmentData)iter.next();
                    if (a2.getIsLink().booleanValue()) continue;
                    this.deleteAttachedFile(sbPrefixedPath.append(a2.getResourceId()).toString());
                }
            }
        }
        return "send";
    }

    public String sendMail() {
        try {
            Properties props = new Properties();
            if (this.smtpServer == null || this.smtpServer.equals("")) {
                log.info((Object)"samigo.email.smtpServer is not set");
                this.smtpServer = ServerConfigurationService.getString((String)"smtp@org.sakaiproject.email.api.EmailService");
                if (this.smtpServer == null || this.smtpServer.equals("")) {
                    log.info((Object)"smtp@org.sakaiproject.email.api.EmailService is not set");
                    log.error((Object)"Please set the value of samigo.email.smtpServer or smtp@org.sakaiproject.email.api.EmailService");
                    return "error";
                }
            }
            props.setProperty("mail.smtp.host", this.smtpServer);
            if (this.smtpPort == null || this.smtpPort.equals("")) {
                log.warn((Object)"samigo.email.smtpPort is not set. The default port 25 will be used.");
            } else {
                props.setProperty("mail.smtp.port", this.smtpPort);
            }
            props.put("mail.smtp.sendpartial", "true");
            Session session = Session.getInstance((Properties)props, null);
            session.setDebug(true);
            MimeMessage msg = new MimeMessage(session);
            InternetAddress fromIA = new InternetAddress(this.fromEmailAddress, this.fromName);
            msg.setFrom((Address)fromIA);
            msg.setSubject(this.subject, "UTF-8");
            String noReplyEmaillAddress = "no-reply@" + ServerConfigurationService.getServerName();
            msg.addHeaderLine("To: " + noReplyEmaillAddress);
            msg.setText(this.message, "UTF-8");
            msg.addHeaderLine("Content-Type: text/html");
            ArrayList<InternetAddress> toIAList = new ArrayList<InternetAddress>();
            String email = "";
            Iterator iter = this.toEmailAddressList.iterator();
            while (iter.hasNext()) {
                try {
                    email = (String)iter.next();
                    toIAList.add(new InternetAddress(email));
                }
                catch (AddressException ae) {
                    log.error((Object)("invalid email address: " + email));
                }
            }
            InternetAddress[] toIA = new InternetAddress[toIAList.size()];
            int count = 0;
            Iterator iter2 = toIAList.iterator();
            while (iter2.hasNext()) {
                toIA[count++] = (InternetAddress)iter2.next();
            }
            try {
                Transport transport = session.getTransport("smtp");
                msg.saveChanges();
                transport.connect();
                try {
                    transport.sendMessage((Message)msg, (Address[])toIA);
                }
                catch (SendFailedException e) {
                    log.debug((Object)("SendFailedException: " + (Object)((Object)e)));
                    return "error";
                }
                catch (MessagingException e) {
                    log.warn((Object)("1st MessagingException: " + (Object)((Object)e)));
                    return "error";
                }
                transport.close();
            }
            catch (MessagingException e) {
                log.warn((Object)("2nd MessagingException:" + (Object)((Object)e)));
                return "error";
            }
        }
        catch (UnsupportedEncodingException ue) {
            log.warn((Object)("UnsupportedEncodingException:" + ue));
            ue.printStackTrace();
        }
        catch (MessagingException me) {
            log.warn((Object)("3rd MessagingException:" + (Object)((Object)me)));
            return "error";
        }
        return "send";
    }

    private File getAttachedFile(String resourceId) throws PermissionException, IdUnusedException, TypeException, ServerOverloadException, IOException {
        File file;
        ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
        log.debug((Object)("getAttachedFile(): resourceId = " + resourceId));
        byte[] data = cr.getContent();
        StringBuilder sbPrefixedPath = new StringBuilder(this.prefixedPath);
        sbPrefixedPath.append("/email_tmp/");
        sbPrefixedPath.append(resourceId);
        String filename = sbPrefixedPath.toString().replace(" ", "");
        log.debug((Object)("getAttachedFile(): filename = " + filename));
        String path = filename.substring(0, filename.lastIndexOf("/"));
        log.debug((Object)("getAttachedFile(): path = " + path));
        File dir = new File(path);
        boolean success = dir.mkdirs();
        if (!success) {
            log.error((Object)"getAttachedFile(): File exists already! This should not heppen. Please check for resourceId.");
        }
        if (!(success = (file = new File(filename)).createNewFile())) {
            log.error((Object)"getAttachedFile(): File exists already! This should not heppen. Please check for resourceId.");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(data);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return file;
    }

    private void deleteAttachedFile(String filename) {
        log.debug((Object)("deleteAttachedFile(): filename = " + filename));
        String tunedFilename = filename.replace(" ", "");
        log.debug((Object)("deleteAttachedFile(): tunedFilename = " + tunedFilename));
        File file = new File(tunedFilename);
        boolean success = file.delete();
        if (!success) {
            log.error((Object)("Fail to delete file: " + tunedFilename));
        }
        String directoryName = tunedFilename.substring(0, tunedFilename.lastIndexOf("/"));
        log.debug((Object)("deleteAttachedFile(): directoryName = " + directoryName));
        File dir = new File(directoryName);
        success = dir.delete();
        if (!success) {
            log.error((Object)("Fail to delete directory: " + directoryName));
        }
    }
}

