/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.tool.assessment.data.dao.assessment.FavoriteColChoices;
import org.sakaiproject.tool.assessment.facade.FavoriteColChoicesFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class FavoriteColChoicesFacadeQueries
extends HibernateDaoSupport
implements FavoriteColChoicesFacadeQueriesAPI {
    private static Log log = LogFactory.getLog(FavoriteColChoicesFacadeQueries.class);

    public void saveOrUpdate(final FavoriteColChoices choices) {
        Iterator iter;
        List favoriteList = null;
        String query = "from FavoriteColChoices as a where a.favoriteName=? ";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from FavoriteColChoices as a where a.favoriteName=? ");
                q.setString(0, choices.getFavoriteName());
                return q.list();
            }
        };
        favoriteList = this.getHibernateTemplate().executeFind(hcb);
        if (favoriteList != null && (iter = favoriteList.iterator()).hasNext()) {
            FavoriteColChoices fChoice = (FavoriteColChoices)iter.next();
            this.getHibernateTemplate().delete((Object)fChoice);
        }
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)choices);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem saving favoriteColChoices: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public List getFavoriteColChoicesByAgent(final String siteAgentId) {
        String query = "from FavoriteColChoices as a where a.ownerStringId=? ";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from FavoriteColChoices as a where a.ownerStringId=? ");
                q.setString(0, siteAgentId);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }
}

