/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAnswer;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAttachmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedEvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSecuredIPAddress;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SecuredIPAddress;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentGradingFacade;
import org.sakaiproject.tool.assessment.facade.AuthzQueriesFacadeAPI;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.PublishedSectionFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.util.PagingUtilQueriesAPI;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.PublishingTargetHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class PublishedAssessmentFacadeQueries
extends HibernateDaoSupport
implements PublishedAssessmentFacadeQueriesAPI {
    private static Log log = LogFactory.getLog(PublishedAssessmentFacadeQueries.class);
    public static final String STARTDATE = "assessmentAccessControl.startDate";
    public static final String DUEDATE = "assessmentAccessControl.dueDate";
    public static final String RETRACTDATE = "assessmentAccessControl.retractDate";
    public static final String RELEASETO = "assessmentAccessControl.releaseTo";
    public static final String PUB_RELEASETO = "releaseTo";
    public static final String PUB_STARTDATE = "startDate";
    public static final String PUB_DUEDATE = "dueDate";
    public static final String TITLE = "title";
    public static final String GRADE = "finalScore";
    public static final String DUE = "dueDate";
    public static final String RAW = "totalAutoScore";
    public static final String TIME = "timeElapsed";
    public static final String SUBMITTED = "submittedDate";
    private SecurityService securityService;
    private SiteService siteService;

    public IdImpl getId(String id) {
        return new IdImpl(id);
    }

    public IdImpl getId(Long id) {
        return new IdImpl(id);
    }

    public IdImpl getId(long id) {
        return new IdImpl(id);
    }

    public IdImpl getAssessmentId(String id) {
        return new IdImpl(id);
    }

    public IdImpl getAssessmentId(Long id) {
        return new IdImpl(id);
    }

    public IdImpl getAssessmentId(long id) {
        return new IdImpl(id);
    }

    public IdImpl getAssessmentTemplateId(String id) {
        return new IdImpl(id);
    }

    public IdImpl getAssessmentTemplateId(Long id) {
        return new IdImpl(id);
    }

    public IdImpl getAssessmentTemplateId(long id) {
        return new IdImpl(id);
    }

    public PublishedAssessmentData preparePublishedAssessment(AssessmentData a) {
        String protocol = ServerConfigurationService.getServerUrl();
        PublishedAssessmentData publishedAssessment = new PublishedAssessmentData(a.getTitle(), a.getDescription(), a.getComments(), TypeFacade.HOMEWORK, a.getInstructorNotification(), a.getTesteeNotification(), a.getMultipartAllowed(), a.getStatus(), AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        publishedAssessment.setAssessmentId(a.getAssessmentBaseId());
        Set publishedSectionSet = this.preparePublishedSectionSet(publishedAssessment, a.getSectionSet(), protocol);
        publishedAssessment.setSectionSet(publishedSectionSet);
        PublishedAccessControl publishedAccessControl = this.preparePublishedAccessControl(publishedAssessment, (AssessmentAccessControl)a.getAssessmentAccessControl());
        publishedAssessment.setAssessmentAccessControl((AssessmentAccessControlIfc)publishedAccessControl);
        PublishedEvaluationModel publishedEvaluationModel = this.preparePublishedEvaluationModel(publishedAssessment, (EvaluationModel)a.getEvaluationModel());
        publishedAssessment.setEvaluationModel((EvaluationModelIfc)publishedEvaluationModel);
        PublishedFeedback publishedFeedback = this.preparePublishedFeedback(publishedAssessment, (AssessmentFeedback)a.getAssessmentFeedback());
        publishedAssessment.setAssessmentFeedback((AssessmentFeedbackIfc)publishedFeedback);
        Set publishedMetaDataSet = this.preparePublishedMetaDataSet(publishedAssessment, a.getAssessmentMetaDataSet());
        log.debug((Object)("******* metadata set" + a.getAssessmentMetaDataSet()));
        log.debug((Object)("******* published metadata set" + publishedMetaDataSet));
        publishedAssessment.setAssessmentMetaDataSet(publishedMetaDataSet);
        Set publishedIPSet = this.preparePublishedSecuredIPSet(publishedAssessment, a.getSecuredIPAddressSet());
        publishedAssessment.setSecuredIPAddressSet(publishedIPSet);
        Set publishedAssessmentAttachmentSet = this.preparePublishedAssessmentAttachmentSet(publishedAssessment, a.getAssessmentAttachmentSet(), protocol);
        publishedAssessment.setAssessmentAttachmentSet(publishedAssessmentAttachmentSet);
        return publishedAssessment;
    }

    public PublishedFeedback preparePublishedFeedback(PublishedAssessmentData p, AssessmentFeedback a) {
        if (a == null) {
            return null;
        }
        PublishedFeedback publishedFeedback = new PublishedFeedback(a.getFeedbackDelivery(), a.getFeedbackComponentOption(), a.getFeedbackAuthoring(), a.getEditComponents(), a.getShowQuestionText(), a.getShowStudentResponse(), a.getShowCorrectResponse(), a.getShowStudentScore(), a.getShowStudentQuestionScore(), a.getShowQuestionLevelFeedback(), a.getShowSelectionLevelFeedback(), a.getShowGraderComments(), a.getShowStatistics());
        publishedFeedback.setAssessmentBase((AssessmentBaseIfc)p);
        return publishedFeedback;
    }

    public PublishedAccessControl preparePublishedAccessControl(PublishedAssessmentData p, AssessmentAccessControl a) {
        if (a == null) {
            return new PublishedAccessControl();
        }
        PublishedAccessControl publishedAccessControl = new PublishedAccessControl(a.getSubmissionsAllowed(), a.getSubmissionsSaved(), a.getAssessmentFormat(), a.getBookMarkingItem(), a.getTimeLimit(), a.getTimedAssessment(), a.getRetryAllowed(), a.getLateHandling(), a.getStartDate(), a.getDueDate(), a.getScoreDate(), a.getFeedbackDate());
        publishedAccessControl.setRetractDate(a.getRetractDate());
        publishedAccessControl.setAutoSubmit(a.getAutoSubmit());
        publishedAccessControl.setItemNavigation(a.getItemNavigation());
        publishedAccessControl.setItemNumbering(a.getItemNumbering());
        publishedAccessControl.setSubmissionMessage(a.getSubmissionMessage());
        publishedAccessControl.setReleaseTo(a.getReleaseTo());
        publishedAccessControl.setUsername(a.getUsername());
        publishedAccessControl.setPassword(a.getPassword());
        publishedAccessControl.setFinalPageUrl(a.getFinalPageUrl());
        publishedAccessControl.setUnlimitedSubmissions(a.getUnlimitedSubmissions());
        publishedAccessControl.setMarkForReview(a.getMarkForReview());
        publishedAccessControl.setAssessmentBase((AssessmentBaseIfc)p);
        return publishedAccessControl;
    }

    public PublishedEvaluationModel preparePublishedEvaluationModel(PublishedAssessmentData p, EvaluationModel e) {
        if (e == null) {
            return null;
        }
        PublishedEvaluationModel publishedEvaluationModel = new PublishedEvaluationModel(e.getEvaluationComponents(), e.getScoringType(), e.getNumericModelId(), e.getFixedTotalScore(), e.getGradeAvailable(), e.getIsStudentIdPublic(), e.getAnonymousGrading(), e.getAutoScoring(), e.getToGradeBook());
        publishedEvaluationModel.setAssessmentBase((AssessmentBaseIfc)p);
        return publishedEvaluationModel;
    }

    public Set preparePublishedMetaDataSet(PublishedAssessmentData p, Set metaDataSet) {
        HashSet<PublishedMetaData> h = new HashSet<PublishedMetaData>();
        for (AssessmentMetaData metaData : metaDataSet) {
            PublishedMetaData publishedMetaData = new PublishedMetaData((AssessmentBaseIfc)p, metaData.getLabel(), metaData.getEntry());
            h.add(publishedMetaData);
        }
        return h;
    }

    public Set preparePublishedSecuredIPSet(PublishedAssessmentData p, Set ipSet) {
        HashSet<PublishedSecuredIPAddress> h = new HashSet<PublishedSecuredIPAddress>();
        for (SecuredIPAddress ip : ipSet) {
            PublishedSecuredIPAddress publishedIP = new PublishedSecuredIPAddress((AssessmentBaseIfc)p, ip.getHostname(), ip.getIpAddress());
            h.add(publishedIP);
        }
        return h;
    }

    public Set preparePublishedSectionSet(PublishedAssessmentData publishedAssessment, Set sectionSet, String protocol) {
        log.debug((Object)("**published section size = " + sectionSet.size()));
        HashSet<PublishedSectionData> h = new HashSet<PublishedSectionData>();
        for (SectionData section : sectionSet) {
            PublishedSectionData publishedSection = new PublishedSectionData(section.getDuration(), section.getSequence(), section.getTitle(), section.getDescription(), section.getTypeId(), section.getStatus(), section.getCreatedBy(), section.getCreatedDate(), section.getLastModifiedBy(), section.getLastModifiedDate());
            Set publishedSectionAttachmentSet = this.preparePublishedSectionAttachmentSet(publishedSection, section.getSectionAttachmentSet(), protocol);
            publishedSection.setSectionAttachmentSet(publishedSectionAttachmentSet);
            Set publishedItemSet = this.preparePublishedItemSet(publishedSection, section.getItemSet(), protocol);
            publishedSection.setItemSet(publishedItemSet);
            Set publishedMetaDataSet = this.preparePublishedSectionMetaDataSet(publishedSection, section.getSectionMetaDataSet());
            publishedSection.setSectionMetaDataSet(publishedMetaDataSet);
            publishedSection.setAssessment((AssessmentIfc)publishedAssessment);
            h.add(publishedSection);
        }
        return h;
    }

    public Set preparePublishedSectionMetaDataSet(PublishedSectionData publishedSection, Set metaDataSet) {
        HashSet<PublishedSectionMetaData> h = new HashSet<PublishedSectionMetaData>();
        for (SectionMetaData sectionMetaData : metaDataSet) {
            PublishedSectionMetaData publishedSectionMetaData = new PublishedSectionMetaData((SectionDataIfc)publishedSection, sectionMetaData.getLabel(), sectionMetaData.getEntry());
            h.add(publishedSectionMetaData);
        }
        return h;
    }

    public Set preparePublishedItemSet(PublishedSectionData publishedSection, Set itemSet, String protocol) {
        log.debug((Object)("**published item size = " + itemSet.size()));
        HashSet<PublishedItemData> h = new HashSet<PublishedItemData>();
        for (ItemData item : itemSet) {
            PublishedItemData publishedItem = new PublishedItemData((SectionDataIfc)publishedSection, item.getSequence(), item.getDuration(), item.getInstruction(), item.getDescription(), item.getTypeId(), item.getGrade(), item.getScore(), item.getDiscount(), item.getHint(), item.getHasRationale(), item.getStatus(), item.getCreatedBy(), item.getCreatedDate(), item.getLastModifiedBy(), item.getLastModifiedDate(), null, null, null, item.getTriesAllowed(), item.getPartialCreditFlag());
            Set publishedItemTextSet = this.preparePublishedItemTextSet(publishedItem, item.getItemTextSet());
            Set publishedItemMetaDataSet = this.preparePublishedItemMetaDataSet(publishedItem, item.getItemMetaDataSet());
            Set publishedItemFeedbackSet = this.preparePublishedItemFeedbackSet(publishedItem, item.getItemFeedbackSet());
            Set publishedItemAttachmentSet = this.preparePublishedItemAttachmentSet(publishedItem, item.getItemAttachmentSet(), protocol);
            publishedItem.setItemTextSet(publishedItemTextSet);
            publishedItem.setItemMetaDataSet(publishedItemMetaDataSet);
            publishedItem.setItemFeedbackSet(publishedItemFeedbackSet);
            publishedItem.setItemAttachmentSet(publishedItemAttachmentSet);
            h.add(publishedItem);
        }
        return h;
    }

    public Set preparePublishedItemTextSet(PublishedItemData publishedItem, Set itemTextSet) {
        log.debug((Object)("**published item text size = " + itemTextSet.size()));
        HashSet<PublishedItemText> h = new HashSet<PublishedItemText>();
        for (ItemText itemText : itemTextSet) {
            log.debug((Object)("**item text id =" + itemText.getId()));
            PublishedItemText publishedItemText = new PublishedItemText(publishedItem, itemText.getSequence(), itemText.getText(), null);
            Set publishedAnswerSet = this.preparePublishedAnswerSet(publishedItemText, itemText.getAnswerSet());
            publishedItemText.setAnswerSet(publishedAnswerSet);
            h.add(publishedItemText);
        }
        return h;
    }

    public Set preparePublishedItemMetaDataSet(PublishedItemData publishedItem, Set itemMetaDataSet) {
        HashSet<PublishedItemMetaData> h = new HashSet<PublishedItemMetaData>();
        for (ItemMetaData itemMetaData : itemMetaDataSet) {
            PublishedItemMetaData publishedItemMetaData = new PublishedItemMetaData((ItemDataIfc)publishedItem, itemMetaData.getLabel(), itemMetaData.getEntry());
            h.add(publishedItemMetaData);
        }
        return h;
    }

    public Set preparePublishedItemFeedbackSet(PublishedItemData publishedItem, Set itemFeedbackSet) {
        HashSet<PublishedItemFeedback> h = new HashSet<PublishedItemFeedback>();
        for (ItemFeedback itemFeedback : itemFeedbackSet) {
            PublishedItemFeedback publishedItemFeedback = new PublishedItemFeedback(publishedItem, itemFeedback.getTypeId(), itemFeedback.getText());
            h.add(publishedItemFeedback);
        }
        return h;
    }

    public Set preparePublishedItemAttachmentSet(PublishedItemData publishedItem, Set itemAttachmentSet, String protocol) {
        HashSet<PublishedItemAttachment> h = new HashSet<PublishedItemAttachment>();
        for (ItemAttachment itemAttachment : itemAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemAttachment.getResourceId(), itemAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                PublishedItemAttachment publishedItemAttachment = new PublishedItemAttachment(null, (ItemDataIfc)publishedItem, cr_copy.getId(), itemAttachment.getFilename(), itemAttachment.getMimeType(), itemAttachment.getFileSize(), itemAttachment.getDescription(), url, itemAttachment.getIsLink(), itemAttachment.getStatus(), itemAttachment.getCreatedBy(), itemAttachment.getCreatedDate(), itemAttachment.getLastModifiedBy(), itemAttachment.getLastModifiedDate());
                h.add(publishedItemAttachment);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        return h;
    }

    public String getRelativePath(String url, String protocol) {
        String location = url = this.replaceSpace(url);
        int index = url.lastIndexOf(protocol);
        if (index == 0) {
            location = url.substring(protocol.length());
        }
        return location;
    }

    public Set preparePublishedSectionAttachmentSet(PublishedSectionData publishedSection, Set sectionAttachmentSet, String protocol) {
        HashSet<PublishedSectionAttachment> h = new HashSet<PublishedSectionAttachment>();
        for (SectionAttachment sectionAttachment : sectionAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(sectionAttachment.getResourceId(), sectionAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                PublishedSectionAttachment publishedSectionAttachment = new PublishedSectionAttachment(null, (SectionDataIfc)publishedSection, cr_copy.getId(), sectionAttachment.getFilename(), sectionAttachment.getMimeType(), sectionAttachment.getFileSize(), sectionAttachment.getDescription(), url, sectionAttachment.getIsLink(), sectionAttachment.getStatus(), sectionAttachment.getCreatedBy(), sectionAttachment.getCreatedDate(), sectionAttachment.getLastModifiedBy(), sectionAttachment.getLastModifiedDate());
                h.add(publishedSectionAttachment);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        return h;
    }

    public Set preparePublishedAssessmentAttachmentSet(PublishedAssessmentData publishedAssessment, Set assessmentAttachmentSet, String protocol) {
        HashSet<PublishedAssessmentAttachment> h = new HashSet<PublishedAssessmentAttachment>();
        for (AssessmentAttachment assessmentAttachment : assessmentAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(assessmentAttachment.getResourceId(), assessmentAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                PublishedAssessmentAttachment publishedAssessmentAttachment = new PublishedAssessmentAttachment(null, (AssessmentIfc)publishedAssessment, cr_copy.getId(), assessmentAttachment.getFilename(), assessmentAttachment.getMimeType(), assessmentAttachment.getFileSize(), assessmentAttachment.getDescription(), url, assessmentAttachment.getIsLink(), assessmentAttachment.getStatus(), assessmentAttachment.getCreatedBy(), assessmentAttachment.getCreatedDate(), assessmentAttachment.getLastModifiedBy(), assessmentAttachment.getLastModifiedDate());
                h.add(publishedAssessmentAttachment);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        return h;
    }

    public Set preparePublishedAnswerSet(PublishedItemText publishedItemText, Set answerSet) {
        log.debug((Object)("**published answer size = " + answerSet.size()));
        HashSet<PublishedAnswer> h = new HashSet<PublishedAnswer>();
        for (Answer answer : answerSet) {
            PublishedAnswer publishedAnswer = new PublishedAnswer((ItemTextIfc)publishedItemText, answer.getText(), answer.getSequence(), answer.getLabel(), answer.getIsCorrect(), answer.getGrade(), answer.getScore(), answer.getPartialCredit(), answer.getDiscount(), null);
            Set publishedAnswerFeedbackSet = this.preparePublishedAnswerFeedbackSet(publishedAnswer, answer.getAnswerFeedbackSet());
            publishedAnswer.setAnswerFeedbackSet(publishedAnswerFeedbackSet);
            h.add(publishedAnswer);
        }
        return h;
    }

    public Set preparePublishedAnswerFeedbackSet(PublishedAnswer publishedAnswer, Set answerFeedbackSet) {
        HashSet<PublishedAnswerFeedback> h = new HashSet<PublishedAnswerFeedback>();
        for (AnswerFeedback answerFeedback : answerFeedbackSet) {
            PublishedAnswerFeedback publishedAnswerFeedback = new PublishedAnswerFeedback((AnswerIfc)publishedAnswer, answerFeedback.getTypeId(), answerFeedback.getText());
            h.add(publishedAnswerFeedback);
        }
        return h;
    }

    public PublishedAssessmentFacade getPublishedAssessment(Long assessmentId) {
        return this.getPublishedAssessment(assessmentId, true);
    }

    public PublishedAssessmentFacade getPublishedAssessment(Long assessmentId, boolean withGroupsInfo) {
        PublishedAssessmentData a = this.loadPublishedAssessment(assessmentId);
        a.setSectionSet((Set)this.getSectionSetForAssessment((PublishedAssessmentIfc)a));
        String releaseToGroups = "";
        if (withGroupsInfo) {
            String siteId = this.getPublishedAssessmentSiteId(assessmentId.toString());
            TreeMap groupsForSite = this.getGroupsForSite(siteId);
            releaseToGroups = this.getReleaseToGroupsAsString(groupsForSite, assessmentId);
        }
        PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a, releaseToGroups);
        return f;
    }

    public Long getPublishedAssessmentId(Long assessmentId) {
        List list = this.getHibernateTemplate().find("from PublishedAssessmentData as p where p.assessmentId=? order by p.createdDate desc", (Object)assessmentId);
        Long publishedId = 0L;
        if (!list.isEmpty()) {
            PublishedAssessmentData f = (PublishedAssessmentData)list.get(0);
            publishedId = f.getPublishedAssessmentId();
        }
        return publishedId;
    }

    public PublishedAssessmentFacade publishAssessment(AssessmentFacade assessment) throws Exception {
        PublishedAssessmentData publishedAssessment = this.preparePublishedAssessment((AssessmentData)assessment.getData());
        this.saveOrUpdate((PublishedAssessmentIfc)publishedAssessment);
        Set sectionSet = publishedAssessment.getSectionSet();
        for (PublishedSectionData section : sectionSet) {
            Set itemSet = section.getItemSet();
            for (PublishedItemData item : itemSet) {
                Set itemMetaDataSet = item.getItemMetaDataSet();
                for (PublishedItemMetaData itemMetaData : itemMetaDataSet) {
                    if (itemMetaData.getLabel() == null || !itemMetaData.getLabel().equals("PARTID")) continue;
                    log.debug((Object)("sectionId = " + section.getSectionId()));
                    itemMetaData.setEntry(section.getSectionId().toString());
                }
            }
        }
        if (publishedAssessment.getEvaluationModel() != null) {
            GradebookServiceHelper gbsHelper;
            String toGradebook = publishedAssessment.getEvaluationModel().getToGradeBook();
            boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
            GradebookService g = null;
            if (integrated) {
                g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
            }
            if ((gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper()).gradebookExists(GradebookFacade.getGradebookUId(), g) && toGradebook != null && toGradebook.equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString())) {
                try {
                    gbsHelper.addToGradebook(publishedAssessment, g);
                }
                catch (Exception e) {
                    log.error((Object)("Removing published assessment: " + e));
                    this.delete((PublishedAssessmentIfc)publishedAssessment);
                    throw e;
                }
            }
        }
        this.createAuthorization(publishedAssessment);
        return new PublishedAssessmentFacade((PublishedAssessmentIfc)publishedAssessment);
    }

    public PublishedAssessmentFacade publishPreviewAssessment(AssessmentFacade assessment) {
        PublishedAssessmentData publishedAssessment = this.preparePublishedAssessment((AssessmentData)assessment.getData());
        publishedAssessment.setStatus(PublishedAssessmentIfc.DEAD_STATUS);
        try {
            this.saveOrUpdate((PublishedAssessmentIfc)publishedAssessment);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        this.createAuthorization(publishedAssessment);
        return new PublishedAssessmentFacade((PublishedAssessmentIfc)publishedAssessment);
    }

    public void createAuthorization(PublishedAssessmentData p) {
        if (p.getAssessmentAccessControl().getReleaseTo() != null && p.getAssessmentAccessControl().getReleaseTo().equals("Selected Groups")) {
            this.createAuthorizationForSelectedGroups(p);
            return;
        }
        String qualifierIdString = p.getPublishedAssessmentId().toString();
        Vector<String> v = new Vector<String>();
        PublishingTargetHelper ptHelper = IntegrationContextFactory.getInstance().getPublishingTargetHelper();
        HashMap targets = ptHelper.getTargets();
        HashMap<String, String> trimedTargets = new HashMap<String, String>();
        for (Map.Entry entry : targets.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            trimedTargets.put(key.trim(), value);
        }
        AssessmentAccessControlIfc control = p.getAssessmentAccessControl();
        String releaseTo = control.getReleaseTo();
        if (releaseTo != null) {
            String[] targetSelected = new String[]{releaseTo};
            for (int i = 0; i < targetSelected.length; ++i) {
                String agentKey = targetSelected[i].trim();
                if (trimedTargets.get(agentKey) == null) continue;
                v.add((String)trimedTargets.get(agentKey));
            }
        }
        PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(AgentFacade.getCurrentSiteId(), "OWN_PUBLISHED_ASSESSMENT", qualifierIdString);
        for (int i = 0; i < v.size(); ++i) {
            String agentId = (String)v.get(i);
            log.debug((Object)("** agentId=" + agentId));
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(agentId, "TAKE_PUBLISHED_ASSESSMENT", qualifierIdString);
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(agentId, "VIEW_PUBLISHED_ASSESSMENT_FEEDBACK", qualifierIdString);
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(agentId, "GRADE_PUBLISHED_ASSESSMENT", qualifierIdString);
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(agentId, "VIEW_PUBLISHED_ASSESSMENT", qualifierIdString);
        }
    }

    public void createAuthorizationForSelectedGroups(PublishedAssessmentData publishedAssessment) {
        AuthzQueriesFacadeAPI authz = PersistenceService.getInstance().getAuthzQueriesFacade();
        String qualifierIdString = publishedAssessment.getPublishedAssessmentId().toString();
        authz.createAuthorization(AgentFacade.getCurrentSiteId(), "OWN_PUBLISHED_ASSESSMENT", qualifierIdString);
        authz.createAuthorization(AgentFacade.getCurrentSiteId(), "VIEW_PUBLISHED_ASSESSMENT", qualifierIdString);
        List authorizationsToCopy = authz.getAuthorizationByFunctionAndQualifier("TAKE_ASSESSMENT", publishedAssessment.getAssessmentId().toString());
        if (authorizationsToCopy != null && authorizationsToCopy.size() > 0) {
            for (AuthorizationData adToCopy : authorizationsToCopy) {
                authz.createAuthorization(adToCopy.getAgentIdString(), "TAKE_PUBLISHED_ASSESSMENT", publishedAssessment.getPublishedAssessmentId().toString());
            }
        }
    }

    public AssessmentData loadAssessment(Long assessmentId) {
        return (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
    }

    public PublishedAssessmentData loadPublishedAssessment(Long assessmentId) {
        return (PublishedAssessmentData)this.getHibernateTemplate().load(PublishedAssessmentData.class, (Serializable)assessmentId);
    }

    public ArrayList getAllTakeableAssessments(String orderBy, boolean ascending, final Integer status) {
        String query = "from PublishedAssessmentData as p where p.status=? order by p." + orderBy;
        query = ascending ? query + " asc" : query + " desc";
        log.debug((Object)("Order by " + orderBy));
        final String hql = query;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setInteger(0, status.intValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<PublishedAssessmentFacade> assessmentList = new ArrayList<PublishedAssessmentFacade>();
        for (int i = 0; i < list.size(); ++i) {
            PublishedAssessmentData a = (PublishedAssessmentData)list.get(i);
            log.debug((Object)("Title: " + a.getTitle()));
            PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    public Integer getNumberOfSubmissions(final String publishedAssessmentId, final String agentId) {
        String query = "select count(a) from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(a) from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=?");
                q.setLong(0, Long.parseLong(publishedAssessmentId));
                q.setString(1, agentId);
                q.setBoolean(2, true);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        return (Integer)list.get(0);
    }

    public List getNumberOfSubmissionsOfAllAssessmentsByAgent(final String agentId) {
        String query = "select new AssessmentGradingData( a.publishedAssessmentId, count(a))  from AssessmentGradingData as a where a.agentId=? and a.forGrade=? group by a.publishedAssessmentId";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.publishedAssessmentId, count(a))  from AssessmentGradingData as a where a.agentId=? and a.forGrade=? group by a.publishedAssessmentId");
                q.setString(0, agentId);
                q.setBoolean(1, true);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public List getNumberOfSubmissionsOfAllAssessmentsByAgent(final String agentId, final String siteId) {
        final ArrayList groupIds = this.getSiteGroupIdsForSubmittingAgent(agentId, siteId);
        if (groupIds.size() > 0) {
            String query = "select new AssessmentGradingData( a.publishedAssessmentId, count(a))  from AssessmentGradingData as a, AuthorizationData as az  where a.agentId=:agentId and a.forGrade=:forGrade  and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=a.publishedAssessmentId group by a.publishedAssessmentId";
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select new AssessmentGradingData( a.publishedAssessmentId, count(a))  from AssessmentGradingData as a, AuthorizationData as az  where a.agentId=:agentId and a.forGrade=:forGrade  and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=a.publishedAssessmentId group by a.publishedAssessmentId");
                    q.setString("agentId", agentId);
                    q.setBoolean("forGrade", true);
                    q.setString("siteId", siteId);
                    q.setParameterList("groupIds", (Collection)groupIds);
                    q.setString("functionId", "TAKE_PUBLISHED_ASSESSMENT");
                    return q.list();
                }
            };
            return this.getHibernateTemplate().executeFind(hcb);
        }
        String query = "select new AssessmentGradingData( a.publishedAssessmentId, count(a))  from AssessmentGradingData as a, AuthorizationData as az  where a.agentId=:agentId and a.forGrade=:forGrade  and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=a.publishedAssessmentId group by a.publishedAssessmentId";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.publishedAssessmentId, count(a))  from AssessmentGradingData as a, AuthorizationData as az  where a.agentId=:agentId and a.forGrade=:forGrade  and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=a.publishedAssessmentId group by a.publishedAssessmentId");
                q.setString("agentId", agentId);
                q.setBoolean("forGrade", true);
                q.setString("siteId", siteId);
                q.setString("functionId", "TAKE_PUBLISHED_ASSESSMENT");
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public ArrayList getAllPublishedAssessments(String sortString) {
        String orderBy = this.getOrderBy(sortString);
        List list = this.getHibernateTemplate().find("from PublishedAssessmentData p order by p." + orderBy);
        ArrayList<PublishedAssessmentFacade> assessmentList = new ArrayList<PublishedAssessmentFacade>();
        for (int i = 0; i < list.size(); ++i) {
            PublishedAssessmentData a = (PublishedAssessmentData)list.get(i);
            a.setSectionSet((Set)this.getSectionSetForAssessment((PublishedAssessmentIfc)a));
            PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    public ArrayList getAllPublishedAssessments(String sortString, final Integer status) {
        final String orderBy = this.getOrderBy(sortString);
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from PublishedAssessmentData as p where p.status=? order by p." + orderBy);
                q.setInteger(0, status.intValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<PublishedAssessmentFacade> assessmentList = new ArrayList<PublishedAssessmentFacade>();
        for (int i = 0; i < list.size(); ++i) {
            PublishedAssessmentData a = (PublishedAssessmentData)list.get(i);
            a.setSectionSet((Set)this.getSectionSetForAssessment((PublishedAssessmentIfc)a));
            PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    public ArrayList getAllPublishedAssessments(int pageSize, int pageNumber, String sortString, Integer status) {
        String orderBy = this.getOrderBy(sortString);
        String queryString = "from PublishedAssessmentData p order by p." + orderBy;
        if (!status.equals(PublishedAssessmentFacade.ANY_STATUS)) {
            queryString = "from PublishedAssessmentData p where p.status = ?  order by p." + orderBy;
        }
        PagingUtilQueriesAPI pagingUtilQueries = PersistenceService.getInstance().getPagingUtilQueries();
        List pageList = pagingUtilQueries.getAll(pageSize, pageNumber, queryString, status);
        log.debug((Object)("**** pageList=" + pageList));
        ArrayList<PublishedAssessmentFacade> assessmentList = new ArrayList<PublishedAssessmentFacade>();
        for (int i = 0; i < pageList.size(); ++i) {
            PublishedAssessmentData a = (PublishedAssessmentData)pageList.get(i);
            a.setSectionSet((Set)this.getSectionSetForAssessment((PublishedAssessmentIfc)a));
            log.debug((Object)("****  published assessment=" + a.getTitle()));
            PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a);
            log.debug((Object)("**** published assessment title=" + f.getTitle()));
            assessmentList.add(f);
        }
        return assessmentList;
    }

    public void removeAssessment(Long assessmentId, String action) {
        PublishedAssessmentData assessment = (PublishedAssessmentData)this.getHibernateTemplate().load(PublishedAssessmentData.class, (Serializable)assessmentId);
        if (action == null || action.equals("preview")) {
            this.delete((PublishedAssessmentIfc)assessment);
            PersistenceService.getInstance().getAuthzQueriesFacade().removeAuthorizationByQualifier(assessment.getPublishedAssessmentId().toString(), true);
        } else {
            assessment.setStatus(PublishedAssessmentIfc.DEAD_STATUS);
            try {
                this.saveOrUpdate((PublishedAssessmentIfc)assessment);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
    }

    private String getOrderBy(String sortString) {
        String startDate = STARTDATE.substring(STARTDATE.lastIndexOf(".") + 1);
        String dueDate = DUEDATE.substring(DUEDATE.lastIndexOf(".") + 1);
        String releaseTo = RELEASETO.substring(RELEASETO.lastIndexOf(".") + 1);
        if (sortString.equals(startDate)) {
            return STARTDATE;
        }
        if (sortString.equals(dueDate)) {
            return DUEDATE;
        }
        if (sortString.equals(releaseTo)) {
            return RELEASETO;
        }
        return TITLE;
    }

    public void deleteAllSecuredIP(PublishedAssessmentIfc assessment) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                Long assessmentId = assessment.getPublishedAssessmentId();
                List ip = this.getHibernateTemplate().find("from PublishedSecuredIPAddress s where s.assessment.publishedAssessmentId=?", (Object)assessmentId);
                if (ip.size() > 0) {
                    PublishedSecuredIPAddress s = (PublishedSecuredIPAddress)ip.get(0);
                    PublishedAssessmentData a = (PublishedAssessmentData)s.getAssessment();
                    a.setSecuredIPAddressSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)ip);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleting ip address: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public void saveOrUpdate(PublishedAssessmentIfc assessment) throws Exception {
        PublishedAssessmentData data = assessment instanceof PublishedAssessmentFacade ? (PublishedAssessmentData)((PublishedAssessmentFacade)assessment).getData() : (PublishedAssessmentData)assessment;
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem save or update assessment: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
                if (retryCount != 0) continue;
                throw e;
            }
        }
    }

    public ArrayList getBasicInfoOfAllActivePublishedAssessments(String sortString, final String siteAgentId, boolean ascending) {
        Date currentDate = new Date();
        String orderBy = this.getOrderBy(sortString);
        String query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate, p.lastModifiedDate, p.lastModifiedBy)  from PublishedAssessmentData p, PublishedAccessControl c, AuthorizationData z   where c.assessment.publishedAssessmentId = p.publishedAssessmentId and p.status=:status and  p.publishedAssessmentId=z.qualifierId and z.functionId=:functionId  and z.agentIdString=:siteId  order by p." + orderBy;
        query = ascending ? query + " asc" : query + " desc";
        final String hql = query;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setInteger("status", 1);
                q.setString("functionId", "OWN_PUBLISHED_ASSESSMENT");
                q.setString("siteId", siteAgentId);
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<PublishedAssessmentData> list = new ArrayList<PublishedAssessmentData>();
        for (int j = 0; j < l.size(); ++j) {
            PublishedAssessmentData p = (PublishedAssessmentData)l.get(j);
            if (p.getDueDate() != null && !p.getDueDate().after(currentDate) || p.getRetractDate() != null && !p.getRetractDate().after(currentDate)) continue;
            list.add(p);
        }
        ArrayList<PublishedAssessmentFacade> pubList = new ArrayList<PublishedAssessmentFacade>();
        TreeMap groupsForSite = null;
        String lastModifiedBy = "";
        AgentFacade agent = null;
        for (int i = 0; i < list.size(); ++i) {
            PublishedAssessmentData p = (PublishedAssessmentData)list.get(i);
            String releaseToGroups = null;
            if (p.getReleaseTo().equals("Selected Groups")) {
                if (groupsForSite == null) {
                    groupsForSite = this.getGroupsForSite(siteAgentId);
                }
                Long assessmentId = p.getPublishedAssessmentId();
                releaseToGroups = this.getReleaseToGroupsAsString(groupsForSite, assessmentId);
            }
            if ((agent = new AgentFacade(p.getLastModifiedBy())) != null) {
                lastModifiedBy = agent.getFirstName() + " " + agent.getLastName();
            }
            PublishedAssessmentFacade f = new PublishedAssessmentFacade(p.getPublishedAssessmentId(), p.getTitle(), p.getReleaseTo(), p.getStartDate(), p.getDueDate(), releaseToGroups, p.getLastModifiedDate(), lastModifiedBy);
            pubList.add(f);
        }
        return pubList;
    }

    public ArrayList getBasicInfoOfAllInActivePublishedAssessments(String sortString, final String siteAgentId, boolean ascending) {
        String orderBy = this.getOrderBy(sortString);
        String query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title, c.releaseTo, c.startDate, c.dueDate, c.retractDate, p.status, p.lastModifiedDate, p.lastModifiedBy) from PublishedAssessmentData p, PublishedAccessControl c, AuthorizationData z   where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and ((p.status=:activeStatus and (c.dueDate<=:today or c.retractDate<=:today)) or p.status=:editStatus) and p.publishedAssessmentId=z.qualifierId and z.functionId=:functionId  and z.agentIdString=:siteId  order by p." + orderBy;
        query = ascending ? query + " asc" : query + " desc";
        final String hql = query;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setInteger("activeStatus", 1);
                q.setTimestamp("today", new Date());
                q.setInteger("editStatus", 3);
                q.setString("functionId", "OWN_PUBLISHED_ASSESSMENT");
                q.setString("siteId", siteAgentId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<PublishedAssessmentFacade> pubList = new ArrayList<PublishedAssessmentFacade>();
        TreeMap groupsForSite = null;
        String lastModifiedBy = "";
        AgentFacade agent = null;
        for (int i = 0; i < list.size(); ++i) {
            PublishedAssessmentData p = (PublishedAssessmentData)list.get(i);
            String releaseToGroups = null;
            if (p.getReleaseTo().equals("Selected Groups")) {
                if (groupsForSite == null) {
                    groupsForSite = this.getGroupsForSite(siteAgentId);
                }
                Long assessmentId = p.getPublishedAssessmentId();
                releaseToGroups = this.getReleaseToGroupsAsString(groupsForSite, assessmentId);
            }
            if ((agent = new AgentFacade(p.getLastModifiedBy())) != null) {
                lastModifiedBy = agent.getFirstName() + " " + agent.getLastName();
            }
            PublishedAssessmentFacade f = new PublishedAssessmentFacade(p.getPublishedAssessmentId(), p.getTitle(), p.getReleaseTo(), p.getStartDate(), p.getDueDate(), p.getStatus(), releaseToGroups, p.getLastModifiedDate(), lastModifiedBy);
            pubList.add(f);
        }
        return pubList;
    }

    public HashSet getSectionSetForAssessment(PublishedAssessmentIfc assessment) {
        List sectionList = this.getHibernateTemplate().find("from PublishedSectionData s where s.assessment.publishedAssessmentId=? ", (Object)assessment.getPublishedAssessmentId());
        HashSet<PublishedSectionData> set = new HashSet<PublishedSectionData>();
        for (int j = 0; j < sectionList.size(); ++j) {
            set.add((PublishedSectionData)sectionList.get(j));
        }
        return set;
    }

    public PublishedAssessmentFacade getSettingsOfPublishedAssessment(Long assessmentId) {
        PublishedAssessmentData a = this.loadPublishedAssessment(assessmentId);
        Boolean loadSection = Boolean.FALSE;
        PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)a, loadSection);
        return f;
    }

    public PublishedItemData loadPublishedItem(Long itemId) {
        return (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)itemId);
    }

    public PublishedItemText loadPublishedItemText(Long itemTextId) {
        return (PublishedItemText)this.getHibernateTemplate().load(PublishedItemText.class, (Serializable)itemTextId);
    }

    public ArrayList getBasicInfoOfAllPublishedAssessments(String orderBy, boolean ascending, final String siteId) {
        final ArrayList groupIds = this.getSiteGroupIdsForCurrentUser(siteId);
        String query = "";
        query = groupIds.size() > 0 ? "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate,  c.feedbackDate, f.feedbackDelivery, f.feedbackComponentOption, f.feedbackAuthoring, c.lateHandling,  c.unlimitedSubmissions, c.submissionsAllowed, em.scoringType, p.status, p.lastModifiedDate, c.timeLimit)  from PublishedAssessmentData as p, PublishedAccessControl as c, PublishedFeedback as f, AuthorizationData as az, PublishedEvaluationModel as em where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and p.publishedAssessmentId = f.assessment.publishedAssessmentId  and p.publishedAssessmentId = em.assessment.publishedAssessmentId  and (p.status=:activeStatus or p.status=:editStatus) and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by " : "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate,  c.feedbackDate, f.feedbackDelivery, f.feedbackComponentOption, f.feedbackAuthoring, c.lateHandling,  c.unlimitedSubmissions, c.submissionsAllowed, em.scoringType, p.status, p.lastModifiedDate, c.timeLimit)  from PublishedAssessmentData as p, PublishedAccessControl as c, PublishedFeedback as f, AuthorizationData as az, PublishedEvaluationModel as em where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and p.publishedAssessmentId = f.assessment.publishedAssessmentId  and p.publishedAssessmentId = em.assessment.publishedAssessmentId  and (p.status=:activeStatus or p.status=:editStatus) and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by ";
        query = !ascending ? (orderBy.equals("dueDate") ? query + " c." + orderBy + " desc" : query + " p." + orderBy + " desc") : (orderBy.equals("dueDate") ? query + " c." + orderBy + " asc" : query + " p." + orderBy + " asc");
        final String hql = query;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setInteger("activeStatus", 1);
                q.setInteger("editStatus", 3);
                q.setString("siteId", siteId);
                if (groupIds.size() > 0) {
                    q.setParameterList("groupIds", (Collection)groupIds);
                }
                q.setString("functionId", "TAKE_PUBLISHED_ASSESSMENT");
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<PublishedAssessmentFacade> pubList = new ArrayList<PublishedAssessmentFacade>();
        for (int i = 0; i < list.size(); ++i) {
            PublishedAssessmentData p = (PublishedAssessmentData)list.get(i);
            PublishedAssessmentFacade f = new PublishedAssessmentFacade(p.getPublishedAssessmentId(), p.getTitle(), p.getReleaseTo(), p.getStartDate(), p.getDueDate(), p.getRetractDate(), p.getFeedbackDate(), p.getFeedbackDelivery(), p.getFeedbackComponentOption(), p.getFeedbackAuthoring(), p.getLateHandling(), p.getUnlimitedSubmissions(), p.getSubmissionsAllowed(), p.getScoringType(), p.getStatus(), p.getLastModifiedDate(), p.getTimeLimit());
            pubList.add(f);
        }
        return pubList;
    }

    public ArrayList getBasicInfoOfAllPublishedAssessments2(String sortString, boolean ascending, final String siteAgentId) {
        String orderBy = this.getOrderBy(sortString);
        String query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate, p.status, p.lastModifiedDate, p.lastModifiedBy, c.lateHandling, c.unlimitedSubmissions, c.submissionsAllowed)  from PublishedAssessmentData p, PublishedAccessControl c, AuthorizationData z   where c.assessment.publishedAssessmentId = p.publishedAssessmentId  and p.publishedAssessmentId=z.qualifierId and z.functionId=:functionId  and z.agentIdString=:siteId and (p.status=:activeStatus or p.status=:editStatus)  order by p." + orderBy;
        query = ascending ? query + " asc" : query + " desc";
        final String hql = query;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString("functionId", "OWN_PUBLISHED_ASSESSMENT");
                q.setString("siteId", siteAgentId);
                q.setInteger("activeStatus", 1);
                q.setInteger("editStatus", 3);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<PublishedAssessmentFacade> pubList = new ArrayList<PublishedAssessmentFacade>();
        TreeMap groupsForSite = null;
        String lastModifiedBy = "";
        AgentFacade agent = null;
        for (int i = 0; i < list.size(); ++i) {
            PublishedAssessmentData p = (PublishedAssessmentData)list.get(i);
            String releaseToGroups = null;
            if (p.getReleaseTo().equals("Selected Groups")) {
                if (groupsForSite == null) {
                    groupsForSite = this.getGroupsForSite(siteAgentId);
                }
                Long assessmentId = p.getPublishedAssessmentId();
                releaseToGroups = this.getReleaseToGroupsAsString(groupsForSite, assessmentId);
            }
            if ((agent = new AgentFacade(p.getLastModifiedBy())) != null) {
                lastModifiedBy = agent.getFirstName() + " " + agent.getLastName();
            }
            PublishedAssessmentFacade f = new PublishedAssessmentFacade(p.getPublishedAssessmentId(), p.getTitle(), p.getReleaseTo(), p.getStartDate(), p.getDueDate(), p.getRetractDate(), p.getStatus(), releaseToGroups, p.getLastModifiedDate(), lastModifiedBy, p.getLateHandling(), p.getUnlimitedSubmissions(), p.getSubmissionsAllowed());
            pubList.add(f);
        }
        return pubList;
    }

    public ArrayList getBasicInfoOfLastSubmittedAssessments(final String agentId, String orderBy, boolean ascending) {
        String query = "select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p where a.publishedAssessmentId = p.publishedAssessmentId  and a.forGrade=? and a.agentId=? order by p.publishedAssessmentId DESC, a.submittedDate DESC";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p where a.publishedAssessmentId = p.publishedAssessmentId  and a.forGrade=? and a.agentId=? order by p.publishedAssessmentId DESC, a.submittedDate DESC");
                q.setBoolean(0, true);
                q.setString(1, agentId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingFacade> assessmentList = new ArrayList<AssessmentGradingFacade>();
        Long current = new Long("0");
        for (int i = 0; i < list.size(); ++i) {
            AssessmentGradingData a = (AssessmentGradingData)list.get(i);
            if (a.getPublishedAssessmentId().equals(current)) continue;
            current = a.getPublishedAssessmentId();
            AssessmentGradingFacade f = new AssessmentGradingFacade(a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    public HashMap getTotalSubmissionPerAssessment(String agentId) {
        List l = this.getNumberOfSubmissionsOfAllAssessmentsByAgent(agentId);
        HashMap<Long, Integer> h = new HashMap<Long, Integer>();
        for (int i = 0; i < l.size(); ++i) {
            AssessmentGradingData d = (AssessmentGradingData)l.get(i);
            h.put(d.getPublishedAssessmentId(), d.getTotalSubmitted());
            log.debug((Object)("pId=" + d.getPublishedAssessmentId() + " submitted=" + d.getTotalSubmitted()));
        }
        return h;
    }

    public HashMap getTotalSubmissionPerAssessment(String agentId, String siteId) {
        List l = this.getNumberOfSubmissionsOfAllAssessmentsByAgent(agentId, siteId);
        HashMap<Long, Integer> h = new HashMap<Long, Integer>();
        for (int i = 0; i < l.size(); ++i) {
            AssessmentGradingData d = (AssessmentGradingData)l.get(i);
            h.put(d.getPublishedAssessmentId(), d.getTotalSubmitted());
            log.debug((Object)("pId=" + d.getPublishedAssessmentId() + " submitted=" + d.getTotalSubmitted()));
        }
        return h;
    }

    public Integer getTotalSubmission(final String agentId, final Long publishedAssessmentId) {
        String query = "select count(a) from AssessmentGradingData a where a.forGrade=?  and a.agentId=? and a.publishedAssessmentId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(a) from AssessmentGradingData a where a.forGrade=?  and a.agentId=? and a.publishedAssessmentId=?");
                q.setBoolean(0, true);
                q.setString(1, agentId);
                q.setLong(2, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        return (Integer)l.get(0);
    }

    public PublishedAssessmentFacade getPublishedAssessmentIdByAlias(String alias) {
        return this.getPublishedAssessmentIdByMetaLabel("ALIAS", alias);
    }

    public PublishedAssessmentFacade getPublishedAssessmentIdByMetaLabel(final String label, final String entry) {
        String query = "select p  from PublishedAssessmentData p,  PublishedMetaData m where p=m.assessment  and m.label=? and m.entry=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p  from PublishedAssessmentData p,  PublishedMetaData m where p=m.assessment  and m.label=? and m.entry=?");
                q.setString(0, label);
                q.setString(1, entry);
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        if (l.size() > 0) {
            PublishedAssessmentData p = (PublishedAssessmentData)l.get(0);
            p.setSectionSet((Set)this.getSectionSetForAssessment((PublishedAssessmentIfc)p));
            PublishedAssessmentFacade f = new PublishedAssessmentFacade((PublishedAssessmentIfc)p);
            f.setFeedbackComponentOption(p.getAssessmentFeedback().getFeedbackComponentOption());
            return f;
        }
        return null;
    }

    public void saveOrUpdateMetaData(PublishedMetaData meta) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)meta);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem save or update meta data: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public HashMap getFeedbackHash() {
        String siteId = AgentFacade.getCurrentSiteId();
        HashMap<Long, PublishedFeedback> h = new HashMap<Long, PublishedFeedback>();
        String query = "select new PublishedFeedback( p.assessment.publishedAssessmentId, p.feedbackDelivery,p.feedbackComponentOption,  p.feedbackAuthoring, p.editComponents, p.showQuestionText, p.showStudentResponse, p.showCorrectResponse, p.showStudentScore, p.showStudentQuestionScore, p.showQuestionLevelFeedback, p.showSelectionLevelFeedback, p.showGraderComments, p.showStatistics) from PublishedFeedback p, AuthorizationData az where az.qualifierId = p.assessment.publishedAssessmentId and az.agentIdString=? and az.functionId=?";
        Object[] values = new Object[]{siteId, "TAKE_PUBLISHED_ASSESSMENT"};
        List l = this.getHibernateTemplate().find(query, values);
        for (int i = 0; i < l.size(); ++i) {
            PublishedFeedback f = (PublishedFeedback)l.get(i);
            h.put(f.getAssessmentId(), f);
        }
        return h;
    }

    public HashMap getAllAssessmentsReleasedToAuthenticatedUsers() {
        HashMap<Long, PublishedAssessmentFacade> h = new HashMap<Long, PublishedAssessmentFacade>();
        String query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate)  from PublishedAssessmentData p, PublishedAccessControl c   where c.assessment = p and c.releaseTo like '%Authenticated Users%'";
        List l = this.getHibernateTemplate().find(query);
        for (int i = 0; i < l.size(); ++i) {
            PublishedAssessmentData p = (PublishedAssessmentData)l.get(i);
            h.put(p.getPublishedAssessmentId(), new PublishedAssessmentFacade((PublishedAssessmentIfc)p));
        }
        return h;
    }

    public String getPublishedAssessmentOwner(String publishedAssessmentId) {
        String query = "select a from AuthorizationData a where  a.functionId=? and a.qualifierId=? ";
        Object[] values = new Object[]{"OWN_PUBLISHED_ASSESSMENT", publishedAssessmentId};
        List l = this.getHibernateTemplate().find(query, values);
        if (l.size() > 0) {
            AuthorizationData a = (AuthorizationData)l.get(0);
            return a.getAgentIdString();
        }
        return null;
    }

    public boolean publishedAssessmentTitleIsUnique(final Long assessmentBaseId, final String title) {
        final String currentSiteId = AgentFacade.getCurrentSiteId();
        boolean isUnique = true;
        String query = "select new PublishedAssessmentData(a.publishedAssessmentId, a.title, a.lastModifiedDate) from PublishedAssessmentData a, AuthorizationData z where  a.title=? and a.publishedAssessmentId!=? and a.status!=? and  z.functionId=? and  a.publishedAssessmentId=z.qualifierId and z.agentIdString=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new PublishedAssessmentData(a.publishedAssessmentId, a.title, a.lastModifiedDate) from PublishedAssessmentData a, AuthorizationData z where  a.title=? and a.publishedAssessmentId!=? and a.status!=? and  z.functionId=? and  a.publishedAssessmentId=z.qualifierId and z.agentIdString=?");
                q.setString(0, title);
                q.setLong(1, assessmentBaseId.longValue());
                q.setInteger(2, 2);
                q.setString(3, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(4, currentSiteId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        if (list.size() > 0) {
            isUnique = false;
        }
        return isUnique;
    }

    public boolean hasRandomPart(final Long publishedAssessmentId) {
        boolean hasRandomPart = false;
        String key = "AUTHOR_TYPE";
        final String value = SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString();
        String query = "select s from PublishedSectionData s, PublishedSectionMetaData m where  s = m.section and s.assessment.publishedAssessmentId=? and  m.label=? and m.entry=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from PublishedSectionData s, PublishedSectionMetaData m where  s = m.section and s.assessment.publishedAssessmentId=? and  m.label=? and m.entry=?");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, "AUTHOR_TYPE");
                q.setString(2, value);
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        if (l.size() > 0) {
            hasRandomPart = true;
        }
        return hasRandomPart;
    }

    public List getContainRandomPartAssessmentIds(final Collection assessmentIds) {
        if (assessmentIds == null || assessmentIds.size() < 1) {
            return new ArrayList();
        }
        String key = "AUTHOR_TYPE";
        final String value = SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString();
        String query = "select s.assessment.publishedAssessmentId from PublishedSectionData s, PublishedSectionMetaData m where s.assessment.publishedAssessmentId in (:ids) and s = m.section and m.label=:label and m.entry=:entry group by s.assessment.publishedAssessmentId";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s.assessment.publishedAssessmentId from PublishedSectionData s, PublishedSectionMetaData m where s.assessment.publishedAssessmentId in (:ids) and s = m.section and m.label=:label and m.entry=:entry group by s.assessment.publishedAssessmentId");
                q.setString("label", "AUTHOR_TYPE");
                q.setString("entry", value);
                q.setParameterList("ids", assessmentIds);
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        return l;
    }

    public PublishedItemData getFirstPublishedItem(final Long publishedAssessmentId) {
        String query = "select i from PublishedAssessmentData p, PublishedSectionData s,  PublishedItemData i where p.publishedAssessmentId=? and p.publishedAssessmentId=s.assessment.publishedAssessmentId and  s=i.section";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i from PublishedAssessmentData p, PublishedSectionData s,  PublishedItemData i where p.publishedAssessmentId=? and p.publishedAssessmentId=s.assessment.publishedAssessmentId and  s=i.section");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        String query2 = "select s from PublishedAssessmentData p, PublishedSectionData s, PublishedSectionMetaData m  where p.publishedAssessmentId=? and s = m.section and  p.publishedAssessmentId=s.assessment.publishedAssessmentId ";
        HibernateCallback hcb2 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from PublishedAssessmentData p, PublishedSectionData s, PublishedSectionMetaData m  where p.publishedAssessmentId=? and s = m.section and  p.publishedAssessmentId=s.assessment.publishedAssessmentId ");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List sec = this.getHibernateTemplate().executeFind(hcb2);
        PublishedItemData returnItem = null;
        if (sec.size() > 0 && l.size() > 0) {
            Collections.sort(sec, new SecComparator());
            for (int i = 0; i < sec.size(); ++i) {
                PublishedSectionData thisSec = (PublishedSectionData)sec.get(i);
                ArrayList<PublishedItemData> itemList = new ArrayList<PublishedItemData>();
                for (int j = 0; j < l.size(); ++j) {
                    PublishedItemData compItem = (PublishedItemData)l.get(j);
                    if (!compItem.getSection().getSectionId().equals(thisSec.getSectionId())) continue;
                    itemList.add(compItem);
                }
                if (itemList.size() <= 0) continue;
                Collections.sort(itemList, new ItemComparator());
                returnItem = (PublishedItemData)itemList.get(0);
                break;
            }
        }
        return returnItem;
    }

    public List getPublishedItemIds(final Long publishedAssessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i.itemId from PublishedItemData i, PublishedSectionData s,  PublishedAssessmentData p where p.publishedAssessmentId=? and  p = s.assessment and i.section = s");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public HashSet getPublishedItemSet(final Long publishedAssessmentId, final Long sectionId) {
        HashSet<PublishedItemData> itemSet = new HashSet<PublishedItemData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i from PublishedItemData i, PublishedSectionData s,  PublishedAssessmentData p where p.publishedAssessmentId=?  and i.section.id=? and p = s.assessment and i.section = s");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setLong(1, sectionId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        for (PublishedItemData publishedItemData : assessmentGradings) {
            log.debug((Object)("itemId = " + publishedItemData.getItemId()));
            itemSet.add(publishedItemData);
        }
        return itemSet;
    }

    public Long getItemType(final Long publishedItemId) {
        String query = "select p.typeId  from PublishedItemData p  where p.itemId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p.typeId  from PublishedItemData p  where p.itemId=?");
                q.setLong(0, publishedItemId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        if (list.size() > 0) {
            return (Long)list.get(0);
        }
        return null;
    }

    public void delete(PublishedAssessmentIfc assessment) {
        PublishedAssessmentData data = assessment instanceof PublishedAssessmentFacade ? (PublishedAssessmentData)((PublishedAssessmentFacade)assessment).getData() : (PublishedAssessmentData)assessment;
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem removing publishedAssessment: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public HashSet getSectionSetForAssessment(Long publishedAssessmentId) {
        List sectionList = this.getHibernateTemplate().find("from PublishedSectionData s where s.assessment.publishedAssessmentId=?", (Object)publishedAssessmentId);
        HashSet<PublishedSectionData> set = new HashSet<PublishedSectionData>();
        for (int j = 0; j < sectionList.size(); ++j) {
            set.add((PublishedSectionData)sectionList.get(j));
        }
        return set;
    }

    private String replaceSpace(String tempString) {
        String newString = "";
        char[] oneChar = new char[1];
        for (int i = 0; i < tempString.length(); ++i) {
            if (tempString.charAt(i) != ' ') {
                oneChar[0] = tempString.charAt(i);
                String concatString = new String(oneChar);
                newString = newString.concat(concatString);
                continue;
            }
            newString = newString.concat("%20");
        }
        return newString;
    }

    public boolean isRandomDrawPart(final Long publishedAssessmentId, final Long sectionId) {
        boolean isRandomDrawPart = false;
        String key = "AUTHOR_TYPE";
        final String value = SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString();
        String query = "select s from PublishedSectionData s, PublishedSectionMetaData m where  s = m.section and s.assessment.publishedAssessmentId=? and  s.id=? and m.label=? and m.entry=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from PublishedSectionData s, PublishedSectionMetaData m where  s = m.section and s.assessment.publishedAssessmentId=? and  s.id=? and m.label=? and m.entry=?");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setLong(1, sectionId.longValue());
                q.setString(2, "AUTHOR_TYPE");
                q.setString(3, value);
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        if (l.size() > 0) {
            isRandomDrawPart = true;
        }
        return isRandomDrawPart;
    }

    public ArrayList getBasicInfoOfLastOrHighestOrAverageSubmittedAssessmentsByScoringOption(final String agentId, final String siteId, boolean allAssessments) {
        AssessmentGradingFacade f;
        AssessmentGradingData a;
        int i;
        List highest_list;
        Object hcb_highest;
        List last_list;
        Object hcb_last;
        String hql;
        final ArrayList groupIds = this.getSiteGroupIdsForCurrentUser(siteId);
        String order_last = " order by p.publishedAssessmentId DESC, a.submittedDate DESC";
        String order_highest = " order by p.publishedAssessmentId DESC, a.finalScore DESC, a.submittedDate DESC";
        if (groupIds.size() > 0) {
            hql = "select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.agentId=:agentId and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId and (p.status=:activeStatus or p.status=:editStatus) ";
            hcb_last = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.agentId=:agentId and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId and (p.status=:activeStatus or p.status=:editStatus)  order by p.publishedAssessmentId DESC, a.submittedDate DESC");
                    q.setBoolean("forGrade", true);
                    q.setString("agentId", agentId);
                    q.setString("siteId", siteId);
                    q.setParameterList("groupIds", (Collection)groupIds);
                    q.setString("functionId", "TAKE_PUBLISHED_ASSESSMENT");
                    q.setInteger("activeStatus", 1);
                    q.setInteger("editStatus", 3);
                    return q.list();
                }
            };
            last_list = this.getHibernateTemplate().executeFind(hcb_last);
            hcb_highest = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.agentId=:agentId and (az.agentIdString=:siteId or az.agentIdString in (:groupIds))  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId and (p.status=:activeStatus or p.status=:editStatus)  order by p.publishedAssessmentId DESC, a.finalScore DESC, a.submittedDate DESC");
                    q.setBoolean("forGrade", true);
                    q.setString("agentId", agentId);
                    q.setString("siteId", siteId);
                    q.setParameterList("groupIds", (Collection)groupIds);
                    q.setString("functionId", "TAKE_PUBLISHED_ASSESSMENT");
                    q.setInteger("activeStatus", 1);
                    q.setInteger("editStatus", 3);
                    return q.list();
                }
            };
            highest_list = this.getHibernateTemplate().executeFind(hcb_highest);
        } else {
            hql = "select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.agentId=:agentId and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by p.publishedAssessmentId DESC, a.submittedDate DESC";
            hcb_last = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.agentId=:agentId and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by p.publishedAssessmentId DESC, a.submittedDate DESC order by p.publishedAssessmentId DESC, a.submittedDate DESC");
                    q.setBoolean("forGrade", true);
                    q.setString("agentId", agentId);
                    q.setString("siteId", siteId);
                    q.setString("functionId", "TAKE_PUBLISHED_ASSESSMENT");
                    return q.list();
                }
            };
            last_list = this.getHibernateTemplate().executeFind(hcb_last);
            hcb_highest = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.publishedAssessmentId, p.title, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore,a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed)  from AssessmentGradingData a, PublishedAssessmentData p, AuthorizationData az where a.publishedAssessmentId = p.publishedAssessmentId and a.forGrade=:forGrade and a.agentId=:agentId and az.agentIdString=:siteId  and az.functionId=:functionId and az.qualifierId=p.publishedAssessmentId order by p.publishedAssessmentId DESC, a.submittedDate DESC order by p.publishedAssessmentId DESC, a.finalScore DESC, a.submittedDate DESC");
                    q.setBoolean("forGrade", true);
                    q.setString("agentId", agentId);
                    q.setString("siteId", siteId);
                    q.setString("functionId", "TAKE_PUBLISHED_ASSESSMENT");
                    return q.list();
                }
            };
            highest_list = this.getHibernateTemplate().executeFind(hcb_highest);
        }
        String query = "select e.assessment.publishedAssessmentId, e.scoringType, ac.submissionsAllowed  from PublishedEvaluationModel e, PublishedAccessControl ac, AuthorizationData az where e.assessment.publishedAssessmentId = ac.assessment.publishedAssessmentId and az.qualifierId = ac.assessment.publishedAssessmentId and az.agentIdString=? and az.functionId=?";
        Object[] values = new Object[]{siteId, "TAKE_PUBLISHED_ASSESSMENT"};
        List l = this.getHibernateTemplate().find(query, values);
        HashMap<Object, Object> scoringTypeMap = new HashMap<Object, Object>();
        HashMap<Object, Object> subissionAllowedMap = new HashMap<Object, Object>();
        for (Object[] o : l) {
            scoringTypeMap.put(o[0], o[1]);
            subissionAllowedMap.put(o[0], o[2]);
        }
        ArrayList<AssessmentGradingFacade> assessmentList = new ArrayList<AssessmentGradingFacade>();
        Long currentid = new Long("0");
        Integer scoringOption = EvaluationModelIfc.LAST_SCORE;
        Integer submissionAllowed = null;
        boolean multiSubmissionAllowed = false;
        for (i = 0; i < last_list.size(); ++i) {
            a = (AssessmentGradingData)last_list.get(i);
            scoringOption = scoringTypeMap.get(a.getPublishedAssessmentId()) != null ? (Integer)scoringTypeMap.get(a.getPublishedAssessmentId()) : EvaluationModelIfc.LAST_SCORE;
            submissionAllowed = subissionAllowedMap.get(a.getPublishedAssessmentId()) != null ? (Integer)subissionAllowedMap.get(a.getPublishedAssessmentId()) : null;
            if (submissionAllowed != null && submissionAllowed == 1) {
                scoringOption = EvaluationModelIfc.LAST_SCORE;
            }
            if (!EvaluationModelIfc.LAST_SCORE.equals(scoringOption) || a.getPublishedAssessmentId().equals(currentid) && !allAssessments) continue;
            f = new AssessmentGradingFacade(a);
            if (!a.getPublishedAssessmentId().equals(currentid)) {
                f.setIsRecorded(true);
            }
            assessmentList.add(f);
            currentid = a.getPublishedAssessmentId();
        }
        for (i = 0; i < highest_list.size(); ++i) {
            a = (AssessmentGradingData)highest_list.get(i);
            scoringOption = scoringTypeMap.get(a.getPublishedAssessmentId()) != null ? (Integer)scoringTypeMap.get(a.getPublishedAssessmentId()) : EvaluationModelIfc.LAST_SCORE;
            submissionAllowed = subissionAllowedMap.get(a.getPublishedAssessmentId()) != null ? (Integer)subissionAllowedMap.get(a.getPublishedAssessmentId()) : null;
            multiSubmissionAllowed = submissionAllowed != null ? submissionAllowed > 1 : true;
            if (multiSubmissionAllowed && EvaluationModelIfc.HIGHEST_SCORE.equals(scoringOption) && (!a.getPublishedAssessmentId().equals(currentid) || allAssessments)) {
                f = new AssessmentGradingFacade(a);
                if (!a.getPublishedAssessmentId().equals(currentid)) {
                    f.setIsRecorded(true);
                }
                assessmentList.add(f);
                currentid = a.getPublishedAssessmentId();
            }
            if (!EvaluationModelIfc.AVERAGE_SCORE.equals(scoringOption)) continue;
            f = new AssessmentGradingFacade(a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    public PublishedAssessmentData getBasicInfoOfPublishedAssessment(final Long publishedId) {
        String query;
        final String hql = query = "select new PublishedAssessmentData(p.publishedAssessmentId, p.title,  c.releaseTo, c.startDate, c.dueDate, c.retractDate,  c.feedbackDate, f.feedbackDelivery, f.feedbackComponentOption, f.feedbackAuthoring, c.lateHandling,  c.unlimitedSubmissions, c.submissionsAllowed)  from PublishedAssessmentData as p, PublishedAccessControl as c, PublishedFeedback as f where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and p.publishedAssessmentId = f.assessment.publishedAssessmentId  and p.publishedAssessmentId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setLong(0, publishedId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        return (PublishedAssessmentData)list.get(0);
    }

    public String getPublishedAssessmentSiteId(String publishedAssessmentId) {
        String query = "select a from AuthorizationData a where a.functionId = ? and a.qualifierId = ? ";
        Object[] values = new Object[]{"TAKE_PUBLISHED_ASSESSMENT", publishedAssessmentId};
        List l = this.getHibernateTemplate().find(query, values);
        PublishedAssessmentData publishedAssessment = this.loadPublishedAssessment(Long.valueOf(publishedAssessmentId));
        boolean releaseToGroups = "Selected Groups".equals(publishedAssessment.getAssessmentAccessControl().getReleaseTo());
        for (int i = 0; i < l.size(); ++i) {
            AuthorizationData a = (AuthorizationData)l.get(i);
            if (releaseToGroups) {
                String agentId = a.getAgentIdString();
                if (SiteService.findGroup((String)agentId) == null) continue;
                if (SiteService.findGroup((String)agentId).getContainingSite() == null) continue;
                return SiteService.findGroup((String)a.getAgentIdString()).getContainingSite().getId();
            }
            return a.getAgentIdString();
        }
        return "";
    }

    public Integer getPublishedItemCount(Long publishedAssessmentId) {
        return this.getPublishedItemCountForNonRandomSections(publishedAssessmentId) + this.getPublishedItemCountForRandomSections(publishedAssessmentId);
    }

    public Integer getPublishedItemCountForRandomSections(final Long publishedAssessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select m.entry from PublishedSectionData s,  PublishedAssessmentData p, PublishedSectionMetaData m  where p.publishedAssessmentId=:publishedAssessmentId and m.label=:metaDataLabel and  p = s.assessment and m.section = s ");
                q.setLong("publishedAssessmentId", publishedAssessmentId.longValue());
                q.setString("metaDataLabel", "NUM_QUESTIONS_DRAWN");
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        int sum = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            sum += Integer.valueOf((String)list.get(i)).intValue();
        }
        return sum;
    }

    public Integer getPublishedItemCountForNonRandomSections(final Long publishedAssessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(i) from PublishedItemData i, PublishedSectionData s,  PublishedAssessmentData p, PublishedSectionMetaData m  where p.publishedAssessmentId=:publishedAssessmentId and m.label=:metaDataLabel and  p = s.assessment and i.section = s and m.section = s and m.entry=:metaDataEntry ");
                q.setLong("publishedAssessmentId", publishedAssessmentId.longValue());
                q.setString("metaDataLabel", "AUTHOR_TYPE");
                q.setString("metaDataEntry", SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        return (Integer)list.get(0);
    }

    public Integer getPublishedSectionCount(final Long publishedAssessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(s) from PublishedSectionData s,  PublishedAssessmentData p where p.publishedAssessmentId=? and  p = s.assessment");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        return (Integer)list.get(0);
    }

    public PublishedAttachmentData getPublishedAttachmentData(Long attachmentId) {
        String query = "select a from PublishedAttachmentData a where a.attachmentId = ?";
        List l = this.getHibernateTemplate().find(query, (Object)attachmentId);
        if (l.size() > 0) {
            PublishedAttachmentData a = (PublishedAttachmentData)l.get(0);
            return a;
        }
        return null;
    }

    public void updateAssessmentLastModifiedInfo(PublishedAssessmentFacade publishedAssessmentFacade) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        PublishedAssessmentIfc data = publishedAssessmentFacade.getData();
        data.setLastModifiedBy(AgentFacade.getAgentString());
        data.setLastModifiedDate(new Date());
        retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem update assessment: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public void saveOrUpdateSection(SectionFacade section) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)section.getData());
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem save or update section: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public void removeItemAttachment(Long itemAttachmentId) {
        PublishedItemAttachment itemAttachment = (PublishedItemAttachment)this.getHibernateTemplate().load(PublishedItemAttachment.class, (Serializable)itemAttachmentId);
        ItemDataIfc item = itemAttachment.getItem();
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item == null) continue;
                Set set = item.getItemAttachmentSet();
                set.remove(itemAttachment);
                this.getHibernateTemplate().delete((Object)itemAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem delete itemAttachment: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public PublishedSectionFacade addSection(Long publishedAssessmentId) {
        PublishedAssessmentData assessment = this.loadPublishedAssessment(publishedAssessmentId);
        HashSet sectionSet = this.getSectionSetForAssessment(publishedAssessmentId);
        assessment.setSectionSet((Set)sectionSet);
        PublishedSectionData section = new PublishedSectionData(null, Integer.valueOf(sectionSet.size() + 1), "", "", TypeD.DEFAULT_SECTION, SectionData.ACTIVE_STATUS, AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        section.setAssessment((AssessmentIfc)assessment);
        section.setAssessmentId(assessment.getAssessmentId());
        section.addSectionMetaData("AUTHOR_TYPE", SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString());
        section.addSectionMetaData("QUESTIONS_ORDERING", SectionDataIfc.AS_LISTED_ON_ASSESSMENT_PAGE.toString());
        sectionSet.add(section);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)section);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem save or update assessment: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        return new PublishedSectionFacade((SectionDataIfc)section);
    }

    public PublishedSectionFacade getSection(Long sectionId) {
        PublishedSectionData publishedSection = (PublishedSectionData)this.getHibernateTemplate().load(PublishedSectionData.class, (Serializable)sectionId);
        return new PublishedSectionFacade((SectionDataIfc)publishedSection);
    }

    public AssessmentAccessControlIfc loadPublishedAccessControl(Long publishedAssessmentId) {
        List list = this.getHibernateTemplate().find("select c from PublishedAssessmentData as p, PublishedAccessControl as c  where c.assessment.publishedAssessmentId=p.publishedAssessmentId  and p.publishedAssessmentId = ?", (Object)publishedAssessmentId);
        return (PublishedAccessControl)list.get(0);
    }

    public void saveOrUpdatePublishedAccessControl(AssessmentAccessControlIfc publishedAccessControl) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)publishedAccessControl);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem save or update publishedAccessControl data: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    private ArrayList getSiteGroupIdsForSubmittingAgent(String agentId, String siteId) {
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("none");
        if (siteId == null) {
            return groupIds;
        }
        Collection siteGroups = null;
        try {
            Site s = SiteService.getSite((String)siteId);
            if (s != null) {
                siteGroups = s.getGroupsWithMember(agentId);
            }
        }
        catch (IdUnusedException ex) {
            log.debug((Object)("No site found for siteid: " + siteId + "agentid: " + agentId));
        }
        if (siteGroups != null) {
            for (Group group : siteGroups) {
                groupIds.add(group.getId());
            }
        }
        return groupIds;
    }

    private ArrayList getSiteGroupIdsForCurrentUser(String siteId) {
        String currentUserId = UserDirectoryService.getCurrentUser().getId();
        return this.getSiteGroupIdsForSubmittingAgent(currentUserId, siteId);
    }

    private String getReleaseToGroupsAsString(TreeMap groupsForSite, Long assessmentId) {
        ArrayList releaseToGroups = new ArrayList();
        String releaseToGroupsAsString = null;
        AuthzQueriesFacadeAPI authz = PersistenceService.getInstance().getAuthzQueriesFacade();
        List authorizations = authz.getAuthorizationByFunctionAndQualifier("TAKE_PUBLISHED_ASSESSMENT", assessmentId.toString());
        if (authorizations != null && authorizations.size() > 0) {
            for (AuthorizationData ad : authorizations) {
                Object group = groupsForSite.get(ad.getAgentIdString());
                if (group == null) continue;
                releaseToGroups.add(group);
            }
            Collections.sort(releaseToGroups);
            StringBuilder releaseToGroupsAsStringbuf = new StringBuilder();
            if (releaseToGroups != null && releaseToGroups.size() != 0) {
                String lastGroup = (String)releaseToGroups.get(releaseToGroups.size() - 1);
                for (String group : releaseToGroups) {
                    releaseToGroupsAsStringbuf.append(group);
                    if (group.equals(lastGroup)) continue;
                    releaseToGroupsAsStringbuf.append(", ");
                }
            }
            releaseToGroupsAsString = releaseToGroupsAsStringbuf.toString();
        }
        return releaseToGroupsAsString;
    }

    private TreeMap getGroupsForSite(String siteId) {
        TreeMap<String, String> sortedGroups = new TreeMap<String, String>();
        Site site = null;
        try {
            site = SiteService.getSite((String)siteId);
            Collection groups = site.getGroups();
            if (groups != null && groups.size() > 0) {
                for (Group group : groups) {
                    sortedGroups.put(group.getId(), group.getTitle());
                }
            }
        }
        catch (IdUnusedException ex) {
            // empty catch block
        }
        return sortedGroups;
    }

    public TreeMap getGroupsForSite() {
        String siteId = ToolManager.getCurrentPlacement().getContext();
        return this.getGroupsForSite(siteId);
    }

    public List getReleaseToGroupIdsForPublishedAssessment(final String publishedAssessmentId) {
        String query = "select agentIdString from AuthorizationData az where az.functionId=:functionId and az.qualifierId=:publishedAssessmentId";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select agentIdString from AuthorizationData az where az.functionId=:functionId and az.qualifierId=:publishedAssessmentId");
                q.setString("publishedAssessmentId", publishedAssessmentId);
                q.setString("functionId", "TAKE_PUBLISHED_ASSESSMENT");
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public Integer getPublishedAssessmentStatus(Long publishedAssessmentId) {
        String query = "select p.status from PublishedAssessmentData p where p.publishedAssessmentId = ?";
        List l = this.getHibernateTemplate().find(query, (Object)publishedAssessmentId);
        if (l.size() > 0) {
            Integer status = (Integer)l.get(0);
            return status;
        }
        return 2;
    }

    public AssessmentAttachmentIfc createAssessmentAttachment(AssessmentIfc assessment, String resourceId, String filename, String protocol) {
        PublishedAssessmentAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new PublishedAssessmentAttachment();
                attach.setAssessment(assessment);
                attach.setResourceId(resourceId);
                attach.setFilename(filename);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(AssessmentAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            pe.printStackTrace();
        }
        catch (IdUnusedException ie) {
            ie.printStackTrace();
        }
        catch (TypeException te) {
            te.printStackTrace();
        }
        return attach;
    }

    private long fileSizeInKB(long fileSize) {
        return fileSize / 1024L;
    }

    public void removeAssessmentAttachment(Long assessmentAttachmentId) {
        PublishedAssessmentAttachment assessmentAttachment = (PublishedAssessmentAttachment)this.getHibernateTemplate().load(PublishedAssessmentAttachment.class, (Serializable)assessmentAttachmentId);
        AssessmentIfc assessment = assessmentAttachment.getAssessment();
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (assessment == null) continue;
                Set set = assessment.getAssessmentAttachmentSet();
                set.remove(assessmentAttachment);
                this.getHibernateTemplate().delete((Object)assessmentAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem delete publishedAssessmentAttachment: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public SectionAttachmentIfc createSectionAttachment(SectionDataIfc section, String resourceId, String filename, String protocol) {
        PublishedSectionAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new PublishedSectionAttachment();
                attach.setSection(section);
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(SectionAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            pe.printStackTrace();
        }
        catch (IdUnusedException ie) {
            ie.printStackTrace();
        }
        catch (TypeException te) {
            te.printStackTrace();
        }
        return attach;
    }

    public void removeSectionAttachment(Long sectionAttachmentId) {
        PublishedSectionAttachment sectionAttachment = (PublishedSectionAttachment)this.getHibernateTemplate().load(PublishedSectionAttachment.class, (Serializable)sectionAttachmentId);
        SectionDataIfc section = sectionAttachment.getSection();
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (section == null) continue;
                Set set = section.getSectionAttachmentSet();
                set.remove(sectionAttachment);
                this.getHibernateTemplate().delete((Object)sectionAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem delete sectionAttachment: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    public void saveOrUpdateAttachments(List list) {
        this.getHibernateTemplate().saveOrUpdateAll((Collection)list);
    }

    public PublishedAssessmentFacade getPublishedAssessmentInfoForRemove(Long publishedAssessmentId) {
        PublishedAssessmentData a = (PublishedAssessmentData)this.getHibernateTemplate().load(PublishedAssessmentData.class, (Serializable)publishedAssessmentId);
        PublishedAssessmentFacade f = new PublishedAssessmentFacade(a.getAssessmentId(), a.getTitle(), a.getCreatedBy());
        return f;
    }

    public HashMap getToGradebookPublishedAssessmentSiteIdMap() {
        String query = "select em.assessment.publishedAssessmentId, a.agentIdString from PublishedEvaluationModel em, AuthorizationData a where a.functionId = 'OWN_PUBLISHED_ASSESSMENT' and em.assessment.publishedAssessmentId = a.qualifierId and em.toGradeBook = ?";
        List l = this.getHibernateTemplate().find(query, (Object)"1");
        HashMap<Object, Object> toGradebookPublishedAssessmentSiteIdMap = new HashMap<Object, Object>();
        for (Object[] o : l) {
            toGradebookPublishedAssessmentSiteIdMap.put(o[0], o[1]);
        }
        return toGradebookPublishedAssessmentSiteIdMap;
    }

    class ItemComparator
    implements Comparator {
        ItemComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return ((PublishedItemData)arg0).getSequence().compareTo(((PublishedItemData)arg1).getSequence());
        }
    }

    class SecComparator
    implements Comparator {
        SecComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return ((PublishedSectionData)arg0).getSequence().compareTo(((PublishedSectionData)arg1).getSequence());
        }
    }
}

