/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.osid.assessment.AssessmentException;
import org.osid.shared.Id;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacadeQueries;
import org.sakaiproject.tool.assessment.facade.PublishedSectionFacade;
import org.sakaiproject.tool.assessment.osid.assessment.impl.ItemImpl;

public class PublishedItemFacade
extends ItemFacade
implements Serializable,
ItemDataIfc,
Comparable {
    private static final long serialVersionUID = -1711478342512505707L;
    private PublishedSectionFacade section;

    public PublishedItemFacade() {
        this.data = new PublishedItemData();
        ItemImpl itemImpl = new ItemImpl();
        this.item = itemImpl;
        try {
            this.item.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public PublishedItemFacade(ItemDataIfc data) {
        this.data = data;
        ItemImpl itemImpl = new ItemImpl();
        this.item = itemImpl;
        try {
            this.item.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.id = this.getId();
        this.description = this.getDescription();
        this.itemType = this.getItemType();
        this.itemTextSet = this.getItemTextSet();
        this.itemMetaDataSet = this.getItemMetaDataSet();
        this.itemMetaDataMap = this.getItemMetaDataMap(this.itemMetaDataSet);
        this.itemFeedbackSet = this.getItemFeedbackSet();
        this.itemFeedbackMap = this.getItemFeedbackMap(this.itemFeedbackSet);
        this.hasRationale = data.getHasRationale();
        this.itemAttachmentSet = this.getItemAttachmentSet();
    }

    Id getId() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        PublishedItemFacadeQueries publishedItemFacadeQueries = new PublishedItemFacadeQueries();
        return publishedItemFacadeQueries.getItemId(this.data.getItemId());
    }

    public void setItemIdString(String itemIdString) {
        this.itemIdString = itemIdString;
        this.data.setItemIdString(itemIdString);
    }

    public SectionDataIfc getSection() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        if (this.data.getSection() != null) {
            return new PublishedSectionFacade(this.data.getSection());
        }
        return null;
    }

    public void setSection(SectionDataIfc section) {
        this.section = (PublishedSectionFacade)section;
        if (this.section != null) {
            this.data.setSection(this.section.getData());
        } else {
            this.data.setSection(null);
        }
    }

    public void addItemText(String text, Set answerSet) {
        if (this.data.getItemTextSet() == null) {
            this.data.setItemTextSet(new HashSet());
        }
        Long sequence = this.data.getItemTextSet().size() + 1;
        PublishedItemText itemText = new PublishedItemText((PublishedItemData)this.data, sequence, text, answerSet);
        this.data.getItemTextSet().add(itemText);
        this.itemTextSet = this.data.getItemTextSet();
    }

    public void addItemMetaData(String label, String entry) {
        if (this.itemMetaDataSet == null) {
            this.setItemMetaDataSet(new HashSet());
            this.itemMetaDataMap = new HashMap();
        }
        this.itemMetaDataMap.put(label, entry);
        this.data.getItemMetaDataSet().add(new PublishedItemMetaData((ItemDataIfc)((PublishedItemData)this.data), label, entry));
        this.itemMetaDataSet = this.data.getItemMetaDataSet();
    }

    public void addItemFeedback(String feedbackTypeId, String text) {
        if (this.itemFeedbackSet == null) {
            this.setItemFeedbackSet(new HashSet());
            this.itemFeedbackMap = new HashMap();
        }
        this.itemFeedbackMap.put(feedbackTypeId, text);
        this.data.getItemFeedbackSet().add(new PublishedItemFeedback((PublishedItemData)this.data, feedbackTypeId, text));
        this.itemFeedbackSet = this.data.getItemFeedbackSet();
    }
}

