/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class PublishedItemFacadeQueries
extends HibernateDaoSupport
implements PublishedItemFacadeQueriesAPI {
    private static Log log = LogFactory.getLog(PublishedItemFacadeQueries.class);

    public IdImpl getItemId(String id) {
        return new IdImpl(id);
    }

    public IdImpl getItemId(Long id) {
        return new IdImpl(id);
    }

    public IdImpl getItemId(long id) {
        return new IdImpl(id);
    }

    public PublishedItemFacade getItem(Long itemId, String agent) {
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)itemId);
        return new PublishedItemFacade((ItemDataIfc)item);
    }

    public PublishedItemFacade getItem(String itemId) {
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)Long.valueOf(itemId));
        return new PublishedItemFacade((ItemDataIfc)item);
    }

    public void deleteItemContent(Long itemId, String agent) {
        Set set;
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)itemId);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemTextSet();
                    item.setItemTextSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleteItemTextSet: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemMetaDataSet();
                    item.setItemMetaDataSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleteItemMetaDataSet: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemFeedbackSet();
                    item.setItemFeedbackSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleting ItemFeedbackSet: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }
}

