/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osid.assessment.AssessmentException;
import org.osid.shared.Id;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionMetaDataIfc;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedSectionFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;

public class PublishedSectionFacade
extends SectionFacade
implements Serializable,
Comparable {
    private static final long serialVersionUID = 5788637014806801101L;
    private static Log log = LogFactory.getLog(PublishedSectionFacade.class);

    public PublishedSectionFacade(SectionDataIfc data) {
        super(data);
    }

    Id getId() {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        PublishedSectionFacadeQueriesAPI publishedSectionFacadeQueries = PersistenceService.getInstance().getPublishedSectionFacadeQueries();
        return publishedSectionFacadeQueries.getId(this.data.getSectionId());
    }

    public void addSectionMetaData(String label, String entry) {
        if (this.metaDataSet == null) {
            this.setSectionMetaDataSet(new HashSet());
            this.metaDataMap = new HashMap();
        }
        if (this.metaDataMap.get(label) != null) {
            for (SectionMetaDataIfc metadata : this.metaDataSet) {
                if (!metadata.getLabel().equals(label)) continue;
                metadata.setEntry(entry);
            }
        } else {
            this.metaDataMap.put(label, entry);
            this.data.getSectionMetaDataSet().add(new PublishedSectionMetaData(this.data, label, entry));
            this.metaDataSet = this.data.getSectionMetaDataSet();
        }
    }

    public Set getItemFacadeSet() throws DataFacadeException {
        this.itemFacadeSet = new HashSet();
        try {
            this.data = (SectionDataIfc)this.section.getData();
            Set set = this.data.getItemSet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                PublishedItemFacade publishedItemFacade = new PublishedItemFacade((ItemDataIfc)iter.next());
                this.itemFacadeSet.add(publishedItemFacade);
            }
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.itemFacadeSet;
    }

    public AssessmentIfc getAssessment() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return new PublishedAssessmentFacade(this.data.getAssessment());
    }

    public void setAssessment(AssessmentIfc assessment) {
        this.assessment = (PublishedAssessmentFacade)assessment;
        PublishedAssessmentData d = (PublishedAssessmentData)((PublishedAssessmentFacade)this.assessment).getData();
        this.data.setAssessment((AssessmentIfc)d);
    }
}

