/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.authz;

import java.util.Date;
import org.osid.authorization.Function;
import org.osid.authorization.Qualifier;
import org.osid.shared.Id;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.ifc.authz.AuthorizationIfc;

public class AuthorizationFacade
implements AuthorizationIfc {
    private static final long serialVersionUID = -262696599577971352L;
    private Id agentId;
    private Function function;
    private Qualifier qualifier;
    private long effectiveDate;
    private long expirationDate;
    private Id modifiedBy;
    private long modifiedDate;
    private boolean isExplicit;
    private boolean isActiveNow;
    private AuthorizationIfc data;
    private String functionId;
    private String qualifierId;
    private Date authorizationEffectiveDate;
    private Date authorizationExpirationDate;
    private String agentIdString;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private Boolean isExplicitBoolean;
    private Boolean isActiveNowBoolean;

    public AuthorizationFacade() {
        this.data = new AuthorizationData();
    }

    public AuthorizationFacade(String agentIdString, String functionId, String qualifierId, Date authorizationEffectiveDate, Date authorizationExpirationDate, String lastModifiedBy, Date lastModifiedDate, Boolean isExplicitBoolean) {
        this.data = new AuthorizationData();
        this.setAgentIdString(agentIdString);
        this.setFunctionId(functionId);
        this.setQualifierId(qualifierId);
        this.setAuthorizationEffectiveDate(authorizationEffectiveDate);
        this.setAuthorizationExpirationDate(authorizationExpirationDate);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDate(lastModifiedDate);
        this.setIsExplicitBoolean(isExplicitBoolean);
    }

    public AuthorizationFacade(AuthorizationIfc data) {
        this.data = data;
        this.agentIdString = data.getAgentIdString();
        this.functionId = data.getFunctionId();
        this.qualifierId = data.getQualifierId();
        this.authorizationEffectiveDate = data.getAuthorizationEffectiveDate();
        this.authorizationExpirationDate = data.getAuthorizationExpirationDate();
        this.lastModifiedBy = data.getLastModifiedBy();
        this.lastModifiedDate = data.getLastModifiedDate();
        this.isExplicitBoolean = data.getIsExplicitBoolean();
    }

    public Id getAgentId() {
        return null;
    }

    public String getAgentIdString() {
        return this.data.getAgentIdString();
    }

    public void setAgentIdString(String id) {
        this.agentIdString = id;
        this.data.setAgentIdString(id);
    }

    public Function getFunction() {
        return null;
    }

    public Qualifier getQualifier() {
        return null;
    }

    public long getEffectiveDate() {
        Date d = this.data.getAuthorizationEffectiveDate();
        if (d != null) {
            return d.getTime();
        }
        return 0L;
    }

    public long getExpirationDate() {
        Date d = this.data.getAuthorizationExpirationDate();
        if (d != null) {
            return d.getTime();
        }
        return 0L;
    }

    public Id getModifiedBy() {
        return null;
    }

    public long getModifiedDate() {
        Date d = this.data.getLastModifiedDate();
        if (d != null) {
            return d.getTime();
        }
        return 0L;
    }

    public void updateExpirationDate(long expirationDate) {
        this.expirationDate = expirationDate;
        this.setAuthorizationExpirationDate(new Date(expirationDate));
    }

    public void updateEffectiveDate(long effectiveDate) {
        this.effectiveDate = effectiveDate;
        this.setAuthorizationEffectiveDate(new Date(effectiveDate));
    }

    public boolean getIsExplicit() {
        return this.data.getIsExplicitBoolean();
    }

    public void setIsExplicit(boolean type) {
        this.isExplicit = type;
        this.data.setIsExplicitBoolean(Boolean.valueOf(type));
    }

    public boolean isActiveNow() {
        int effectiveVal = this.getEffectiveDate() == 0L ? 0 : 1;
        int expirationVal = this.getExpirationDate() == 0L ? 0 : 2;
        long nowMillis = new Date().getTime();
        boolean returnVal = false;
        switch (effectiveVal + expirationVal) {
            case 0: {
                returnVal = true;
                break;
            }
            case 1: {
                if (nowMillis > this.getEffectiveDate()) {
                    returnVal = true;
                    break;
                }
                returnVal = false;
                break;
            }
            case 2: {
                if (nowMillis < this.getExpirationDate()) {
                    returnVal = true;
                    break;
                }
                returnVal = false;
                break;
            }
            case 3: {
                returnVal = nowMillis > this.getEffectiveDate() && nowMillis < this.getExpirationDate();
            }
        }
        return returnVal;
    }

    public AuthorizationIfc getData() {
        return this.data;
    }

    public void setAgentId(String id) {
    }

    public String getFunctionId() {
        return this.data.getFunctionId();
    }

    public void setFunctionId(String id) {
        this.functionId = id;
        this.data.setFunctionId(id);
    }

    public String getQualifierId() {
        return this.data.getQualifierId();
    }

    public void setQualifierId(String id) {
        this.qualifierId = id;
        this.data.setQualifierId(id);
    }

    public void setAuthorizationEffectiveDate(Date cal) {
        this.authorizationEffectiveDate = cal;
        this.data.setAuthorizationEffectiveDate(cal);
        if (cal != null) {
            this.effectiveDate = cal.getTime();
        }
    }

    public void setAuthorizationExpirationDate(Date cal) {
        this.authorizationExpirationDate = cal;
        this.data.setAuthorizationExpirationDate(cal);
        if (cal != null) {
            this.expirationDate = cal.getTime();
        }
    }

    public String getLastModifiedBy() {
        return this.data.getLastModifiedBy();
    }

    public void setLastModifiedBy(String id) {
        this.lastModifiedBy = id;
        this.data.setLastModifiedBy(id);
    }

    public Date getLastModifiedDate() {
        return this.data.getLastModifiedDate();
    }

    public void setLastModifiedDate(Date cal) {
        this.lastModifiedDate = cal;
        this.data.setLastModifiedDate(cal);
    }

    public Boolean getIsExplicitBoolean() {
        return this.data.getIsExplicitBoolean();
    }

    public void setIsExplicitBoolean(Boolean type) {
        this.isExplicitBoolean = type;
        this.data.setIsExplicitBoolean(type);
    }

    public void setIsActiveNowBoolean(Boolean isActiveNowBoolean) {
    }

    public Boolean getIsActiveNowBoolean() {
        return this.data.getIsActiveNowBoolean();
    }

    public Date getAuthorizationEffectiveDate() {
        return this.data.getAuthorizationEffectiveDate();
    }

    public Date getAuthorizationExpirationDate() {
        return this.data.getAuthorizationExpirationDate();
    }
}

