/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.complex.ComplexFormat;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.AssessmentGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.ItemGradingIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.StudentGradingSummaryIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.FinFormatException;
import org.sakaiproject.tool.assessment.services.GradebookServiceException;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.util.TextFormat;

public class GradingService {
    private static Log log = LogFactory.getLog(GradingService.class);

    public ArrayList getTotalScores(String publishedId, String which) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getTotalScores(publishedId, which));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public ArrayList getTotalScores(String publishedId, String which, boolean getSubmittedOnly) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getTotalScores(publishedId, which, getSubmittedOnly));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public List getAllSubmissions(String publishedId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAllSubmissions(publishedId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public List getAllAssessmentGradingData(Long publishedId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAllAssessmentGradingData(publishedId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public ArrayList getHighestAssessmentGradingList(Long publishedId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestAssessmentGradingList(publishedId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public List getHighestSubmittedOrGradedAssessmentGradingList(Long publishedId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestSubmittedOrGradedAssessmentGradingList(publishedId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public ArrayList getLastAssessmentGradingList(Long publishedId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastAssessmentGradingList(publishedId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public List getLastSubmittedAssessmentGradingList(Long publishedId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSubmittedAssessmentGradingList(publishedId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public List getLastSubmittedOrGradedAssessmentGradingList(Long publishedId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSubmittedOrGradedAssessmentGradingList(publishedId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public void saveTotalScores(ArrayList gdataList, PublishedAssessmentIfc pub) {
        try {
            AssessmentGradingData gdata = null;
            if (gdataList.size() <= 0) {
                return;
            }
            gdata = (AssessmentGradingData)gdataList.get(0);
            Integer scoringType = this.getScoringType(pub);
            ArrayList oldList = this.getAssessmentGradingsByScoringType(scoringType, gdata.getPublishedAssessmentId());
            for (int i = 0; i < gdataList.size(); ++i) {
                AssessmentGradingData ag = (AssessmentGradingData)gdataList.get(i);
                this.saveOrUpdateAssessmentGrading((AssessmentGradingIfc)ag);
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.total.score.update", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", gradedBy=" + AgentFacade.getAgentString() + ", assessmentGradingId=" + ag.getAssessmentGradingId() + ", totalAutoScore=" + ag.getTotalAutoScore() + ", totalOverrideScore=" + ag.getTotalOverrideScore() + ", FinalScore=" + ag.getFinalScore() + ", comments=" + ag.getComments()), (boolean)true));
            }
            ArrayList newList = this.getAssessmentGradingsByScoringType(scoringType, gdata.getPublishedAssessmentId());
            ArrayList l = this.getListForGradebookNotification(newList, oldList);
            this.notifyGradebook(l, pub);
        }
        catch (GradebookServiceException ge) {
            log.error((Object)("GradebookServiceException" + ge));
            throw ge;
        }
    }

    private ArrayList getListForGradebookNotification(ArrayList newList, ArrayList oldList) {
        int i;
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        HashMap<Long, AssessmentGradingData> h = new HashMap<Long, AssessmentGradingData>();
        for (i = 0; i < oldList.size(); ++i) {
            AssessmentGradingData ag = (AssessmentGradingData)oldList.get(i);
            h.put(ag.getAssessmentGradingId(), ag);
        }
        for (i = 0; i < newList.size(); ++i) {
            AssessmentGradingData a = (AssessmentGradingData)newList.get(i);
            Object o = h.get(a.getAssessmentGradingId());
            if (o == null) {
                l.add(a);
                continue;
            }
            AssessmentGradingData b = (AssessmentGradingData)o;
            if (a.getFinalScore() == null || b.getFinalScore() == null || a.getFinalScore().equals(b.getFinalScore())) continue;
            l.add(a);
        }
        return l;
    }

    public ArrayList getAssessmentGradingsByScoringType(Integer scoringType, Long publishedAssessmentId) {
        List l = null;
        l = scoringType.equals(EvaluationModelIfc.HIGHEST_SCORE) ? this.getHighestSubmittedOrGradedAssessmentGradingList(publishedAssessmentId) : (scoringType.equals(EvaluationModelIfc.LAST_SCORE) ? this.getLastSubmittedOrGradedAssessmentGradingList(publishedAssessmentId) : this.getTotalScores(publishedAssessmentId.toString(), "3", false));
        return new ArrayList(l);
    }

    public Integer getScoringType(PublishedAssessmentIfc pub) {
        Integer scoringType = null;
        EvaluationModelIfc e = pub.getEvaluationModel();
        if (e != null) {
            scoringType = e.getScoringType();
        }
        return scoringType;
    }

    private boolean updateGradebook(AssessmentGradingIfc data, PublishedAssessmentIfc pub) {
        boolean forGrade = Boolean.TRUE.equals(data.getForGrade());
        boolean toGradebook = false;
        EvaluationModelIfc e = pub.getEvaluationModel();
        if (e != null) {
            String toGradebookString = e.getToGradeBook();
            toGradebook = toGradebookString.equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString());
        }
        return forGrade && toGradebook;
    }

    private void notifyGradebook(ArrayList l, PublishedAssessmentIfc pub) {
        for (int i = 0; i < l.size(); ++i) {
            this.notifyGradebook((AssessmentGradingIfc)((AssessmentGradingData)l.get(i)), pub);
        }
    }

    public HashMap getItemScores(Long publishedId, Long itemId, String which) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemScores(publishedId, itemId, which);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    public HashMap getItemScores(Long itemId, List scores) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemScores(itemId, scores);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    public HashMap getLastItemGradingData(String publishedId, String agentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastItemGradingData(Long.valueOf(publishedId), agentId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    public HashMap getStudentGradingData(String assessmentGradingId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getStudentGradingData(assessmentGradingId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    public HashMap getSubmitData(String publishedId, String agentId, Integer scoringoption, String assessmentGradingId) {
        try {
            Long gradingId = null;
            if (assessmentGradingId != null) {
                gradingId = Long.valueOf(assessmentGradingId);
            }
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSubmitData(Long.valueOf(publishedId), agentId, scoringoption, gradingId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    public String getTextForId(Long typeId) {
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        TypeFacade type = typeFacadeQueries.getTypeFacadeById(typeId);
        return type.getKeyword();
    }

    public int getSubmissionSizeOfPublishedAssessment(String publishedAssessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSubmissionSizeOfPublishedAssessment(Long.valueOf(publishedAssessmentId));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public Long saveMedia(byte[] media, String mimeType) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveMedia(media, mimeType);
    }

    public Long saveMedia(MediaData mediaData) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveMedia(mediaData);
    }

    public MediaData getMedia(String mediaId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMedia(Long.valueOf(mediaId));
    }

    public ArrayList getMediaArray(String itemGradingId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaArray(Long.valueOf(itemGradingId));
    }

    public ArrayList getMediaArray2(String itemGradingId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaArray2(Long.valueOf(itemGradingId));
    }

    public ArrayList getMediaArray(ItemGradingData i) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaArray(i);
    }

    public HashMap getMediaItemGradingHash(Long assessmentGradingId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaItemGradingHash(assessmentGradingId);
    }

    public List getMediaArray(String publishedId, String publishItemId, String which) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaArray(Long.valueOf(publishedId), Long.valueOf(publishItemId), which);
    }

    public ItemGradingData getLastItemGradingDataByAgent(String publishedItemId, String agentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastItemGradingDataByAgent(Long.valueOf(publishedItemId), agentId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemGradingData getItemGradingData(String assessmentGradingId, String publishedItemId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemGradingData(Long.valueOf(assessmentGradingId), Long.valueOf(publishedItemId));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AssessmentGradingData load(String assessmentGradingId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().load(Long.valueOf(assessmentGradingId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public ItemGradingData getItemGrading(String itemGradingId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemGrading(Long.valueOf(itemGradingId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Error(e);
        }
    }

    public AssessmentGradingIfc getLastAssessmentGradingByAgentId(String publishedAssessmentId, String agentIdString) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastAssessmentGradingByAgentId(Long.valueOf(publishedAssessmentId), agentIdString);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentGradingData getLastSavedAssessmentGradingByAgentId(String publishedAssessmentId, String agentIdString) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSavedAssessmentGradingByAgentId(Long.valueOf(publishedAssessmentId), agentIdString);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentGradingData getLastSubmittedAssessmentGradingByAgentId(String publishedAssessmentId, String agentIdString, String assessmentGradingId) {
        AssessmentGradingData assessmentGranding = null;
        try {
            assessmentGranding = assessmentGradingId != null ? PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSubmittedAssessmentGradingByAgentId(Long.valueOf(publishedAssessmentId), agentIdString, Long.valueOf(assessmentGradingId)) : PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSubmittedAssessmentGradingByAgentId(Long.valueOf(publishedAssessmentId), agentIdString, null);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return assessmentGranding;
    }

    public void saveItemGrading(ItemGradingIfc item) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveItemGrading(item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveOrUpdateAssessmentGrading(AssessmentGradingIfc assessment) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveOrUpdateAssessmentGrading(assessment);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateAssessmentGradingOnly(AssessmentGradingIfc assessment) {
        Set origItemGradingSet = assessment.getItemGradingSet();
        HashSet h = new HashSet(origItemGradingSet);
        origItemGradingSet.clear();
        int size = assessment.getItemGradingSet().size();
        log.debug((Object)("before persist to db: size = " + size));
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveOrUpdateAssessmentGrading(assessment);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            assessment.setItemGradingSet(h);
            size = assessment.getItemGradingSet().size();
            log.debug((Object)("after persist to db: size = " + size));
        }
    }

    public List getAssessmentGradingIds(String publishedItemId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAssessmentGradingIds(Long.valueOf(publishedItemId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentGradingIfc getHighestAssessmentGrading(String publishedAssessmentId, String agentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestAssessmentGrading(Long.valueOf(publishedAssessmentId), agentId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentGradingIfc getHighestSubmittedAssessmentGrading(String publishedAssessmentId, String agentId, String assessmentGradingId) {
        AssessmentGradingIfc assessmentGrading = null;
        try {
            assessmentGrading = assessmentGradingId != null ? PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestSubmittedAssessmentGrading(Long.valueOf(publishedAssessmentId), agentId, Long.valueOf(assessmentGradingId)) : PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestSubmittedAssessmentGrading(Long.valueOf(publishedAssessmentId), agentId, null);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return assessmentGrading;
    }

    public AssessmentGradingIfc getHighestSubmittedAssessmentGrading(String publishedAssessmentId, String agentId) {
        return this.getHighestSubmittedAssessmentGrading(publishedAssessmentId, agentId, null);
    }

    public Set getItemGradingSet(String assessmentGradingId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemGradingSet(Long.valueOf(assessmentGradingId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public HashMap getAssessmentGradingByItemGradingId(String publishedAssessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAssessmentGradingByItemGradingId(Long.valueOf(publishedAssessmentId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void updateItemScore(ItemGradingData gdata, float scoreDifference, PublishedAssessmentIfc pub) {
        try {
            AssessmentGradingData adata = this.load(gdata.getAssessmentGradingId().toString());
            adata.setItemGradingSet(this.getItemGradingSet(adata.getAssessmentGradingId().toString()));
            Set itemGradingSet = adata.getItemGradingSet();
            Iterator iter = itemGradingSet.iterator();
            float totalAutoScore = 0.0f;
            float totalOverrideScore = adata.getTotalOverrideScore().floatValue();
            while (iter.hasNext()) {
                ItemGradingIfc i = (ItemGradingIfc)iter.next();
                if (i.getItemGradingId().equals(gdata.getItemGradingId())) {
                    i.setAutoScore(gdata.getAutoScore());
                    i.setComments(gdata.getComments());
                    i.setGradedBy(AgentFacade.getAgentString());
                    i.setGradedDate(new Date());
                }
                if (i.getAutoScore() == null) continue;
                totalAutoScore += i.getAutoScore().floatValue();
            }
            adata.setTotalAutoScore(Float.valueOf(totalAutoScore));
            if (Float.compare(totalAutoScore + totalOverrideScore, Float.valueOf("0").floatValue()) < 0) {
                adata.setFinalScore(Float.valueOf("0"));
            } else {
                adata.setFinalScore(Float.valueOf(totalAutoScore + totalOverrideScore));
            }
            this.saveOrUpdateAssessmentGrading((AssessmentGradingIfc)adata);
            if (scoreDifference != 0.0f) {
                this.notifyGradebookByScoringType((AssessmentGradingIfc)adata, pub);
            }
        }
        catch (GradebookServiceException ge) {
            ge.printStackTrace();
            throw ge;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void storeGrades(AssessmentGradingIfc data, PublishedAssessmentIfc pub, HashMap publishedItemHash, HashMap publishedItemTextHash, HashMap publishedAnswerHash, HashMap invalidFINMap, ArrayList invalidSALengthList) throws GradebookServiceException, FinFormatException {
        log.debug((Object)("storeGrades: data.getSubmittedDate()" + data.getSubmittedDate()));
        this.storeGrades(data, false, pub, publishedItemHash, publishedItemTextHash, publishedAnswerHash, true, invalidFINMap, invalidSALengthList);
    }

    public void storeGrades(AssessmentGradingIfc data, PublishedAssessmentIfc pub, HashMap publishedItemHash, HashMap publishedItemTextHash, HashMap publishedAnswerHash, boolean persistToDB, HashMap invalidFINMap, ArrayList invalidSALengthList) throws GradebookServiceException, FinFormatException {
        log.debug((Object)("storeGrades (not persistToDB) : data.getSubmittedDate()" + data.getSubmittedDate()));
        this.storeGrades(data, false, pub, publishedItemHash, publishedItemTextHash, publishedAnswerHash, persistToDB, invalidFINMap, invalidSALengthList);
    }

    public void storeGrades(AssessmentGradingIfc data, boolean regrade, PublishedAssessmentIfc pub, HashMap publishedItemHash, HashMap publishedItemTextHash, HashMap publishedAnswerHash, boolean persistToDB) throws GradebookServiceException, FinFormatException {
        log.debug((Object)("storeGrades (not persistToDB) : data.getSubmittedDate()" + data.getSubmittedDate()));
        this.storeGrades(data, regrade, pub, publishedItemHash, publishedItemTextHash, publishedAnswerHash, persistToDB, null, null);
    }

    public void storeGrades(AssessmentGradingIfc data, boolean regrade, PublishedAssessmentIfc pub, HashMap publishedItemHash, HashMap publishedItemTextHash, HashMap publishedAnswerHash, boolean persistToDB, HashMap invalidFINMap, ArrayList invalidSALengthList) throws GradebookServiceException, FinFormatException {
        log.debug((Object)("****x1. regrade =" + regrade + " " + new Date().getTime()));
        try {
            ItemDataIfc item;
            Long itemId;
            String agent = data.getAgentId();
            HashSet itemGradingSet = data.getItemGradingSet();
            if (itemGradingSet == null) {
                itemGradingSet = new HashSet();
            }
            log.debug((Object)("****itemGrading size=" + itemGradingSet.size()));
            Iterator iter = itemGradingSet.iterator();
            HashMap fibAnswersMap = new HashMap();
            HashMap<Long, Float> totalItems = new HashMap<Long, Float>();
            log.debug((Object)("****x2. " + new Date().getTime()));
            float autoScore = 0.0f;
            while (iter.hasNext()) {
                Long itemType;
                ItemGradingIfc itemGrading;
                block22: {
                    String processedAnswerText;
                    itemGrading = (ItemGradingIfc)iter.next();
                    itemId = itemGrading.getPublishedItemId();
                    item = (ItemDataIfc)publishedItemHash.get(itemId);
                    if (item == null) {
                        log.error((Object)("unable to retrive itemDataIfc for: " + publishedItemHash.get(itemId)));
                        continue;
                    }
                    itemType = item.getTypeId();
                    autoScore = 0.0f;
                    itemGrading.setAssessmentGradingId(data.getAssessmentGradingId());
                    itemGrading.setAgentId(agent);
                    itemGrading.setOverrideScore(Float.valueOf(0.0f));
                    if (itemType == 5L && itemGrading.getAnswerText() != null && (processedAnswerText = itemGrading.getAnswerText().replaceAll("\r", "").replaceAll("\n", "")).length() > 60000 && invalidSALengthList != null) {
                        invalidSALengthList.add(item.getItemId());
                    }
                    if (itemType == 8L && itemGrading.getAnswerText() != null) {
                        processedAnswerText = TextFormat.convertPlaintextToFormattedTextNoHighUnicode(log, itemGrading.getAnswerText().trim());
                        itemGrading.setAnswerText(processedAnswerText);
                    }
                    try {
                        autoScore = this.getScoreByQuestionType(itemGrading, item, itemType, publishedItemTextHash, totalItems, fibAnswersMap, publishedAnswerHash, regrade);
                    }
                    catch (FinFormatException e) {
                        ArrayList list;
                        autoScore = 0.0f;
                        if (invalidFINMap == null) break block22;
                        if (invalidFINMap.containsKey(itemId)) {
                            list = (ArrayList)invalidFINMap.get(itemId);
                            list.add(itemGrading.getItemGradingId());
                        }
                        list = new ArrayList();
                        list.add(itemGrading.getItemGradingId());
                        invalidFINMap.put(itemId, list);
                    }
                }
                log.debug((Object)("**!regrade, autoScore=" + autoScore));
                if (!TypeIfc.MULTIPLE_CORRECT.equals(itemType)) {
                    totalItems.put(itemId, Float.valueOf(autoScore));
                }
                if (regrade && TypeIfc.AUDIO_RECORDING.equals(itemType)) {
                    itemGrading.setAttemptsRemaining(item.getTriesAllowed());
                }
                itemGrading.setAutoScore(Float.valueOf(autoScore));
            }
            if (invalidFINMap != null && invalidFINMap.size() > 0 || invalidSALengthList != null && invalidSALengthList.size() > 0) {
                return;
            }
            if (!regrade && persistToDB) {
                data.setSubmittedDate(new Date());
                this.setIsLate(data, pub);
            }
            log.debug((Object)("****x3. " + new Date().getTime()));
            for (ItemGradingIfc itemGrading : itemGradingSet) {
                itemId = itemGrading.getPublishedItemId();
                item = (ItemDataIfc)publishedItemHash.get(itemId);
                Long itemType2 = item.getTypeId();
                float eachItemScore = ((Float)totalItems.get(itemId)).floatValue();
                if (!(eachItemScore < 0.0f) || TypeIfc.MULTIPLE_CHOICE.equals(itemType2) || TypeIfc.TRUE_FALSE.equals(itemType2)) continue;
                itemGrading.setAutoScore(Float.valueOf(0.0f));
            }
            log.debug((Object)("****x4. " + new Date().getTime()));
            if (persistToDB) {
                this.saveOrUpdateAll(itemGradingSet);
            }
            log.debug((Object)("****x5. " + new Date().getTime()));
            Set fullItemGradingSet = this.getItemGradingSet(data.getAssessmentGradingId().toString());
            float totalAutoScore = this.getTotalAutoScore(fullItemGradingSet);
            data.setTotalAutoScore(Float.valueOf(totalAutoScore));
            if (Float.compare(totalAutoScore + data.getTotalOverrideScore().floatValue(), new Float("0").floatValue()) < 0) {
                data.setFinalScore(Float.valueOf("0"));
            } else {
                data.setFinalScore(Float.valueOf(totalAutoScore + data.getTotalOverrideScore().floatValue()));
            }
            log.debug((Object)("****x6. " + new Date().getTime()));
        }
        catch (GradebookServiceException ge) {
            ge.printStackTrace();
            throw ge;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (persistToDB) {
            data.setItemGradingSet(new HashSet());
            this.saveOrUpdateAssessmentGrading(data);
            log.debug((Object)("****x7. " + new Date().getTime()));
            if (!regrade) {
                this.notifyGradebookByScoringType(data, pub);
            }
        }
        log.debug((Object)("****x8. " + new Date().getTime()));
        if (!regrade && Boolean.TRUE.equals(data.getForGrade())) {
            this.removeUnsubmittedAssessmentGradingData(data);
        }
    }

    private float getTotalAutoScore(Set itemGradingSet) {
        float totalAutoScore = 0.0f;
        for (ItemGradingIfc i : itemGradingSet) {
            if (i.getAutoScore() == null) continue;
            totalAutoScore += i.getAutoScore().floatValue();
        }
        return totalAutoScore;
    }

    private void notifyGradebookByScoringType(AssessmentGradingIfc data, PublishedAssessmentIfc pub) {
        Integer scoringType = pub.getEvaluationModel().getScoringType();
        if (this.updateGradebook(data, pub)) {
            AssessmentGradingIfc d = data;
            if (scoringType.equals(EvaluationModelIfc.HIGHEST_SCORE)) {
                d = this.getHighestSubmittedAssessmentGrading(pub.getPublishedAssessmentId().toString(), data.getAgentId());
            }
            this.notifyGradebook(d, pub);
        }
    }

    private float getScoreByQuestionType(ItemGradingIfc itemGrading, ItemDataIfc item, Long itemType, HashMap publishedItemTextHash, HashMap totalItems, HashMap fibAnswersMap, HashMap publishedAnswerHash, boolean regrade) throws FinFormatException {
        float initScore = 0.0f;
        float autoScore = 0.0f;
        float accumelateScore = 0.0f;
        Long itemId = item.getItemId();
        int type = itemType.intValue();
        switch (type) {
            case 1: {
                autoScore = item.getPartialCreditFlag() != false ? this.getAnswerScoreMCQ(itemGrading, publishedAnswerHash) : this.getAnswerScore(itemGrading, publishedAnswerHash);
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().floatValue();
                }
                totalItems.put(itemId, new Float(autoScore));
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                autoScore = this.getAnswerScore(itemGrading, publishedAnswerHash);
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().floatValue();
                }
                totalItems.put(itemId, Float.valueOf(autoScore));
                break;
            }
            case 2: {
                ItemTextIfc itemText = (ItemTextIfc)publishedItemTextHash.get(itemGrading.getPublishedItemTextId());
                ArrayList answerArray = itemText.getAnswerArray();
                int correctAnswers = 0;
                if (answerArray != null) {
                    for (int i = 0; i < answerArray.size(); ++i) {
                        AnswerIfc a = (AnswerIfc)answerArray.get(i);
                        if (!a.getIsCorrect().booleanValue()) continue;
                        ++correctAnswers;
                    }
                }
                autoScore = (initScore = this.getAnswerScore(itemGrading, publishedAnswerHash)) > 0.0f ? initScore / (float)correctAnswers : this.getTotalCorrectScore(itemGrading, publishedAnswerHash) / (float)correctAnswers * -1.0f;
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().floatValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, Float.valueOf(autoScore));
                    break;
                }
                accumelateScore = ((Float)totalItems.get(itemId)).floatValue();
                totalItems.put(itemId, Float.valueOf(accumelateScore += autoScore));
                break;
            }
            case 9: {
                initScore = this.getAnswerScore(itemGrading, publishedAnswerHash);
                if (initScore > 0.0f) {
                    autoScore = initScore / (float)item.getItemTextSet().size();
                }
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().floatValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, Float.valueOf(autoScore));
                    break;
                }
                accumelateScore = ((Float)totalItems.get(itemId)).floatValue();
                totalItems.put(itemId, Float.valueOf(accumelateScore += autoScore));
                break;
            }
            case 8: {
                autoScore = this.getFIBScore(itemGrading, fibAnswersMap, item, publishedAnswerHash) / (float)((ItemTextIfc)item.getItemTextSet().toArray()[0]).getAnswerSet().size();
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().floatValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, Float.valueOf(autoScore));
                    break;
                }
                accumelateScore = ((Float)totalItems.get(itemId)).floatValue();
                totalItems.put(itemId, Float.valueOf(accumelateScore += autoScore));
                break;
            }
            case 11: {
                autoScore = this.getFINScore(itemGrading, item, publishedAnswerHash) / (float)((ItemTextIfc)item.getItemTextSet().toArray()[0]).getAnswerSet().size();
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().floatValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, Float.valueOf(autoScore));
                    break;
                }
                accumelateScore = ((Float)totalItems.get(itemId)).floatValue();
                totalItems.put(itemId, Float.valueOf(accumelateScore += autoScore));
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (regrade && itemGrading.getAutoScore() != null) {
                    autoScore = itemGrading.getAutoScore().floatValue();
                }
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().floatValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, Float.valueOf(autoScore));
                    break;
                }
                accumelateScore = ((Float)totalItems.get(itemId)).floatValue();
                totalItems.put(itemId, Float.valueOf(accumelateScore += autoScore));
            }
        }
        return autoScore;
    }

    public float getAnswerScore(ItemGradingIfc data, HashMap publishedAnswerHash) {
        AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answer == null || answer.getScore() == null) {
            return 0.0f;
        }
        ItemDataIfc item = answer.getItem();
        Long itemType = item.getTypeId();
        if (answer.getIsCorrect() == null || !answer.getIsCorrect().booleanValue()) {
            if (TypeIfc.MULTIPLE_CHOICE.equals(itemType) || TypeIfc.TRUE_FALSE.equals(itemType)) {
                return Math.abs(answer.getDiscount().floatValue()) * -1.0f;
            }
            return 0.0f;
        }
        return answer.getScore().floatValue();
    }

    public void notifyGradebook(AssessmentGradingIfc data, PublishedAssessmentIfc pub) throws GradebookServiceException {
        PublishedAssessmentService publishedAssessmentService;
        String currentSiteId;
        GradebookServiceHelper gbsHelper;
        String toGradebook = pub.getEvaluationModel().getToGradeBook();
        GradebookService g = null;
        boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
        if (integrated) {
            g = (GradebookService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookService");
        }
        if ((gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper()).gradebookExists(GradebookFacade.getGradebookUId(currentSiteId = (publishedAssessmentService = new PublishedAssessmentService()).getPublishedAssessmentSiteId(pub.getPublishedAssessmentId().toString())), g) && toGradebook.equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attempting to update a score in the gradebook");
            }
            Float originalFinalScore = data.getFinalScore();
            int retryCount = PersistenceService.getInstance().getRetryCount();
            while (retryCount > 0) {
                try {
                    Integer scoringType = pub.getEvaluationModel().getScoringType();
                    if (scoringType.equals(EvaluationModelIfc.AVERAGE_SCORE)) {
                        if (data.getStatus() == 5) {
                            data.setFinalScore(data.getFinalScore());
                        } else {
                            Float averageScore = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAverageSubmittedAssessmentGrading((long)pub.getPublishedAssessmentId(), data.getAgentId());
                            data.setFinalScore(averageScore);
                        }
                    }
                    gbsHelper.updateExternalAssessmentScore(data, g);
                    retryCount = 0;
                }
                catch (AssessmentNotFoundException ante) {
                    log.warn((Object)("problem sending grades to gradebook: " + ante.getMessage()));
                    if (AssessmentIfc.RETRACT_FOR_EDIT_STATUS.equals(pub.getStatus())) {
                        retryCount = this.retry(retryCount, (Exception)((Object)ante), pub, true);
                        continue;
                    }
                    retryCount = this.retry(retryCount, (Exception)((Object)ante), pub, false);
                }
                catch (Exception e) {
                    retryCount = this.retry(retryCount, e, pub, false);
                }
            }
            if (data.getFinalScore() != originalFinalScore) {
                data.setFinalScore(originalFinalScore);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Not updating the gradebook.  toGradebook = " + toGradebook));
        }
    }

    private int retry(int retryCount, Exception e, PublishedAssessmentIfc pub, boolean retractForEditStatus) {
        log.warn((Object)"retrying...sending grades to gradebook. ");
        log.warn((Object)"retry....");
        --retryCount;
        try {
            int deadlockInterval = PersistenceService.getInstance().getDeadlockInterval();
            Thread.sleep(deadlockInterval);
        }
        catch (InterruptedException ex) {
            log.warn((Object)ex.getMessage());
        }
        if (retryCount == 0) {
            if (retractForEditStatus) {
                log.info((Object)("We quietly sallow the AssessmentNotFoundException excption here. Published Assessment Name: " + pub.getTitle()));
            } else {
                log.warn((Object)"After all retries, still failed ...  Now throw error to UI");
                throw new GradebookServiceException(e);
            }
        }
        return retryCount;
    }

    public float getFIBScore(ItemGradingIfc data, HashMap fibmap, ItemDataIfc itemdata, HashMap publishedAnswerHash) {
        String studentanswer = "";
        boolean matchresult = false;
        float totalScore = 0.0f;
        if (data.getPublishedAnswerId() == null) {
            return totalScore;
        }
        AnswerIfc answerIfc = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answerIfc == null) {
            return totalScore;
        }
        String answertext = answerIfc.getText();
        Long itemId = itemdata.getItemId();
        String casesensitive = itemdata.getItemMetaDataByLabel("CASE_SENSITIVE");
        String mutuallyexclusive = itemdata.getItemMetaDataByLabel("MUTUALLY_EXCLUSIVE");
        if (answertext != null) {
            StringTokenizer st = new StringTokenizer(answertext, "|");
            while (st.hasMoreTokens()) {
                String answer = st.nextToken().trim();
                if ("true".equalsIgnoreCase(casesensitive)) {
                    if (data.getAnswerText() != null) {
                        studentanswer = data.getAnswerText().trim();
                        matchresult = this.fibmatch(answer, studentanswer, true);
                    }
                } else if (data.getAnswerText() != null) {
                    studentanswer = data.getAnswerText().trim();
                    matchresult = this.fibmatch(answer, studentanswer, false);
                }
                if (!matchresult) continue;
                boolean alreadyused = false;
                if ("true".equalsIgnoreCase(mutuallyexclusive)) {
                    HashSet<String> answer_used_sofar = (HashSet<String>)fibmap.get(itemId);
                    if (answer_used_sofar != null && answer_used_sofar.contains(studentanswer.toLowerCase())) {
                        alreadyused = true;
                    } else {
                        if (answer_used_sofar == null) {
                            answer_used_sofar = new HashSet<String>();
                        }
                        answer_used_sofar.add(studentanswer.toLowerCase());
                        fibmap.put(itemId, answer_used_sofar);
                    }
                }
                if (alreadyused) break;
                totalScore += ((AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId())).getScore().floatValue();
                break;
            }
        }
        return totalScore;
    }

    public boolean getFIBResult(ItemGradingIfc data, HashMap fibmap, ItemDataIfc itemdata, HashMap publishedAnswerHash) {
        String studentanswer = "";
        boolean matchresult = false;
        if (data.getPublishedAnswerId() == null) {
            return matchresult;
        }
        AnswerIfc answerIfc = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answerIfc == null) {
            return matchresult;
        }
        String answertext = answerIfc.getText();
        Long itemId = itemdata.getItemId();
        String casesensitive = itemdata.getItemMetaDataByLabel("CASE_SENSITIVE");
        String mutuallyexclusive = itemdata.getItemMetaDataByLabel("MUTUALLY_EXCLUSIVE");
        if (answertext != null) {
            StringTokenizer st = new StringTokenizer(answertext, "|");
            while (st.hasMoreTokens()) {
                String answer = st.nextToken().trim();
                if ("true".equalsIgnoreCase(casesensitive)) {
                    if (data.getAnswerText() != null) {
                        studentanswer = data.getAnswerText().trim();
                        matchresult = this.fibmatch(answer, studentanswer, true);
                    }
                } else if (data.getAnswerText() != null) {
                    studentanswer = data.getAnswerText().trim();
                    matchresult = this.fibmatch(answer, studentanswer, false);
                }
                if (!matchresult) continue;
                boolean alreadyused = false;
                if ("true".equalsIgnoreCase(mutuallyexclusive)) {
                    HashSet<String> answer_used_sofar = (HashSet<String>)fibmap.get(itemId);
                    if (answer_used_sofar != null && answer_used_sofar.contains(studentanswer.toLowerCase())) {
                        alreadyused = true;
                    } else {
                        if (answer_used_sofar == null) {
                            answer_used_sofar = new HashSet<String>();
                        }
                        answer_used_sofar.add(studentanswer.toLowerCase());
                        fibmap.put(itemId, answer_used_sofar);
                    }
                }
                if (!alreadyused) break;
                matchresult = false;
                break;
            }
        }
        return matchresult;
    }

    public float getFINScore(ItemGradingIfc data, ItemDataIfc itemdata, HashMap publishedAnswerHash) throws FinFormatException {
        float totalScore = 0.0f;
        boolean matchresult = this.getFINResult(data, itemdata, publishedAnswerHash);
        if (matchresult) {
            totalScore += ((AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId())).getScore().floatValue();
        }
        return totalScore;
    }

    public boolean getFINResult(ItemGradingIfc data, ItemDataIfc itemdata, HashMap publishedAnswerHash) throws FinFormatException {
        String studentanswer = "";
        boolean matchresult = false;
        ComplexFormat complexFormat = new ComplexFormat();
        Complex answerComplex = null;
        Complex studentAnswerComplex = null;
        BigDecimal answerNum = null;
        BigDecimal answer1Num = null;
        BigDecimal answer2Num = null;
        BigDecimal studentAnswerNum = null;
        if (data.getPublishedAnswerId() == null) {
            return false;
        }
        AnswerIfc answerIfc = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answerIfc == null) {
            return matchresult;
        }
        String answertext = answerIfc.getText();
        if (answertext != null) {
            StringTokenizer st = new StringTokenizer(answertext, "|");
            boolean range = false;
            if (st.countTokens() > 1) {
                range = true;
            }
            String studentAnswerText = null;
            if (data.getAnswerText() != null) {
                studentAnswerText = data.getAnswerText().trim();
            }
            if (range) {
                String answer1 = st.nextToken().trim();
                String answer2 = st.nextToken().trim();
                try {
                    answer1Num = new BigDecimal(answer1);
                    answer2Num = new BigDecimal(answer2);
                }
                catch (Exception e) {
                    log.debug((Object)("Number is not BigDecimal: " + answer1 + " or " + answer2));
                }
                HashMap map = this.validate(studentAnswerText);
                studentAnswerNum = (BigDecimal)map.get("REAL");
                matchresult = answer1Num != null && answer2Num != null && studentAnswerNum != null && answer1Num.compareTo(studentAnswerNum) <= 0 && answer2Num.compareTo(studentAnswerNum) >= 0;
            } else {
                String answer = st.nextToken().trim();
                try {
                    answerNum = new BigDecimal(answer);
                }
                catch (NumberFormatException ex) {
                    log.debug((Object)("Number is not BigDecimal: " + answer));
                }
                try {
                    answerComplex = complexFormat.parse(answer);
                }
                catch (ParseException ex) {
                    log.debug((Object)("Number is not Complex: " + answer));
                }
                if (data.getAnswerText() != null) {
                    HashMap map = this.validate(studentAnswerText);
                    if (answerNum != null) {
                        studentAnswerNum = (BigDecimal)map.get("REAL");
                        matchresult = studentAnswerNum != null && answerNum.compareTo(studentAnswerNum) == 0;
                    } else if (answerComplex != null) {
                        studentAnswerComplex = (Complex)map.get("COMPLEX");
                        matchresult = studentAnswerComplex != null && answerComplex.equals((Object)studentAnswerComplex);
                    }
                }
            }
        }
        return matchresult;
    }

    private HashMap validate(String value) {
        Boolean isValid;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (value == null || value.trim().equals("")) {
            return map;
        }
        String trimmedValue = value.trim();
        boolean isComplex = true;
        boolean isRealNumber = true;
        BigDecimal studentAnswerReal = null;
        try {
            studentAnswerReal = new BigDecimal(trimmedValue);
        }
        catch (Exception e) {
            isRealNumber = false;
        }
        Complex studentAnswerComplex = null;
        if (!isRealNumber) {
            try {
                DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
                df.setGroupingUsed(false);
                ComplexFormat complexFormat = new ComplexFormat((NumberFormat)df);
                studentAnswerComplex = complexFormat.parse(trimmedValue);
                if (studentAnswerComplex.getImaginary() == 0.0 && trimmedValue.contains("i")) {
                    isComplex = false;
                }
            }
            catch (Exception e) {
                isComplex = false;
            }
        }
        if (!(isValid = Boolean.valueOf(isComplex || isRealNumber)).booleanValue()) {
            throw new FinFormatException("Not a valid FIN Input. studentanswer=" + trimmedValue);
        }
        if (isRealNumber) {
            map.put("REAL", studentAnswerReal);
        } else if (isComplex) {
            map.put("COMPLEX", (BigDecimal)studentAnswerComplex);
        }
        return map;
    }

    public float getTotalCorrectScore(ItemGradingIfc data, HashMap publishedAnswerHash) {
        AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answer == null || answer.getScore() == null) {
            return 0.0f;
        }
        return answer.getScore().floatValue();
    }

    private void setIsLate(AssessmentGradingIfc data, PublishedAssessmentIfc pub) {
        if (pub.getAssessmentAccessControl() != null && pub.getAssessmentAccessControl().getDueDate() != null && pub.getAssessmentAccessControl().getDueDate().before(new Date())) {
            data.setIsLate(Boolean.TRUE);
        } else {
            data.setIsLate(Boolean.valueOf(false));
        }
        if (data.getForGrade().booleanValue()) {
            data.setStatus(Integer.valueOf(1));
        }
        data.setTotalOverrideScore(Float.valueOf(0.0f));
    }

    public void deleteAll(Collection c) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().deleteAll(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateAssessmentGradingScore(AssessmentGradingIfc adata, PublishedAssessmentIfc pub) {
        try {
            Set itemGradingSet = adata.getItemGradingSet();
            Iterator iter = itemGradingSet.iterator();
            float totalAutoScore = 0.0f;
            float totalOverrideScore = adata.getTotalOverrideScore().floatValue();
            while (iter.hasNext()) {
                ItemGradingIfc i = (ItemGradingIfc)iter.next();
                if (i.getAutoScore() == null) continue;
                totalAutoScore += i.getAutoScore().floatValue();
            }
            float oldAutoScore = adata.getTotalAutoScore().floatValue();
            float scoreDifference = totalAutoScore - oldAutoScore;
            adata.setTotalAutoScore(Float.valueOf(totalAutoScore));
            if (Float.compare(totalAutoScore + totalOverrideScore, Float.valueOf("0").floatValue()) < 0) {
                adata.setFinalScore(Float.valueOf("0"));
            } else {
                adata.setFinalScore(Float.valueOf(totalAutoScore + totalOverrideScore));
            }
            this.saveOrUpdateAssessmentGrading(adata);
            if (scoreDifference != 0.0f) {
                this.notifyGradebookByScoringType(adata, pub);
            }
        }
        catch (GradebookServiceException ge) {
            ge.printStackTrace();
            throw ge;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void saveOrUpdateAll(Collection c) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveOrUpdateAll(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PublishedAssessmentIfc getPublishedAssessmentByAssessmentGradingId(String id) {
        PublishedAssessmentIfc pub = null;
        try {
            pub = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getPublishedAssessmentByAssessmentGradingId(Long.valueOf(id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pub;
    }

    public PublishedAssessmentIfc getPublishedAssessmentByPublishedItemId(String publishedItemId) {
        PublishedAssessmentIfc pub = null;
        try {
            pub = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getPublishedAssessmentByPublishedItemId(Long.valueOf(publishedItemId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pub;
    }

    public ArrayList getLastItemGradingDataPosition(Long assessmentGradingId, String agentId) {
        ArrayList results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastItemGradingDataPosition(assessmentGradingId, agentId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public List getPublishedItemIds(Long assessmentGradingId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getPublishedItemIds(assessmentGradingId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public HashSet getItemSet(Long publishedAssessmentId, Long sectionId) {
        HashSet results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemSet(publishedAssessmentId, sectionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public Long getTypeId(Long itemGradingId) {
        Long typeId = null;
        try {
            typeId = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getTypeId(itemGradingId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return typeId;
    }

    public boolean fibmatch(String answer, String input, boolean casesensitive) {
        try {
            StringBuilder regex_quotebuf = new StringBuilder();
            String REGEX = answer.replaceAll("\\*", "|*|");
            String[] oneblank = REGEX.split("\\|");
            for (int j = 0; j < oneblank.length; ++j) {
                if ("*".equals(oneblank[j])) {
                    regex_quotebuf.append(".+");
                    continue;
                }
                regex_quotebuf.append(Pattern.quote(oneblank[j]));
            }
            String regex_quote = regex_quotebuf.toString();
            Pattern p = casesensitive ? Pattern.compile(regex_quote) : Pattern.compile(regex_quote, 2);
            Matcher m = p.matcher(input);
            boolean result = m.matches();
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List getAllAssessmentGradingByAgentId(Long publishedAssessmentId, String agentIdString) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAllAssessmentGradingByAgentId(publishedAssessmentId, agentIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public HashMap getSiteSubmissionCountHash(String siteId) {
        HashMap results = new HashMap();
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteSubmissionCountHash(siteId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public HashMap getSiteInProgressCountHash(String siteId) {
        HashMap results = new HashMap();
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteInProgressCountHash(siteId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public int getActualNumberRetake(Long publishedAssessmentId, String agentIdString) {
        int actualNumberReatke = 0;
        try {
            actualNumberReatke = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getActualNumberRetake(publishedAssessmentId, agentIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actualNumberReatke;
    }

    public HashMap getActualNumberRetakeHash(String agentIdString) {
        HashMap actualNumberReatkeHash = new HashMap();
        try {
            actualNumberReatkeHash = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getActualNumberRetakeHash(agentIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actualNumberReatkeHash;
    }

    public HashMap getSiteActualNumberRetakeHash(String siteIdString) {
        HashMap numberRetakeHash = new HashMap();
        try {
            numberRetakeHash = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteActualNumberRetakeHash(siteIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return numberRetakeHash;
    }

    public List getStudentGradingSummaryData(Long publishedAssessmentId, String agentIdString) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getStudentGradingSummaryData(publishedAssessmentId, agentIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public int getNumberRetake(Long publishedAssessmentId, String agentIdString) {
        int numberRetake = 0;
        try {
            numberRetake = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getNumberRetake(publishedAssessmentId, agentIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return numberRetake;
    }

    public HashMap getNumberRetakeHash(String agentIdString) {
        HashMap numberRetakeHash = new HashMap();
        try {
            numberRetakeHash = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getNumberRetakeHash(agentIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return numberRetakeHash;
    }

    public HashMap getSiteNumberRetakeHash(String siteIdString) {
        HashMap siteActualNumberRetakeList = new HashMap();
        try {
            siteActualNumberRetakeList = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteNumberRetakeHash(siteIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return siteActualNumberRetakeList;
    }

    public void saveStudentGradingSummaryData(StudentGradingSummaryIfc studentGradingSummaryData) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveStudentGradingSummaryData(studentGradingSummaryData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLateSubmissionsNumberByAgentId(Long publishedAssessmentId, String agentIdString, Date dueDate) {
        int numberRetake = 0;
        try {
            numberRetake = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLateSubmissionsNumberByAgentId(publishedAssessmentId, agentIdString, dueDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return numberRetake;
    }

    public List getExportResponsesData(String publishedAssessmentId, boolean anonymous, String audioMessage, String fileUploadMessage, String noSubmissionMessage, boolean showPartAndTotalScoreSpreadsheetColumns, String poolString, String partString, String questionString, String textString, String rationaleString, String itemGradingCommentsString, Map useridMap) {
        List list = null;
        try {
            list = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getExportResponsesData(publishedAssessmentId, anonymous, audioMessage, fileUploadMessage, noSubmissionMessage, showPartAndTotalScoreSpreadsheetColumns, poolString, partString, questionString, textString, rationaleString, itemGradingCommentsString, useridMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private void removeUnsubmittedAssessmentGradingData(AssessmentGradingIfc data) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().removeUnsubmittedAssessmentGradingData(data);
        }
        catch (Exception e) {
            log.error((Object)("Exception thrown from removeUnsubmittedAssessmentGradingData" + e.getMessage()));
        }
    }

    public boolean getHasGradingData(Long publishedAssessmentId) {
        boolean hasGradingData = false;
        try {
            hasGradingData = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHasGradingData(publishedAssessmentId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasGradingData;
    }

    public ArrayList getHasGradingDataAndHasSubmission(Long publishedAssessmentId) {
        ArrayList al = new ArrayList();
        try {
            al = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHasGradingDataAndHasSubmission(publishedAssessmentId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return al;
    }

    public String getFileName(Long itemGradingId, String agentId, String filename) {
        String name = "";
        try {
            name = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getFilename(itemGradingId, agentId, filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public List getUpdatedAssessmentList(String agentId, String siteId) {
        List list = null;
        try {
            list = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getUpdatedAssessmentList(agentId, siteId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List getSiteNeedResubmitList(String siteId) {
        List list = null;
        try {
            list = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteNeedResubmitList(siteId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public void autoSubmitAssessments() {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().autoSubmitAssessments();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ItemGradingAttachmentIfc createItemGradingAttachment(ItemGradingIfc itemGrading, String resourceId, String filename, String protocol) {
        ItemGradingAttachmentIfc attachment = null;
        try {
            attachment = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().createItemGradingtAttachment(itemGrading, resourceId, filename, protocol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachment;
    }

    public void removeItemGradingAttachment(String attachmentId) {
        PersistenceService.getInstance().getAssessmentGradingFacadeQueries().removeItemGradingAttachment(Long.valueOf(attachmentId));
    }

    public void saveOrUpdateAttachments(List list) {
        PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveOrUpdateAttachments(list);
    }

    public HashMap getInProgressCounts(String siteId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getInProgressCounts(siteId);
    }

    public HashMap getSubmittedCounts(String siteId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSubmittedCounts(siteId);
    }

    public void completeItemGradingData(AssessmentGradingData assessmentGradingData) {
        PersistenceService.getInstance().getAssessmentGradingFacadeQueries().completeItemGradingData(assessmentGradingData);
    }

    public float getAnswerScoreMCQ(ItemGradingIfc data, HashMap publishedAnswerHash) {
        AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answer == null || answer.getScore() == null) {
            return 0.0f;
        }
        if (answer.getIsCorrect().booleanValue()) {
            return answer.getItem().getScore().floatValue();
        }
        return answer.getItem().getScore().floatValue() * answer.getPartialCredit().floatValue() / 100.0f;
    }
}

