/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import osid.shared.Id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionPoolService {
    private static Log log = LogFactory.getLog(QuestionPoolService.class);

    public QuestionPoolIteratorFacade getAllPools(String agentId) {
        QuestionPoolIteratorFacade results = null;
        results = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllPools(agentId);
        return results;
    }

    public QuestionPoolIteratorFacade getAllPoolsWithAccess(String agentId) {
        QuestionPoolIteratorFacade results = null;
        results = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllPoolsWithAccess(agentId);
        return results;
    }

    public ArrayList getBasicInfoOfAllPools(String agentId) {
        ArrayList results = null;
        results = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getBasicInfoOfAllPools(agentId);
        return results;
    }

    public QuestionPoolFacade getPool(Long poolId, String agentId) {
        QuestionPoolFacade pool = null;
        try {
            pool = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getPool(poolId, agentId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return pool;
    }

    public List getPoolIdsByItem(String itemId) {
        List idList = null;
        try {
            idList = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getPoolIdsByItem(itemId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return idList;
    }

    public boolean hasItem(String itemId, Long poolId) {
        List poollist = null;
        boolean found = false;
        try {
            poollist = this.getPoolIdsByItem(itemId);
            found = poollist != null ? poollist.contains(poolId) : false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return found;
    }

    public List getPoolIdsByAgent(String agentId) {
        List idList = null;
        try {
            idList = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getPoolIdsByAgent(agentId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return idList;
    }

    public List getSubPools(Long poolId) {
        List poolList = null;
        try {
            poolList = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getSubPools(poolId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return poolList;
    }

    public int getSubPoolSize(Long poolId) {
        int poolSize = 0;
        try {
            poolSize = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getSubPoolSize(poolId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return poolSize;
    }

    public boolean hasSubPools(Long poolId) {
        boolean result = false;
        try {
            result = PersistenceService.getInstance().getQuestionPoolFacadeQueries().hasSubPools(poolId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return result;
    }

    public ArrayList getAllItemsSorted(Long poolId, String orderBy, String ascending) {
        ArrayList results = null;
        try {
            if ("text".equals(orderBy)) {
                results = new ArrayList(PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllItemFacadesOrderByItemText(poolId, "instruction", ascending));
            } else if ("keyword".equals(orderBy)) {
                results = new ArrayList(PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllItemFacadesOrderByItemType(poolId, orderBy, ascending));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public ArrayList getAllItems(Long poolId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAllItemFacades(poolId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public void addItemToPool(String itemId, Long poolId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().addItemToPool(new QuestionPoolItemData(poolId, itemId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void moveItemToPool(String itemId, Long sourceId, Long destId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().moveItemToPool(itemId, sourceId, destId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public boolean isDescendantOf(Long poolA, Long poolB, String agentId) {
        try {
            Long tempPoolId = poolA;
            while (tempPoolId != null && tempPoolId.toString().compareTo("0") > 0) {
                QuestionPoolFacade tempPool = this.getPool(tempPoolId, agentId);
                if (tempPool.getParentPoolId().toString().compareTo(poolB.toString()) == 0) {
                    return true;
                }
                tempPoolId = tempPool.getParentPoolId();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return false;
        }
    }

    public void movePool(String agentId, Long sourceId, Long destId) {
        try {
            if (!this.isDescendantOf(destId, sourceId, agentId)) {
                if (!sourceId.equals(destId)) {
                    PersistenceService.getInstance().getQuestionPoolFacadeQueries().movePool(agentId, sourceId, destId);
                } else {
                    log.warn((Object)"Illegal Move: Can not move a pool to itself.");
                }
            } else {
                log.warn((Object)"Illegal Move: Can not move a pool to its descendant.");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void deletePool(Long poolId, String agentId, Tree tree) {
        try {
            QuestionPoolFacade qp = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getPool(poolId, agentId);
            if (!qp.getOwnerId().equals(agentId)) {
                throw new Exception("You are not allowed to delete pool if you are not the owner");
            }
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().deletePool(poolId, agentId, tree);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void removeQuestionFromPool(String questionId, Long poolId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().removeItemFromPool(questionId, poolId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void copyPool(Tree tree, String agentId, Long sourceId, Long destId, String prependString1, String prependString2) {
        try {
            if (!this.isDescendantOf(destId, sourceId, agentId)) {
                PersistenceService.getInstance().getQuestionPoolFacadeQueries().copyPool(tree, agentId, sourceId, destId, prependString1, prependString2);
            } else {
                log.warn((Object)"Illegal Copy: Can not copy a pool to its descendant!");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void copyQuestion(Id questionId, Id destId) {
    }

    public void copyQuestion(Id questionId, Id destId, boolean duplicateCopy) {
    }

    public String exportQuestion(Id questionId) {
        try {
            return "";
        }
        catch (Exception e) {
            log.debug((Object)"Exception in exportQuestion");
            log.error((Object)e);
            return null;
        }
    }

    public QuestionPoolFacade savePool(QuestionPoolFacade pool) {
        try {
            return PersistenceService.getInstance().getQuestionPoolFacadeQueries().savePool(pool);
        }
        catch (Exception e) {
            log.error((Object)e);
            return pool;
        }
    }

    public HashMap getQuestionPoolItemMap() {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().getQuestionPoolItemMap();
    }

    public boolean poolIsUnique(String questionPoolId, String title, String parentPoolId, String agentId) {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().poolIsUnique(new Long(questionPoolId), title, new Long(parentPoolId), agentId);
    }

    public Long copyItemFacade(ItemDataIfc itemData) {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().copyItemFacade(itemData);
    }

    public ItemFacade copyItemFacade2(ItemDataIfc itemData) {
        return PersistenceService.getInstance().getQuestionPoolFacadeQueries().copyItemFacade2(itemData);
    }

    public int getCountItems(Long poolId) {
        Integer result = 0;
        try {
            result = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getCountItemFacades(poolId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void addQuestionPoolAccess(Tree tree, String user, Long questionPoolId, Long accessTypeId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().addQuestionPoolAccess(tree, user, questionPoolId, accessTypeId);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void removeQuestionPoolAccess(Tree tree, String user, Long questionPoolId, Long accessTypeId) {
        try {
            PersistenceService.getInstance().getQuestionPoolFacadeQueries().removeQuestionPoolAccess(tree, user, questionPoolId, accessTypeId);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public List<AgentFacade> getAgentsWithAccess(Long questionPoolId) {
        List<AgentFacade> agents = null;
        try {
            agents = PersistenceService.getInstance().getQuestionPoolFacadeQueries().getAgentsWithAccess(questionPoolId);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return agents;
    }

    public List<AgentFacade> getAgentsWithoutAccess(Long questionPoolId, String realmId) {
        ArrayList<AgentFacade> agents = new ArrayList<AgentFacade>();
        try {
            List<AgentFacade> agentsWithAccess = this.getAgentsWithAccess(questionPoolId);
            ArrayList<String> azGroups = new ArrayList<String>();
            azGroups.add("/site/" + realmId);
            Set users = AuthzGroupService.getUsersIsAllowed((String)"assessment.questionpool.create", azGroups);
            for (String userId : users) {
                AgentFacade agent = new AgentFacade(userId);
                agents.add(agent);
            }
            agents.removeAll(agentsWithAccess);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return agents;
    }
}

