/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.Collection;
import java.util.Iterator;
import org.sakaiproject.entity.api.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCollections {
    public static boolean isIntersectionEntityRefsToEntities(Collection<String> entityRefs, Collection<Entity> entities) {
        for (String findThisEntityRef : entityRefs) {
            Iterator<Entity> iEntities = entities.iterator();
            while (iEntities.hasNext()) {
                String thisEntityRef = iEntities.next().getReference();
                if (!thisEntityRef.equals(findThisEntityRef)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isContainedEntityRefsToEntities(Collection<String> entityRefs, Collection<Entity> entities) {
        for (String findThisEntityRef : entityRefs) {
            if (EntityCollections.entityCollectionContainsRefString(entities, findThisEntityRef)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualEntityRefsToEntities(Collection<String> entityRefs, Collection<Entity> entities) {
        if (entityRefs.size() != entities.size()) {
            return false;
        }
        for (String entityRef : entityRefs) {
            if (EntityCollections.entityCollectionContainsRefString(entities, entityRef)) continue;
            return false;
        }
        Iterator<Entity> iEntities = entities.iterator();
        while (iEntities.hasNext()) {
            String findThisEntityRef = iEntities.next().getReference();
            if (entityRefs.contains(findThisEntityRef)) continue;
            return false;
        }
        return true;
    }

    public static boolean entityCollectionContainsRefString(Collection<Entity> entities, String entityRef) {
        for (Entity entity : entities) {
            if (!entity.getReference().equals(entityRef)) continue;
            return true;
        }
        return false;
    }

    public static boolean refCollectionContainsEntity(Collection<String> refs, Entity entity) {
        String targetRef = entity.getReference();
        for (String entityRef : refs) {
            if (!entityRef.equals(targetRef)) continue;
            return true;
        }
        return false;
    }

    public static void setEntityRefsFromEntities(Collection<String> refs, Collection<Entity> entities) {
        refs.clear();
        for (Entity entity : entities) {
            refs.add(entity.getReference());
        }
    }

    public static void computeAddedRemovedEntityRefsFromNewEntitiesOldRefs(Collection<String> addedEntities, Collection<String> removedEntities, Collection<Entity> newEntities, Collection<String> oldEntityRefs) {
        for (Entity entity : newEntities) {
            if (EntityCollections.refCollectionContainsEntity(oldEntityRefs, entity)) continue;
            addedEntities.add(entity.getReference());
        }
        for (String entityRef : oldEntityRefs) {
            if (EntityCollections.entityCollectionContainsRefString(newEntities, entityRef)) continue;
            removedEntities.add(entityRef);
        }
    }
}

