/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.sakaiproject.alias.api.Alias;
import org.sakaiproject.alias.cover.AliasService;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.NotificationAction;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.EmailNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteEmailNotification
extends EmailNotification {
    public SiteEmailNotification() {
    }

    public SiteEmailNotification(String siteId) {
        super(siteId);
    }

    @Override
    public NotificationAction getClone() {
        EmailNotification clone = this.makeEmailNotification();
        clone.set(this);
        return clone;
    }

    @Override
    protected List<User> getRecipients(Event event) {
        Reference ref = EntityManager.newReference((String)event.getResource());
        String siteId = this.getSite() != null ? this.getSite() : ref.getContext();
        try {
            Site site = SiteService.getSite((String)siteId);
            String ability = SiteService.SITE_VISIT;
            if (!site.isPublished()) {
                ability = SiteService.SITE_VISIT_UNPUBLISHED;
            }
            List users = SecurityService.unlockUsers((String)ability, (String)ref.getReference());
            if (this.getResourceAbility() != null) {
                List users2 = SecurityService.unlockUsers((String)this.getResourceAbility(), (String)ref.getReference());
                users.retainAll(users2);
            }
            this.refineToSiteMembers(users, site);
            this.addSpecialRecipients(users, ref);
            return users;
        }
        catch (Exception any) {
            return new Vector<User>();
        }
    }

    protected void addSpecialRecipients(List<User> users, Reference ref) {
    }

    protected String getResourceAbility() {
        return null;
    }

    protected String getTo(Event event) {
        if (NotificationService.isNotificationToReplyable()) {
            return "To: " + this.getToSite(event);
        }
        return "To: " + this.getToSiteNoReply(event);
    }

    protected String getToSiteNoReply(Event event) {
        String siteId;
        Reference ref = EntityManager.newReference((String)event.getResource());
        String title = siteId = this.getSite() != null ? this.getSite() : ref.getContext();
        try {
            Site site = SiteService.getSite((String)siteId);
            title = site.getTitle();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return "\"" + title + "\"<no-reply@" + ServerConfigurationService.getServerName() + ">";
    }

    protected String getToSite(Event event) {
        String siteId;
        Reference ref = EntityManager.newReference((String)event.getResource());
        String title = siteId = this.getSite() != null ? this.getSite() : ref.getContext();
        String email = null;
        try {
            Site site = SiteService.getSite((String)siteId);
            title = site.getTitle();
            String channel = "/mailarchive/channel/" + siteId + "/main";
            EntityManager.newReference((String)channel);
            List all = AliasService.getAliases((String)channel);
            if (!all.isEmpty()) {
                email = ((Alias)all.get(0)).getId();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (email == null) {
            email = "no-reply";
        }
        String rv = "\"" + title + "\" <" + email + "@" + ServerConfigurationService.getServerName() + ">";
        return rv;
    }

    protected void refineToSiteMembers(List<User> users, Site site) {
        Set members = site.getMembers();
        Set<String> memberUserIds = this.getUserIds(members);
        ListIterator<User> i = users.listIterator();
        while (i.hasNext()) {
            User user = (User)i.next();
            if (memberUserIds.contains(user.getId())) continue;
            i.remove();
        }
    }

    private Set<String> getUserIds(Collection<Member> members) {
        HashSet<String> userIds = new HashSet<String>();
        for (Member member : members) {
            userIds.add(member.getUserId());
        }
        return userIds;
    }
}

