/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.samlite.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlOptions;
import org.imsglobal.xsd.imsQtiasiv1P2.AssessfeedbackType;
import org.imsglobal.xsd.imsQtiasiv1P2.AssessmentType;
import org.imsglobal.xsd.imsQtiasiv1P2.AssessmentcontrolType;
import org.imsglobal.xsd.imsQtiasiv1P2.ConditionvarType;
import org.imsglobal.xsd.imsQtiasiv1P2.DecvarType;
import org.imsglobal.xsd.imsQtiasiv1P2.DisplayfeedbackType;
import org.imsglobal.xsd.imsQtiasiv1P2.FlowMatType;
import org.imsglobal.xsd.imsQtiasiv1P2.FlowType;
import org.imsglobal.xsd.imsQtiasiv1P2.ItemType;
import org.imsglobal.xsd.imsQtiasiv1P2.ItemfeedbackType;
import org.imsglobal.xsd.imsQtiasiv1P2.ItemmetadataType;
import org.imsglobal.xsd.imsQtiasiv1P2.ItemrubricType;
import org.imsglobal.xsd.imsQtiasiv1P2.MaterialType;
import org.imsglobal.xsd.imsQtiasiv1P2.MatimageType;
import org.imsglobal.xsd.imsQtiasiv1P2.MattextType;
import org.imsglobal.xsd.imsQtiasiv1P2.OrType;
import org.imsglobal.xsd.imsQtiasiv1P2.OrderType;
import org.imsglobal.xsd.imsQtiasiv1P2.OutcomesType;
import org.imsglobal.xsd.imsQtiasiv1P2.PresentationMaterialType;
import org.imsglobal.xsd.imsQtiasiv1P2.PresentationType;
import org.imsglobal.xsd.imsQtiasiv1P2.QtimetadataType;
import org.imsglobal.xsd.imsQtiasiv1P2.QtimetadatafieldType;
import org.imsglobal.xsd.imsQtiasiv1P2.QuestestinteropDocument;
import org.imsglobal.xsd.imsQtiasiv1P2.RenderChoiceType;
import org.imsglobal.xsd.imsQtiasiv1P2.RenderFibType;
import org.imsglobal.xsd.imsQtiasiv1P2.RespconditionType;
import org.imsglobal.xsd.imsQtiasiv1P2.ResponseLabelType;
import org.imsglobal.xsd.imsQtiasiv1P2.ResponseLidType;
import org.imsglobal.xsd.imsQtiasiv1P2.ResponseStrType;
import org.imsglobal.xsd.imsQtiasiv1P2.ResprocessingType;
import org.imsglobal.xsd.imsQtiasiv1P2.RubricType;
import org.imsglobal.xsd.imsQtiasiv1P2.SectionType;
import org.imsglobal.xsd.imsQtiasiv1P2.SelectionOrderingType;
import org.imsglobal.xsd.imsQtiasiv1P2.SetvarType;
import org.imsglobal.xsd.imsQtiasiv1P2.VarequalType;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.samlite.api.Answer;
import org.sakaiproject.tool.assessment.samlite.api.Question;
import org.sakaiproject.tool.assessment.samlite.api.QuestionGroup;
import org.sakaiproject.tool.assessment.samlite.api.SamLiteService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.util.ResourceLoader;
import org.w3c.dom.Document;

public class SamLiteServiceImpl
implements SamLiteService {
    private static Log log = LogFactory.getLog(SamLiteServiceImpl.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    private Pattern justQuestionPattern;
    private Pattern startOfQuestionPattern;
    private Pattern correctAnswerPattern;
    private Pattern correctFillInPattern;
    private Pattern answerPattern;
    private Pattern endQuestionPattern;
    private Pattern correctMultipleChoicePattern;
    private Pattern shortEssayPattern;
    private Pattern correctTruePattern;
    private Pattern correctFalsePattern;
    private Pattern unnecessaryTruePattern;
    private Pattern unnecessaryFalsePattern;
    private Pattern startOfQuestionNumericPattern;
    private Pattern pointsPattern;

    public void init() {
        this.startOfQuestionNumericPattern = Pattern.compile("^(\\d+\\.|\\)|\\]\\s*)", 2);
        this.correctAnswerPattern = Pattern.compile("^\\*");
        this.correctMultipleChoicePattern = Pattern.compile("^\\*\\s*([a-z])\\.\\s*(.*)", 2);
        this.correctFillInPattern = Pattern.compile("^\\*\\s*(.*)");
        this.answerPattern = Pattern.compile("^([a-z])\\.\\s*(.*)", 2);
    }

    public Question saveLast(QuestionGroup questionGroup, Question question) {
        if (null != question) {
            if (0 == question.getQuestionType()) {
                question.setQuestionType(40);
            }
            if (!question.hasPoints()) {
                question.setQuestionPoints("0");
            }
            questionGroup.addQuestion(question);
        }
        return new Question();
    }

    private String getPoints(String line) {
        Matcher pointsMatcher = this.pointsPattern.matcher(line);
        String points = "";
        if (pointsMatcher.find()) {
            points = pointsMatcher.group(1);
        }
        return points;
    }

    private String stripPoints(String line) {
        Matcher pointsMatcher = this.pointsPattern.matcher(line);
        StringBuffer sb = new StringBuffer();
        while (pointsMatcher.find()) {
            pointsMatcher.appendReplacement(sb, "");
        }
        pointsMatcher.appendTail(sb);
        return sb.toString();
    }

    private String removeMatchedPattern(Matcher m) {
        StringBuffer buffer = new StringBuffer();
        m.appendReplacement(buffer, "");
        m.appendTail(buffer);
        return buffer.toString();
    }

    public QuestionGroup parse(String name, String description, String data) {
        ResourceLoader rb = new ResourceLoader("org.sakaiproject.tool.assessment.bundle.SamLitePatternMessages");
        String stQuestion = rb.getString("question");
        this.startOfQuestionPattern = Pattern.compile("^(" + stQuestion + "\\s*\\d*\\s*)", 2);
        String stPoints = rb.getString("points");
        this.pointsPattern = Pattern.compile("\\((\\d*\\.?\\d*)\\s+" + stPoints + "\\)", 2);
        String stSaveAnswer = rb.getString("save_answer");
        this.endQuestionPattern = Pattern.compile("^" + stSaveAnswer, 2);
        String stTrue = rb.getString("true");
        String stFalse = rb.getString("false");
        this.correctTruePattern = Pattern.compile("^\\*\\s*" + stTrue + "$");
        this.correctFalsePattern = Pattern.compile("^\\*\\s*" + stFalse + "$");
        this.unnecessaryTruePattern = Pattern.compile("^" + stTrue + "$");
        this.unnecessaryFalsePattern = Pattern.compile("^" + stFalse + "$");
        QuestionGroup questionGroup = new QuestionGroup(name, description);
        String cleanData = data;
        String[] lines = cleanData.split("\\n");
        Question question = null;
        int questionNumber = 1;
        for (int i = 0; i < lines.length; ++i) {
            String line;
            if (lines[i].endsWith("<br />")) {
                lines[i] = lines[i].replaceAll("<br />", "").replace('\r', ' ');
            }
            if (null == (line = lines[i].trim()) || "".equals(line)) continue;
            Matcher startOfQuestionMatcher = this.startOfQuestionPattern.matcher(line);
            Matcher startOfQuestionNumericMatcher = this.startOfQuestionNumericPattern.matcher(line);
            Matcher pointsMatcher = this.pointsPattern.matcher(line);
            boolean isQuestionStart = startOfQuestionMatcher.find();
            boolean isQuestionNumericStart = startOfQuestionNumericMatcher.find();
            boolean isJustPoints = pointsMatcher.find();
            if (isQuestionStart || isQuestionNumericStart || isJustPoints) {
                question = this.saveLast(questionGroup, question);
                if (isQuestionStart) {
                    line = this.removeMatchedPattern(startOfQuestionMatcher);
                } else if (isQuestionNumericStart) {
                    line = this.removeMatchedPattern(startOfQuestionNumericMatcher);
                }
                String points = this.getPoints(line);
                question.setQuestionPoints(points);
                String questionText = this.stripPoints(line);
                question.append(questionText.trim());
                question.setQuestionNumber(questionNumber);
                ++questionNumber;
                continue;
            }
            if (null == question) continue;
            this.parseLine(question, line);
        }
        if (null != question) {
            this.saveLast(questionGroup, question);
        }
        return questionGroup;
    }

    private void parseLine(Question question, String line) {
        boolean isEndOfQuestion = this.endQuestionPattern.matcher(line).find();
        boolean isCorrectAnswer = this.correctAnswerPattern.matcher(line).lookingAt();
        Matcher answerMatcher = this.answerPattern.matcher(line);
        boolean isAnswer = answerMatcher.find();
        boolean isEmptyTrue = this.unnecessaryTruePattern.matcher(line).find();
        boolean isEmptyFalse = this.unnecessaryFalsePattern.matcher(line).find();
        if (!isEndOfQuestion) {
            if (isAnswer) {
                question.addAnswer(answerMatcher.group(1), answerMatcher.group(2), false);
            } else if (isCorrectAnswer) {
                Matcher multipleChoiceMatcher = this.correctMultipleChoicePattern.matcher(line);
                boolean isMC = multipleChoiceMatcher.find();
                Matcher fillInMatcher = this.correctFillInPattern.matcher(line);
                boolean isFI = fillInMatcher.find();
                boolean isTrue = this.correctTruePattern.matcher(line).find();
                boolean isFalse = this.correctFalsePattern.matcher(line).find();
                if (isMC) {
                    String earlierCorrectAnswer = question.getCorrectAnswer();
                    boolean hasOneCorrectAnswerAlready = null != earlierCorrectAnswer && !"".equals(earlierCorrectAnswer.trim());
                    question.setCorrectAnswer(multipleChoiceMatcher.group(1));
                    question.addAnswer(multipleChoiceMatcher.group(1), multipleChoiceMatcher.group(2), true);
                    if (hasOneCorrectAnswerAlready) {
                        question.setQuestionType(15);
                    } else {
                        question.setQuestionType(10);
                    }
                } else if (isTrue) {
                    question.addAnswer("A", "True", true);
                    question.addAnswer("B", "False", false);
                    question.setQuestionType(30);
                    question.setCorrectAnswer("True");
                } else if (isFalse) {
                    question.addAnswer("A", "True", false);
                    question.addAnswer("B", "False", true);
                    question.setQuestionType(30);
                    question.setCorrectAnswer("False");
                } else if (isFI) {
                    question.setCorrectAnswer(fillInMatcher.group(1));
                    question.setQuestionType(20);
                }
            } else if (!isEmptyTrue && !isEmptyFalse) {
                question.append(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document createDocument(QuestionGroup questionGroup) {
        log.debug((Object)("Creating a new qti document with the following name: " + questionGroup.getName()));
        QuestestinteropDocument document = this.createQTIDocument(questionGroup);
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrintIndent(4);
        options.setSavePrettyPrint();
        options.setUseDefaultNamespace();
        HashMap<String, String> prefixes = new HashMap<String, String>();
        prefixes.put("", "http://www.imsglobal.org/xsd/ims_qtiasiv1p2");
        options.setSaveImplicitNamespaces(prefixes);
        InputStream inputStream = null;
        try {
            Document doc;
            inputStream = document.newInputStream(options);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            Document document2 = doc = documentBuilder.parse(inputStream);
            return document2;
        }
        catch (ParserConfigurationException pce) {
            log.error((Object)"Unable to parse quiz document ", (Throwable)pce);
        }
        catch (IOException ioe) {
            log.error((Object)"Low-level IOException caught reading quiz document ", (Throwable)ioe);
        }
        catch (Exception qse) {
            log.error((Object)"Unable to save this quiz as an imported assessment ", (Throwable)qse);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)"Unimportant ioe");
                }
            }
        }
        return null;
    }

    public QuestestinteropDocument createQTIDocument(QuestionGroup questionGroup) {
        QuestestinteropDocument doc = QuestestinteropDocument.Factory.newInstance();
        doc.addNewQuestestinterop();
        doc.getQuestestinterop().addNewAssessment();
        AssessmentType assessment = doc.getQuestestinterop().getAssessment();
        assessment.setTitle(questionGroup.getName());
        this.addAssessmentMetadata(assessment);
        AssessmentcontrolType assessmentControl = assessment.addNewAssessmentcontrol();
        assessmentControl.setFeedbackswitch(AssessmentcontrolType.Feedbackswitch.YES);
        assessmentControl.setHintswitch(AssessmentcontrolType.Hintswitch.YES);
        assessmentControl.setSolutionswitch(AssessmentcontrolType.Solutionswitch.YES);
        assessmentControl.setView(AssessmentcontrolType.View.ALL);
        RubricType rubric = assessment.addNewRubric();
        this.buildMattext(rubric.addNewMaterial().addNewMattext());
        PresentationMaterialType presentationMaterial = assessment.addNewPresentationMaterial();
        FlowMatType pFlowMat = presentationMaterial.addNewFlowMat();
        pFlowMat.setClass1("Block");
        this.buildMattext(pFlowMat.addNewMaterial().addNewMattext(), questionGroup.getDescription());
        AssessfeedbackType assessFeedback = assessment.addNewAssessfeedback();
        assessFeedback.setIdent("Feedback");
        assessFeedback.setTitle("Feedback");
        assessFeedback.setView(AssessfeedbackType.View.ALL);
        FlowMatType afFlowMat = assessFeedback.addNewFlowMat();
        this.buildMattext(afFlowMat.addNewMaterial().addNewMattext());
        SectionType section = assessment.addNewSection();
        section.setIdent("Multiple Choice Questions");
        QtimetadataType sectionMetaData = section.addNewQtimetadata();
        this.buildMetaDataField(sectionMetaData, "SECTION_OBJECTIVE", "");
        this.buildMetaDataField(sectionMetaData, "SECTION_KEYWORD", "");
        this.buildMetaDataField(sectionMetaData, "SECTION_RUBRIC", "");
        PresentationMaterialType sectionPresentationMaterial = section.addNewPresentationMaterial();
        FlowMatType spFlowMat = sectionPresentationMaterial.addNewFlowMat();
        spFlowMat.setClass1("Block");
        this.buildMattext(spFlowMat.addNewMaterial().addNewMattext());
        this.buildEmptyMaterialImage(spFlowMat.addNewMaterial().addNewMatimage());
        SelectionOrderingType selectionOrdering = section.addNewSelectionOrdering();
        selectionOrdering.setSequenceType("Normal");
        OrderType order = selectionOrdering.addNewOrder();
        order.setOrderType("Sequential");
        if (null != questionGroup.getQuestions()) {
            for (Question question : questionGroup.getQuestions()) {
                this.processQuestion(section, question);
            }
        }
        return doc;
    }

    private void buildMetaDataField(QtimetadataType metadata, String label, String entry) {
        QtimetadatafieldType field = metadata.addNewQtimetadatafield();
        field.setFieldlabel(label);
        field.setFieldentry(entry);
    }

    private void addAssessmentMetadata(AssessmentType assessment) {
        QtimetadataType metadata = assessment.addNewQtimetadata();
        AssessmentService service = new AssessmentService();
        List metadataList = service.getDefaultMetaDataSet();
        Iterator iter = metadataList.iterator();
        String automaticSubmissionEditable = "true";
        while (iter.hasNext()) {
            AssessmentMetaData mData = (AssessmentMetaData)iter.next();
            if ("automaticSubmission_isInstructorEditable".equals(mData.getLabel())) {
                automaticSubmissionEditable = mData.getEntry();
                continue;
            }
            String label = mData.getLabel();
            String entry = mData.getEntry();
            this.buildMetaDataField(metadata, label, entry);
        }
        String autoSubmitEnabled = ServerConfigurationService.getString((String)"samigo.autoSubmit.enabled");
        if (autoSubmitEnabled == null || autoSubmitEnabled.equals("") || !autoSubmitEnabled.equals("true")) {
            this.buildMetaDataField(metadata, "automaticSubmission_isInstructorEditable", "false");
        } else {
            this.buildMetaDataField(metadata, "automaticSubmission_isInstructorEditable", automaticSubmissionEditable);
        }
    }

    private void processQuestion(SectionType section, Question question) {
        log.debug((Object)"Processing a question");
        switch (question.getQuestionType()) {
            case 10: {
                this.processMultipleChoiceQuestion(section, question);
                break;
            }
            case 15: {
                this.processMultipleChoiceMultipleAnswerQuestion(section, question);
                break;
            }
            case 20: {
                this.processFillInQuestion(section, question);
                break;
            }
            case 40: {
                this.processShortEssayQuestion(section, question);
                break;
            }
            case 30: {
                this.processTrueFalseQuestion(section, question);
                break;
            }
        }
    }

    private void buildMattext(MattextType mattext) {
        mattext.setCharset(DEFAULT_CHARSET);
        mattext.setTexttype("text/plain");
    }

    private void buildMattext(MattextType mattext, String value) {
        this.buildMattext(mattext);
        mattext.setStringValue(this.cdata(value));
    }

    private String cdata(String value) {
        return value;
    }

    private void buildEmptyMaterialImage(MatimageType matImage) {
        matImage.setEmbedded("base64");
        matImage.setImagtype("text/html");
    }

    private void buildItemFeedback(ItemType item, String identity) {
        ItemfeedbackType ifeedback = item.addNewItemfeedback();
        ifeedback.setIdent(identity);
        ifeedback.setView(ItemfeedbackType.View.ALL);
        FlowMatType ifflow = ifeedback.addNewFlowMat();
        ifflow.setClass1("Block");
        this.buildMattext(ifflow.addNewMaterial().addNewMattext());
        this.buildEmptyMaterialImage(ifflow.addNewMaterial().addNewMatimage());
    }

    private void buildPresentationAndResponseLid(ItemType item, Question question, String label, String respLidId, ResponseLidType.Rcardinality.Enum rCardinality) {
        PresentationType presentation = item.addNewPresentation();
        presentation.setLabel(label);
        FlowType flow = presentation.addNewFlow();
        flow.setClass1("Block");
        MaterialType material = flow.addNewMaterial();
        this.buildMattext(material.addNewMattext(), this.cdata(question.getQuestion()));
        MaterialType material2 = flow.addNewMaterial();
        this.buildMattext(material2.addNewMattext());
        if (10 == question.getQuestionType() || 15 == question.getQuestionType()) {
            MatimageType matImage = material2.addNewMatimage();
            matImage.setEmbedded("base64");
            matImage.setImagtype("text/html");
            matImage.setUri("");
        }
        ResponseLidType responseLid = flow.addNewResponseLid();
        responseLid.setIdent(respLidId);
        responseLid.setRcardinality(rCardinality);
        responseLid.setRtiming(ResponseLidType.Rtiming.NO);
        RenderChoiceType renderChoice = responseLid.addNewRenderChoice();
        renderChoice.setShuffle(RenderChoiceType.Shuffle.NO);
        char c = 'A';
        for (Answer answer : question.getAnswers()) {
            ResponseLabelType responseLabel = renderChoice.addNewResponseLabel();
            responseLabel.setIdent(String.valueOf(c));
            responseLabel.setRarea(ResponseLabelType.Rarea.ELLIPSE);
            responseLabel.setRrange(ResponseLabelType.Rrange.EXACT);
            responseLabel.setRshuffle(ResponseLabelType.Rshuffle.YES);
            MaterialType mat = responseLabel.addNewMaterial();
            MattextType text = mat.addNewMattext();
            text.setCharset(DEFAULT_CHARSET);
            text.setTexttype("text/plain");
            text.setStringValue(this.cdata(answer.getText()));
            MaterialType m2 = responseLabel.addNewMaterial();
            MatimageType mi = m2.addNewMatimage();
            mi.setEmbedded("base64");
            mi.setImagtype("text/html");
            mi.setUri("");
            c = (char)(c + '\u0001');
        }
    }

    private void addResponseLid(FlowType flow, Question question, boolean isMultipleAnswer) {
        ResponseLidType responseLid = flow.addNewResponseLid();
        responseLid.setIdent("MCSC");
        if (isMultipleAnswer) {
            responseLid.setRcardinality(ResponseLidType.Rcardinality.MULTIPLE);
        } else {
            responseLid.setRcardinality(ResponseLidType.Rcardinality.SINGLE);
        }
        responseLid.setRtiming(ResponseLidType.Rtiming.NO);
        RenderChoiceType renderChoice = responseLid.addNewRenderChoice();
        renderChoice.setShuffle(RenderChoiceType.Shuffle.NO);
        char c = 'A';
        for (Answer answer : question.getAnswers()) {
            ResponseLabelType responseLabel = renderChoice.addNewResponseLabel();
            responseLabel.setIdent(String.valueOf(c));
            responseLabel.setRarea(ResponseLabelType.Rarea.ELLIPSE);
            responseLabel.setRrange(ResponseLabelType.Rrange.EXACT);
            responseLabel.setRshuffle(ResponseLabelType.Rshuffle.YES);
            MaterialType mat = responseLabel.addNewMaterial();
            MattextType text = mat.addNewMattext();
            text.setCharset(DEFAULT_CHARSET);
            text.setTexttype("text/plain");
            text.setStringValue(this.cdata(answer.getText()));
            MaterialType m2 = responseLabel.addNewMaterial();
            MatimageType mi = m2.addNewMatimage();
            mi.setEmbedded("base64");
            mi.setImagtype("text/html");
            mi.setUri("");
            c = (char)(c + '\u0001');
        }
    }

    private void addRespProcessing(ItemType item, Question question, String respident) {
        ResprocessingType resProcessing = item.addNewResprocessing();
        DecvarType decvar = resProcessing.addNewOutcomes().addNewDecvar();
        decvar.setDefaultval("0");
        decvar.setMaxvalue(question.getQuestionPoints());
        decvar.setMinvalue("0");
        decvar.setVarname("SCORE");
        decvar.setVartype(DecvarType.Vartype.INTEGER);
        char alpha = 'A';
        if (null != question.getAnswers()) {
            for (Answer answer : question.getAnswers()) {
                String response = answer.isCorrect() ? "Correct" : "InCorrect";
                RespconditionType respCondition = resProcessing.addNewRespcondition();
                respCondition.setContinue(RespconditionType.Continue.NO);
                ConditionvarType conditionVar = respCondition.addNewConditionvar();
                VarequalType varEqual = conditionVar.addNewVarequal();
                varEqual.setCase(VarequalType.Case.YES);
                varEqual.setRespident(respident);
                varEqual.setStringValue(String.valueOf(alpha));
                SetvarType setVar = respCondition.addNewSetvar();
                setVar.setAction(SetvarType.Action.ADD);
                setVar.setVarname("SCORE");
                setVar.setStringValue("0.0");
                DisplayfeedbackType feedback1 = respCondition.addNewDisplayfeedback();
                feedback1.setFeedbacktype(DisplayfeedbackType.Feedbacktype.RESPONSE);
                feedback1.setLinkrefid(response);
                DisplayfeedbackType feedback2 = respCondition.addNewDisplayfeedback();
                feedback2.setFeedbacktype(DisplayfeedbackType.Feedbacktype.RESPONSE);
                feedback2.setLinkrefid("AnswerFeedback");
                feedback2.setStringValue(this.cdata(""));
                alpha = (char)(alpha + '\u0001');
            }
        }
    }

    private void processTrueFalseQuestion(SectionType section, Question question) {
        ItemType item = section.addNewItem();
        item.setTitle("True-False");
        ItemmetadataType itemMetaData = item.addNewItemmetadata();
        QtimetadataType qtiMetaData = itemMetaData.addNewQtimetadata();
        this.buildMetaDataField(qtiMetaData, "qmd_itemtype", "True False");
        this.buildMetaDataField(qtiMetaData, "TEXT_FORMAT", "HTML");
        ItemrubricType itemRubric = item.addNewItemrubric();
        itemRubric.setView(ItemrubricType.View.ALL);
        MattextType mattext = itemRubric.addNewMaterial().addNewMattext();
        mattext.setCharset(DEFAULT_CHARSET);
        mattext.setTexttype("text/plain");
        this.buildPresentationAndResponseLid(item, question, "Resp001", "TF02", ResponseLidType.Rcardinality.SINGLE);
        this.addRespProcessing(item, question, "TF02");
        this.buildItemFeedback(item, "Correct");
        this.buildItemFeedback(item, "InCorrect");
    }

    private void processMultipleChoiceQuestion(SectionType section, Question question) {
        ItemType item = section.addNewItem();
        item.setTitle("Multiple Choice");
        ItemmetadataType itemMetaData = item.addNewItemmetadata();
        QtimetadataType qtiMetaData = itemMetaData.addNewQtimetadata();
        this.buildMetaDataField(qtiMetaData, "qmd_itemtype", "Multiple Choice");
        this.buildMetaDataField(qtiMetaData, "TEXT_FORMAT", "HTML");
        this.buildMetaDataField(qtiMetaData, "hasRationale", "False");
        ItemrubricType itemRubric = item.addNewItemrubric();
        MattextType mattext = itemRubric.addNewMaterial().addNewMattext();
        mattext.setCharset(DEFAULT_CHARSET);
        mattext.setTexttype("text/plain");
        this.buildPresentationAndResponseLid(item, question, "Resp001", "MCSC", ResponseLidType.Rcardinality.SINGLE);
        this.addRespProcessing(item, question, "MCSC");
        int numberOfAnswers = question.getAnswers().size();
        char c = 'A';
        for (int i = 0; i < numberOfAnswers; ++i) {
            this.buildItemFeedback(item, String.valueOf(c) + "1");
            c = (char)(c + '\u0001');
        }
        this.buildItemFeedback(item, "Correct");
        this.buildItemFeedback(item, "InCorrect");
    }

    private void processMultipleChoiceMultipleAnswerQuestion(SectionType section, Question question) {
        ItemType item = section.addNewItem();
        item.setTitle("Multiple Correct");
        ItemmetadataType itemMetaData = item.addNewItemmetadata();
        QtimetadataType qtiMetaData = itemMetaData.addNewQtimetadata();
        this.buildMetaDataField(qtiMetaData, "qmd_itemtype", "Multiple Correct Answer");
        this.buildMetaDataField(qtiMetaData, "TEXT_FORMAT", "HTML");
        this.buildMetaDataField(qtiMetaData, "hasRationale", "False");
        ItemrubricType itemRubric = item.addNewItemrubric();
        MattextType mattext = itemRubric.addNewMaterial().addNewMattext();
        mattext.setCharset(DEFAULT_CHARSET);
        mattext.setTexttype("text/plain");
        this.buildPresentationAndResponseLid(item, question, "Resp001", "MCMC", ResponseLidType.Rcardinality.MULTIPLE);
        this.addRespProcessing(item, question, "MCMC");
        int numberOfAnswers = question.getAnswers().size();
        char c = 'A';
        for (int i = 0; i < numberOfAnswers; ++i) {
            this.buildItemFeedback(item, String.valueOf(c) + "1");
            c = (char)(c + '\u0001');
        }
        this.buildItemFeedback(item, "Correct");
        this.buildItemFeedback(item, "InCorrect");
    }

    private void processFillInQuestion(SectionType section, Question question) {
        ItemType item = section.addNewItem();
        item.setTitle("Fill in the Blank");
        ItemmetadataType itemMetaData = item.addNewItemmetadata();
        QtimetadataType qtiMetaData = itemMetaData.addNewQtimetadata();
        this.buildMetaDataField(qtiMetaData, "qmd_itemtype", "Fill In the Blank");
        this.buildMetaDataField(qtiMetaData, "TEXT_FORMAT", "HTML");
        this.buildMetaDataField(qtiMetaData, "MUTUALLY_EXCLUSIVE", "True");
        ItemrubricType itemRubric = item.addNewItemrubric();
        MattextType mattext = itemRubric.addNewMaterial().addNewMattext();
        mattext.setCharset(DEFAULT_CHARSET);
        mattext.setTexttype("text/plain");
        PresentationType presentation = item.addNewPresentation();
        presentation.setLabel("FIB");
        FlowType flow = presentation.addNewFlow();
        flow.setClass1("Block");
        MaterialType material = flow.addNewMaterial();
        this.buildMattext(material.addNewMattext(), this.cdata(question.getQuestion()));
        MaterialType material2 = flow.addNewMaterial();
        this.buildMattext(material2.addNewMattext());
        ResponseStrType responseStr = flow.addNewResponseStr();
        responseStr.setRcardinality(ResponseStrType.Rcardinality.ORDERED);
        responseStr.setRtiming(ResponseStrType.Rtiming.NO);
        RenderFibType renderFib = responseStr.addNewRenderFib();
        renderFib.setCharset(DEFAULT_CHARSET);
        renderFib.setColumns("5");
        renderFib.setEncoding("UTF_8");
        renderFib.setFibtype(RenderFibType.Fibtype.STRING);
        renderFib.setPrompt(RenderFibType.Prompt.BOX);
        renderFib.setRows("1");
        MaterialType material3 = flow.addNewMaterial();
        this.buildMattext(material3.addNewMattext());
        ResprocessingType resProcessing = item.addNewResprocessing();
        OutcomesType outcomes = resProcessing.addNewOutcomes();
        DecvarType decvar = outcomes.addNewDecvar();
        decvar.setDefaultval("0");
        decvar.setMaxvalue(question.getQuestionPoints());
        decvar.setMinvalue("0");
        decvar.setVarname("SCORE");
        decvar.setVartype(DecvarType.Vartype.INTEGER);
        RespconditionType respCondition = resProcessing.addNewRespcondition();
        respCondition.setContinue(RespconditionType.Continue.YES);
        ConditionvarType condition = respCondition.addNewConditionvar();
        OrType or = condition.addNewOr();
        VarequalType varequal = or.addNewVarequal();
        varequal.setCase(VarequalType.Case.NO);
        varequal.setStringValue(this.cdata(question.getCorrectAnswer()));
        SetvarType setvar = respCondition.addNewSetvar();
        setvar.setAction(SetvarType.Action.ADD);
        setvar.setVarname("SCORE");
        setvar.setStringValue("0");
        this.buildItemFeedback(item, "Correct");
        this.buildItemFeedback(item, "InCorrect");
    }

    private void processShortEssayQuestion(SectionType section, Question question) {
        ItemType item = section.addNewItem();
        item.setTitle("Essay Question");
        ItemmetadataType itemMetaData = item.addNewItemmetadata();
        QtimetadataType qtiMetaData = itemMetaData.addNewQtimetadata();
        this.buildMetaDataField(qtiMetaData, "qmd_itemtype", "Essay");
        this.buildMetaDataField(qtiMetaData, "TEXT_FORMAT", "HTML");
        ItemrubricType itemRubric = item.addNewItemrubric();
        itemRubric.setView(ItemrubricType.View.ALL);
        this.buildMattext(itemRubric.addNewMaterial().addNewMattext());
        PresentationType presentation = item.addNewPresentation();
        presentation.setLabel("Model Short Answer");
        FlowType flow = presentation.addNewFlow();
        flow.setClass1("Block");
        MaterialType material = flow.addNewMaterial();
        this.buildMattext(material.addNewMattext(), this.cdata(question.getQuestion()));
        MaterialType material2 = flow.addNewMaterial();
        this.buildMattext(material2.addNewMattext());
        this.addResponseLid(flow, question, false);
        ResprocessingType resProcessing = item.addNewResprocessing();
        OutcomesType outcomes = resProcessing.addNewOutcomes();
        DecvarType decvar = outcomes.addNewDecvar();
        decvar.setDefaultval("0");
        decvar.setMaxvalue(question.getQuestionPoints());
        decvar.setMinvalue("0");
        decvar.setVarname("SCORE");
        decvar.setVartype(DecvarType.Vartype.INTEGER);
        this.buildItemFeedback(item, "Correct");
        this.buildItemFeedback(item, "InCorrect");
    }
}

