/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ItemFacadeQueries
extends HibernateDaoSupport
implements ItemFacadeQueriesAPI {
    private static Log log = LogFactory.getLog(ItemFacadeQueries.class);

    @Override
    public IdImpl getItemId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(long id) {
        return new IdImpl(id);
    }

    @Override
    public Long add() {
        ItemData item = new ItemData();
        item.setInstruction("Matching game");
        item.setTypeId(TypeFacade.MATCHING);
        item.setScore(Float.valueOf(10.0f));
        item.setDiscount(Float.valueOf(0.0f));
        item.setHasRationale(Boolean.FALSE);
        item.setStatus(Integer.valueOf(1));
        item.setCreatedBy("1");
        item.setCreatedDate(new Date());
        item.setLastModifiedBy("1");
        item.setLastModifiedDate(new Date());
        item.setItemTextSet((Set)this.prepareText(item));
        item.setItemMetaDataSet((Set)this.prepareMetaData(item));
        item.addItemMetaData("ITEM_OBJECTIVE", "the objective is to ...");
        item.setCorrectItemFeedback("well done!");
        item.setInCorrectItemFeedback("better luck next time!");
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)item);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem saving item: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        return item.getItemId();
    }

    @Override
    public List getQPItems(final Long questionPoolId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select ab from ItemData ab, QuestionPoolItem qpi where qpi.itemId=ab.itemIdString and qpi.questionPoolId = ?");
                q.setLong(0, questionPoolId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List list() {
        return this.getHibernateTemplate().find("from ItemData");
    }

    @Override
    public void show(Long itemId) {
        this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
    }

    @Override
    public ItemFacade getItem(Long itemId, String agent) {
        ItemFacade item = new ItemFacade((ItemDataIfc)((ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId)));
        return item;
    }

    @Override
    public void showType(Long typeId) {
        this.getHibernateTemplate().load(TypeD.class, (Serializable)typeId);
    }

    @Override
    public void listType() {
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        TypeFacade f = typeFacadeQueries.getTypeFacadeById(1L);
        log.debug((Object)("***facade: " + f.getAuthority()));
    }

    @Override
    public void remove(Long itemId) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        AssessmentService service = new AssessmentService();
        List itemAttachmentList = service.getItemResourceIdList((ItemDataIfc)item);
        service.deleteResources(itemAttachmentList);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)item);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleting item : " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        if (item != null) {
            this.printItem(item);
        }
    }

    @Override
    public void deleteItem(Long itemId, String agent) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        AssessmentService service = new AssessmentService();
        List itemAttachmentList = service.getItemResourceIdList((ItemDataIfc)item);
        service.deleteResources(itemAttachmentList);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                SectionDataIfc section = item.getSection();
                if (section != null) {
                    Set set = section.getItemSet();
                    set.remove(item);
                }
                this.getHibernateTemplate().delete((Object)item);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleting item: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deleteItemContent(Long itemId, String agent) {
        Set set;
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemTextSet();
                    item.setItemTextSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleteItemTextSet: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemMetaDataSet();
                    item.setItemMetaDataSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleteItemMetaDataSet: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemFeedbackSet();
                    item.setItemFeedbackSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleting ItemFeedbackSet: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deleteItemMetaData(final Long itemId, final String label) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        String query = "from ItemMetaData imd where imd.item.itemId=? and imd.label= ?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemMetaData imd where imd.item.itemId=? and imd.label= ?");
                q.setLong(0, itemId.longValue());
                q.setString(1, label);
                return q.list();
            }
        };
        List itemmetadatalist = this.getHibernateTemplate().executeFind(hcb);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    for (ItemMetaDataIfc meta : itemmetadatalist) {
                        meta.setItem(null);
                    }
                    Set set = item.getItemMetaDataSet();
                    set.removeAll(itemmetadatalist);
                    item.setItemMetaDataSet(set);
                    this.getHibernateTemplate().deleteAll((Collection)itemmetadatalist);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem delete itemmetadatalist: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void addItemMetaData(Long itemId, String label, String value) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        if (item != null) {
            this.printItem(item);
            ItemMetaData itemmetadata = new ItemMetaData((ItemDataIfc)item, label, value);
            int retryCount = PersistenceService.getInstance().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().save((Object)itemmetadata);
                    retryCount = 0;
                }
                catch (Exception e) {
                    log.warn((Object)("problem saving itemmetadata: " + e.getMessage()));
                    retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
                }
            }
        }
    }

    private HashSet prepareText(ItemData item) {
        HashSet<ItemText> textSet = new HashSet<ItemText>();
        ItemText text1 = new ItemText();
        text1.setItem((ItemDataIfc)item);
        text1.setSequence(Long.valueOf(1L));
        text1.setText("cat has");
        HashSet<Answer> answerSet1 = new HashSet<Answer>();
        HashSet<AnswerFeedback> answerFeedbackSet1 = new HashSet<AnswerFeedback>();
        Answer answer1 = new Answer((ItemTextIfc)text1, "2 legs", Long.valueOf(1L), "i", Boolean.FALSE, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        answerFeedbackSet1.add(new AnswerFeedback((AnswerIfc)answer1, "incorrect", "sorry"));
        answer1.setAnswerFeedbackSet(answerFeedbackSet1);
        answerSet1.add(answer1);
        answerSet1.add(new Answer((ItemTextIfc)text1, "3 legs", Long.valueOf(2L), "ii", Boolean.FALSE, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        answerSet1.add(new Answer((ItemTextIfc)text1, "4 legs", Long.valueOf(3L), "iii", Boolean.TRUE, null, Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        text1.setAnswerSet(answerSet1);
        textSet.add(text1);
        ItemText text2 = new ItemText();
        text2.setItem((ItemDataIfc)item);
        text2.setSequence(Long.valueOf(2L));
        text2.setText("chicken has");
        HashSet<Answer> answerSet2 = new HashSet<Answer>();
        answerSet2.add(new Answer((ItemTextIfc)text2, "2 legs", Long.valueOf(1L), "i", Boolean.TRUE, null, Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        answerSet2.add(new Answer((ItemTextIfc)text2, "3 legs", Long.valueOf(2L), "ii", Boolean.FALSE, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        answerSet2.add(new Answer((ItemTextIfc)text2, "4 legs", Long.valueOf(3L), "iii", Boolean.FALSE, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        text2.setAnswerSet(answerSet2);
        textSet.add(text2);
        ItemText text3 = new ItemText();
        text3.setItem((ItemDataIfc)item);
        text3.setSequence(Long.valueOf(3L));
        text3.setText("baby has");
        HashSet<Answer> answerSet3 = new HashSet<Answer>();
        answerSet3.add(new Answer((ItemTextIfc)text3, "2 legs", Long.valueOf(1L), "i", Boolean.FALSE, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        answerSet3.add(new Answer((ItemTextIfc)text3, "3 legs", Long.valueOf(2L), "ii", Boolean.FALSE, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        answerSet3.add(new Answer((ItemTextIfc)text3, "4 legs", Long.valueOf(3L), "iii", Boolean.TRUE, null, Float.valueOf(5.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        text3.setAnswerSet(answerSet3);
        textSet.add(text3);
        return textSet;
    }

    private HashSet prepareMetaData(ItemData item) {
        HashSet<ItemMetaData> set = new HashSet<ItemMetaData>();
        set.add(new ItemMetaData((ItemDataIfc)item, "qmd_itemtype", "Matching"));
        set.add(new ItemMetaData((ItemDataIfc)item, "TEXT_FORMAT", "HTML"));
        set.add(new ItemMetaData((ItemDataIfc)item, "MUTUALLY_EXCLUSIVE", "True"));
        return set;
    }

    private void printItem(ItemData item) {
        log.debug((Object)("**Id = " + item.getItemId()));
        log.debug((Object)("**score = " + item.getScore()));
        log.debug((Object)("**grade = " + item.getGrade()));
        log.debug((Object)("**CorrectFeedback is lazy = " + item.getCorrectItemFeedback()));
        log.debug((Object)("**Objective not lazy = " + item.getItemMetaDataByLabel("ITEM_OBJECTIVE")));
    }

    @Override
    public Long facadeAdd() throws DataFacadeException {
        ItemFacade item = new ItemFacade();
        item.setInstruction("Matching game");
        item.setTypeId(9L);
        item.setScore(Float.valueOf(10.0f));
        item.setDiscount(Float.valueOf(0.0f));
        item.setHasRationale(Boolean.FALSE);
        item.setStatus(1);
        item.setCreatedBy("1");
        item.setCreatedDate(new Date());
        item.setLastModifiedBy("1");
        item.setLastModifiedDate(new Date());
        item.setItemTextSet(this.prepareText((ItemData)item.getData()));
        item.addItemText("I have", new HashSet());
        item.setItemMetaDataSet(this.prepareMetaData((ItemData)item.getData()));
        item.addItemMetaData("ITEM_OBJECTIVE", "the objective is to ...");
        item.setCorrectItemFeedback("well done!");
        item.setInCorrectItemFeedback("better luck next time!");
        this.getHibernateTemplate().save((Object)item.getData());
        return item.getData().getItemId();
    }

    @Override
    public void ifcShow(Long itemId) {
        ItemDataIfc itemData = (ItemDataIfc)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        if (itemData != null) {
            this.printIfcItem(itemData);
            this.printFacadeItem(itemData);
        }
    }

    @Override
    public ItemFacade saveItem(ItemFacade item) throws DataFacadeException {
        try {
            ItemDataIfc itemdata = item.getData();
            itemdata.setLastModifiedDate(new Date());
            itemdata.setLastModifiedBy(AgentFacade.getAgentString());
            int retryCount = PersistenceService.getInstance().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().saveOrUpdate((Object)itemdata);
                    item.setItemId(itemdata.getItemId());
                    retryCount = 0;
                }
                catch (Exception e) {
                    log.warn((Object)("problem save or update itemdata: " + e.getMessage()));
                    retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
                }
            }
            if (item.getData() != null && item.getData().getSection() != null) {
                AssessmentIfc assessment = item.getData().getSection().getAssessment();
                assessment.setLastModifiedBy(AgentFacade.getAgentString());
                assessment.setLastModifiedDate(new Date());
                retryCount = PersistenceService.getInstance().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)assessment);
                        retryCount = 0;
                    }
                    catch (Exception e) {
                        log.warn((Object)("problem updating asssessment: " + e.getMessage()));
                        retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
                    }
                }
            }
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void printIfcItem(ItemDataIfc item) {
        log.debug((Object)("**Id = " + item.getItemId()));
        log.debug((Object)("**score = " + item.getScore()));
        log.debug((Object)("**grade = " + item.getGrade()));
        log.debug((Object)("**CorrectFeedback is lazy = " + item.getCorrectItemFeedback()));
        log.debug((Object)("**Objective not lazy = " + item.getItemMetaDataByLabel("ITEM_OBJECTIVE")));
        log.debug((Object)("**createdDate = " + item.getCreatedDate()));
    }

    private void printFacadeItem(ItemDataIfc item) {
        ItemFacade f = new ItemFacade(item);
        log.debug((Object)("****Id = " + f.getItemId()));
        log.debug((Object)("****score = " + f.getScore()));
        log.debug((Object)("****grade = " + f.getGrade()));
        log.debug((Object)("****CorrectFeedback is lazy = " + f.getCorrectItemFeedback()));
        log.debug((Object)("****Objective not lazy = " + f.getItemMetaDataByLabel("ITEM_OBJECTIVE")));
        log.debug((Object)("****createdDate = " + f.getCreatedDate()));
        log.debug((Object)("****ItemType = " + f.getItemType().getKeyword()));
    }

    @Override
    public ItemFacade getItem(Long itemId) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        return new ItemFacade((ItemDataIfc)item);
    }

    @Override
    public HashMap getItemsByKeyword(final String keyword) {
        ItemFacade f;
        ItemData a;
        int i;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select ab from ItemData ab, ItemText itext where itext.item=ab and itext.text like ? ");
                q.setString(0, keyword);
                return q.list();
            }
        };
        List list1 = this.getHibernateTemplate().executeFind(hcb);
        HibernateCallback hcb2 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select distinct ab from ItemData ab, Answer answer where answer.item=ab and answer.text like ? ");
                q.setString(0, keyword);
                return q.list();
            }
        };
        List list2 = this.getHibernateTemplate().executeFind(hcb2);
        HibernateCallback hcb3 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select ab from ItemData ab, ItemMetaData md where md.item=ab and md.entry like ?  and md.label= ? ");
                q.setString(0, keyword);
                q.setString(1, "KEYWORD");
                return q.list();
            }
        };
        List list3 = this.getHibernateTemplate().executeFind(hcb3);
        HibernateCallback hcb4 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select ab from ItemData ab where ab.instruction like ?  ");
                q.setString(0, keyword);
                return q.list();
            }
        };
        List list4 = this.getHibernateTemplate().executeFind(hcb4);
        HashMap<String, ItemFacade> itemfacadeMap = new HashMap<String, ItemFacade>();
        for (i = 0; i < list1.size(); ++i) {
            a = (ItemData)list1.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list2.size(); ++i) {
            a = (ItemData)list2.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list3.size(); ++i) {
            a = (ItemData)list3.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list4.size(); ++i) {
            a = (ItemData)list4.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        log.debug((Object)("Search for keyword, found: " + itemfacadeMap.size()));
        return itemfacadeMap;
    }

    @Override
    public Long getItemTextId(final Long publishedItemId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i.id from PublishedItemText i where i.item.itemId = ?");
                q.setLong(0, publishedItemId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        log.debug((Object)("list.size() = " + list.size()));
        Long itemTextId = (Long)list.get(0);
        log.debug((Object)("itemTextId" + itemTextId));
        return itemTextId;
    }

    @Override
    public void deleteSet(Set s) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (s != null) {
                    this.getHibernateTemplate().deleteAll((Collection)s);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem deleteSet: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }
}

