/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PathHashUtil {
    private static final Log log = LogFactory.getLog(PathHashUtil.class);
    private static char[] encode = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static ThreadLocal<MessageDigest> digest = new ThreadLocal();

    public static String hash(String nodePath) {
        MessageDigest mdigest = digest.get();
        if (mdigest == null) {
            try {
                mdigest = MessageDigest.getInstance("SHA1");
                digest.set(mdigest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failed to find SHA1 message digest: " + e, e);
            }
        }
        byte[] b = mdigest.digest(nodePath.getBytes());
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[i * 2] = encode[b[i] & 0xF];
            c[i * 2 + 1] = encode[b[i] >> 4 & 0xF];
        }
        String encoded = new String(c);
        log.debug((Object)("Encoded " + nodePath + " as " + encoded));
        return encoded;
    }
}

