/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.user.api.Authentication;
import org.sakaiproject.user.api.AuthenticationException;
import org.sakaiproject.user.cover.AuthenticationManager;
import org.sakaiproject.util.IdPwEvidence;

public class BasicAuth {
    public static final String BASIC_AUTH_LOGIN_REQUEST = "__auth=basic";
    public static Pattern[] patterns = null;
    private static String[] match;
    private static String[] matchPatterns;

    public void init() {
        String check;
        String line;
        ArrayList<Pattern> pat = new ArrayList<Pattern>();
        ArrayList<String> mat = new ArrayList<String>();
        String[] morepatterns = null;
        try {
            morepatterns = ServerConfigurationService.getStrings((String)"login.browser.user.agent");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (morepatterns != null) {
            for (int i = 0; i < morepatterns.length; ++i) {
                line = morepatterns[i];
                if (line == null || line.length() <= 0) continue;
                check = line.substring(0, 1);
                mat.add(check);
                line = line.substring(1);
                pat.add(Pattern.compile(line));
            }
        }
        for (int i = 0; i < matchPatterns.length; ++i) {
            line = matchPatterns[i];
            check = line.substring(0, 1);
            mat.add(check);
            line = line.substring(1);
            pat.add(Pattern.compile(line));
        }
        patterns = new Pattern[pat.size()];
        patterns = pat.toArray(patterns);
        match = new String[mat.size()];
        match = mat.toArray(match);
    }

    protected boolean isBrowser(String userAgentHeader) {
        if (userAgentHeader == null) {
            return false;
        }
        if (patterns != null) {
            for (int i = 0; i < patterns.length; ++i) {
                Matcher m = patterns[i].matcher(userAgentHeader);
                if (!m.matches()) continue;
                return "1".equals(match[i]);
            }
            return true;
        }
        return true;
    }

    protected boolean requestedBasicAuth(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        boolean ret = queryString.indexOf(BASIC_AUTH_LOGIN_REQUEST) != -1;
        return ret;
    }

    protected boolean doBasicAuth(HttpServletRequest req) {
        boolean allowBasicAuth = ServerConfigurationService.getBoolean((String)"allow.basic.auth.login", (boolean)false);
        if (allowBasicAuth) {
            allowBasicAuth = this.requestedBasicAuth(req) || !this.isBrowser(req.getHeader("User-Agent"));
        }
        return allowBasicAuth;
    }

    public boolean doLogin(HttpServletRequest req) throws IOException {
        if (this.doBasicAuth(req)) {
            String auth = req.getHeader("Authorization");
            IdPwEvidence e = null;
            try {
                if (auth != null && (auth = auth.trim()).startsWith("Basic ")) {
                    auth = auth.substring(6).trim();
                    int colon = (auth = new String(Base64.decodeBase64((byte[])auth.getBytes("UTF-8")))).indexOf(":");
                    if (colon != -1) {
                        String eid = auth.substring(0, colon);
                        String pw = auth.substring(colon + 1);
                        if (eid.length() > 0 && pw.length() > 0) {
                            e = new IdPwEvidence(eid, pw);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                if (e == null) {
                    throw new AuthenticationException("missing required fields");
                }
                Authentication a = AuthenticationManager.authenticate(e);
                return UsageSessionService.login((Authentication)a, (HttpServletRequest)req);
            }
            catch (AuthenticationException ex) {
                return false;
            }
        }
        return true;
    }

    public boolean doAuth(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.doBasicAuth(req)) {
            String uiService = ServerConfigurationService.getString((String)"ui.service");
            res.addHeader("WWW-Authenticate", "Basic realm=\"" + uiService + "\"");
            res.sendError(401, "Authorization Required");
            return true;
        }
        return false;
    }

    static {
        matchPatterns = new String[]{"0.*Thunderbird.*", "1Mozilla.*", "0i[tT]unes.*", "0Jakarta Commons-HttpClient.*", "0.*Googlebot/2.1.*", "0[gG]oogle[bB]ot.*", "0curl.*"};
    }
}

