/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.shared.AgentDataIfc;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.AgentHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.AgentImpl;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;

public class AgentFacade
implements Serializable,
AgentDataIfc {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(AgentFacade.class);
    private static final AgentHelper helper = IntegrationContextFactory.getInstance().getAgentHelper();
    private static final boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
    private AgentImpl agent;
    private String agentString;
    private String eid;
    private boolean accessViaUrl;

    public AgentFacade(String agentId) {
        this.agent = new AgentImpl(agentId, null, new IdImpl(agentId));
        this.agentString = agentId;
        this.eid = helper.getEid(agentId);
    }

    public AgentFacade() {
        String agentId = helper.getAgentString("UNASSIGNED");
        this.agent = new AgentImpl(agentId, null, new IdImpl(agentId));
        this.agentString = agentId;
        this.eid = helper.getEid("UNASSIGNED");
    }

    public static AgentImpl getAgent() {
        return helper.getAgent();
    }

    public static String getAgentString() {
        AgentFacade facade = new AgentFacade();
        return facade.agentString;
    }

    public static String getEid() {
        AgentFacade facade = new AgentFacade();
        return facade.eid;
    }

    public String getAgentInstanceString() {
        return this.agentString;
    }

    public String getEidString() {
        log.debug((Object)("agentfacade.getEid(agentS) agentString = " + this.agentString));
        return helper.getEidById(this.agentString);
    }

    public static String getDisplayName(String agentS) {
        return helper.getDisplayName(agentS);
    }

    public String getDisplayName() {
        return helper.getDisplayName(this.agentString);
    }

    public String getFirstName() {
        return helper.getFirstName(this.agentString);
    }

    public String getLastName() {
        return helper.getLastName(this.agentString);
    }

    public String getEmail() {
        return helper.getEmail(this.agentString);
    }

    public String getRole() {
        return helper.getRoleForCurrentAgent(this.agentString);
    }

    public static String getRole(String agentString) {
        return helper.getRole(agentString);
    }

    public static String getCurrentSiteId() {
        AgentFacade facade = new AgentFacade();
        boolean accessViaUrl = facade.isAccessViaUrl();
        return helper.getCurrentSiteId(accessViaUrl);
    }

    public static String getCurrentSiteName() {
        AgentFacade facade = new AgentFacade();
        boolean accessViaUrl = facade.isAccessViaUrl();
        return helper.getCurrentSiteName(accessViaUrl);
    }

    public static String getSiteName(String siteId) {
        return helper.getSiteName(siteId);
    }

    public String getIdString() {
        return this.agentString;
    }

    public static String getDisplayNameByAgentId(String agentId) {
        return helper.getDisplayNameByAgentId(agentId);
    }

    public static String createAnonymous() {
        AgentFacade facade = new AgentFacade();
        return helper.createAnonymous(facade);
    }

    public static boolean isStandaloneEnvironment() {
        return !integrated;
    }

    public static boolean isIntegratedEnvironment() {
        return integrated;
    }

    public static String getAnonymousId() {
        AgentFacade facade = new AgentFacade();
        String agentString = facade.getAgentInstanceString();
        return helper.getAnonymousId(agentString);
    }

    public void setIdString(String idString) {
        this.agentString = idString;
    }

    public static Map getUserRolesFromContextRealm(Collection inUsers) {
        return helper.getUserRolesFromContextRealm(inUsers);
    }

    public static String getRoleForAgentAndSite(String agentString, String siteId) {
        return helper.getRoleForAgentAndSite(agentString, siteId);
    }

    public boolean isAccessViaUrl() {
        return this.agentString.startsWith("anonymous_");
    }

    public void setAccessViaUrl(boolean accessViaUrl) {
        this.accessViaUrl = accessViaUrl;
    }

    public void setAgentInstanceString(String agentInstanceString) {
        this.agentString = agentInstanceString;
    }

    public static boolean isFileUploadAvailable() {
        return helper.isFileUploadAvailable();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AgentFacade) {
            return ((AgentFacade)obj).agentString.equals(this.agentString);
        }
        return false;
    }
}

