/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolAccessData;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolData;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolDataIfc;
import org.sakaiproject.tool.assessment.data.model.Tree;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacade;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.QuestionPoolIteratorFacade;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class QuestionPoolFacadeQueries
extends HibernateDaoSupport
implements QuestionPoolFacadeQueriesAPI {
    private static Log log = LogFactory.getLog(QuestionPoolFacadeQueries.class);

    @Override
    public IdImpl getQuestionPoolId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getQuestionPoolId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getQuestionPoolId(long id) {
        return new IdImpl(id);
    }

    @Override
    public List getAllPools() {
        return this.getHibernateTemplate().find("from QuestionPoolData");
    }

    public List getAllPoolsByAgent(final String agentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from QuestionPoolData a  where a.questionPoolId in (select ac.questionPoolId from QuestionPoolAccessData ac where agentId= ?) ");
                q.setString(0, agentId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        return list;
    }

    @Override
    public QuestionPoolIteratorFacade getAllPools(String agentId) {
        ArrayList<QuestionPoolFacade> qpList = new ArrayList<QuestionPoolFacade>();
        List poolList = this.getHibernateTemplate().find("from QuestionPoolData a where a.ownerId= ? ", new Object[]{agentId});
        try {
            HashMap<Long, Integer> counts = new HashMap<Long, Integer>();
            for (Object[] result : this.getSubPoolSizes(agentId)) {
                counts.put((Long)result[0], (Integer)result[1]);
            }
            for (QuestionPoolData qpp : poolList) {
                Integer subPoolSize = (Integer)counts.get((long)qpp.getQuestionPoolId());
                if (subPoolSize == null) {
                    qpp.setSubPoolSize(Integer.valueOf(0));
                } else {
                    qpp.setSubPoolSize(subPoolSize);
                }
                qpList.add(this.getQuestionPool(qpp));
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        return new QuestionPoolIteratorFacade(qpList);
    }

    @Override
    public QuestionPoolIteratorFacade getAllPoolsWithAccess(String agentId) {
        ArrayList<QuestionPoolFacade> qpList = new ArrayList<QuestionPoolFacade>();
        List poolList = this.getAllPoolsByAgent(agentId);
        try {
            for (QuestionPoolData qpp : poolList) {
                qpp.setSubPoolSize(Integer.valueOf(this.getSubPoolSize(qpp.getQuestionPoolId())));
                qpList.add(this.getQuestionPool(qpp));
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
            log.warn((Object)e.getStackTrace());
        }
        return new QuestionPoolIteratorFacade(qpList);
    }

    @Override
    public ArrayList getBasicInfoOfAllPools(final String agentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new QuestionPoolData(a.questionPoolId, a.title)from QuestionPoolData a where a.questionPoolId  in (select ac.questionPoolId from QuestionPoolAccessData ac where agentId= ?)");
                q.setString(0, agentId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<QuestionPoolFacade> poolList = new ArrayList<QuestionPoolFacade>();
        for (int i = 0; i < list.size(); ++i) {
            QuestionPoolData a = (QuestionPoolData)list.get(i);
            QuestionPoolFacade f = new QuestionPoolFacade(a.getQuestionPoolId(), a.getTitle());
            poolList.add(f);
        }
        return poolList;
    }

    private QuestionPoolFacade getQuestionPool(QuestionPoolData qpp) {
        try {
            return new QuestionPoolFacade((QuestionPoolDataIfc)qpp);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
            return null;
        }
    }

    private List getAllItemsInThisPoolOnlyAndDetachFromAssessment(Long questionPoolId) {
        List list = this.getAllItemsInThisPoolOnly(questionPoolId);
        ArrayList<ItemData> newlist = new ArrayList<ItemData>();
        for (int i = 0; i < list.size(); ++i) {
            ItemData itemdata = (ItemData)list.get(i);
            if (itemdata.getSection() == null) {
                newlist.add(itemdata);
                continue;
            }
            itemdata.removeMetaDataByType("POOLID");
            this.getHibernateTemplate().saveOrUpdate((Object)itemdata);
        }
        return newlist;
    }

    private List getAllItemsInThisPoolOnly(final Long questionPoolId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi where ab.itemId=qpi.itemId and qpi.questionPoolId = ?");
                q.setLong(0, questionPoolId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<ItemData> newlist = new ArrayList<ItemData>();
        for (int i = 0; i < list.size(); ++i) {
            ItemData itemdata = (ItemData)list.get(i);
            String itemId = itemdata.getItemId().toString();
            if (this.getPoolIdsByItem(itemId).size() != 1) continue;
            newlist.add(itemdata);
        }
        return newlist;
    }

    @Override
    public List getAllItems(final Long questionPoolId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi where ab.itemId=qpi.itemId and qpi.questionPoolId = ?");
                q.setLong(0, questionPoolId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        return list;
    }

    @Override
    public List getAllItemFacadesOrderByItemText(Long questionPoolId, String orderBy, String ascending) {
        ItemFacade itemFacade;
        log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: orderBy=" + orderBy));
        List list = this.getAllItems(questionPoolId);
        log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: size = " + list.size()));
        HashMap<String, Vector<Integer>> hp = new HashMap<String, Vector<Integer>>();
        Vector<ItemFacade> facadeVector = new Vector<ItemFacade>();
        for (int i = 0; i < list.size(); ++i) {
            log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: i = " + i));
            ItemData itemData = (ItemData)list.get(i);
            itemFacade = new ItemFacade((ItemDataIfc)itemData);
            facadeVector.add(itemFacade);
            log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: getItemId = " + itemData.getItemId()));
            log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: getText = " + itemData.getText()));
            String text = itemFacade.getTextHtmlStrippedAll();
            log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: getTextHtmlStrippedAll = '" + text + "'"));
            Vector<Integer> origValueV = (Vector<Integer>)hp.get(text);
            if (origValueV == null) {
                log.debug((Object)"QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: origValueV is null ");
                origValueV = new Vector<Integer>();
            }
            origValueV.add(i);
            hp.put(text, origValueV);
        }
        Vector v = new Vector(hp.keySet());
        Collections.sort(v, String.CASE_INSENSITIVE_ORDER);
        ArrayList<ItemFacade> itemList = new ArrayList<ItemFacade>();
        Iterator it = v.iterator();
        if (ascending != null && "false".equals(ascending)) {
            for (int l = v.size() - 1; l >= 0; --l) {
                String key = (String)v.get(l);
                Vector orderdValueV = (Vector)hp.get(key);
                for (Integer value : orderdValueV) {
                    ItemData itemdata = (ItemData)list.get(value);
                    ItemFacade f = new ItemFacade((ItemDataIfc)itemdata);
                    itemList.add(f);
                }
            }
        } else {
            while (it.hasNext()) {
                String key = (String)it.next();
                Vector orderdValueV = (Vector)hp.get(key);
                for (Integer value : orderdValueV) {
                    log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemText:: sorted (value) = " + value));
                    itemFacade = (ItemFacade)facadeVector.get(value);
                    itemList.add(itemFacade);
                }
            }
        }
        return itemList;
    }

    @Override
    public List getAllItemFacadesOrderByItemType(final Long questionPoolId, final String orderBy, final String ascending) {
        log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemType:: orderBy=" + orderBy));
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = "false".equals(ascending) ? session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi, TypeD t where ab.itemId=qpi.itemId and ab.typeId=t.typeId and qpi.questionPoolId = ? order by t." + orderBy + " desc") : session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi, TypeD t where ab.itemId=qpi.itemId and ab.typeId=t.typeId and qpi.questionPoolId = ? order by t." + orderBy);
                q.setLong(0, questionPoolId.longValue());
                log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemType:: getQueryString() = " + q.getQueryString()));
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        log.debug((Object)("QuestionPoolFacadeQueries: getAllItemFacadesOrderByItemType:: size = " + list.size()));
        ArrayList<ItemFacade> itemList = new ArrayList<ItemFacade>();
        for (int i = 0; i < list.size(); ++i) {
            ItemData itemdata = (ItemData)list.get(i);
            ItemFacade f = new ItemFacade((ItemDataIfc)itemdata);
            itemList.add(f);
        }
        return itemList;
    }

    @Override
    public List getAllItemFacades(final Long questionPoolId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select ab from ItemData ab, QuestionPoolItemData qpi where ab.itemId=qpi.itemId and qpi.questionPoolId = ?");
                q.setLong(0, questionPoolId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<ItemFacade> itemList = new ArrayList<ItemFacade>();
        for (int i = 0; i < list.size(); ++i) {
            ItemData itemdata = (ItemData)list.get(i);
            ItemFacade f = new ItemFacade((ItemDataIfc)itemdata);
            itemList.add(f);
        }
        return itemList;
    }

    private void populateQuestionPoolItemDatas(QuestionPoolData qpp) {
        try {
            Set questionPoolItems = qpp.getQuestionPoolItems();
            if (questionPoolItems != null) {
                HashMap<String, ItemData> h = new HashMap<String, ItemData>();
                List itemList = this.getAllItems(qpp.getQuestionPoolId());
                for (ItemData itemData : itemList) {
                    h.put(itemData.getItemIdString(), itemData);
                }
                ArrayList<ItemData> itemArrayList = new ArrayList<ItemData>();
                for (QuestionPoolItemData questionPoolItem : questionPoolItems) {
                    ItemData itemData_0 = (ItemData)h.get(questionPoolItem.getItemId());
                    itemArrayList.add(itemData_0);
                }
                qpp.setQuestions(itemArrayList);
                qpp.setSubPoolSize(Integer.valueOf(this.getSubPoolSize(qpp.getQuestionPoolId())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ItemFacade getItem(String id) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)((Object)id));
        return new ItemFacade((ItemDataIfc)item);
    }

    @Override
    public QuestionPoolFacade getPool(Long poolId, String agent) {
        try {
            QuestionPoolData qpp = (QuestionPoolData)this.getHibernateTemplate().load(QuestionPoolData.class, (Serializable)poolId);
            this.setPoolAccessType(qpp, agent);
            this.populateQuestionPoolItemDatas(qpp);
            return this.getQuestionPool(qpp);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    public void setPoolAccessType(QuestionPoolData qpp, String agentId) {
        try {
            QuestionPoolAccessData qpa = this.getQuestionPoolAccessData(qpp.getQuestionPoolId(), agentId);
            if (qpa != null) {
                qpp.setAccessTypeId(qpa.getAccessTypeId());
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
    }

    @Override
    public QuestionPoolAccessData getQuestionPoolAccessData(final Long poolId, final String agentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from QuestionPoolAccessData as qpa where qpa.questionPoolId =? and qpa.agentId=?");
                q.setLong(0, poolId.longValue());
                q.setString(1, agentId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        return (QuestionPoolAccessData)list.get(0);
    }

    @Override
    public void addItemsToSection(Collection ids, long sectionId) {
    }

    @Override
    public void addItemToPool(QuestionPoolItemData qpi) {
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)qpi);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem saving item to pool: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deletePool(final Long poolId, String agent, Tree tree) {
        try {
            Object hcb;
            QuestionPoolData questionPool = (QuestionPoolData)this.getHibernateTemplate().load(QuestionPoolData.class, (Serializable)poolId);
            List itemList = this.getAllItemsInThisPoolOnlyAndDetachFromAssessment(poolId);
            int retryCount = PersistenceService.getInstance().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().deleteAll((Collection)itemList);
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn((Object)("problem delete all items in pool: " + e.getMessage()));
                    retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            retryCount = PersistenceService.getInstance().getRetryCount();
            while (retryCount > 0) {
                try {
                    hcb = new HibernateCallback(){

                        public Object doInHibernate(Session session) throws HibernateException, SQLException {
                            Query q = session.createQuery("select qpi from QuestionPoolItemData as qpi where qpi.questionPoolId= ?");
                            q.setLong(0, poolId.longValue());
                            return q.list();
                        }
                    };
                    List list = this.getHibernateTemplate().executeFind(hcb);
                    ArrayList metaList = new ArrayList();
                    for (int j = 0; j < list.size(); ++j) {
                        String itemId = ((QuestionPoolItemData)list.get(j)).getItemId();
                        String query = "from ItemMetaData as meta where meta.item.itemId=? and meta.label=?";
                        Object[] values = new Object[]{Long.valueOf(itemId), "POOLID"};
                        List m = this.getHibernateTemplate().find(query, values);
                        if (m.size() <= 0) continue;
                        ItemMetaDataIfc meta = (ItemMetaDataIfc)m.get(0);
                        meta.setEntry(null);
                    }
                    try {
                        this.getHibernateTemplate().saveOrUpdateAll(metaList);
                        retryCount = 0;
                    }
                    catch (DataAccessException e) {
                        log.warn((Object)("problem delete question and questionpool map inside itemMetaData: " + e.getMessage()));
                        retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                    }
                    if (list.size() > 0) {
                        questionPool.setQuestionPoolItems(new HashSet());
                        this.getHibernateTemplate().deleteAll((Collection)list);
                        retryCount = 0;
                        continue;
                    }
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn((Object)("problem delete question and questionpool map: " + e.getMessage()));
                    retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select qpa from QuestionPoolAccessData as qpa, QuestionPoolData as qpp where qpa.questionPoolId = qpp.questionPoolId and (qpp.questionPoolId=? or qpp.parentPoolId=?) ");
                    q.setLong(0, poolId.longValue());
                    q.setLong(1, poolId.longValue());
                    return q.list();
                }
            };
            List qpaList = this.getHibernateTemplate().executeFind(hcb);
            retryCount = PersistenceService.getInstance().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().deleteAll((Collection)qpaList);
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn((Object)("problem delete question pool access data: " + e.getMessage()));
                    retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            HibernateCallback hcb2 = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select qp from QuestionPoolData as qp where qp.id= ?");
                    q.setLong(0, poolId.longValue());
                    return q.list();
                }
            };
            List qppList = this.getHibernateTemplate().executeFind(hcb2);
            retryCount = PersistenceService.getInstance().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().deleteAll((Collection)qppList);
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn((Object)("problem delete all pools: " + e.getMessage()));
                    retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            Iterator citer = tree.getChildList(poolId).iterator();
            while (citer.hasNext()) {
                this.deletePool((Long)citer.next(), agent, tree);
            }
        }
        catch (DataAccessException e) {
            log.warn((Object)("error deleting pool. " + e.getMessage()));
        }
    }

    @Override
    public void movePool(String agentId, Long sourcePoolId, Long destPoolId) {
        try {
            QuestionPoolFacade sourcePool = this.getPool(sourcePoolId, agentId);
            if (destPoolId.equals(QuestionPoolFacade.ROOT_POOL) && !sourcePoolId.equals(QuestionPoolFacade.ROOT_POOL)) {
                sourcePool.setParentPoolId(QuestionPoolFacade.ROOT_POOL);
                int retryCount = PersistenceService.getInstance().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)((QuestionPoolData)sourcePool.getData()));
                        retryCount = 0;
                    }
                    catch (DataAccessException e) {
                        log.warn((Object)("problem moving pool: " + e.getMessage()));
                        retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                    }
                }
            } else {
                QuestionPoolFacade destPool = this.getPool(destPoolId, agentId);
                sourcePool.setParentPoolId(destPool.getQuestionPoolId());
                int retryCount = PersistenceService.getInstance().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)((QuestionPoolData)sourcePool.getData()));
                        retryCount = 0;
                    }
                    catch (DataAccessException e) {
                        log.warn((Object)("problem update source pool: " + e.getMessage()));
                        retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            log.warn((Object)e.getMessage());
        }
    }

    @Override
    public boolean isDescendantOf(QuestionPoolFacade destPool, QuestionPoolFacade sourcePool) {
        Long tempPoolId = destPool.getQuestionPoolId();
        try {
            while (tempPoolId != null && !tempPoolId.equals(QuestionPoolFacade.ROOT_POOL)) {
                QuestionPoolFacade tempPool = this.getPoolById(tempPoolId);
                if (tempPool.getParentPoolId().equals(sourcePool.getQuestionPoolId())) {
                    return true;
                }
                tempPoolId = tempPool.getParentPoolId();
            }
            return false;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
            return false;
        }
    }

    @Override
    public void removeItemFromPool(String itemId, Long poolId) {
        QuestionPoolItemData qpi = new QuestionPoolItemData(poolId, itemId);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)qpi);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem delete item from pool: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void moveItemToPool(String itemId, Long sourceId, Long destId) {
        QuestionPoolItemData qpi = new QuestionPoolItemData(sourceId, itemId);
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)qpi);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem delete old mapping: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
        QuestionPoolItemData qpi2 = new QuestionPoolItemData(destId, itemId);
        retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)qpi2);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn((Object)("problem saving new mapping: " + e.getMessage()));
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public QuestionPoolFacade savePool(QuestionPoolFacade pool) {
        boolean insert = false;
        try {
            QuestionPoolData qpp = (QuestionPoolData)pool.getData();
            qpp.setLastModified(new Date());
            qpp.setLastModifiedById(AgentFacade.getAgentString());
            int retryCount = PersistenceService.getInstance().getRetryCount();
            if (qpp.getQuestionPoolId() == null || qpp.getQuestionPoolId().equals(new Long("0"))) {
                insert = true;
            }
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().saveOrUpdate((Object)qpp);
                    retryCount = 0;
                }
                catch (DataAccessException e) {
                    log.warn((Object)("problem saving Or Update pool: " + e.getMessage()));
                    retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                }
            }
            if (insert) {
                QuestionPoolAccessData qpa = new QuestionPoolAccessData(qpp.getQuestionPoolId(), qpp.getOwnerId(), QuestionPoolData.ADMIN);
                retryCount = PersistenceService.getInstance().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().save((Object)qpa);
                        retryCount = 0;
                    }
                    catch (DataAccessException e) {
                        log.warn((Object)("problem saving pool: " + e.getMessage()));
                        retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                    }
                }
                long parentPoolId = qpp.getParentPoolId();
                String ownerId = qpp.getOwnerId();
                if (parentPoolId != 0L) {
                    List listSubpool = new ArrayList();
                    try {
                        listSubpool = this.getHibernateTemplate().find("from QuestionPoolAccessData as qpa where qpa.questionPoolId=? and qpa.agentId<>?", new Object[]{parentPoolId, ownerId});
                    }
                    catch (Exception e1) {
                        log.warn((Object)("problem finding pool: " + e1.getMessage()));
                    }
                    for (QuestionPoolAccessData questioPoolData : listSubpool) {
                        qpa = new QuestionPoolAccessData(qpp.getQuestionPoolId(), questioPoolData.getAgentId(), QuestionPoolData.READ_COPY);
                        retryCount = PersistenceService.getInstance().getRetryCount();
                        while (retryCount > 0) {
                            try {
                                this.getHibernateTemplate().save((Object)qpa);
                                retryCount = 0;
                            }
                            catch (DataAccessException e) {
                                log.warn((Object)("problem saving pool: " + e.getMessage()));
                                retryCount = PersistenceService.getInstance().retryDeadlock((Exception)((Object)e), retryCount);
                            }
                        }
                    }
                }
            }
            return pool;
        }
        catch (RuntimeException e) {
            log.warn((Object)e.getMessage());
            return null;
        }
    }

    @Override
    public List getSubPools(final Long poolId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from QuestionPoolData as qpp where qpp.parentPoolId=?");
                q.setLong(0, poolId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public List getSubPoolSizes(final String agent) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.questionPoolId, (select count(*) from QuestionPoolData b where b.parentPoolId=a.questionPoolId) from QuestionPoolData a where a.ownerId=?");
                q.setString(0, agent);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public int getSubPoolSize(final Long poolId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(qpp) from QuestionPoolData qpp where qpp.parentPoolId=?");
                q.setLong(0, poolId.longValue());
                return q.uniqueResult();
            }
        };
        Integer count = (Integer)this.getHibernateTemplate().execute(hcb);
        return count;
    }

    @Override
    public boolean hasSubPools(Long poolId) {
        int poolSize = this.getSubPoolSize(poolId);
        return poolSize >= 0;
    }

    @Override
    public boolean poolIsUnique(final Long questionPoolId, final String title, final Long parentPoolId, final String agentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new QuestionPoolData(a.questionPoolId, a.title, a.parentPoolId)from QuestionPoolData a where a.questionPoolId!= ? and a.title=? and a.parentPoolId=? and a.ownerId = ? ");
                q.setLong(0, questionPoolId.longValue());
                q.setString(1, title);
                q.setLong(2, parentPoolId.longValue());
                q.setString(3, agentId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        boolean isUnique = true;
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                QuestionPoolData q = (QuestionPoolData)list.get(i);
                if (!title.equals(q.getTitle().trim())) continue;
                isUnique = false;
                break;
            }
        }
        return isUnique;
    }

    @Override
    public List getPoolIdsByAgent(final String agentId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select qpa from QuestionPoolAccessData as qpa where qpa.agentId= ?");
                q.setString(0, agentId);
                return q.list();
            }
        };
        List qpaList = this.getHibernateTemplate().executeFind(hcb);
        try {
            for (QuestionPoolAccessData qpa : qpaList) {
                idList.add(qpa.getQuestionPoolId());
            }
            return idList;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Override
    public List getPoolIdsByItem(final String itemId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select qpi from QuestionPoolItemData as qpi where qpi.itemId= ?");
                q.setString(0, itemId);
                return q.list();
            }
        };
        List qpiList = this.getHibernateTemplate().executeFind(hcb);
        try {
            for (QuestionPoolItemData qpa : qpiList) {
                idList.add(qpa.getQuestionPoolId());
            }
            return idList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void copyPool(Tree tree, String agentId, Long sourceId, Long destId, String prependString1, String prependString2) {
        try {
            boolean haveCommonRoot = false;
            boolean duplicate = false;
            QuestionPoolFacade oldPool = this.getPool(sourceId, agentId);
            String oldPoolName = oldPool.getDisplayName();
            if (destId.equals(oldPool.getParentPoolId())) {
                duplicate = true;
            }
            if (!duplicate) {
                haveCommonRoot = tree.haveCommonRoot(sourceId, destId);
            }
            if (haveCommonRoot && tree.poolLevel(sourceId) <= tree.poolLevel(destId)) {
                return;
            }
            QuestionPoolFacade newPool = (QuestionPoolFacade)oldPool.clone();
            newPool.setParentPoolId(destId);
            newPool.setQuestionPoolId(0L);
            newPool.setOwnerId(AgentFacade.getAgentString());
            if (!haveCommonRoot) {
                if (duplicate) {
                    this.resetTitle(destId, newPool, oldPoolName, prependString1, prependString2);
                } else {
                    newPool.updateDisplayName(oldPoolName);
                }
            }
            newPool = this.savePool(newPool);
            Iterator iter = oldPool.getQuestions().iterator();
            ArrayList<ItemDataIfc> itemDataArray = new ArrayList<ItemDataIfc>();
            while (iter.hasNext()) {
                ItemDataIfc itemData = (ItemDataIfc)iter.next();
                ItemFacade itemFacade = this.copyItemFacade2(itemData);
                ItemDataIfc newItemData = itemFacade.getData();
                itemDataArray.add(newItemData);
            }
            newPool.setQuestionPoolItems(this.prepareQuestions(newPool.getQuestionPoolId(), itemDataArray));
            newPool.setQuestions(itemDataArray);
            newPool = this.savePool(newPool);
            for (Long childPoolId : tree.getChildList(sourceId)) {
                this.copyPool(tree, agentId, childPoolId, newPool.getQuestionPoolId(), prependString1, prependString2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Long add() {
        QuestionPoolData questionPool = new QuestionPoolData();
        questionPool.setTitle("Daisy Happy Pool");
        questionPool.setOwnerId("1");
        questionPool.setDateCreated(new Date());
        questionPool.setLastModifiedById("1");
        questionPool.setLastModified(new Date());
        this.getHibernateTemplate().save((Object)questionPool);
        return questionPool.getQuestionPoolId();
    }

    @Override
    public QuestionPoolFacade getPoolById(Long questionPoolId) {
        QuestionPoolFacade questionPoolFacade = null;
        try {
            QuestionPoolData questionPool;
            if (!questionPoolId.equals(QuestionPoolFacade.ROOT_POOL) && (questionPool = (QuestionPoolData)this.getHibernateTemplate().load(QuestionPoolData.class, (Serializable)questionPoolId)) != null) {
                questionPoolFacade = new QuestionPoolFacade((QuestionPoolDataIfc)questionPool);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return questionPoolFacade;
    }

    @Override
    public HashMap getQuestionPoolItemMap() {
        HashMap<String, QuestionPoolItemData> h = new HashMap<String, QuestionPoolItemData>();
        String query = "from QuestionPoolItemData";
        List l = this.getHibernateTemplate().find(query);
        for (int i = 0; i < l.size(); ++i) {
            QuestionPoolItemData q = (QuestionPoolItemData)l.get(i);
            h.put(q.getItemId(), q);
        }
        return h;
    }

    public HashSet prepareQuestions(Long questionPoolId, ArrayList itemDataArray) {
        HashSet<QuestionPoolItemData> set = new HashSet<QuestionPoolItemData>();
        for (ItemDataIfc itemData : itemDataArray) {
            set.add(new QuestionPoolItemData(questionPoolId, itemData.getItemIdString(), (ItemData)itemData));
        }
        return set;
    }

    private void resetTitle(Long destId, QuestionPoolFacade newPool, String oldPoolName, String prependString1, String prependString2) {
        List siblings = this.getSubPools(destId);
        int num = 0;
        int startIndex = 0;
        int endIndex = 0;
        int maxNum = 0;
        StringBuilder prependString = new StringBuilder(prependString1);
        prependString.append(" ");
        prependString.append(prependString2);
        prependString.append(" ");
        for (int l = 0; l < siblings.size(); ++l) {
            QuestionPoolData a = (QuestionPoolData)siblings.get(l);
            String n = a.getTitle();
            if (n.startsWith(prependString.toString()) && n.equals(prependString + oldPoolName) && maxNum < 1) {
                maxNum = 1;
            }
            if (!n.startsWith(prependString1 + "(")) continue;
            startIndex = n.indexOf("(");
            endIndex = n.indexOf(")");
            try {
                String partialPoolName = n.substring(endIndex + 2).replaceFirst(prependString2 + " ", "").trim();
                num = Integer.parseInt(n.substring(startIndex + 1, endIndex));
                if (!oldPoolName.equals(partialPoolName) || num <= maxNum) continue;
                maxNum = num;
                continue;
            }
            catch (NumberFormatException e) {
                log.warn((Object)("rename title of duplicate pool:" + e.getMessage()));
            }
        }
        if (maxNum == 0) {
            newPool.updateDisplayName(prependString + oldPoolName);
        } else {
            newPool.updateDisplayName(prependString1 + "(" + (maxNum + 1) + ") " + prependString2 + " " + oldPoolName);
        }
    }

    @Override
    public Long copyItemFacade(ItemDataIfc itemData) {
        ItemFacade item = this.getItemFacade(itemData);
        ItemService itemService = new ItemService();
        Long itemId = itemService.saveItem(item).getItemId();
        return itemId;
    }

    @Override
    public ItemFacade copyItemFacade2(ItemDataIfc itemData) {
        ItemFacade item = this.getItemFacade(itemData);
        ItemService itemService = new ItemService();
        return itemService.saveItem(item);
    }

    private ItemFacade getItemFacade(ItemDataIfc itemData) {
        ItemFacade item = new ItemFacade();
        item.setScore(itemData.getScore());
        item.setDiscount(itemData.getDiscount());
        item.setHint(itemData.getHint());
        item.setStatus(itemData.getStatus());
        item.setTypeId(itemData.getTypeId());
        item.setCreatedBy(AgentFacade.getAgentString());
        item.setCreatedDate(new Date());
        item.setLastModifiedBy(AgentFacade.getAgentString());
        item.setLastModifiedDate(new Date());
        item.setInstruction(itemData.getInstruction());
        item.setHasRationale(itemData.getHasRationale());
        item.setTriesAllowed(itemData.getTriesAllowed());
        item.setDuration(itemData.getDuration());
        item.setItemTextSet(this.copyItemText(item.getData(), itemData));
        item.setItemMetaDataSet(this.copyMetaData(item.getData(), itemData));
        item.setItemAttachmentSet(this.copyAttachment(item.getData(), itemData));
        if (itemData.getCorrectItemFeedback() != null && !itemData.getCorrectItemFeedback().equals("")) {
            item.setCorrectItemFeedback(itemData.getCorrectItemFeedback());
        }
        if (itemData.getInCorrectItemFeedback() != null && !itemData.getInCorrectItemFeedback().equals("")) {
            item.setInCorrectItemFeedback(itemData.getInCorrectItemFeedback());
        }
        if (itemData.getGeneralItemFeedback() != null && !itemData.getGeneralItemFeedback().equals("")) {
            item.setGeneralItemFeedback(itemData.getGeneralItemFeedback());
        }
        return item;
    }

    private HashSet copyItemText(ItemDataIfc toItemData, ItemDataIfc fromItemData) {
        HashSet<ItemText> toItemTextSet = new HashSet<ItemText>();
        Set fromItemTextSet = fromItemData.getItemTextSet();
        for (ItemText fromItemText : fromItemTextSet) {
            ItemText toItemText = new ItemText();
            toItemText.setItem(toItemData);
            toItemText.setSequence(fromItemText.getSequence());
            toItemText.setText(fromItemText.getText());
            HashSet<Answer> toAnswerSet = new HashSet<Answer>();
            Set fromAnswerSet = fromItemText.getAnswerSet();
            for (Answer fromAnswer : fromAnswerSet) {
                Answer toAnswer = new Answer((ItemTextIfc)toItemText, fromAnswer.getText(), fromAnswer.getSequence(), fromAnswer.getLabel(), fromAnswer.getIsCorrect(), fromAnswer.getGrade(), fromAnswer.getScore(), fromAnswer.getPartialCredit(), fromAnswer.getDiscount());
                HashSet<AnswerFeedback> toAnswerFeedbackSet = new HashSet<AnswerFeedback>();
                Set fromAnswerFeedbackSet = fromAnswer.getAnswerFeedbackSet();
                for (AnswerFeedback fromAnswerFeedback : fromAnswerFeedbackSet) {
                    toAnswerFeedbackSet.add(new AnswerFeedback((AnswerIfc)toAnswer, fromAnswerFeedback.getTypeId(), fromAnswerFeedback.getText()));
                    toAnswer.setAnswerFeedbackSet(toAnswerFeedbackSet);
                }
                toAnswerSet.add(toAnswer);
                toItemText.setAnswerSet(toAnswerSet);
            }
            toItemTextSet.add(toItemText);
        }
        return toItemTextSet;
    }

    private HashSet copyMetaData(ItemDataIfc toItemData, ItemDataIfc fromItemData) {
        HashSet<ItemMetaData> toSet = new HashSet<ItemMetaData>();
        Set fromSet = fromItemData.getItemMetaDataSet();
        for (ItemMetaData itemMetaData : fromSet) {
            toSet.add(new ItemMetaData(toItemData, itemMetaData.getLabel(), itemMetaData.getEntry()));
        }
        return toSet;
    }

    private Set copyAttachment(ItemDataIfc toItemData, ItemDataIfc fromItemData) {
        AssessmentService assessmentService = new AssessmentService();
        Set toSet = assessmentService.copyItemAttachmentSet((ItemData)toItemData, fromItemData.getItemAttachmentSet());
        return toSet;
    }

    @Override
    public Integer getCountItemFacades(final Long questionPoolId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(ab) from ItemData ab, QuestionPoolItemData qpi where ab.itemId=qpi.itemId and qpi.questionPoolId = ?");
                q.setLong(0, questionPoolId.longValue());
                return q.uniqueResult();
            }
        };
        Integer count = (Integer)this.getHibernateTemplate().execute(hcb);
        return count;
    }

    @Override
    public void addQuestionPoolAccess(Tree tree, String user, Long questionPoolId, Long accessTypeId) {
        QuestionPoolAccessData qpad = new QuestionPoolAccessData(questionPoolId, user, accessTypeId);
        this.getHibernateTemplate().saveOrUpdate((Object)qpad);
        for (Long childPoolId : tree.getChildList(questionPoolId)) {
            this.addQuestionPoolAccess(tree, user, childPoolId, accessTypeId);
        }
    }

    @Override
    public void removeQuestionPoolAccess(Tree tree, String user, Long questionPoolId, Long accessTypeId) {
        QuestionPoolAccessData qpad = new QuestionPoolAccessData(questionPoolId, user, accessTypeId);
        this.getHibernateTemplate().delete((Object)qpad);
        for (Long childPoolId : tree.getChildList(questionPoolId)) {
            this.removeQuestionPoolAccess(tree, user, childPoolId, accessTypeId);
        }
    }

    @Override
    public List<AgentFacade> getAgentsWithAccess(final Long questionPoolId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select qpa from QuestionPoolAccessData as qpa where qpa.questionPoolId= ?");
                q.setLong(0, questionPoolId.longValue());
                return q.list();
            }
        };
        List qpaList = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AgentFacade> agents = new ArrayList<AgentFacade>();
        for (QuestionPoolAccessData pool : qpaList) {
            AgentFacade agent = new AgentFacade(pool.getAgentId());
            agents.add(agent);
        }
        return agents;
    }
}

