/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.service.gradebook.shared.ExternalAssignmentProvider;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.UserDirectoryService;

public class AssessmentGradeInfoProvider
implements ExternalAssignmentProvider {
    private Log log = LogFactory.getLog(AssessmentGradeInfoProvider.class);
    private GradebookExternalAssessmentService geaService;
    private UserDirectoryService userDirectoryService;
    private SiteService siteService;

    public void init() {
        this.log.info((Object)"INIT and Register Samigo AssessmentGradeInfoProvider");
        this.geaService.registerExternalAssignmentProvider((ExternalAssignmentProvider)this);
    }

    public void destroy() {
        this.log.info((Object)"DESTROY and unregister Samigo AssessmentGradeInfoProvider");
        this.geaService.unregisterExternalAssignmentProvider(this.getAppKey());
    }

    public String getAppKey() {
        return "samigo";
    }

    private PublishedAssessmentIfc getPublishedAssessment(String id) {
        PublishedAssessmentFacade a;
        PublishedAssessmentService pas = new PublishedAssessmentService();
        try {
            a = pas.getPublishedAssessment(id);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Assessment lookup failed for ID: " + id + " -- " + e.getMessage()));
            }
            a = null;
        }
        return a;
    }

    public boolean isAssignmentDefined(String id) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Samigo provider isAssignmentDefined: " + id));
        }
        return this.getPublishedAssessment(id) != null;
    }

    public boolean isAssignmentGrouped(String id) {
        boolean grouped;
        block3: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Samigo provider isAssignmentGrouped: " + id));
            }
            PublishedAssessmentService pas = new PublishedAssessmentService();
            grouped = false;
            try {
                grouped = pas.isReleasedToGroups(id);
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Assignment lookup failed for ID: " + id + " -- " + e.getMessage()));
            }
        }
        return grouped;
    }

    public boolean isAssignmentVisible(String id, String userId) {
        PublishedAssessmentIfc pub;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Samigo provider isAssignmentVisible: " + id + ", " + userId));
        }
        if ((pub = this.getPublishedAssessment(id)) == null) {
            return false;
        }
        boolean isAuthorized = false;
        boolean isAuthenticated = false;
        String releaseTo = pub.getAssessmentAccessControl().getReleaseTo();
        if (releaseTo != null && releaseTo.indexOf("Anonymous Users") > -1) {
            isAuthenticated = true;
            isAuthorized = true;
        } else {
            boolean bl = isAuthenticated = userId != null && !"".equals(userId);
            if (isAuthenticated) {
                isAuthorized = releaseTo.indexOf("Selected Groups") > -1 ? this.checkMembershipForGroupRelease(pub, userId) : this.checkMembership(pub, userId);
            }
        }
        return isAuthorized;
    }

    private boolean checkMembership(PublishedAssessmentIfc pub, String userId) {
        boolean isMember = false;
        List l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("VIEW_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size(); ++i) {
            String siteId = ((AuthorizationData)l.get(i)).getAgentIdString();
            try {
                isMember = this.siteService.getSite(siteId).getUserRole(userId) != null;
            }
            catch (IdUnusedException e) {
                this.log.info((Object)("Site with ID: " + siteId + " does not exists but is " + "authorized for assessment id: " + pub.getPublishedAssessmentId()));
            }
            if (isMember) break;
        }
        return isMember;
    }

    private boolean checkMembershipForGroupRelease(PublishedAssessmentIfc pub, String userId) {
        String groupId;
        boolean isMember = false;
        List l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("OWN_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        if (l == null || l.isEmpty()) {
            return false;
        }
        String siteId = ((AuthorizationData)l.get(0)).getAgentIdString();
        Collection siteGroupsContainingUser = null;
        try {
            siteGroupsContainingUser = this.siteService.getSite(siteId).getGroupsWithMember(userId);
        }
        catch (IdUnusedException ex) {
            // empty catch block
        }
        l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("TAKE_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size() && !(isMember = this.isUserInAuthorizedGroup(groupId = ((AuthorizationData)l.get(i)).getAgentIdString(), siteGroupsContainingUser)); ++i) {
        }
        return isMember;
    }

    private boolean isUserInAuthorizedGroup(String authorizedGroupId, Collection userGroups) {
        if (userGroups == null || userGroups.isEmpty() || authorizedGroupId == null || authorizedGroupId.equals("")) {
            return false;
        }
        for (Group group : userGroups) {
            if (!group.getId().equals(authorizedGroupId)) continue;
            return true;
        }
        return false;
    }

    public GradebookExternalAssessmentService getGradebookExternalAssessmentService() {
        return this.geaService;
    }

    public void setGradebookExternalAssessmentService(GradebookExternalAssessmentService geaService) {
        this.geaService = geaService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

