/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static final SessionFactory sessionFactory;
    public static final ThreadLocal session;

    public static Session currentSession() throws HibernateException {
        Session s = (Session)session.get();
        if (s == null) {
            s = sessionFactory.openSession();
            session.set(s);
        }
        return s;
    }

    public static void closeSession() throws HibernateException {
        Session s = (Session)session.get();
        session.set(null);
        if (s != null) {
            s.close();
        }
    }

    static {
        try {
            sessionFactory = new Configuration().configure().buildSessionFactory();
        }
        catch (HibernateException ex) {
            throw new RuntimeException("Exception building SessionFactory: " + ex.getMessage(), ex);
        }
        session = new ThreadLocal();
    }
}

