/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osid.assessment.AssessmentException;
import org.osid.assessment.Item;
import org.osid.shared.Id;
import org.osid.shared.Type;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.ItemFacadeQueries;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.assessment.impl.ItemImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;

public class ItemFacade
implements Serializable,
ItemDataIfc,
Comparable {
    private static Log log = LogFactory.getLog(ItemFacade.class);
    private static final long serialVersionUID = 7526471155622776147L;
    protected Item item;
    protected Id id;
    protected String description;
    protected ItemDataIfc data;
    protected Type itemType;
    protected Long itemId;
    protected String itemIdString;
    private SectionFacade section;
    protected Integer sequence;
    protected Integer duration;
    protected Integer triesAllowed;
    protected String instruction;
    protected Long typeId;
    protected String grade;
    protected Float score;
    protected Float discount;
    protected String hint;
    protected Boolean partialCreditFlag;
    protected Boolean hasRationale;
    protected Integer status;
    protected String createdBy;
    protected Date createdDate;
    protected String lastModifiedBy;
    protected Date lastModifiedDate;
    protected Set itemTextSet;
    protected Set itemMetaDataSet;
    protected Set itemFeedbackSet;
    protected HashMap itemMetaDataMap = new HashMap();
    protected HashMap itemFeedbackMap = new HashMap();
    protected TypeFacade itemTypeFacade;
    protected Set itemAttachmentSet;
    protected String itemAttachmentMetaData;

    public ItemFacade() {
        this.data = new ItemData();
        ItemImpl itemImpl = new ItemImpl();
        this.item = itemImpl;
        try {
            this.item.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public ItemFacade(ItemDataIfc data) {
        this.data = data;
        ItemImpl itemImpl = new ItemImpl();
        this.item = itemImpl;
        try {
            this.item.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.id = this.getId();
        this.description = this.getDescription();
        this.itemType = this.getItemType();
        this.itemTextSet = this.getItemTextSet();
        this.itemMetaDataSet = this.getItemMetaDataSet();
        this.itemMetaDataMap = this.getItemMetaDataMap(this.itemMetaDataSet);
        this.itemFeedbackSet = this.getItemFeedbackSet();
        this.itemFeedbackMap = this.getItemFeedbackMap(this.itemFeedbackSet);
        this.hasRationale = data.getHasRationale();
        this.itemAttachmentSet = this.getItemAttachmentSet();
    }

    Id getId() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        ItemFacadeQueries itemFacadeQueries = new ItemFacadeQueries();
        return itemFacadeQueries.getItemId(this.data.getItemId());
    }

    Type getItemType() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeById(this.data.getTypeId());
    }

    public TypeIfc getType() {
        return this.getItemTypeFacade();
    }

    public TypeFacade getItemTypeFacade() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeFacadeById(this.data.getTypeId());
    }

    public ItemDataIfc getData() {
        return this.data;
    }

    public void updateData(ItemDataIfc data) {
        this.setData(data);
    }

    public void setData(ItemDataIfc data) {
        this.data = data;
    }

    public Long getItemId() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemId();
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
        this.data.setItemId(itemId);
        this.setItemIdString(itemId.toString());
    }

    public String getItemIdString() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemIdString();
    }

    public void setItemIdString(String itemIdString) {
        this.itemIdString = itemIdString;
        this.data.setItemIdString(itemIdString);
    }

    public SectionDataIfc getSection() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        if (this.data.getSection() != null) {
            return new SectionFacade(this.data.getSection());
        }
        return null;
    }

    public void setSection(SectionDataIfc section) {
        this.section = (SectionFacade)section;
        if (this.section != null) {
            this.data.setSection(this.section.getData());
        } else {
            this.data.setSection(null);
        }
    }

    public Integer getSequence() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getSequence();
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
        this.data.setSequence(sequence);
    }

    public Integer getDuration() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDuration();
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
        this.data.setDuration(duration);
    }

    public String getInstruction() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getInstruction();
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
        this.data.setInstruction(instruction);
    }

    public String getDescription() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.description = description;
        this.data.setDescription(description);
    }

    public Long getTypeId() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTypeId();
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
        this.data.setTypeId(typeId);
    }

    public String getGrade() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getGrade();
    }

    public void setGrade(String grade) {
        this.grade = grade;
        this.data.setGrade(grade);
    }

    public Float getScore() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getScore();
    }

    public void setScore(Float score) {
        this.score = score;
        this.data.setScore(score);
    }

    public Float getDiscount() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDiscount();
    }

    public void setDiscount(Float discount) {
        this.discount = discount;
        this.data.setDiscount(discount);
    }

    public String getHint() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getHint();
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.data.setHint(hint);
    }

    public Boolean getHasRationale() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getHasRationale();
    }

    public void setHasRationale(Boolean hasRationale) {
        this.hasRationale = hasRationale;
        this.data.setHasRationale(hasRationale);
    }

    public Integer getStatus() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getStatus();
    }

    public void setStatus(Integer status) {
        this.status = status;
        this.data.setStatus(status);
    }

    public String getCreatedBy() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getCreatedBy();
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        this.data.setCreatedBy(createdBy);
    }

    public Date getCreatedDate() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getCreatedDate();
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
        this.data.setCreatedDate(createdDate);
    }

    public String getLastModifiedBy() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedBy();
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        this.data.setLastModifiedBy(lastModifiedBy);
    }

    public Date getLastModifiedDate() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedDate();
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        this.data.setLastModifiedDate(lastModifiedDate);
    }

    public Set getItemTextSet() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemTextSet();
    }

    public void setItemTextSet(Set itemTextSet) {
        this.itemTextSet = itemTextSet;
        this.data.setItemTextSet(itemTextSet);
    }

    public Set getItemMetaDataSet() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemMetaDataSet();
    }

    public void setItemMetaDataSet(Set itemMetaDataSet) {
        this.itemMetaDataSet = itemMetaDataSet;
        this.data.setItemMetaDataSet(itemMetaDataSet);
        this.itemMetaDataMap = this.getItemMetaDataMap(itemMetaDataSet);
    }

    public HashMap getItemMetaDataMap(Set itemMetaDataSet) {
        HashMap<String, String> itemMetaDataMap = new HashMap<String, String>();
        if (itemMetaDataSet != null) {
            for (ItemMetaDataIfc itemMetaData : itemMetaDataSet) {
                itemMetaDataMap.put(itemMetaData.getLabel(), itemMetaData.getEntry());
            }
        }
        return itemMetaDataMap;
    }

    public Set getItemFeedbackSet() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemFeedbackSet();
    }

    public void setItemFeedbackSet(Set itemFeedbackSet) {
        this.itemFeedbackSet = itemFeedbackSet;
        this.data.setItemFeedbackSet(itemFeedbackSet);
        this.itemFeedbackMap = this.getItemFeedbackMap(itemFeedbackSet);
    }

    public HashMap getItemFeedbackMap(Set itemFeedbackSet) {
        HashMap<String, String> itemFeedbackMap = new HashMap<String, String>();
        if (itemFeedbackSet != null) {
            for (ItemFeedbackIfc itemFeedback : itemFeedbackSet) {
                itemFeedbackMap.put(itemFeedback.getTypeId(), itemFeedback.getText());
            }
        }
        return itemFeedbackMap;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void addItemText(String text, Set answerSet) {
        if (this.data.getItemTextSet() == null) {
            this.data.setItemTextSet(new HashSet());
        }
        Long sequence = this.data.getItemTextSet().size() + 1;
        ItemText itemText = new ItemText((ItemData)this.data, sequence, text, answerSet);
        this.data.getItemTextSet().add(itemText);
        this.itemTextSet = this.data.getItemTextSet();
    }

    public String getItemMetaDataByLabel(String label) {
        return (String)this.itemMetaDataMap.get(label);
    }

    public void addItemMetaData(String label, String entry) {
        if (this.itemMetaDataSet == null) {
            this.setItemMetaDataSet(new HashSet());
            this.itemMetaDataMap = new HashMap();
        }
        this.itemMetaDataMap.put(label, entry);
        this.data.getItemMetaDataSet().add(new ItemMetaData((ItemDataIfc)((ItemData)this.data), label, entry));
        this.itemMetaDataSet = this.data.getItemMetaDataSet();
    }

    public String getGeneralItemFeedback() {
        return this.getItemFeedback("General Feedback");
    }

    public void setGeneralItemFeedback(String text) {
        this.removeFeedbackByType("General Feedback");
        this.addItemFeedback("General Feedback", text);
    }

    public String getCorrectItemFeedback() {
        return this.getItemFeedback("Correct Feedback");
    }

    public void setCorrectItemFeedback(String text) {
        this.removeFeedbackByType("Correct Feedback");
        this.addItemFeedback("Correct Feedback", text);
    }

    public String getInCorrectItemFeedback() {
        return this.getItemFeedback("InCorrect Feedback");
    }

    public void setInCorrectItemFeedback(String text) {
        this.removeFeedbackByType("InCorrect Feedback");
        this.addItemFeedback("InCorrect Feedback", text);
    }

    public String getItemFeedback(String feedbackTypeId) {
        return (String)this.itemFeedbackMap.get(feedbackTypeId);
    }

    public void addItemFeedback(String feedbackTypeId, String text) {
        if (this.itemFeedbackSet == null) {
            this.setItemFeedbackSet(new HashSet());
            this.itemFeedbackMap = new HashMap();
        }
        this.itemFeedbackMap.put(feedbackTypeId, text);
        this.data.getItemFeedbackSet().add(new ItemFeedback((ItemData)this.data, feedbackTypeId, text));
        this.itemFeedbackSet = this.data.getItemFeedbackSet();
    }

    public void removeFeedbackByType(String feedbackTypeId) {
        this.itemFeedbackSet = this.data.getItemFeedbackSet();
        if (this.itemFeedbackSet != null) {
            HashSet<ItemFeedbackIfc> toBeRemovedSet = new HashSet<ItemFeedbackIfc>();
            for (ItemFeedbackIfc itemFeedback : this.itemFeedbackSet) {
                if (!itemFeedback.getTypeId().equals(feedbackTypeId)) continue;
                toBeRemovedSet.add(itemFeedback);
            }
            this.itemFeedbackSet.removeAll(toBeRemovedSet);
        }
    }

    public Boolean getIsTrue() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getIsTrue();
    }

    public String getText() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getText();
    }

    public String getTextHtmlStripped() throws DataFacadeException {
        String regex = "\\<.*?\\>";
        return this.getText().replaceAll(regex, " ");
    }

    public String getTextHtmlStrippedAll() throws DataFacadeException {
        String regex = "\\<.*?\\>|\\n|\\r\\n";
        return this.getText().replaceAll(regex, "");
    }

    public ArrayList getItemTextArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.itemTextSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public ArrayList getItemTextArraySorted() {
        ArrayList list = this.getItemTextArray();
        Collections.sort(list);
        return list;
    }

    public Integer getTriesAllowed() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTriesAllowed();
    }

    public void setTriesAllowed(Integer triesAllowed) {
        this.triesAllowed = triesAllowed;
        this.data.setTriesAllowed(triesAllowed);
    }

    public void removeMetaDataByType(String label) {
        try {
            if (this.itemMetaDataSet != null) {
                Iterator i = this.itemMetaDataSet.iterator();
                while (i.hasNext()) {
                    ItemMetaDataIfc itemMetaData = (ItemMetaDataIfc)i.next();
                    if (!itemMetaData.getLabel().equals(label)) continue;
                    i.remove();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAnswerKey() {
        return ((ItemData)this.data).getAnswerKey();
    }

    public int compareTo(Object o) {
        ItemFacade a = (ItemFacade)o;
        return this.sequence.compareTo(a.sequence);
    }

    public Set getItemAttachmentSet() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemAttachmentSet();
    }

    public void setItemAttachmentSet(Set itemAttachmentSet) {
        this.itemAttachmentSet = itemAttachmentSet;
        this.data.setItemAttachmentSet(itemAttachmentSet);
    }

    public List getItemAttachmentList() {
        ArrayList<ItemAttachmentIfc> list = new ArrayList<ItemAttachmentIfc>();
        Set set = this.getItemAttachmentSet();
        if (set != null) {
            for (ItemAttachmentIfc a : set) {
                list.add(a);
            }
        }
        return list;
    }

    public void addItemAttachmentMetaData(String entry) {
        this.itemAttachmentMetaData = entry;
    }

    public String getItemAttachmentMetaData() {
        return this.itemAttachmentMetaData;
    }

    public void setPartialCreditFlag(Boolean partialCreditFlag) {
        this.partialCreditFlag = partialCreditFlag;
        this.data.setPartialCreditFlag(partialCreditFlag);
    }

    public Boolean getPartialCreditFlag() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getPartialCreditFlag();
    }
}

