/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.osid.shared.Type;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.shared.extension.TypeExtension;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TypeFacadeQueries
extends HibernateDaoSupport
implements TypeFacadeQueriesAPI {
    private static Log log = LogFactory.getLog(TypeFacadeQueries.class);
    private HashMap typeFacadeMap;
    private List itemTypes;

    @Override
    public void setTypeFacadeMap() {
        this.typeFacadeMap = this.getMapForAllTypes();
    }

    @Override
    public HashMap getTypeFacadeMap() {
        return this.typeFacadeMap;
    }

    @Override
    public TypeFacade getTypeFacadeById(Long typeId) {
        TypeFacade typeFacade = null;
        HashMap typeMap = this.getTypeFacadeMap();
        typeFacade = (TypeFacade)typeMap.get(typeId);
        return typeFacade;
    }

    @Override
    public Type getTypeById(Long typeId) {
        TypeFacade typeFacade = this.getTypeFacadeById(typeId);
        TypeExtension type = new TypeExtension(typeFacade.getAuthority(), typeFacade.getDomain(), typeFacade.getKeyword(), typeFacade.getDescription());
        return type;
    }

    @Override
    public ArrayList getArrayListByAuthorityDomain(String authority, String domain) {
        List typeList = this.getListByAuthorityDomain(authority, domain);
        ArrayList<TypeFacade> typeFacadeList = new ArrayList<TypeFacade>();
        for (int i = 0; i < typeList.size(); ++i) {
            TypeD typeData = (TypeD)typeList.get(i);
            TypeFacade typeFacade = new TypeFacade((TypeIfc)typeData);
            typeFacadeList.add(typeFacade);
        }
        return typeFacadeList;
    }

    @Override
    public HashMap getHashMapByAuthorityDomain(String authority, String domain) {
        List typeList = this.getListByAuthorityDomain(authority, domain);
        return this.createTypeFacadeMapById(typeList);
    }

    private List getAllTypes() {
        return this.getHibernateTemplate().find("from TypeD");
    }

    private HashMap getMapForAllTypes() {
        List typeList = this.getAllTypes();
        return this.createTypeFacadeMapById(typeList);
    }

    private HashMap createTypeFacadeMapById(List typeList) {
        HashMap<Long, TypeFacade> typeFacadeMap = new HashMap<Long, TypeFacade>();
        for (int i = 0; i < typeList.size(); ++i) {
            TypeD typeData = (TypeD)typeList.get(i);
            TypeFacade typeFacade = new TypeFacade((TypeIfc)typeData);
            typeFacadeMap.put(typeData.getTypeId(), typeFacade);
        }
        return typeFacadeMap;
    }

    @Override
    public List getListByAuthorityDomain(final String authority, final String domain) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from TypeD as t where t.authority=? and t.domain=?");
                q.setString(0, authority);
                q.setString(1, domain);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List getFacadeListByAuthorityDomain(String authority, String domain) {
        ArrayList<TypeFacade> typeList = new ArrayList<TypeFacade>();
        List list = this.getListByAuthorityDomain(authority, domain);
        for (int i = 0; i < list.size(); ++i) {
            TypeD type = (TypeD)list.get(i);
            TypeFacade f = new TypeFacade(type.getAuthority(), type.getDomain(), type.getKeyword(), type.getDescription());
            f.setTypeId(type.getTypeId());
            typeList.add(f);
        }
        return typeList;
    }

    @Override
    public List getFacadeItemTypes() {
        if (this.itemTypes == null) {
            this.itemTypes = this.getFacadeListByAuthorityDomain("stanford.edu", "assessment.item");
        }
        return this.itemTypes;
    }

    @Override
    public void setFacadeItemTypes() {
        this.itemTypes = this.getFacadeItemTypes();
    }
}

