/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.service.gradebook.shared.ExternalAssignmentProvider;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.UserDirectoryService;

public class AssessmentGradeInfoProvider
implements ExternalAssignmentProvider {
    private Log log = LogFactory.getLog(AssessmentGradeInfoProvider.class);
    private GradebookExternalAssessmentService geaService;
    private UserDirectoryService userDirectoryService;
    private SiteService siteService;

    public void init() {
        this.log.info((Object)"INIT and Register Samigo AssessmentGradeInfoProvider");
        this.geaService.registerExternalAssignmentProvider((ExternalAssignmentProvider)this);
    }

    public void destroy() {
        this.log.info((Object)"DESTROY and unregister Samigo AssessmentGradeInfoProvider");
        this.geaService.unregisterExternalAssignmentProvider(this.getAppKey());
    }

    public String getAppKey() {
        return "samigo";
    }

    private PublishedAssessmentIfc getPublishedAssessment(String id) {
        PublishedAssessmentFacade a;
        PublishedAssessmentService pas = new PublishedAssessmentService();
        try {
            a = pas.getPublishedAssessment(id);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Assessment lookup failed for ID: " + id + " -- " + e.getMessage()));
            }
            a = null;
        }
        return a;
    }

    public boolean isAssignmentDefined(String id) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Samigo provider isAssignmentDefined: " + id));
        }
        return this.getPublishedAssessment(id) != null;
    }

    public boolean isAssignmentGrouped(String id) {
        boolean grouped;
        block3: {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Samigo provider isAssignmentGrouped: " + id));
            }
            PublishedAssessmentService pas = new PublishedAssessmentService();
            grouped = false;
            try {
                grouped = pas.isReleasedToGroups(id);
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Assignment lookup failed for ID: " + id + " -- " + e.getMessage()));
            }
        }
        return grouped;
    }

    public boolean isAssignmentVisible(String id, String userId) {
        PublishedAssessmentIfc pub;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Samigo provider isAssignmentVisible: " + id + ", " + userId));
        }
        if ((pub = this.getPublishedAssessment(id)) == null) {
            return false;
        }
        boolean isAuthorized = false;
        boolean isAuthenticated = false;
        String releaseTo = pub.getAssessmentAccessControl().getReleaseTo();
        if (releaseTo != null && releaseTo.indexOf("Anonymous Users") > -1) {
            isAuthenticated = true;
            isAuthorized = true;
        } else {
            boolean bl = isAuthenticated = userId != null && !"".equals(userId);
            if (isAuthenticated) {
                isAuthorized = releaseTo.indexOf("Selected Groups") > -1 ? this.checkMembershipForGroupRelease(pub, userId) : this.checkMembership(pub, userId);
            }
        }
        return isAuthorized;
    }

    public List<String> getExternalAssignmentsForCurrentUser(String gradebookUid) {
        ArrayList all = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllPublishedAssessments("title", true, gradebookUid);
        ArrayList<String> externalIds = new ArrayList<String>();
        for (PublishedAssessmentIfc pub : all) {
            externalIds.add(pub.getPublishedAssessmentId().toString());
        }
        return externalIds;
    }

    public Map<String, List<String>> getAllExternalAssignments(String gradebookUid, Collection<String> studentIds) {
        ArrayList allPublished = PersistenceService.getInstance().getPublishedAssessmentFacadeQueries().getBasicInfoOfAllPublishedAssessments2("title", true, gradebookUid);
        HashMap allExternals = new HashMap();
        for (String studentId : studentIds) {
            allExternals.put(studentId, new HashSet());
        }
        Set<String> siteUserIds = this.getSiteUserIds(gradebookUid);
        Map<String, Set<String>> userIdGroupIds = this.getUserGroups(gradebookUid, studentIds);
        Map<String, Set<String>> groupIdUserIds = this.invertMapSet(userIdGroupIds);
        for (PublishedAssessmentFacade pub : allPublished) {
            String assessmentId = pub.getPublishedAssessmentId().toString();
            String releaseTo = pub.getReleaseTo();
            if (releaseTo == null || assessmentId == null) continue;
            if (releaseTo.indexOf("Anonymous Users") > -1) {
                for (String studentId : studentIds) {
                    ((Set)allExternals.get(studentId)).add(assessmentId);
                }
                continue;
            }
            if ("Selected Groups".equals(releaseTo)) {
                Set<String> authorizedGroups = this.getAuthorizedGroups(assessmentId);
                for (String groupId : authorizedGroups) {
                    if (!groupIdUserIds.containsKey(groupId)) continue;
                    for (String userId : groupIdUserIds.get(groupId)) {
                        if (!allExternals.containsKey(userId)) continue;
                        ((Set)allExternals.get(userId)).add(assessmentId);
                    }
                }
                continue;
            }
            for (String studentId : studentIds) {
                if (!siteUserIds.contains(studentId)) continue;
                ((Set)allExternals.get(studentId)).add(assessmentId);
            }
        }
        HashMap<String, List<String>> allExternalsList = new HashMap<String, List<String>>();
        for (String studentId : allExternals.keySet()) {
            allExternalsList.put(studentId, new ArrayList((Collection)allExternals.get(studentId)));
        }
        return allExternalsList;
    }

    private Set<String> getAuthorizedGroups(String assessmentId) {
        List authorizations = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("TAKE_PUBLISHED_ASSESSMENT", assessmentId);
        HashSet<String> authorizedGroups = new HashSet<String>();
        if (authorizations != null && authorizations.size() > 0) {
            for (AuthorizationData ad : authorizations) {
                authorizedGroups.add(ad.getAgentIdString());
            }
        }
        return authorizedGroups;
    }

    private Set<String> getSiteUserIds(String siteId) {
        HashSet<String> userIds;
        block3: {
            userIds = new HashSet<String>();
            try {
                Site site = this.siteService.getSite(siteId);
                for (Member m : site.getMembers()) {
                    userIds.add(m.getUserId());
                }
            }
            catch (IdUnusedException e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Site not found when attempting to retrieve its users: " + siteId));
            }
        }
        return userIds;
    }

    private Map<String, Set<String>> getUserGroups(String siteId, Collection<String> studentIds) {
        HashMap<String, Set<String>> userIdGroupIds;
        block5: {
            userIdGroupIds = new HashMap<String, Set<String>>();
            for (String studentId : studentIds) {
                userIdGroupIds.put(studentId, new HashSet());
            }
            try {
                Site site = this.siteService.getSite(siteId);
                for (Group g : site.getGroups()) {
                    for (Member m : g.getMembers()) {
                        String userId = m.getUserId();
                        if (!userIdGroupIds.containsKey(userId)) continue;
                        ((Set)userIdGroupIds.get(userId)).add(g.getId());
                    }
                }
            }
            catch (IdUnusedException e) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug((Object)("Site not found when attempting to retrieve user groups: " + siteId));
            }
        }
        return userIdGroupIds;
    }

    private Map<String, Set<String>> invertMapSet(Map<String, Set<String>> mapSet) {
        HashMap<String, Set<String>> inverted = new HashMap<String, Set<String>>();
        for (String key : mapSet.keySet()) {
            Set<String> values = mapSet.get(key);
            for (String value : values) {
                if (!inverted.containsKey(value)) {
                    inverted.put(value, new HashSet());
                }
                ((Set)inverted.get(value)).add(key);
            }
        }
        return inverted;
    }

    private boolean checkMembership(PublishedAssessmentIfc pub, String userId) {
        boolean isMember = false;
        List l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("VIEW_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size(); ++i) {
            String siteId = ((AuthorizationData)l.get(i)).getAgentIdString();
            try {
                isMember = this.siteService.getSite(siteId).getUserRole(userId) != null;
            }
            catch (IdUnusedException e) {
                this.log.info((Object)("Site with ID: " + siteId + " does not exists but is " + "authorized for assessment id: " + pub.getPublishedAssessmentId()));
            }
            if (isMember) break;
        }
        return isMember;
    }

    private boolean checkMembershipForGroupRelease(PublishedAssessmentIfc pub, String userId) {
        String groupId;
        boolean isMember = false;
        List l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("OWN_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        if (l == null || l.isEmpty()) {
            return false;
        }
        String siteId = ((AuthorizationData)l.get(0)).getAgentIdString();
        Collection siteGroupsContainingUser = null;
        try {
            siteGroupsContainingUser = this.siteService.getSite(siteId).getGroupsWithMember(userId);
        }
        catch (IdUnusedException ex) {
            // empty catch block
        }
        l = PersistenceService.getInstance().getAuthzQueriesFacade().getAuthorizationByFunctionAndQualifier("TAKE_PUBLISHED_ASSESSMENT", pub.getPublishedAssessmentId().toString());
        for (int i = 0; i < l.size() && !(isMember = this.isUserInAuthorizedGroup(groupId = ((AuthorizationData)l.get(i)).getAgentIdString(), siteGroupsContainingUser)); ++i) {
        }
        return isMember;
    }

    private boolean isUserInAuthorizedGroup(String authorizedGroupId, Collection userGroups) {
        if (userGroups == null || userGroups.isEmpty() || authorizedGroupId == null || authorizedGroupId.equals("")) {
            return false;
        }
        for (Group group : userGroups) {
            if (!group.getId().equals(authorizedGroupId)) continue;
            return true;
        }
        return false;
    }

    public GradebookExternalAssessmentService getGradebookExternalAssessmentService() {
        return this.geaService;
    }

    public void setGradebookExternalAssessmentService(GradebookExternalAssessmentService geaService) {
        this.geaService = geaService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

