/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.standalone;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.integration.helper.ifc.AgentHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.AgentImpl;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.user.cover.UserDirectoryService;

public class AgentHelperImpl
implements AgentHelper {
    private static Log log = LogFactory.getLog(AgentHelperImpl.class);
    String agentString;

    @Override
    public AgentImpl getAgent() {
        AgentImpl agent = new AgentImpl("Administrator", null, new IdImpl("admin"));
        return agent;
    }

    @Override
    public String getEid(String agentString) {
        return this.getAgentString(agentString);
    }

    @Override
    public String getEidById(String agentString) {
        return this.getAgentString(agentString);
    }

    @Override
    public String getAgentString(String agentString) {
        String agentS = "admin";
        try {
            if (!"UNASSIGNED".equals(agentString)) {
                agentS = agentString;
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
        }
        return agentS;
    }

    public String getAgentString(HttpServletRequest req, HttpServletResponse res) {
        String agentS = "admin";
        try {
            if (!"UNASSIGNED".equals(this.agentString)) {
                agentS = this.agentString;
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
        }
        return agentS;
    }

    @Override
    public String getDisplayName(String agentString) {
        if ("admin".equals(agentString)) {
            return "Administrator";
        }
        if ("rachel".equals(agentString)) {
            return "Rachel Gollub";
        }
        if ("marith".equals(agentString)) {
            return "Margaret Petit";
        }
        return "Dr. Who";
    }

    @Override
    public String getFirstName(String agentString) {
        if ("admin".equals(agentString)) {
            return "Samigo";
        }
        if ("rachel".equals(agentString)) {
            return "Rachel";
        }
        if ("marith".equals(agentString)) {
            return "Margaret";
        }
        return "Dr.";
    }

    @Override
    public String getLastName(String agentString) {
        if ("admin".equals(agentString)) {
            return "Administrator";
        }
        if ("rachel".equals(agentString)) {
            return "Gollub";
        }
        if ("marith".equals(agentString)) {
            return "Petit";
        }
        return "Who";
    }

    @Override
    public String getEmail(String agentString) {
        String s = "";
        try {
            if (!agentString.startsWith("anonymous_")) {
                s = UserDirectoryService.getUser((String)agentString).getEmail();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage());
        }
        return s;
    }

    @Override
    public String getRoleForCurrentAgent(String agentString) {
        return "Student";
    }

    @Override
    public String getRole(String agentString) {
        return "Maintain";
    }

    @Override
    public String getCurrentSiteId(boolean accessViaUrl) {
        return "Samigo Site";
    }

    @Override
    public String getCurrentSiteName(boolean accessViaUrl) {
        return "Samigo Site";
    }

    @Override
    public String getSiteName(String siteId) {
        return "Samigo Site";
    }

    @Override
    public String getDisplayNameByAgentId(String agentId) {
        return "Samigo Administrator";
    }

    @Override
    public String createAnonymous(AgentFacade agent) {
        String anonymousId = "anonymous_";
        try {
            anonymousId = anonymousId + new Date().getTime();
            agent.setAgentInstanceString(anonymousId);
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
        }
        return anonymousId;
    }

    @Override
    public boolean isStandaloneEnvironment() {
        return true;
    }

    @Override
    public boolean isIntegratedEnvironment() {
        return false;
    }

    public String getCurrentSiteIdFromExternalServlet(HttpServletRequest req, HttpServletResponse res) {
        return "Samigo Site";
    }

    @Override
    public String getAnonymousId(String agentString) {
        String agentS = "";
        try {
            if (!"UNASSIGNED".equals(agentString)) {
                agentS = agentString;
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex.getMessage());
        }
        return agentS;
    }

    public void setAgentString(String agentString) {
        this.agentString = agentString;
    }

    @Override
    public Map getUserRolesFromContextRealm(Collection inUsers) {
        return new HashMap();
    }

    @Override
    public String getRoleForAgentAndSite(String agentString, String siteId) {
        return null;
    }

    @Override
    public boolean isFileUploadAvailable() {
        return true;
    }
}

