/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services.assessment;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentTemplateData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AttachmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.cover.ToolManager;

public class AssessmentService {
    private static Log log = LogFactory.getLog(AssessmentService.class);
    public static final int UPDATE_SUCCESS = 0;
    public static final int UPDATE_ERROR_DRAW_SIZE_TOO_LARGE = 1;
    public static final String INVALID_CHARS_IN_RESOURCE_ID = "^/\\{}[]()%*?#&=\n\r\t\b\f";
    protected static final String MAP_TO_A = "\u0089\u008a\u0088\u008c\u0080?\u0087\u0087";
    protected static final String MAP_TO_B = "\u00a7\u00a7";
    protected static final String MAP_TO_C = "\u0082?\u00a2\u00a2";
    protected static final String MAP_TO_E = "\u008e?\u0091?\u0083\u00be\u00ae\u00ae";
    protected static final String MAP_TO_I = "\u0095\u0094\u0093\u0092\u0092";
    protected static final String MAP_TO_L = "\u00a3\u00a3";
    protected static final String MAP_TO_N = "\u0096\u0084\u0084";
    protected static final String MAP_TO_O = "\u0099\u009a\u0098\u0085\u0097\u0097";
    protected static final String MAP_TO_U = "\u009f\u009e?\u0086\u009c\u009c";
    protected static final String MAP_TO_Y = "\u00d8\u00b4??";
    protected static final String MAP_TO_X = "???\u00a4\u00a9\u00bb\u00a8\u00b1?\u00ab\u00b5\u00a6\u00c0?";
    protected static final String ESCAPE_CHARS_IN_RESOURCE_ID = ";'\"";

    public AssessmentTemplateFacade getAssessmentTemplate(String assessmentTemplateId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessmentTemplate(new Long(assessmentTemplateId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentFacade getAssessment(String assessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessment(Long.valueOf(assessmentId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentIfc getAssessment(Long assessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessment(assessmentId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentFacade getBasicInfoOfAnAssessment(String assessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAnAssessment(new Long(assessmentId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public ArrayList getAllAssessmentTemplates() {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllAssessmentTemplates();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public ArrayList getAllActiveAssessmentTemplates() {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllActiveAssessmentTemplates();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public ArrayList getTitleOfAllActiveAssessmentTemplates() {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getTitleOfAllActiveAssessmentTemplates();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public ArrayList getAllAssessments(String orderBy) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllAssessments(orderBy);
    }

    public ArrayList getAllActiveAssessments(String orderBy) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllActiveAssessments(orderBy);
    }

    public ArrayList getSettingsOfAllActiveAssessments(String orderBy) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getSettingsOfAllActiveAssessments(orderBy);
    }

    public ArrayList getBasicInfoOfAllActiveAssessments(String orderBy, boolean ascending) {
        String siteAgentId = AgentFacade.getCurrentSiteId();
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAllActiveAssessmentsByAgent(orderBy, siteAgentId, ascending);
    }

    public ArrayList getBasicInfoOfAllActiveAssessments(String orderBy) {
        String siteAgentId = AgentFacade.getCurrentSiteId();
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAllActiveAssessmentsByAgent(orderBy, siteAgentId);
    }

    public ArrayList getAllAssessments(int pageSize, int pageNumber, String orderBy) {
        try {
            if (pageSize > 0 && pageNumber > 0) {
                return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllAssessments(pageSize, pageNumber, orderBy);
            }
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllAssessments(orderBy);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentFacade createAssessment(String title, String description, String typeId, String templateId) throws Exception {
        return this.createAssessment(title, description, typeId, templateId, null);
    }

    public AssessmentFacade createAssessment(String title, String description, String typeId, String templateId, String siteId) throws Exception {
        AssessmentFacade assessment = null;
        try {
            Object assessmentTemplate = null;
            Long templateIdLong = AssessmentTemplateFacade.DEFAULTTEMPLATE;
            if (templateId != null && !templateId.equals("")) {
                templateIdLong = new Long(templateId);
            }
            Long typeIdLong = TypeFacade.HOMEWORK;
            if (typeId != null && !typeId.equals("")) {
                typeIdLong = new Long(typeId);
            }
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            log.debug((Object)("**** AssessmentFacadeQueries=" + queries));
            assessment = queries.createAssessment(title, description, typeIdLong, templateIdLong, siteId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception(e);
        }
        return assessment;
    }

    public int getQuestionSize(String assessmentId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getQuestionSize(new Long(assessmentId));
    }

    public void update(AssessmentFacade assessment) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdate(assessment);
    }

    public void save(AssessmentTemplateData template) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdate(template);
    }

    public void deleteAllSecuredIP(AssessmentIfc assessment) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().deleteAllSecuredIP(assessment);
    }

    public void saveAssessment(AssessmentFacade assessment) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdate(assessment);
    }

    public void deleteAssessmentTemplate(Long assessmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().deleteTemplate(assessmentId);
    }

    public void removeAssessment(String assessmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeAssessment(new Long(assessmentId));
    }

    public SectionFacade addSection(String assessmentId) {
        SectionFacade section = null;
        try {
            Long assessmentIdLong = new Long(assessmentId);
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            section = queries.addSection(assessmentIdLong);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return section;
    }

    public void removeSection(String sectionId) {
        try {
            Long sectionIdLong = new Long(sectionId);
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            queries.removeSection(sectionIdLong);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SectionFacade getSection(String sectionId) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getSection(new Long(sectionId));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void saveOrUpdateSection(SectionFacade section) {
        try {
            PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdateSection(section);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void moveAllItems(String sourceSectionId, String destSectionId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().moveAllItems(new Long(sourceSectionId), new Long(destSectionId));
    }

    public void removeAllItems(String sourceSectionId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeAllItems(new Long(sourceSectionId));
    }

    public boolean verifyItemsDrawSize(SectionFacade section) {
        if (section != null && section.getSectionMetaDataByLabel("AUTHOR_TYPE") != null && section.getSectionMetaDataByLabel("AUTHOR_TYPE").equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
            QuestionPoolService qpService = new QuestionPoolService();
            ArrayList itemlist = qpService.getAllItems(Long.valueOf(section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW")));
            return this.verifyItemsDrawSize(itemlist.size(), section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
        }
        return true;
    }

    private boolean verifyItemsDrawSize(int itemcount, String numberDrawn) {
        try {
            int numberDrawnInt = Integer.parseInt(numberDrawn);
            if (numberDrawnInt <= 0 || numberDrawnInt > itemcount) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public int updateRandomPoolQuestions(SectionFacade section) {
        if (section != null && section.getSectionMetaDataByLabel("AUTHOR_TYPE") != null && section.getSectionMetaDataByLabel("AUTHOR_TYPE").equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
            QuestionPoolService qpService = new QuestionPoolService();
            ArrayList itemlist = qpService.getAllItems(Long.valueOf(section.getSectionMetaDataByLabel("POOLID_FOR_RANDOM_DRAW")));
            if (this.verifyItemsDrawSize(itemlist.size(), section.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"))) {
                String requestedDiscount;
                String requestedScore;
                this.removeAllItems(section.getSectionId().toString());
                ItemService itemService = new ItemService();
                String agentId = AgentFacade.getAgentString();
                Iterator itemIter = section.getItemSet().iterator();
                while (itemIter.hasNext()) {
                    ItemDataIfc item = (ItemDataIfc)itemIter.next();
                    List poolIds = qpService.getPoolIdsByItem(item.getItemId().toString());
                    if (poolIds.size() != 0) continue;
                    itemService.deleteItem(item.getItemId(), agentId);
                    itemIter.remove();
                }
                section = this.getSection(section.getSectionId().toString());
                boolean hasRandomPartScore = false;
                Float score = null;
                String string = requestedScore = section.getSectionMetaDataByLabel("POINT_VALUE_FOR_QUESTION") != null ? section.getSectionMetaDataByLabel("POINT_VALUE_FOR_QUESTION") : "";
                if (requestedScore != null && !requestedScore.equals("")) {
                    hasRandomPartScore = true;
                    score = new Float(requestedScore);
                }
                boolean hasRandomPartDiscount = false;
                Float discount = null;
                String string2 = requestedDiscount = section.getSectionMetaDataByLabel("DISCOUNT_VALUE_FOR_QUESTION") != null ? section.getSectionMetaDataByLabel("DISCOUNT_VALUE_FOR_QUESTION") : "";
                if (requestedDiscount != null && !requestedDiscount.equals("")) {
                    hasRandomPartDiscount = true;
                    discount = new Float(requestedDiscount);
                }
                int i = 0;
                for (ItemFacade item : itemlist) {
                    item = qpService.copyItemFacade2(item);
                    item.setSection(section);
                    item.setSequence(i + 1);
                    if (hasRandomPartScore || hasRandomPartDiscount) {
                        ItemDataIfc data;
                        Set itemTextSet;
                        if (hasRandomPartScore) {
                            item.setScore(score);
                        }
                        long itemTypeId = item.getTypeId();
                        if (hasRandomPartDiscount && (itemTypeId == TypeFacade.MULTIPLE_CHOICE || itemTypeId == TypeFacade.TRUE_FALSE)) {
                            item.setDiscount(discount);
                        }
                        if ((itemTextSet = (data = item.getData()).getItemTextSet()) != null) {
                            for (ItemTextIfc itemText : itemTextSet) {
                                Set answerSet = itemText.getAnswerSet();
                                if (answerSet == null) continue;
                                for (AnswerIfc answer : answerSet) {
                                    if (hasRandomPartScore) {
                                        answer.setScore(score);
                                    }
                                    if (!hasRandomPartDiscount || itemTypeId != TypeFacade.MULTIPLE_CHOICE && itemTypeId != TypeFacade.TRUE_FALSE) continue;
                                    answer.setDiscount(discount);
                                }
                            }
                        }
                    }
                    section.addItem(item);
                    ++i;
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
                section.addSectionMetaData("QUESTIONS_RANDOM_DRAW_DATE", df.format(new Date()));
                this.saveOrUpdateSection(section);
            } else {
                return 1;
            }
        }
        return 0;
    }

    public int updateAllRandomPoolQuestions(AssessmentFacade assessment) {
        for (SectionFacade section : assessment.getSectionArray()) {
            if (this.verifyItemsDrawSize(section)) continue;
            return 1;
        }
        for (SectionFacade section : assessment.getSectionArray()) {
            this.updateRandomPoolQuestions(section);
        }
        return 0;
    }

    public ArrayList getBasicInfoOfAllActiveAssessmentTemplates(String orderBy) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getBasicInfoOfAllActiveAssessmentTemplates(orderBy);
    }

    public AssessmentFacade createAssessmentWithoutDefaultSection(String title, String description, String typeId, String templateId) throws Exception {
        return this.createAssessmentWithoutDefaultSection(title, description, typeId, templateId, null);
    }

    public AssessmentFacade createAssessmentWithoutDefaultSection(String title, String description, String typeId, String templateId, String siteId) throws Exception {
        AssessmentFacade assessment = null;
        try {
            Object assessmentTemplate = null;
            Long templateIdLong = AssessmentTemplateFacade.DEFAULTTEMPLATE;
            if (templateId != null && !templateId.equals("")) {
                templateIdLong = new Long(templateId);
            }
            Long typeIdLong = TypeFacade.HOMEWORK;
            if (typeId != null && !typeId.equals("")) {
                typeIdLong = new Long(typeId);
            }
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            assessment = queries.createAssessmentWithoutDefaultSection(title, description, typeIdLong, templateIdLong, siteId);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception(e);
        }
        return assessment;
    }

    public boolean assessmentTitleIsUnique(String assessmentBaseId, String title, boolean isTemplate) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().assessmentTitleIsUnique(new Long(assessmentBaseId), title, isTemplate);
    }

    public List getAssessmentByTemplate(String templateId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessmentByTemplate(new Long(templateId));
    }

    public List getDefaultMetaDataSet() {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getDefaultMetaDataSet();
    }

    public void deleteAllMetaData(AssessmentBaseIfc assessment) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().deleteAllMetaData(assessment);
    }

    public ItemAttachmentIfc createItemAttachment(ItemDataIfc item, String resourceId, String filename, String protocol) {
        return this.createItemAttachment(item, resourceId, filename, protocol, true);
    }

    public ItemAttachmentIfc createItemAttachment(ItemDataIfc item, String resourceId, String filename, String protocol, boolean isEditPendingAssessmentFlow) {
        ItemAttachmentIfc attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createItemAttachment(item, resourceId, filename, protocol, isEditPendingAssessmentFlow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachment;
    }

    public void removeItemAttachment(String attachmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeItemAttachment(new Long(attachmentId));
    }

    public void updateAssessmentLastModifiedInfo(AssessmentIfc assessment) {
        try {
            PersistenceService.getInstance().getAssessmentFacadeQueries().updateAssessmentLastModifiedInfo((AssessmentFacade)assessment);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public SectionAttachmentIfc createSectionAttachment(SectionDataIfc section, String resourceId, String filename, String protocol) {
        SectionAttachmentIfc attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createSectionAttachment(section, resourceId, filename, protocol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachment;
    }

    public void removeSectionAttachment(String attachmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeSectionAttachment(new Long(attachmentId));
    }

    public AssessmentAttachmentIfc createAssessmentAttachment(AssessmentIfc assessment, String resourceId, String filename, String protocol) {
        AssessmentAttachmentIfc attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createAssessmentAttachment(assessment, resourceId, filename, protocol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachment;
    }

    public void removeAssessmentAttachment(String attachmentId) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().removeAssessmentAttachment(new Long(attachmentId));
    }

    public AttachmentData createEmailAttachment(String resourceId, String filename, String protocol) {
        AttachmentData attachment = null;
        try {
            AssessmentFacadeQueriesAPI queries = PersistenceService.getInstance().getAssessmentFacadeQueries();
            attachment = queries.createEmailAttachment(resourceId, filename, protocol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachment;
    }

    public List getAssessmentResourceIdList(AssessmentIfc pub) {
        List resourceIdList = new ArrayList();
        List list = pub.getAssessmentAttachmentList();
        if (list != null) {
            resourceIdList = this.getResourceIdList(list);
        }
        Set sectionSet = pub.getSectionSet();
        for (SectionDataIfc section : sectionSet) {
            List sectionAttachments = this.getSectionResourceIdList(section);
            if (sectionAttachments == null) continue;
            resourceIdList.addAll(sectionAttachments);
        }
        log.debug((Object)("*** resource size=" + resourceIdList.size()));
        return resourceIdList;
    }

    public List getSectionResourceIdList(SectionDataIfc section) {
        List resourceIdList = new ArrayList();
        List list = section.getSectionAttachmentList();
        if (list != null) {
            resourceIdList = this.getResourceIdList(list);
        }
        Set itemSet = section.getItemSet();
        for (ItemDataIfc item : itemSet) {
            List itemAttachments = this.getItemResourceIdList(item);
            if (itemAttachments == null) continue;
            resourceIdList.addAll(itemAttachments);
        }
        return resourceIdList;
    }

    public List getItemResourceIdList(ItemDataIfc item) {
        List resourceIdList = new ArrayList();
        List list = item.getItemAttachmentList();
        if (list != null) {
            resourceIdList = this.getResourceIdList(list);
        }
        return resourceIdList;
    }

    private List getResourceIdList(List list) {
        ArrayList<String> resourceIdList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            AttachmentIfc attach = (AttachmentIfc)list.get(i);
            resourceIdList.add(attach.getResourceId());
        }
        return resourceIdList;
    }

    public void deleteResources(List resourceIdList) {
        if (resourceIdList == null) {
            return;
        }
        for (int i = 0; i < resourceIdList.size(); ++i) {
            String resourceId = (String)resourceIdList.get(i);
            if (!(resourceId = resourceId.trim()).toLowerCase().startsWith("/attachment")) continue;
            try {
                log.debug((Object)("removing=" + resourceId));
                AssessmentService.getContentHostingService().removeResource(resourceId);
                continue;
            }
            catch (PermissionException e) {
                log.warn((Object)("cannot remove resourceId=" + resourceId + ":" + e.getMessage()));
                log.warn((Object)("PermissionException from ContentHostingService:" + e.getMessage()));
                continue;
            }
            catch (IdUnusedException e) {
                log.warn((Object)("cannot remove resourceId=" + resourceId + ":" + e.getMessage()));
                log.warn((Object)("IdUnusedException from ContentHostingService:" + e.getMessage()));
                continue;
            }
            catch (TypeException e) {
                log.warn((Object)("cannot remove resourceId=" + resourceId + ":" + e.getMessage()));
                log.warn((Object)("TypeException from ContentHostingService:" + e.getMessage()));
                continue;
            }
            catch (InUseException e) {
                log.warn((Object)("cannot remove resourceId=" + resourceId + ":" + e.getMessage()));
                log.warn((Object)("InUseException from ContentHostingService:" + e.getMessage()));
            }
        }
    }

    public void saveOrUpdateAttachments(List list) {
        PersistenceService.getInstance().getAssessmentFacadeQueries().saveOrUpdateAttachments(list);
    }

    public ContentResource createCopyOfContentResource(String resourceId, String filename, String toContext) {
        filename = filename.replaceAll("http://", "http:__");
        ContentResource cr_copy = null;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            String escapedName = AssessmentService.escapeResourceName(filename);
            cr_copy = toContext != null && !toContext.equals("") ? AssessmentService.getContentHostingService().addAttachmentResource(escapedName, toContext, ToolManager.getTool((String)"sakai.samigo").getTitle(), cr.getContentType(), cr.streamContent(), cr.getProperties()) : AssessmentService.getContentHostingService().addAttachmentResource(escapedName, ToolManager.getCurrentPlacement().getContext(), ToolManager.getTool((String)"sakai.samigo").getTitle(), cr.getContentType(), cr.streamContent(), cr.getProperties());
        }
        catch (IdInvalidException e) {
            log.warn((Object)e.getMessage());
        }
        catch (PermissionException e) {
            log.warn((Object)e.getMessage());
        }
        catch (IdUnusedException e) {
            log.warn((Object)e.getMessage());
        }
        catch (TypeException e) {
            log.warn((Object)e.getMessage());
        }
        catch (InconsistentException e) {
            log.warn((Object)e.getMessage());
        }
        catch (IdUsedException e) {
            log.warn((Object)e.getMessage());
        }
        catch (OverQuotaException e) {
            log.warn((Object)e.getMessage());
        }
        catch (ServerOverloadException e) {
            log.warn((Object)e.getMessage());
        }
        return cr_copy;
    }

    public ContentResource createCopyOfContentResource(String resourceId, String filename) {
        return this.createCopyOfContentResource(resourceId, filename, null);
    }

    public static String escapeResourceName(String id) {
        if (id == null) {
            return "";
        }
        id = id.trim();
        try {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (MAP_TO_A.indexOf(c) >= 0) {
                    buf.append('a');
                    continue;
                }
                if (MAP_TO_E.indexOf(c) >= 0) {
                    buf.append('e');
                    continue;
                }
                if (MAP_TO_I.indexOf(c) >= 0) {
                    buf.append('i');
                    continue;
                }
                if (MAP_TO_O.indexOf(c) >= 0) {
                    buf.append('o');
                    continue;
                }
                if (MAP_TO_U.indexOf(c) >= 0) {
                    buf.append('u');
                    continue;
                }
                if (MAP_TO_Y.indexOf(c) >= 0) {
                    buf.append('y');
                    continue;
                }
                if (MAP_TO_N.indexOf(c) >= 0) {
                    buf.append('n');
                    continue;
                }
                if (MAP_TO_B.indexOf(c) >= 0) {
                    buf.append('b');
                    continue;
                }
                if (MAP_TO_C.indexOf(c) >= 0) {
                    buf.append('c');
                    continue;
                }
                if (MAP_TO_L.indexOf(c) >= 0) {
                    buf.append('l');
                    continue;
                }
                if (MAP_TO_X.indexOf(c) >= 0) {
                    buf.append('x');
                    continue;
                }
                if (c < ' ') {
                    buf.append('_');
                    continue;
                }
                if (INVALID_CHARS_IN_RESOURCE_ID.indexOf(c) >= 0 || ESCAPE_CHARS_IN_RESOURCE_ID.indexOf(c) >= 0) {
                    buf.append('_');
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            log.warn((Object)"escapeResourceName: ", (Throwable)e);
            return id;
        }
    }

    public void copyAllAssessments(String fromContext, String toContext) {
        try {
            PersistenceService.getInstance().getAssessmentFacadeQueries().copyAllAssessments(fromContext, toContext);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void copyAssessment(String assessmentId, String apepndCopyTitle) {
        try {
            PersistenceService.getInstance().getAssessmentFacadeQueries().copyAssessment(assessmentId, apepndCopyTitle);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public List getAllActiveAssessmentsbyAgent(String fromContext) {
        try {
            return PersistenceService.getInstance().getAssessmentFacadeQueries().getAllActiveAssessmentsByAgent(fromContext);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public String getAssessmentSiteId(String assessmentId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessmentSiteId(assessmentId);
    }

    public String getAssessmentCreatedBy(String assessmentId) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getAssessmentCreatedBy(assessmentId);
    }

    public Set copyItemAttachmentSet(ItemData newItem, Set itemAttachmentSet) {
        return PersistenceService.getInstance().getAssessmentFacadeQueries().copyItemAttachmentSet(newItem, itemAttachmentSet);
    }

    public static ContentHostingService getContentHostingService() {
        return (ContentHostingService)ComponentManager.get((String)ContentHostingService.class.getName());
    }

    public List getFavoriteColChoicesbyAgent(String fromContext) {
        try {
            return PersistenceService.getInstance().getFavoriteColChoicesFacadeQueries().getFavoriteColChoicesByAgent(fromContext);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

