/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.assessment;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentTemplateData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentTemplateIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentServiceException;
import org.sakaiproject.tool.assessment.shared.api.assessment.AssessmentServiceAPI;

public class AssessmentServiceImpl
implements AssessmentServiceAPI {
    private static Log log = LogFactory.getLog(AssessmentServiceImpl.class);

    public AssessmentTemplateIfc getAssessmentTemplate(String assessmentTemplateId) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getAssessmentTemplate(assessmentTemplateId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public AssessmentIfc getAssessment(String assessmentId) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getAssessment(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public AssessmentIfc getBasicInfoOfAnAssessment(String assessmentId) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getBasicInfoOfAnAssessment(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllAssessmentTemplates() {
        try {
            AssessmentService service = new AssessmentService();
            return service.getAllAssessmentTemplates();
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllActiveAssessmentTemplates() {
        try {
            AssessmentService service = new AssessmentService();
            return service.getAllActiveAssessmentTemplates();
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getTitleOfAllActiveAssessmentTemplates() {
        try {
            AssessmentService service = new AssessmentService();
            return service.getTitleOfAllActiveAssessmentTemplates();
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllAssessments(String orderBy) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getAllAssessments(orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllActiveAssessments(String orderBy) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getAllActiveAssessments(orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getSettingsOfAllActiveAssessments(String orderBy) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getSettingsOfAllActiveAssessments(orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getBasicInfoOfAllActiveAssessments(String orderBy, boolean ascending) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getBasicInfoOfAllActiveAssessments(orderBy, ascending);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getBasicInfoOfAllActiveAssessments(String orderBy) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getBasicInfoOfAllActiveAssessments(orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllAssessments(int pageSize, int pageNumber, String orderBy) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getAllAssessments(pageSize, pageNumber, orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public AssessmentIfc createAssessment(String title, String description, String typeId, String templateId) {
        try {
            AssessmentService service = new AssessmentService();
            return service.createAssessment(title, description, typeId, templateId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public int getQuestionSize(String assessmentId) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getQuestionSize(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void update(AssessmentIfc assessment) {
        try {
            AssessmentService service = new AssessmentService();
            AssessmentFacade facade = service.getAssessment(assessment.getAssessmentId().toString());
            service.update(facade);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void save(AssessmentTemplateIfc template) {
        try {
            AssessmentService service = new AssessmentService();
            AssessmentTemplateData data = (AssessmentTemplateData)service.getAssessmentTemplate(template.getAssessmentTemplateId().toString()).getData();
            service.save(data);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void saveAssessment(AssessmentIfc assessment) {
        try {
            AssessmentService service = new AssessmentService();
            AssessmentFacade facade = service.getAssessment(assessment.getAssessmentId().toString());
            service.saveAssessment(facade);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void deleteAssessmentTemplate(Long assessmentId) {
        try {
            AssessmentService service = new AssessmentService();
            service.deleteAssessmentTemplate(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void removeAssessment(String assessmentId) {
        try {
            AssessmentService service = new AssessmentService();
            service.removeAssessment(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public SectionDataIfc addSection(String assessmentId) {
        try {
            AssessmentService service = new AssessmentService();
            return service.addSection(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void removeSection(String sectionId) {
        try {
            AssessmentService service = new AssessmentService();
            service.removeSection(sectionId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public SectionDataIfc getSection(String sectionId) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getSection(sectionId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void saveOrUpdateSection(SectionDataIfc section) {
        try {
            AssessmentService service = new AssessmentService();
            SectionFacade facade = service.getSection(section.getSectionId().toString());
            service.saveOrUpdateSection(facade);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void moveAllItems(String sourceSectionId, String destSectionId) {
        try {
            AssessmentService service = new AssessmentService();
            service.moveAllItems(sourceSectionId, destSectionId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void removeAllItems(String sourceSectionId) {
        try {
            AssessmentService service = new AssessmentService();
            service.removeAllItems(sourceSectionId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getBasicInfoOfAllActiveAssessmentTemplates(String orderBy) {
        try {
            AssessmentService service = new AssessmentService();
            return service.getBasicInfoOfAllActiveAssessmentTemplates(orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public AssessmentIfc createAssessmentWithoutDefaultSection(String title, String description, String typeId, String templateId) {
        try {
            AssessmentService service = new AssessmentService();
            return service.createAssessmentWithoutDefaultSection(title, description, typeId, templateId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }
}

