/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.assessment;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentServiceException;
import org.sakaiproject.tool.assessment.shared.api.assessment.ItemServiceAPI;

public class ItemServiceImpl
implements ItemServiceAPI {
    private static Log log = LogFactory.getLog(ItemServiceImpl.class);

    public ItemDataIfc getItem(Long itemId, String agentId) {
        ItemFacade item = null;
        try {
            ItemService service = new ItemService();
            item = service.getItem(itemId, agentId);
        }
        catch (Exception e) {
            throw new AssessmentServiceException(e);
        }
        return item;
    }

    public void deleteItem(Long itemId, String agentId) {
        try {
            ItemService service = new ItemService();
            service.deleteItem(itemId, agentId);
        }
        catch (Exception e) {
            throw new AssessmentServiceException(e);
        }
    }

    public void deleteItemContent(Long itemId, String agentId) {
        try {
            ItemService service = new ItemService();
            service.deleteItemContent(itemId, agentId);
        }
        catch (Exception e) {
            throw new AssessmentServiceException(e);
        }
    }

    public void deleteItemMetaData(Long itemId, String label, String agentId) {
        try {
            ItemService service = new ItemService();
            service.deleteItemMetaData(itemId, label, agentId);
        }
        catch (Exception e) {
            throw new AssessmentServiceException(e);
        }
    }

    public void addItemMetaData(Long itemId, String label, String value, String agentId) {
        try {
            ItemService service = new ItemService();
            service.addItemMetaData(itemId, label, value, agentId);
        }
        catch (Exception e) {
            throw new AssessmentServiceException(e);
        }
    }

    public ItemDataIfc saveItem(ItemDataIfc item) {
        try {
            String itemId = item.getItemIdString();
            ItemService service = new ItemService();
            item = service.saveItem(service.getItem(itemId));
        }
        catch (Exception e) {
            throw new AssessmentServiceException(e);
        }
        return item;
    }

    public ItemDataIfc getItem(String itemId) {
        ItemFacade item = null;
        try {
            ItemService service = new ItemService();
            item = service.getItem(itemId);
        }
        catch (Exception e) {
            throw new AssessmentServiceException(e);
        }
        return item;
    }

    public Map getItemsByKeyword(String keyword) {
        HashMap itemKeywordMap = new HashMap();
        try {
            ItemService service = new ItemService();
            itemKeywordMap = service.getItemsByKeyword(keyword);
        }
        catch (Exception e) {
            throw new AssessmentServiceException(e);
        }
        return itemKeywordMap;
    }
}

