/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextFormat {
    private static Log log = LogFactory.getLog(TextFormat.class);
    private static final String HTML = "HTML";
    private static final String SMART = "SMART";
    private static final String PLAIN = "PLAIN";
    private static final Vector vProtocols = new Vector();
    private StringBuilder returnText;
    private StringBuilder resource;
    private ArrayList arrLst;

    public String formatText(String text, String texttype, String iconPath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("formatText(String " + text + ", String " + texttype + ", String " + iconPath + ")"));
        }
        this.returnText = new StringBuilder();
        if (texttype == null || text == null) {
            return text;
        }
        if (texttype.equals(PLAIN)) {
            return text;
        }
        if (texttype.equals(HTML)) {
            return text;
        }
        if (texttype.equals(SMART)) {
            int start = 0;
            int end = 0;
            while (true) {
                this.arrLst = new ArrayList();
                Iterator i = vProtocols.iterator();
                while (i.hasNext()) {
                    String str = (String)i.next();
                    Integer retVal = this.indexOfIgnoreCase(text, str);
                    this.arrLst.add(retVal);
                    if (retVal != -1) continue;
                    i.remove();
                }
                start = this.minimum(this.arrLst);
                log.debug((Object)("start: " + String.valueOf(start)));
                if (start == -1 || vProtocols.isEmpty()) break;
                end = text.indexOf(" ", start);
                if (end == -1) {
                    end = text.length();
                }
                if (start != 0) {
                    this.returnText.append(text.substring(0, start));
                    log.debug((Object)("adding pre-resource text: " + text.substring(0, start)));
                }
                log.debug((Object)("end: " + String.valueOf(end)));
                this.resource = new StringBuilder();
                String upper = text.substring(start, end).toUpperCase();
                try {
                    if (upper.startsWith("HTTPS://")) {
                        this.resource.append("https://");
                        this.resource.append(URLEncoder.encode(text.substring(start + 8, end), "UTF-8"));
                        log.debug((Object)("hi" + this.resource));
                    } else if (upper.startsWith("HTTP://") || upper.startsWith("MAILTO:") || upper.startsWith("TELNET:")) {
                        this.resource.append("http://");
                        this.resource.append(URLEncoder.encode(text.substring(start + 7, end), "UTF-8"));
                    } else if (upper.startsWith("FTP://")) {
                        this.resource.append("ftp://");
                        this.resource.append(URLEncoder.encode(text.substring(start + 6, end), "UTF-8"));
                    } else if (upper.startsWith("WWW.")) {
                        this.resource.append("www.");
                        this.resource.append(URLEncoder.encode(text.substring(start + 4, end), "UTF-8"));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                String temp = this.resource.toString();
                this.resource.insert(this.resource.length(), "', target=_new>" + temp + "</a>");
                this.resource.insert(0, "<a href='");
                this.returnText.append((CharSequence)this.resource);
                log.debug((Object)("add ing resource: " + this.resource.toString()));
                text = text.substring(end);
            }
            if (text.length() != 0) {
                this.returnText.append(text);
            }
            int temp = 0;
            while ((temp = this.returnText.indexOf(":-)")) != -1) {
                this.returnText.replace(temp, temp + 3, "<img src='" + iconPath + "smile.gif'/>");
            }
            while ((temp = this.returnText.indexOf(":-(")) != -1) {
                this.returnText.replace(temp, temp + 3, "<img src='" + iconPath + "frown.gif'/>");
            }
            while ((temp = this.returnText.indexOf(":-o")) != -1) {
                this.returnText.replace(temp, temp + 3, "<img src='" + iconPath + "suprise.gif'/>");
            }
            while ((temp = this.returnText.indexOf(";-)")) != -1) {
                this.returnText.replace(temp, temp + 3, "<img src='" + iconPath + "wink.gif'/>");
            }
            while ((temp = this.returnText.indexOf(":)")) != -1) {
                this.returnText.replace(temp, temp + 2, "<img src='" + iconPath + "smile.gif'/>");
            }
            while ((temp = this.returnText.indexOf(":(")) != -1) {
                this.returnText.replace(temp, temp + 2, "<img src='" + iconPath + "frown.gif'/>");
            }
            while ((temp = this.returnText.indexOf(":o")) != -1) {
                this.returnText.replace(temp, temp + 2, "<img src='" + iconPath + "suprise.gif'/>");
            }
            while ((temp = this.returnText.indexOf(";)")) != -1) {
                this.returnText.replace(temp, temp + 2, "<img src='" + iconPath + "wink.gif'/>");
            }
            return this.returnText.toString();
        }
        return "";
    }

    public Integer indexOfIgnoreCase(String str, String searchString) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("indexOfIgnoreCase(String " + str + ", String " + searchString + ")"));
        }
        return str.toUpperCase().indexOf(searchString.toUpperCase());
    }

    public int minimum(ArrayList a) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("minimum(ArrayList " + a + ")"));
        }
        boolean firstNumber = true;
        int tmp = 0;
        int min = -1;
        Iterator i = a.iterator();
        while (i.hasNext()) {
            tmp = (Integer)i.next();
            if (firstNumber && tmp != -1) {
                firstNumber = false;
                min = tmp;
            }
            if (tmp == -1 || tmp >= min) continue;
            min = tmp;
        }
        return min;
    }

    public static void main(String[] args) {
        TextFormat tf = new TextFormat();
        log.info((Object)tf.formatText("www.cs.iupui.edu ui.edu dd dd dd:):-) ff telnet:dd dddddupui.edu", "SMART", "http://oncourse.iu.edu/images/icons/"));
        log.info((Object)tf.formatText("http://www.iupui.edu:80 www.ui.edu :( ::-( ddd", "SMART", "http://oncourse.iu.edu/images/icons/"));
        log.debug((Object)String.valueOf(System.identityHashCode(tf)));
    }

    public static String convertPlaintextToFormattedTextNoHighUnicode(Log log, String value) {
        if (value == null) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder();
            int len = value.length();
            block9: for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '<': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&lt;");
                        continue block9;
                    }
                    case '>': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&gt;");
                        continue block9;
                    }
                    case '&': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&amp;");
                        continue block9;
                    }
                    case '\"': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&quot;");
                        continue block9;
                    }
                    case '\n': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("<br />\n");
                        continue block9;
                    }
                    default: {
                        if (buf == null) continue block9;
                        buf.append(c);
                    }
                }
            }
            return buf == null ? value : buf.toString();
        }
        catch (Exception e) {
            log.warn((Object)"convertPlaintextToFormattedTextNoHighUnicode: ", (Throwable)e);
            return "";
        }
    }

    static {
        vProtocols.add("http://");
        vProtocols.add("https://");
        vProtocols.add("ftp://");
        vProtocols.add("www.");
        vProtocols.add("telent:");
        vProtocols.add("mailto:");
    }
}

