/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.samlite.api;

import java.util.LinkedList;
import java.util.List;
import org.sakaiproject.tool.assessment.samlite.api.Answer;

public class Question {
    public static final int UNDEFINED_QUESTION = 0;
    public static final int MULTIPLE_CHOICE_QUESTION = 10;
    public static final int MULTIPLE_CHOICE_MULTIPLE_ANSWER_QUESTION = 15;
    public static final int FILL_IN_THE_BLANK_QUESTION = 20;
    public static final int TRUE_FALSE_QUESTION = 30;
    public static final int SHORT_ESSAY_QUESTION = 40;
    private int questionNumber = 0;
    private String questionPoints = "";
    private List questionLines = new LinkedList();
    private int questionType = 0;
    private String correctAnswer = "";
    private List answers = new LinkedList();
    private boolean hasPoints = false;
    private String questionTypeAsString = "";

    public void addAnswer(String id, String text, boolean isCorrect) {
        this.answers.add(new Answer(id, text, isCorrect));
    }

    public List getAnswers() {
        return this.answers;
    }

    public void setAnswers(List answers) {
        this.answers = answers;
    }

    public String getCorrectAnswer() {
        return this.correctAnswer;
    }

    public void setCorrectAnswer(String correctAnswer) {
        this.correctAnswer = correctAnswer;
    }

    public String getQuestion() {
        StringBuilder buffer = new StringBuilder();
        for (String line : this.questionLines) {
            if (null == line || "".equals(line)) continue;
            buffer.append(line.trim()).append(" ");
        }
        return buffer.toString();
    }

    public void append(String questionSegment) {
        this.questionLines.add(questionSegment);
    }

    public int getQuestionNumber() {
        return this.questionNumber;
    }

    public void setQuestionNumber(int questionNumber) {
        this.questionNumber = questionNumber;
    }

    public String getQuestionPoints() {
        return this.questionPoints;
    }

    public void setQuestionPoints(String questionPoints) {
        if (null != questionPoints && !"".equals(questionPoints)) {
            this.hasPoints = true;
        }
        this.questionPoints = questionPoints;
    }

    public boolean hasPoints() {
        return this.hasPoints;
    }

    public int getQuestionType() {
        return this.questionType;
    }

    public void setQuestionType(int questionType) {
        this.questionType = questionType;
    }

    public String getQuestionTypeAsString() {
        return this.questionTypeAsString;
    }

    public void setQuestionTypeAsString(String questionTypeAsString) {
        this.questionTypeAsString = questionTypeAsString;
    }
}

