/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.authz;

import java.util.ArrayList;
import java.util.Set;
import org.osid.shared.Id;
import org.osid.shared.Type;
import org.sakaiproject.tool.assessment.data.dao.authz.QualifierData;
import org.sakaiproject.tool.assessment.data.ifc.authz.QualifierIfc;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.authz.QualifierIteratorFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;

public class QualifierFacade
implements QualifierIfc {
    private static final long serialVersionUID = 3908822740713745290L;
    private Id id;
    private QualifierIteratorFacade childrenIter;
    private QualifierIteratorFacade parentIter;
    private String referenceName;
    private String description;
    private Type qualifierType;
    private QualifierIfc data;
    private long qualifierId;
    private String displayName;
    private String qualifierTypeId;
    private Set childSet;
    private Set parentSet;

    public QualifierFacade() {
        this.data = new QualifierData();
    }

    public QualifierFacade(long qualifierId, String referenceName, String displayName, String description, String qualifierTypeId) {
        this.data = new QualifierData();
        this.referenceName = referenceName;
        this.setQualifierId(qualifierId);
        this.setReferenceName(referenceName);
        this.setDisplayName(displayName);
        this.setDescription(description);
        this.setQualifierTypeId(qualifierTypeId);
    }

    public QualifierFacade(QualifierIfc data) {
        this.data = data;
        this.id = this.getId();
        this.referenceName = this.getReferenceName();
        this.description = this.getDescription();
        this.qualifierType = this.getQualifierType();
        this.qualifierId = this.getQualifierId();
        this.qualifierTypeId = this.getQualifierTypeId();
        this.displayName = this.getDisplayName();
    }

    public Id getId() {
        return this.id;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
        this.data.setReferenceName(referenceName);
    }

    public String getDescription() {
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.description = description;
        this.data.setDescription(description);
    }

    public Type getQualifierType() {
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeById(new Long(this.data.getQualifierTypeId()));
    }

    public void updateDescription(String description) {
        this.description = description;
    }

    public void addParent(Id parm1) {
        ArrayList<Id> a = new ArrayList<Id>();
        while (this.parentIter.hasNextQualifier()) {
            Id i = (Id)this.parentIter.nextQualifier();
            a.add(i);
        }
        a.add(parm1);
        this.parentIter = new QualifierIteratorFacade(a);
    }

    public void removeParent(Id parm1) {
        ArrayList<Id> a = new ArrayList<Id>();
        while (this.parentIter.hasNextQualifier()) {
            Id i = (Id)this.parentIter.nextQualifier();
            if (parm1.equals(i)) continue;
            a.add(i);
        }
        this.parentIter = new QualifierIteratorFacade(a);
    }

    public void changeParent(Id oldParent, Id newParent) {
        ArrayList<Id> a = new ArrayList<Id>();
        while (this.parentIter.hasNextQualifier()) {
            Id i = (Id)this.parentIter.nextQualifier();
            if (!oldParent.equals(i)) {
                a.add(i);
                continue;
            }
            a.add(newParent);
        }
        this.parentIter = new QualifierIteratorFacade(a);
    }

    public boolean isChildOf(Id parent) {
        boolean returnValue = false;
        while (this.parentIter.hasNextQualifier()) {
            Id i = (Id)this.parentIter.nextQualifier();
            if (!parent.equals(i)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public QualifierIfc getData() {
        return this.data;
    }

    public long getQualifierId() {
        return this.data.getQualifierId();
    }

    public void setQualifierId(long id) {
        this.qualifierId = id;
        this.data.setQualifierId(id);
    }

    public String getDisplayName() {
        return this.data.getDisplayName();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.data.setDisplayName(displayName);
    }

    public String getQualifierTypeId() {
        return this.data.getQualifierTypeId();
    }

    public void setQualifierTypeId(String qualifierTypeId) {
        this.qualifierTypeId = qualifierTypeId;
        this.data.setQualifierTypeId(qualifierTypeId);
    }
}

