/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.integration.context.spring.FactoryUtil;
import org.sakaiproject.tool.assessment.integration.helper.ifc.AgentHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.CalendarServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.PublishingTargetHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.SectionAwareServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.ServerConfigurationServiceHelper;

public abstract class IntegrationContextFactory {
    private static Log log = LogFactory.getLog(IntegrationContextFactory.class);
    private static IntegrationContextFactory instance = null;

    public static IntegrationContextFactory getInstance() {
        log.debug((Object)"IntegrationContextFactory.getInstance()");
        if (instance == null) {
            try {
                FactoryUtil.setUseLocator(true);
                instance = FactoryUtil.lookup();
            }
            catch (Exception ex) {
                log.error((Object)("Unable to read integration context: " + ex));
            }
        }
        log.debug((Object)("instance=" + instance));
        return instance;
    }

    public abstract boolean isIntegrated();

    public abstract AgentHelper getAgentHelper();

    public abstract GradebookHelper getGradebookHelper();

    public abstract GradebookServiceHelper getGradebookServiceHelper();

    public abstract PublishingTargetHelper getPublishingTargetHelper();

    public abstract SectionAwareServiceHelper getSectionAwareServiceHelper();

    public abstract ServerConfigurationServiceHelper getServerConfigurationServiceHelper();

    public abstract CalendarServiceHelper getCalendarServiceHelper();
}

