/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.data.dao.assessment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Category;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemText;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;

public class PublishedItemData
implements Serializable,
ItemDataIfc,
Comparable {
    static Category errorLogger = Category.getInstance((String)"errorLogger");
    static ResourceBundle rb = ResourceBundle.getBundle("org.sakaiproject.tool.assessment.bundle.Messages");
    private static final long serialVersionUID = 7526471155622776147L;
    private Long itemId;
    private String itemIdString;
    private SectionDataIfc section;
    private Integer sequence;
    private Integer duration;
    private Integer triesAllowed;
    private String instruction;
    private String description;
    private Long typeId;
    private String grade;
    private Float score;
    private Float discount;
    private String hint;
    private Boolean hasRationale;
    private Integer status;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private Set itemTextSet;
    private Set itemMetaDataSet;
    private Set itemFeedbackSet;
    private ItemGradingData lastItemGradingDataByAgent;
    private Set itemAttachmentSet;
    private Boolean partialCreditFlag;

    public PublishedItemData() {
    }

    public PublishedItemData(SectionDataIfc section, Integer sequence, Integer duration, String instruction, String description, Long typeId, String grade, Float score, Float discount, String hint, Boolean hasRationale, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, Set itemTextSet, Set itemMetaDataSet, Set itemFeedbackSet, Boolean partialCreditFlag) {
        this.section = section;
        this.sequence = sequence;
        this.duration = duration;
        this.instruction = instruction;
        this.description = description;
        this.typeId = typeId;
        this.grade = grade;
        this.score = score;
        this.discount = discount;
        this.hint = hint;
        this.hasRationale = hasRationale;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.itemTextSet = itemTextSet;
        this.itemMetaDataSet = itemMetaDataSet;
        this.itemFeedbackSet = itemFeedbackSet;
        this.partialCreditFlag = partialCreditFlag;
    }

    public PublishedItemData(SectionDataIfc section, Integer sequence, Integer duration, String instruction, String description, Long typeId, String grade, Float score, Float discount, String hint, Boolean hasRationale, Integer status, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, Set itemTextSet, Set itemMetaDataSet, Set itemFeedbackSet, Integer triesAllowed, Boolean partialCreditFlag) {
        this.section = section;
        this.sequence = sequence;
        this.duration = duration;
        this.instruction = instruction;
        this.description = description;
        this.typeId = typeId;
        this.grade = grade;
        this.score = score;
        this.discount = discount;
        this.hint = hint;
        this.hasRationale = hasRationale;
        this.status = status;
        this.createdBy = createdBy;
        this.createdDate = createdDate;
        this.lastModifiedBy = lastModifiedBy;
        this.lastModifiedDate = lastModifiedDate;
        this.itemTextSet = itemTextSet;
        this.itemMetaDataSet = itemMetaDataSet;
        this.itemFeedbackSet = itemFeedbackSet;
        this.triesAllowed = triesAllowed;
        this.partialCreditFlag = partialCreditFlag;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
        this.setItemIdString(itemId.toString());
    }

    public String getItemIdString() {
        return this.itemIdString;
    }

    public void setItemIdString(String itemIdString) {
        this.itemIdString = itemIdString;
    }

    public SectionDataIfc getSection() {
        return this.section;
    }

    public void setSection(SectionDataIfc section) {
        this.section = section;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    public Float getDiscount() {
        if (this.discount == null) {
            this.discount = Float.valueOf(0.0f);
        }
        return this.discount;
    }

    public void setDiscount(Float discount) {
        if (discount == null) {
            discount = Float.valueOf(0.0f);
        }
        this.discount = discount;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public Boolean getHasRationale() {
        return this.hasRationale;
    }

    public void setHasRationale(Boolean hasRationale) {
        this.hasRationale = hasRationale;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Set getItemTextSet() {
        return this.itemTextSet;
    }

    public void setItemTextSet(Set itemTextSet) {
        this.itemTextSet = itemTextSet;
    }

    public Set getItemMetaDataSet() {
        return this.itemMetaDataSet;
    }

    public void setItemMetaDataSet(Set itemMetaDataSet) {
        this.itemMetaDataSet = itemMetaDataSet;
    }

    public Set getItemFeedbackSet() {
        return this.itemFeedbackSet;
    }

    public void setItemFeedbackSet(Set itemFeedbackSet) {
        this.itemFeedbackSet = itemFeedbackSet;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void addItemText(String text, Set answerSet) {
        if (this.itemTextSet == null) {
            this.itemTextSet = new HashSet();
        }
        Long sequence = this.itemTextSet.size() + 1;
        PublishedItemText itemText = new PublishedItemText(this, sequence, text, answerSet);
        this.itemTextSet.add(itemText);
    }

    public String getItemMetaDataByLabel(String label) {
        for (PublishedItemMetaData imd : this.itemMetaDataSet) {
            if (!imd.getLabel().equals(label)) continue;
            return imd.getEntry();
        }
        return null;
    }

    public void addItemMetaData(String label, String entry) {
        if (this.itemMetaDataSet == null) {
            this.setItemMetaDataSet(new HashSet());
        }
        this.itemMetaDataSet.add(new PublishedItemMetaData(this, label, entry));
    }

    public String getCorrectItemFeedback() {
        return this.getItemFeedback("Correct Feedback");
    }

    public void setCorrectItemFeedback(String text) {
        this.removeFeedbackByType("Correct Feedback");
        this.addItemFeedback("Correct Feedback", text);
    }

    public String getInCorrectItemFeedback() {
        return this.getItemFeedback("InCorrect Feedback");
    }

    public void setInCorrectItemFeedback(String text) {
        this.removeFeedbackByType("InCorrect Feedback");
        this.addItemFeedback("InCorrect Feedback", text);
    }

    public String getGeneralItemFeedback() {
        return this.getItemFeedback("General Feedback");
    }

    public void setGeneralItemFeedback(String text) {
        this.removeFeedbackByType("General Feedback");
        this.addItemFeedback("General Feedback", text);
    }

    public String getItemFeedback(String typeId) {
        for (PublishedItemFeedback itemFeedback : this.itemFeedbackSet) {
            if (!itemFeedback.getTypeId().equals(typeId)) continue;
            return itemFeedback.getText();
        }
        return null;
    }

    public void addItemFeedback(String typeId, String text) {
        if (this.itemFeedbackSet == null) {
            this.setItemFeedbackSet(new HashSet());
        }
        this.itemFeedbackSet.add(new PublishedItemFeedback(this, typeId, text));
    }

    public void removeFeedbackByType(String typeId) {
        if (this.itemFeedbackSet != null) {
            for (PublishedItemFeedback itemFeedback : this.itemFeedbackSet) {
                if (!itemFeedback.getTypeId().equals(typeId)) continue;
                this.itemFeedbackSet.remove(itemFeedback);
            }
        }
    }

    public void removeMetaDataByType(String label) {
        try {
            if (this.itemMetaDataSet != null) {
                Iterator i = this.itemMetaDataSet.iterator();
                while (i.hasNext()) {
                    PublishedItemMetaData itemMetaData = (PublishedItemMetaData)i.next();
                    if (!itemMetaData.getLabel().equals(label)) continue;
                    i.remove();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean getIsTrue() {
        Iterator aiter;
        if (!this.getTypeId().equals(TypeD.TRUE_FALSE)) {
            return Boolean.FALSE;
        }
        Set answerSet = null;
        Set set = this.getItemTextSet();
        Iterator iter = set.iterator();
        if (iter.hasNext()) {
            answerSet = ((ItemTextIfc)iter.next()).getAnswerSet();
        }
        if (answerSet != null && (aiter = answerSet.iterator()).hasNext()) {
            AnswerIfc answer = (AnswerIfc)aiter.next();
            return answer.getIsCorrect();
        }
        return Boolean.FALSE;
    }

    public String getText() {
        String text = "";
        if (this.getTypeId().equals(TypeIfc.MATCHING) || this.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY)) {
            return this.instruction;
        }
        Set set = this.getItemTextSet();
        for (ItemTextIfc itemText : set) {
            text = text + "" + itemText.getText();
            if (this.getTypeId().equals(TypeIfc.FILL_IN_BLANK)) {
                text = text.replaceAll("\\{", "__");
                text = text.replaceAll("\\}", "__");
            }
            if (!this.getTypeId().equals(TypeIfc.FILL_IN_NUMERIC)) continue;
            text = text.replaceAll("\\{", "__");
            text = text.replaceAll("\\}", "__");
        }
        return text;
    }

    public TypeIfc getType() {
        return null;
    }

    public ArrayList getItemTextArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.itemTextSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public ArrayList getItemTextArraySorted() {
        ArrayList list = this.getItemTextArray();
        Collections.sort(list);
        return list;
    }

    public void setTriesAllowed(Integer triesAllowed) {
        this.triesAllowed = triesAllowed;
    }

    public Integer getTriesAllowed() {
        return this.triesAllowed;
    }

    public String getAnswerKey() {
        String answerKey = "";
        ArrayList itemTextArray = this.getItemTextArraySorted();
        if (itemTextArray.size() == 0) {
            return answerKey;
        }
        ArrayList answerArray = ((ItemTextIfc)itemTextArray.get(0)).getAnswerArraySorted();
        HashMap<String, String> h = new HashMap<String, String>();
        for (int i = 0; i < itemTextArray.size(); ++i) {
            String pair;
            AnswerIfc a;
            ItemTextIfc text = (ItemTextIfc)itemTextArray.get(i);
            ArrayList answers = text.getAnswerArraySorted();
            for (int j = 0; j < answers.size(); ++j) {
                a = (AnswerIfc)answers.get(j);
                if (!this.getPartialCreditFlag().booleanValue() && Boolean.TRUE.equals(a.getIsCorrect())) {
                    pair = (String)h.get(a.getLabel());
                    if (!this.getTypeId().equals(TypeD.MATCHING)) {
                        answerKey = this.getTypeId().equals(TypeD.TRUE_FALSE) ? a.getText() : ("".equals(answerKey) ? a.getLabel() : answerKey + "," + a.getLabel());
                    } else if (pair == null) {
                        String s = a.getLabel() + ":" + text.getSequence();
                        h.put(a.getLabel(), s);
                    } else {
                        h.put(a.getLabel(), pair + " " + text.getSequence());
                    }
                }
                if (!this.getTypeId().equals(TypeD.MULTIPLE_CHOICE) || !this.getPartialCreditFlag().booleanValue()) continue;
                Float pc = Float.valueOf(a.getPartialCredit().floatValue());
                if (pc == null) {
                    pc = Float.valueOf(0.0f);
                }
                if (!(pc.floatValue() > 0.0f)) continue;
                String correct = rb.getString("correct");
                answerKey = "".equals(answerKey) ? a.getLabel() + "&nbsp;<span style='color: green'>(" + pc + "%&nbsp;" + correct + ")</span>" : answerKey + ",&nbsp;" + a.getLabel() + "&nbsp;<span style='color: green'>(" + pc + "%&nbsp;" + correct + ")</span>";
            }
            if (!this.getTypeId().equals(TypeD.MATCHING)) continue;
            for (int k = 0; k < answerArray.size(); ++k) {
                a = (AnswerIfc)answerArray.get(k);
                pair = (String)h.get(a.getLabel());
                if (pair == null) {
                    pair = a.getLabel() + ": ";
                }
                answerKey = k != 0 ? answerKey + ",  " + pair : pair;
            }
        }
        return answerKey;
    }

    public int compareTo(Object o) {
        PublishedItemData a = (PublishedItemData)o;
        return this.sequence.compareTo(a.sequence);
    }

    public boolean getGeneralItemFbIsNotEmpty() {
        return this.isNotEmpty(this.getGeneralItemFeedback());
    }

    public boolean getCorrectItemFbIsNotEmpty() {
        return this.isNotEmpty(this.getCorrectItemFeedback());
    }

    public boolean getIncorrectItemFbIsNotEmpty() {
        return this.isNotEmpty(this.getInCorrectItemFeedback());
    }

    public boolean isNotEmpty(String wyzText) {
        if (wyzText != null) {
            String t = wyzText.replaceAll("<.*?>", " ").trim();
            for (int index = 0; index < t.length(); ++index) {
                char c = t.charAt(index);
                if (!Character.isLetterOrDigit(c)) continue;
                return true;
            }
        }
        return false;
    }

    public Set getItemAttachmentSet() {
        return this.itemAttachmentSet;
    }

    public void setItemAttachmentSet(Set itemAttachmentSet) {
        this.itemAttachmentSet = itemAttachmentSet;
    }

    public List getItemAttachmentList() {
        ArrayList<ItemAttachmentIfc> list = new ArrayList<ItemAttachmentIfc>();
        if (this.itemAttachmentSet != null) {
            for (ItemAttachmentIfc a : this.itemAttachmentSet) {
                list.add(a);
            }
        }
        return list;
    }

    public Boolean getPartialCreditFlag() {
        if (this.partialCreditFlag == null) {
            return Boolean.FALSE;
        }
        return this.partialCreditFlag;
    }

    public void setPartialCreditFlag(Boolean partialCreditFlag) {
        this.partialCreditFlag = partialCreditFlag;
    }

    public String[] getRowChoices() {
        ArrayList itemTextArray = this.getItemTextArraySorted();
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < itemTextArray.size(); ++i) {
            String str = ((ItemTextIfc)itemTextArray.get(i)).getText();
            if (str == null || str.trim().length() <= 0) continue;
            stringList.add(str);
        }
        String[] rowChoices = stringList.toArray(new String[stringList.size()]);
        return rowChoices;
    }

    public List<Integer> getColumnIndexList() {
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        ArrayList itemTextArray = this.getItemTextArraySorted();
        ArrayList answerArray = ((ItemTextIfc)itemTextArray.get(0)).getAnswerArraySorted();
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < answerArray.size(); ++i) {
            String str = ((AnswerIfc)answerArray.get(i)).getText();
            if (str == null || str.trim().length() <= 0) continue;
            stringList.add(str);
        }
        for (int k = 0; k < stringList.size(); ++k) {
            columnIndexList.add(new Integer(k));
        }
        return columnIndexList;
    }

    public String[] getColumnChoices() {
        ArrayList itemTextArray = this.getItemTextArraySorted();
        ArrayList answerArray = ((ItemTextIfc)itemTextArray.get(0)).getAnswerArraySorted();
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < answerArray.size(); ++i) {
            String str = ((AnswerIfc)answerArray.get(i)).getText();
            if (str == null || str.trim().length() <= 0) continue;
            stringList.add(str);
        }
        String[] columnChoices = stringList.toArray(new String[stringList.size()]);
        return columnChoices;
    }

    public boolean getAddCommentFlag() {
        if (this.getItemMetaDataByLabel("ADD_COMMENT_MATRIX") != null) {
            return Boolean.parseBoolean(this.getItemMetaDataByLabel("ADD_COMMENT_MATRIX"));
        }
        return false;
    }

    public String getCommentField() {
        if (this.getItemMetaDataByLabel("ADD_COMMENT_MATRIX") != null && this.getItemMetaDataByLabel("ADD_COMMENT_MATRIX").equalsIgnoreCase("true")) {
            return this.getItemMetaDataByLabel("MX_SURVEY_QUESTION_COMMENTFIELD");
        }
        return null;
    }

    public String getRelativeWidthStyle() {
        String width = this.getItemMetaDataByLabel("MX_SURVEY_RELATIVE_WIDTH");
        if (width != null && Integer.valueOf(width) != 0) {
            return "width:" + width + "%";
        }
        return "";
    }
}

